# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from pathlib import Path
from os.path import join, isfile, dirname


def adjusts_icon_paths() -> None:
    fldr = dirname(__file__)

    files = ["intersection_control_nodes", "location_selected", "ev_charging_location_display"]

    for file_name in files:
        file = Path(fldr) / "styles" / (file_name + ".qml")
        if file.exists():
            continue
        base_file = file.parent / (file_name + "_base.qml")

        with open(base_file, "r") as f:
            txt = f.readlines()

        with open(file, "w") as f:
            for line in txt:
                f.write(line.replace("PLUGINBASEPATH", fldr))
