# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.break_link import break_link
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from functools import partial


class BreakLinkDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(break_link, get_polaris_menu_instance()),
            "break_link_dialog",
            "Break Link",
            "Editing",
            "editing",
            "Breaks a link in the network.",
            ["link", "break", "edit", "network"],
        )

    def createInstance(self):
        return BreakLinkDialog()
