# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from qgis.core import QgsVectorLayer
from .style_loader import load_style_by_name
from os.path import join, dirname, isfile


def load_editor_styles(layer: QgsVectorLayer, layer_name: str):
    file = join(dirname(__file__), "styles", f"{layer_name}_form_editor.qml")
    if isfile(file):
        load_style_by_name(layer, f"{layer_name}_form_editor.qml")
