# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from functools import partial

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.location_parking_builder import rebuild_location_parking
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


class LocationParkingBuilderDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(rebuild_location_parking, get_polaris_menu_instance()),
            "location_parking_builder_dialog",
            "Location Parking Builder",
            "Model building and consistency",
            "building_and_consistency",
            "Builds location parking in the network.",
            ["location", "parking", "builder", "consistency", "supply", "edit"],
        )

    def createInstance(self):
        return LocationParkingBuilderDialog()
