# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm

from QPolaris import get_polaris_menu_instance


def export_gmns_action():
    proj = get_polaris_menu_instance()
    if not proj.open_mode:
        proj.show_message_no_supply()
        return {}
    from QPolaris.modules.import_export.export_gmns import ExportGMNSDialog
    from QPolaris.modules.menu_actions.show_dialog import show_diag

    dlg2 = ExportGMNSDialog(proj)
    show_diag(dlg2)
    return {}


class ExportGMNS(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            export_gmns_action,
            "export_gmns_network",
            "EXPORT network to GMNS",
            "Import-Export",
            "import_export",
            "Exports a network to GMNS",
            ["Export", "network", "gmns", "storage", "exchange"],
        )

    def createInstance(self):
        return ExportGMNS()
