# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from os.path import dirname, join

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog

FORM_CLASS, _ = uic.loadUiType(join(dirname(__file__), "forms/ui_library_tool.ui"))


class LocationLinksBuilderDialog(QDialog, FORM_CLASS):
    def __init__(self, _PQgis):
        QDialog.__init__(self)
        self.iface = _PQgis.iface
        self.setupUi(self)

        self._PQgis = _PQgis
        self._p = _PQgis.network
        self.tools = self._p.tools

        self.but_process.clicked.connect(self.rebuild_loclink)
        self.but_process.setText("Recreate Location_Links table")
        self.progress_box.setVisible(False)
        self.setFixedHeight(153)

    def rebuild_loclink(self):
        self.parameter_box.setVisible(False)
        self.tools.rebuild_location_links(self.spinBox_lgth.value(), self.do_multiple.isChecked())
        self.close()
