# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from polaris.utils.database.db_utils import commit_and_close
from polaris.utils.database.standard_database import StandardDatabase, DatabaseType

from QPolaris import get_polaris_menu_instance


def remove_triggers_action():
    proj = get_polaris_menu_instance()
    if not proj.open_mode:
        proj.show_message_no_supply()
    else:
        from polaris.network.create.triggers import delete_network_triggers, delete_triggers

        with commit_and_close(proj.supply_path, spatial=True) as conn:
            delete_network_triggers(conn)
        if proj.open_mode == "project" and proj.freight_path.exists():
            with commit_and_close(proj.freight_path, spatial=True) as conn:
                delete_triggers(StandardDatabase.for_type(DatabaseType.Freight), conn)
        proj.show_error_message(message="Removed triggers from the model. BE CAREFUL WHEN EDITING IT", level=2)


class RemoveTriggers(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            remove_triggers_action,
            "remove_triggers",
            "Remove Triggers",
            "Model Maintenance",
            "model_maintenance",
            "Remove triggers from the Supply and freight databases",
            ["maintenance", "editing", "triggers", "remove"],
        )

    def createInstance(self):
        return RemoveTriggers()
