# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from QPolaris.modules.menu_actions.sys_perf import sys_perf
from functools import partial


class SystemPerformanceDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(sys_perf),
            "system_performance_dialog",
            "System Performance Analysis",
            "Cluster",
            "cluster",
            "Opens the system performance analysis dialog.",
            ["system", "performance", "cluster", "analysis"],
        )

    def createInstance(self):
        return SystemPerformanceDialog()
