from qgis.PyQt import QtCore, QtGui, QtWidgets
from qgis.PyQt.QtWidgets import QApplication, QDialog
from qgis.core import *


class ModeleListeCouches(QtCore.QAbstractTableModel):
    def __init__(self, data, parent=None, *args):
        super().__init__(parent, *args)
        self.data = data

        # Détection automatique de Qt6 pour les rôles et les états de case à cocher
        if hasattr(QtCore.Qt, "ItemDataRole"):
            self.check_state_role = QtCore.Qt.ItemDataRole.CheckStateRole
            self.display_role = QtCore.Qt.ItemDataRole.DisplayRole
            self.font_role = QtCore.Qt.ItemDataRole.FontRole
        else:
            self.check_state_role = QtCore.Qt.CheckStateRole
            self.display_role = QtCore.Qt.DisplayRole
            self.font_role = QtCore.Qt.FontRole

        # Détection automatique de Qt6 pour les valeurs Checked et Unchecked
        if hasattr(QtCore.Qt, "CheckState"):
            self.checked = QtCore.Qt.CheckState.Checked
            self.unchecked = QtCore.Qt.CheckState.Unchecked
        else:
            self.checked = QtCore.Qt.Checked
            self.unchecked = QtCore.Qt.Unchecked

    def columnCount(self, parent):
        return 1

    def rowCount(self, parent):
        return len(self.data)

    def flags(self, index):
        from qgis.PyQt.QtCore import Qt

        # Vérifie si on est sous Qt6
        if hasattr(Qt, "ItemFlag"):
            return Qt.ItemFlag.ItemIsEnabled | Qt.ItemFlag.ItemIsUserCheckable | Qt.ItemFlag.ItemIsSelectable
        else:
            return Qt.ItemIsEnabled | Qt.ItemIsUserCheckable | Qt.ItemIsSelectable

    # Affiche "Nom de la couche" en entête de ligne (inutile ici)
    # def headerData(self, col, orientation, role):
    #     if role == self.display_role:
    #         return "Nom de la couche"
    #     return None

    def data(self, index, role):
        if not index.isValid():
            return None

        if role == self.check_state_role:
            return self.checked if self.data[index.row()].isChecked() else self.unchecked

        elif role == self.font_role:
            font = QtGui.QFont()
            font.setBold(self.data[index.row()].isChecked())
            return font

        elif role == self.display_role:
            return self.data[index.row()].text()

        return None

    def setData(self, index, value, role):
        if not index.isValid():
            return False

        if role == self.check_state_role:
            self.data[index.row()].setChecked(value == self.checked)
            self.dataChanged.emit(index, index, [role])  # Correction pour Qt6
            return True

        return False

    def getDonnees(self):
        return self.data

