![QNetPlanner icon](icon.png)

# QNetPlanner QGIS Plugin
-----------------------------
## Smart Network Planning Plugin for QGIS
![QNetPlanner plugin interface](Images/QNetPlanner_Interface.png)



### Description
----------------------
***QNetPlanner*** is a QGIS plugin designed to support optimal network planning by intelligently selecting the minimum number of gateways and sensors required to cover a given area.
It is especially useful for IoT, wireless sensor networks, LPWAN, radio-frequency–based planning, and similar spatial optimization problems.

The plugin prioritizes locations based on cost, elevation, and spatial coverage, helping planners make data-driven deployment decisions directly inside QGIS.

------------------------------------------
### Key Features
- #### Optimal Gateway and Sensor Selection
    Identifies an optimal set of gateways and sensors that ensures maximum spatial coverage while minimizing overall infrastructure requirements.

- #### Cost-Based Prioritization
    Sensor selection is influenced by cost values normalized on a **1–10 scale**, where lower values indicate higher priority in the optimization process.

- #### GIS-Native Workflow
    Operates directly on layers loaded in the active QGIS project, supporting vector and raster datasets without the need for external preprocessing.

- #### Weighted Decision Logic
    Enables multi-criteria decision-making through configurable weights, including:
  - Cost (assigned higher significance)
  - Elevation and terrain influence (assigned lower significance)


- #### Adaptable to Multiple Use Cases
    Although primarily intended for network planning, the underlying optimization logic can be extended to:
  - Infrastructure and facility placement
  - Spatial resource allocation
  - Coverage-based optimization problems

--------------------------------------------------
### Requirements

QNetPlanner is designed to run within the QGIS environment and relies on the following components:

- **QGIS** 3.22 LTR or newer  
- **Python** 3.8 or newer (provided by QGIS)  
- **PuLP** ≥ 2.7 (Python library for optimization and linear programming)

  PuLP may be installed using one of the following approaches:

  - **Using QPIP (recommended):**  
    Install the *QPIP* plugin from the QGIS Plugin Repository and use it to install the `pulp` package within the active QGIS environment.

  - **Manual installation (advanced users):**  
    Install PuLP directly into the Python environment associated with your QGIS installation.


#### Optional system solvers
For improved performance and reliability of the optimization process, it is recommended to have at least one of the following solvers installed on the system:

- **CBC (coin-or-cbc ≥ 2.10)** – recommended  
- **GLPK (glpsol ≥ 5.0)**

If no external solver is available, QNetPlanner will automatically fall back to PuLP’s bundled solver or a built-in greedy heuristic.

#### GDAL
GDAL is provided as part of the QGIS installation. No separate GDAL installation or configuration is required for QNetPlanner.

----
### Installation
Ensure that the requirements listed above are satisfied before proceeding with the installation.

#### Method 1: Installation from ZIP
1. Download the QNetPlanner plugin as a ZIP archive.

2. Open QGIS and navigate to:  
    ***Plugins → Manage and Install Plugins → Install from ZIP***
3. Select the downloaded ZIP file and proceed with the installation.
4. Restart QGIS if prompted.
5. Enable **QNetPlanner** from the Plugins menu.

#### Method 2: Developer Installation

For development or testing purposes:

```bash
git clone git@gitlab.com:binoy194/QNetPlanner.git
```
---
### Usage

1. Load the required input layers ( gateway candidates, sensor candidates, and DEM layer ) into the QGIS project.

2. Launch the plugin from:
   **Plugins → QNetPlanner**
3. Select the gateway layer and DEM layer from the dropdown menus.
4. Add gateway range, observer height, and cost values to the attribute table using the field names range, height, and cost, respectively.

5. The range and height values shall be specified in meters, and the cost value shall be a numeric (floating-point) value between 1.0 and 10.0.
6. Add one or more sensor types and associate the corresponding point datasets.
7. Cost of sensor can be added in attribute table with field name cost and the value shall be a numeric (floating-point) value between 1.0 and 10.0.
8. Specify the maximum number of sensors to be selected for each sensor type.
9. Execute the optimization process to generate the results.
10. The output layers will be automatically added to the QGIS project.

----------------
### License

QNetPlanner is released under the **GNU General Public License (GPL), Version 3 or later**.  
A copy of this license is provided in the `LICENSE.txt` file included with the QNetPlanner plugin and its source code repository, and is also available at https://www.gnu.org/licenses/.

Developing QNetPlanner under this license ensures that users are free to inspect, use, and modify the source code.  
It further guarantees continued access to a free and open-source version of the software that may be redistributed and adapted in accordance with the terms of the GPL.

---
### Support
If you need assistance, you can reach us through the following channels:
- Refer to the QNetPlanner documentation for detailed guidance and usage instructions

- Submit questions, bug reports, feature requests, or enhancement suggestions via GitLab Issues:
  [Report an Issue](https://gitlab.com/binoy194/QNetPlanner/-/issues)

- Contact the development team directly at: [binoy194@gmail.com](mailto:binoy194@gmail.com) ; 
[kavyask304@gmail.com](mailto:kavyask304@gmail.com)








