import logging
import os

# Create log file in plugin directory
LOG_FILE = os.path.join(os.path.dirname(__file__), "QNetPlanner.log")

# Setup logger
logger = logging.getLogger("QNetPlannerLogger")
logger.setLevel(logging.DEBUG)

def init_logger():
    # Remove old handlers (important for plugin reloads)
    if logger.handlers:
        for h in logger.handlers[:]:
            logger.removeHandler(h)
            h.close()
        
    # File handler → overwrite log on every QGIS start
    fh = logging.FileHandler(LOG_FILE, mode="w", encoding="utf-8")
    fh.setLevel(logging.DEBUG)

    # Log format
    formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
    fh.setFormatter(formatter)

    # Add handler only once (avoid duplicates)
    if not logger.handlers:
        logger.addHandler(fh)

    return logger