# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Neighborhood
                                 A QGIS plugin
 This plugin selects the polygons adjacent to a given polygon
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-06
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Salomón Ramírez / Universidad Distrital Francisco José de Caldas
        email                : seramirezf@correo.udistrital.edu.co
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.gui import QgsMapToolEmitPoint, QgsMapLayerComboBox, QgsFieldComboBox
from qgis.core import QgsGeometry, QgsMapLayerProxyModel, QgsFieldProxyModel

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .neighbor_dialog import NeighborhoodDialog
import os.path


class Neighborhood:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.map = self.iface.mapCanvas()
        self.clickTool = QgsMapToolEmitPoint(self.map)
		
		# initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Neighborhood_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&QNeighborhood')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Neighborhood', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/QNeighborhood/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Select neighborhood'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True		
		
        """Slots and signals"""
        self.clickTool.canvasClicked.connect(self.selectNeighbors)



    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&QNeighborhood'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
		
        self.map.setMapTool(self.clickTool)

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = NeighborhoodDialog()
            #slots and signals
            self.dlg.btnClear.clicked.connect(self.btnClear_clicked)
            self.dlg.btnExit.clicked.connect(self.btnExit_clicked)
            self.dlg.cbxLayers.layerChanged.connect(self.loadFields)

        # show the dialog
        self.dlg.show()        
        self.dlg.cbxLayers.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        self.dlg.cbxFields.setFilters(QgsFieldProxyModel.String)
        self.loadFields()
		
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
		
		
    def loadFields(self):
        """Load fields from a selected Layer"""
        lyr = self.dlg.cbxLayers.currentLayer()
        self.dlg.cbxFields.setLayer(lyr)

        
    def selectNeighbors(self, point, button):	
        """ selects the polygons adjacent to a given polygon"""
        pntGeom = QgsGeometry.fromPointXY(point)
        pntBuff = pntGeom.buffer((self.map.mapUnitsPerPixel() * 2),0)
        rect = pntBuff.boundingBox()
		     		
        self.cLayer = self.dlg.cbxLayers.currentLayer()
        
        if not self.cLayer:
            QMessageBox.critical(None,"Missing layer","You must select a layer")
        else:
			
            cField = self.dlg.cbxFields.currentField()			
			
            if not cField:
                QMessageBox.critical(None,"Missing field","You must select a field")
            else: 

                self.cLayer.removeSelection()
                self.cLayer.selectByRect(rect)

                selFeatures = self.cLayer.selectedFeatures()
            
                if not selFeatures:
                    QMessageBox.critical(None,"Missing feature","You must select a feature")
                else: 				
                    self.dlg.txtNeighbor.setText( \
                         str(selFeatures[0].attribute(selFeatures[0].fieldNameIndex(cField))))
		
                    geom = selFeatures[0].geometry()   
						
                    for f in self.cLayer.getFeatures():
                        if geom.touches(f.geometry()) == True: 
                            self.cLayer.select(f.id())
                            self.dlg.txtNeighborhood.appendPlainText(str(f[cField]))
                
                    self.map.zoomToSelected()
		
		
    def btnClear_clicked(self):
        """Clear field's results"""
        if not self.cLayer:
            QMessageBox.critical(None,"Missing layer","You must select a layer")
        else:			
            self.dlg.txtNeighbor.clear()
            self.dlg.txtNeighborhood.clear()
            self.cLayer.removeSelection()


    def btnExit_clicked(self):
        """Exit from plugin"""
        self.dlg.close()