# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QNSPECT
                                 A QGIS plugin
 QGIS Plugin for NOAA Nonpoint Source Pollution and Erosion Comparison Tool (NSPECT)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-29
        copyright            : (C) 2021 by NOAA
        email                : ocm dot nspect dot admins at noaa dot gov
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "NOAA"
__date__ = "2022-02-15"
__copyright__ = "(C) 2021 by NOAA"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import os
from pathlib import Path
from json import load

from qgis.core import QgsVectorLayer, QgsProcessingException

from QNSPECT.processing.qnspect_algorithm import QNSPECTAlgorithm
from QNSPECT.processing.algorithms.qnspect_utils import (
    LayerPostProcessor,
    select_group,
    create_group,
)


class QNSPECTRunAlgorithm(QNSPECTAlgorithm):
    """
    Base class for QNSPECT Run Algorithms
    """

    _land_cover_TABLES = {1: "C-CAP", 2: "NLCD"}
    _land_cover_PATH = (
        f"file:///{Path(__file__).parents[3] / 'resources' / 'coefficients'}"
    )
    with open(
        f"{Path(__file__).parents[3]  / 'resources' / 'style-colors.json'}"
    ) as json_f:
        _STYLE_COLORS = load(json_f)

    def __init__(self):
        super().__init__()
        # necessary to store LayerPostProcessor instances in class variable because of scoping issue
        self.styler_dict = {}
        self.load_outputs = False

    def group(self):
        return self.tr("Analysis")

    def groupId(self):
        return "analysis"

    def postProcessAlgorithm(self, context, feedback):
        if self.load_outputs:
            project = context.project()
            root = project.instance().layerTreeRoot()  # get base level node

            create_group(self.run_name, root)
            select_group(self.run_name)  # so that layers are spit out within group

        return {}

    def extract_lookup_table(
        self,
        parameters,
        context,
    ):
        """Extract the lookup table as a vector layer."""
        if parameters["LookupTable"]:
            return self.parameterAsVectorLayer(parameters, "LookupTable", context)

        land_cover_type = self.parameterAsEnum(parameters, "LandCoverType", context)
        if land_cover_type > 0:
            return QgsVectorLayer(
                os.path.join(
                    self._land_cover_PATH,
                    f"{self._land_cover_TABLES[land_cover_type]}.csv",
                ),
                "Land Cover Lookup Table",
                "delimitedtext",
            )
        else:
            raise QgsProcessingException(
                "Land Cover Lookup Table must be provided with Custom Land Cover Type.\n"
            )

    def handle_post_processing(self, entity: str, layer, display_name, context) -> None:
        layer_details = context.LayerDetails(
            display_name, context.project(), display_name
        )
        context.addLayerToLoadOnCompletion(
            layer,
            layer_details,
        )

        colors = self._STYLE_COLORS.get(entity, self._STYLE_COLORS["default"])
        if context.willLoadLayerOnCompletion(layer):
            self.styler_dict[layer] = LayerPostProcessor(
                display_name, colors[0], colors[1]
            )
            context.layerToLoadOnCompletionDetails(layer).setPostProcessor(
                self.styler_dict[layer]
            )
