# -*- coding: utf-8 -*-
"""
***************************************************************************
    Qneat3Plugin.py
    ---------------------
    
    Date                 : January 2018
    Copyright            : (C) 2018 by Clemens Raffler
    Email                : clemens dot raffler at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""


from QNEAT3.Qneat3Provider import Qneat3Provider
from qgis.core import QgsApplication

class Qneat3Plugin:
    def __init__(self, iface):
        self.provider = None

    def initProcessing(self):
        self.provider = Qneat3Provider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)


