# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QMarxanToolbox
                                 A QGIS plugin
 Create input files for Marxan
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-08-31
        updated              : 2020-04-02
        copyright            : (C) 2018 by Apropos Information Systems Inc
        email                : tsw.web@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Apropos Information Systems Inc'
__date__ = '2020-05-07'
__copyright__ = '(C) 2018 by Apropos Information Systems Inc'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .qmarxan_toolbox_algorithm import QMarxanToolboxInputFolders, \
    QMarxanToolboxExportBoundaryFile, QMarxanToolboxFeatureFile, \
    QMarxanToolboxExportPlanningUnitFile, QMarxanToolboxReportFeatures, \
    QMarxanToolboxCalibrateSPF, QMarxanToolboxEstimateBLM, \
    QMarxanToolboxCalibrateIterations, QMarxanToolboxGraphBLM
from qgis.PyQt.QtGui import QIcon
import os


class QMarxanToolboxProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)

        # Load algorithms
        self.alglist = [QMarxanToolboxInputFolders(),\
            QMarxanToolboxExportBoundaryFile(), QMarxanToolboxFeatureFile(), \
            QMarxanToolboxExportPlanningUnitFile(), QMarxanToolboxReportFeatures(), \
            QMarxanToolboxCalibrateSPF(), QMarxanToolboxEstimateBLM(), \
            QMarxanToolboxCalibrateIterations(),QMarxanToolboxGraphBLM()]

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        for alg in self.alglist:
            self.addAlgorithm( alg )

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'marxan'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('QMarxan Toolbox (2.0.3)')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()

    def icon(self):
        return QIcon(os.path.dirname(__file__) + '/qm_icon.png')
