## -*- coding: utf-8 -*-

"""
/***************************************************************************
 QMarxanToolbox
                                 A QGIS plugin
 Create input files for Marxan
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-08-31
        updated              : 2020-04-02
        copyright            : (C) 2018 by Apropos Information Systems Inc
        email                : tsw.web@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Apropos Information Systems Inc'
__date__ = '2020-05-07'
__copyright__ = '(C) 2018 by Apropos Information Systems Inc'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os, sys, inspect, subprocess, datetime, time
import platform

# utility functions to calibrate marxan by running marxan
# in the background and monitoring outputs

def runMarxanOnce(exeFile,workingDir,outDir,scenName,numReps,feedback):

    def writeLog(results,fName):
        f = open(logFName+'.stdout','wb')
        stuff = results[0]
        if isinstance(stuff,str):
            f.write(stuff)
        elif isinstance(stuff,bytes):
            f.write(stuff.decode('utf-8'))
        f.close()

    # clear old results
    temp = [os.remove(outDir+'/'+i) for i in os.listdir(outDir)]
    # function variables
    debug = False
    printProgress = True
    abort = False
    currentRun = -1
    lastRun = currentRun
    loadStart = None
    runStart = None
    runFinish = None
    oldStatus = 'starting'
    status = 'load'
    startNotified = False
    pStat = None
    runPercent = 0.0
    lastPercent = 0.0
    messageText = ''
    abort = False

    loadStart = datetime.datetime.now()
    feedback.pushInfo('Attempting to start Marxan')
    os.chdir(workingDir)
    if platform.system() == 'Windows':
        si = subprocess.STARTUPINFO()
        si.dwFlags = subprocess.STARTF_USESTDHANDLES | subprocess.STARTF_USESHOWWINDOW
        proc = subprocess.Popen(exeFile,stdin=subprocess.PIPE,startupinfo=si)
    else:
        proc = subprocess.Popen([exeFile],stdin=subprocess.PIPE,stdout=subprocess.PIPE,stderr=subprocess.PIPE,bufsize=4096)
    # wait
    time.sleep(5)
    logFName = os.path.join(outDir,scenName+'_log.dat')
    # look for log file to see if output directory is valid
    if os.path.exists(logFName):
        # read log to look for phrase indicating missing input files
        f = open(logFName,'r',errors='ignore')
        logLines = f.readlines()
        f.close()
        InputsComplete = True
        for line in logLines:
            lText = line.lower()
            if 'aborting program' in lText:
                InputsComplete = False
        if InputsComplete:
            feedback.pushInfo('Marxan started')
            while currentRun < numReps and not abort:
                f = open(logFName,'r',errors='ignore')
                logLines = f.readlines()
                f.close()
                fileList = os.listdir(outDir)
                currentRun = sum([i.find(scenName+'_r')+1 for i in fileList])
                # check log file to see if things stopped for some reason 
                # we didn't detect otherwise such as changes to input file 
                # that were not passed to this function and are giving incorrect
                # progress count.
                # To resolve this we check to see if "The End" is found 
                # in the log file and if so change the currentRun value
                # to cause the code to exit the loop
                for line in logLines:
                    lText = line.lower()
                    if 'the end' in lText:
                        currentRun = numReps
                runStart = datetime.datetime.now()
                if status == 'load':
                    if oldStatus != status:
                        feedback.pushInfo('Preprocessing inputs (NOTE:For large problems, this will take some time)')
                        oldStatus = status
                    if currentRun > 0:
                        status = 'run'
                        feedback.pushInfo('Marxan running')
                if status == 'load' and not startNotified:
                    startNotified = True
                    f = open(logFName,'r',errors='ignore')
                    logLines = f.readlines()
                    f.close()
                    for line in logLines:
                        if 'species cannot meet' in line:
                            abort = True
                            feedback.pushInfo('Some species cannot meet targets. Check log file.')
                            messageText = 'Some species cannot meet targets. Check log file.'
                            try:
                                results = proc.terminate()
                            except:
                                pass 
                elif status == 'run' and lastRun != currentRun:
                    # progress update
                    runPercent = int(currentRun / float(numReps) * 100)
                    # limit signals to increase processing speed
                    if runPercent > lastPercent + 4:
                        if printProgress:
                            feedback.pushInfo('%d%% repetitions complete' % runPercent)
                        lastPercent = runPercent
                        if abort:
                            break
                    lastRun = currentRun
                time.sleep(1)
                # check for status to find seg faults or other failures
                pStat = proc.poll()
                # Note: Marxan 2.4.3 requires user input to stop
                #       but Marxan 3.0.0 does not, so need to check for a return value of 0 (successful completion)
                if not pStat is None and pStat != 0:
                    abort = True
                    feedback.pushInfo('Inputs failure. Check log file.')
                    try:
                        results = proc.communicate(input=b'\n')
                        writeLog(results,logFName+'.stdout')
                    except:
                        pass 
        else:
            feedback.pushInfo('Load failure. Check log file.')
            abort = True
            results = proc.communicate(input=b'\n')
            writeLog(results,logFName+'.stdout')
            messageText = 'Check log file for information to identify the source of the problem. If source of problem is not clear then check input path, parameters and files.'
    else:
        #print('no log found')
        feedback.pushInfo('System detected failure. Check output path and parameters.')
        proc.terminate()
        messageText = 'System detected failure. Check output path and parameters.'
        abort = True
    # if execution was successful...
    if not abort:
        # grab screen output and commit to disk because log file is not reliable
        runFinish = datetime.datetime.now()
        hasWarnings = False
        specCount = 0
        stdoutData, stderrData = proc.communicate(input=b'\n')
        if platform.system() == 'Windows':
            logFName = os.path.join(outDir,scenName+'_log.dat')
            f = open(logFName,'r',errors='ignore')
            logLines = f.readlines()
            f.close()
        else:
            results = stdoutData.decode("utf-8")
            f = open(logFName+'.stdout','w')
            f.write(results)
            f.close()
            logLines = results.split('\n')
        # scan output for warnings or absence of features (species)
        for line in logLines:
            lText = line.lower()
            if 'abort' in lText or 'warning' in lText:
                hasWarnings = True
            if lText.find('species read in') > -1:
                temp = lText.strip()
                specCount = int(temp.split(' ')[0])
        # output summary and warnings
        messageText = 'Marxan execution completed\n'
        tt = time.strftime("%H:%M:%S", time.gmtime((runFinish-loadStart).seconds))
        lt = time.strftime("%H:%M:%S", time.gmtime((runStart-loadStart).seconds))
        rt = time.strftime("%H:%M:%S", time.gmtime((runFinish-runStart).seconds))
        messageText += 'Load time: %s\n' % lt
        messageText += 'Runs time: %s\n' % rt
        messageText += 'Total time: %s\n' % tt
        if hasWarnings:
            messageText += 'WARNING: The log file has warnings. Please check before using results!!\n'
        if specCount == 0:
            messageText += 'WARNING: Number of species registered appears to be zero. Check results and log file before using!\n'
        if hasWarnings == False and specCount > 0:
            messageText += 'No warnings or errors detected\n'
    if abort or hasWarnings:
        status = 'Error'
    else:
        status = 'Success'

    return(status,messageText)
