# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QMapaDockWidget
                                 A QGIS plugin
 Wtyczka do programu QGIS służąca do wizualizacji mapy zasadniczej z plików
 GML obejmujących zbiory danych EGiB, GESUT i BDOT500 zgodnie ze standardami
 opublikowanymi w rozporządzeniu Ministra Rozwoju, Pracy i Technologii z dnia
 23 lipca 2021 r. w sprawie bazy danych obiektów topograficznych oraz mapy
 zasadniczej.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-04-07
        git sha              : $Format:%H$
        copyright            : (C) 2022 by  
        email                :  
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import webbrowser

from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal, pyqtSlot, QCoreApplication
from qgis.PyQt.QtWidgets import QFileDialog
from qgis.utils import iface
from qgis.core import *
from qgis.gui import *

import gc

# import z folderu src
from .src.qmapa_main import Main
from .src.express_yourself import ExpressYourself
from .src.area_symbol_fill import fill

from .src.simple_gml_import import SimpleGmlImport
from .src.change_map_appearance import ChangeAppearance

from .src.analytics import runAnalytics

from QMapa import FILL_PARAMETERS

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ui', 'qmapa_dockwidget_base.ui'))


class QMapaDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(QMapaDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        # pozwalanie na powrot do pierwotnej symbolizacji

        self.back_wers = True
        self.back_fill = True

        self.setupUi(self)

        # sprawdzenie wersji programu
        plugin_ver = ChangeAppearance().checkVersion(self.lbVersion)

        runAnalytics(1, f"{Qgis.QGIS_VERSION}, {plugin_ver}")

        self.cmbStylization.addItems(Main().getStylizations(omit_special=True))

        # aktywne zbiory dla fillowania
        self.active_sets = []


        # Dodanie aktualnej informacji
        ChangeAppearance().checkAdditionalInfo(self.lbAdditionalInfo)

        self.progressBar.hide()

        self.rel_times = 0

        ChangeAppearance().setRedLabels(self.cmbReda.currentText())

        self.dispSettings()

        iface.mapCanvas().refreshAllLayers()

        iface.mapCanvas().scaleChanged.connect(lambda: ChangeAppearance().setLegendScale(ChangeAppearance().getSelectedScale(self.cmbStylization.currentText())))

        ChangeAppearance().setLegendScale(ChangeAppearance().getSelectedScale(self.cmbStylization.currentText()))


    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    @pyqtSlot()
    def on_pbLogo_clicked(self):
        """Przycisk wywolania strony po nacisnieciu Logo GEOXY"""
        webbrowser.open('http://www.geoxy.pl/')

    @pyqtSlot()
    def on_pbImport_clicked(self):
        """Zaimportowanie pliku GML z konwersją do GPKG oraz nadaniem grup warstw"""
        gc.collect()
        runAnalytics(2, 1)
        dial = QFileDialog(self)
        name, ext = dial.getOpenFileName(self, caption='Wybierz wejściowy plik GML',
                                                filter='gml (*.gml)')

        # zaimportowanie pliku gml
        if name:
            vec_lays_list = SimpleGmlImport().runImport(name, self.progressBar, self.cmbStylization.currentText())

            ChangeAppearance().setRedLabels(self.cmbReda.currentText())
            self.dispSettings()
            self.back_wers = False
            self.back_fill = False
            if self.gbShowWers.isChecked():
                self.dispVers(vec_lays_list)  # sprawdzenie i nadanie wyswietlania wersji
            if self.gbFill.isChecked():
                self.fillSelectSet(vec_lays_list)  # sprawdzenie i nadanie fillowania
            ChangeAppearance().setLegendScale(ChangeAppearance().getSelectedScale(self.cmbStylization.currentText()))
            QCoreApplication.processEvents()
        vec_lays_list = None

    def on_cmbStylization_currentTextChanged(self):
        """ustaw stylizację wybraną w comboboxie"""
        runAnalytics(3, 1)
        ChangeAppearance().backToQmlSymb(self.cmbStylization.currentText(), ChangeAppearance().getLayers())
        if self.gbShowWers.isChecked():
            self.dispVers(ChangeAppearance().getLayers())  # sprawdzenie i nadanie wyswietlania wersji
        if self.gbFill.isChecked():
            self.fillSelectSet(ChangeAppearance().getLayers())  # sprawdzenie i nadanie fillowania

    def on_cmbReda_currentTextChanged(self):
        runAnalytics(3, 2)
        ChangeAppearance().setRedLabels(self.cmbReda.currentText())

    def on_chbShowPierwsze_stateChanged(self):
        self.dispSettings()

    def on_chbShowModyfikowane_stateChanged(self):
        self.dispSettings()

    def on_chbShowArchiwalne_stateChanged(self):
        self.dispSettings()

    def on_chbShowZamkniete_stateChanged(self):
        self.dispSettings()

    def on_chbShowWczesniejsze_stateChanged(self):
        self.dispSettings()

    def on_chbColorPierwsze_stateChanged(self):
        self.dispSettings()

    def on_chbColorModyfikowane_stateChanged(self):
        self.dispSettings()

    def on_chbColorArchiwalne_stateChanged(self):
        self.dispSettings()

    def on_chbColorZamkniete_stateChanged(self):
        self.dispSettings()

    def on_chbColorWczesniejsze_stateChanged(self):
        self.dispSettings()

    def on_colPierwsze_stateChanged(self):
        self.dispSettings()

    def on_colModyfikowane_stateChanged(self):
        self.dispSettings()

    def on_colArchiwalne_stateChanged(self):
        self.dispSettings()

    def on_colZamkniete_stateChanged(self):
        self.dispSettings()

    def on_colWczesniejsze_stateChanged(self):
        self.dispSettings()

    def on_colPierwsze_colorChanged(self):
        self.dispSettings()

    def on_colModyfikowane_colorChanged(self):
        self.dispSettings()

    def on_colArchiwalne_colorChanged(self):
        self.dispSettings()

    def on_colZamkniete_colorChanged(self):
        self.dispSettings()

    def on_colWczesniejsze_colorChanged(self):
        self.dispSettings()

    def on_chbZnacznik_stateChanged(self):
        self.dispSettings()

    def on_dteZnacznik_valueChanged(self):
        self.dispSettings()

    def on_gbShowWers_toggled(self,state):
        runAnalytics(3, 4)
        self.gbShowWers.setEnabled(False)
        QCoreApplication.processEvents()
        self.dispVers(ChangeAppearance().getLayers())
        if state:
            # uncheck dla wersji, dodanie zeby nie wracalo wtedy do poprzedniego qml przy uncheck (bo inaczej robi sie 2 razy)
            self.back_fill = False
            self.gbFill.setChecked(False)
            self.gbFill.setCollapsed(True)
        self.back_fill = True
        self.gbShowWers.setEnabled(True)

    def on_gbFill_toggled(self, state):
        """GroupBox dla fillowania w zaleznosci od wyswietlanego zbioru danych"""
        runAnalytics(3, 3)
        self.gbFill.setEnabled(False)
        QCoreApplication.processEvents()
        self.fillSelectSet(ChangeAppearance().getLayers())
        if state is True:
            # uncheck dla wersji, dodanie zeby nie wracalo wtedy do poprzedniego gml przy uncheck (bo inaczej robi sie 2 razy)
            self.back_wers = False
            self.gbShowWers.setChecked(False)
            self.gbShowWers.setCollapsed(True)
        self.back_wers = True
        self.gbFill.setEnabled(True)

    def on_chbFillBDOT_stateChanged(self):
        self.fillSelectSet(ChangeAppearance().getLayers())

    def on_chbFillEGIB_stateChanged(self):
        self.fillSelectSet(ChangeAppearance().getLayers())

    def on_chbFillGESUT_stateChanged(self):
        self.fillSelectSet(ChangeAppearance().getLayers())

    # FUNKCJE
    def dispSettings(self):
        """ustawienia dotyczace wyswietlania po wersjach:
        pobranie ustawien z okna wtyczki i zapisanie do zmiennych w projekcie
        obsluga aktywowania opcji w oknie wtyczki"""

        # todo : opisac
        #
        # Pierwsze
        if self.chbShowPierwsze.isChecked():
            self.chbColorPierwsze.setEnabled(True)
            vis_Pierwsze = True
            if self.chbColorPierwsze.isChecked() is True:
                self.colPierwsze.setEnabled(True)
                # color_Pierwsze = "'" + ','.join([str(x) for x in self.colPierwsze.color().getRgb()]) + "'"
                color_Pierwsze = ','.join([str(x) for x in self.colPierwsze.color().getRgb()])
                set_color_Pierwsze = True
            else:
                self.colPierwsze.setEnabled(False)
                set_color_Pierwsze = False
                color_Pierwsze = '0'
        else:
            set_color_Pierwsze = False
            vis_Pierwsze = False
            color_Pierwsze = '0'
            self.chbColorPierwsze.setEnabled(False)
            self.colPierwsze.setEnabled(False)

        # Modyfikowane
        if self.chbShowModyfikowane.isChecked():
            self.chbColorModyfikowane.setEnabled(True)
            vis_Modyfikowane = True
            if self.chbColorModyfikowane.isChecked() is True:
                self.colModyfikowane.setEnabled(True)
                # color_Modyfikowane = "'" + ','.join([str(x) for x in self.colModyfikowane.color().getRgb()]) + "'"
                color_Modyfikowane = ','.join([str(x) for x in self.colModyfikowane.color().getRgb()])
                set_color_Modyfikowane = True
            else:
                self.colModyfikowane.setEnabled(False)
                set_color_Modyfikowane = False
                color_Modyfikowane = '0'
        else:
            set_color_Modyfikowane = False
            vis_Modyfikowane = False
            color_Modyfikowane = '0'
            self.chbColorModyfikowane.setEnabled(False)
            self.colModyfikowane.setEnabled(False)

        # Archiwalne
        if self.chbShowArchiwalne.isChecked():
            self.chbColorArchiwalne.setEnabled(True)
            vis_Archiwalne = True
            if self.chbColorArchiwalne.isChecked() is True:
                self.colArchiwalne.setEnabled(True)
                # color_Archiwalne = "'" + ','.join([str(x) for x in self.colArchiwalne.color().getRgb()]) + "'"
                color_Archiwalne = ','.join([str(x) for x in self.colArchiwalne.color().getRgb()])
                set_color_Archiwalne = True
            else:
                self.colArchiwalne.setEnabled(False)
                set_color_Archiwalne = False
                color_Archiwalne = '0'
        else:
            set_color_Archiwalne = False
            vis_Archiwalne = False
            color_Archiwalne = '0'
            self.chbColorArchiwalne.setEnabled(False)
            self.colArchiwalne.setEnabled(False)

        # Zamkniete
        if self.chbShowZamkniete.isChecked():
            self.chbColorZamkniete.setEnabled(True)
            vis_Zamkniete = True
            if self.chbColorZamkniete.isChecked() is True:
                self.colZamkniete.setEnabled(True)
                # color_Zamkniete = "'" + ','.join([str(x) for x in self.colZamkniete.color().getRgb()]) + "'"
                color_Zamkniete = ','.join([str(x) for x in self.colZamkniete.color().getRgb()])
                set_color_Zamkniete = True
            else:
                self.colZamkniete.setEnabled(False)
                set_color_Zamkniete = False
                color_Zamkniete = '0'
        else:
            set_color_Zamkniete = False
            vis_Zamkniete = False
            color_Zamkniete = '0'
            self.chbColorZamkniete.setEnabled(False)
            self.colZamkniete.setEnabled(False)

        # Znacznik czasu
        if self.chbZnacznik.isChecked():
            self.dteZnacznik.setEnabled(True)
            date_to_compare = self.dteZnacznik.dateTime()
            self.chbShowWczesniejsze.setEnabled(True)

            # Wczesniejsze
            if self.chbShowWczesniejsze.isChecked():
                self.chbColorWczesniejsze.setEnabled(True)
                vis_Wczesniejsze = True
                if self.chbColorWczesniejsze.isChecked() is True:
                    self.colWczesniejsze.setEnabled(True)
                    # color_Wczesniejsze = "'" + ','.join([str(x) for x in self.colWczesniejsze.color().getRgb()]) + "'"
                    color_Wczesniejsze = ','.join([str(x) for x in self.colWczesniejsze.color().getRgb()])
                    set_color_Wczesniejsze = True
                else:
                    self.colWczesniejsze.setEnabled(False)
                    set_color_Wczesniejsze = False
                    color_Wczesniejsze = '0'
            else:
                set_color_Wczesniejsze = False
                vis_Wczesniejsze = False
                color_Wczesniejsze = '0'
                self.chbColorWczesniejsze.setEnabled(False)
                self.colWczesniejsze.setEnabled(False)

        else:
            self.dteZnacznik.setEnabled(False)
            date_to_compare = '0'

            # wczesniejsze cd
            self.chbShowWczesniejsze.setEnabled(False)
            set_color_Wczesniejsze = False
            vis_Wczesniejsze = False
            color_Wczesniejsze = '0'
            self.chbColorWczesniejsze.setEnabled(False)
            self.colWczesniejsze.setEnabled(False)

        # dodanie zmiennych do projektu
        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'Pierwsze',
                                                     str([vis_Pierwsze, set_color_Pierwsze, color_Pierwsze]))
        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'Modyfikowane',
                                                     str([vis_Modyfikowane, set_color_Modyfikowane, color_Modyfikowane]))
        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'Archiwalne',
                                                     str([vis_Archiwalne, set_color_Archiwalne, color_Archiwalne]))
        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'Zamkniete',
                                                     str([vis_Zamkniete, set_color_Zamkniete, color_Zamkniete]))
        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'Wczesniejsze',
                                                     str([vis_Wczesniejsze, set_color_Wczesniejsze, color_Wczesniejsze]))

        QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), 'DateCompare', date_to_compare)

        iface.mapCanvas().refreshAllLayers()

    def fillSelectSet(self, layers_list):
        if self.back_fill:
            ChangeAppearance().backToQmlSymb(self.cmbStylization.currentText(), layers_list)

        self.back_fill = True

        on = self.gbFill.isChecked()
        if on:
            current_scale = ChangeAppearance().getSelectedScale(self.cmbStylization.currentText())

            # pobranie aktywnych przyciskow
            if self.chbFillBDOT.isChecked() and 'OT' not in self.active_sets:
                self.active_sets.append('OT')
            elif self.chbFillBDOT.isChecked() is False and 'OT' in self.active_sets:
                self.active_sets.remove('OT')

            if self.chbFillEGIB.isChecked() and 'EGB' not in self.active_sets:
                self.active_sets.append('EGB')
            elif self.chbFillEGIB.isChecked() is False and 'EGB' in self.active_sets:
                self.active_sets.remove('EGB')

            if self.chbFillGESUT.isChecked() and 'GES' not in self.active_sets:
                self.active_sets.append('GES')
            elif self.chbFillGESUT.isChecked() is False and 'GES' in self.active_sets:
                self.active_sets.remove('GES')

            # przejscie po zaznaczonych zbiorach i nadanie wypelnien
            for set in self.active_sets:
                fill(excel_path=FILL_PARAMETERS, scale=current_scale, set=set, layers = layers_list)

            ChangeAppearance().setLegendScale(ChangeAppearance().getSelectedScale(self.cmbStylization.currentText()))

    def dispVers(self, layers_list):
        """ustawienie wyswietlania/niewyswietlania po wersjach"""
        on = self.gbShowWers.isChecked()
        # powrot do pierwotnej stylizacji
        if self.back_wers:
            ChangeAppearance().backToQmlSymb(self.cmbStylization.currentText(), layers_list)

        self.back_wers = True

        if on:
            self.dispSettings()
            expr_show = " with_variable( 'show', pokaz_wersje(if (@DateCompare is '0', @DateCompare, to_datetime(@DateCompare)), @Pierwsze, @Modyfikowane, @Archiwalne, @Zamkniete, @Wczesniejsze, concat(" + '"startObiekt"' + ", ''),concat(" + '"startWersjaObiekt"' + ", ''),concat(" + '"koniecObiekt"' + ", ''),concat(" + '"koniecWersjaObiekt"' + ", '')),  if( var('show'), 1111, var('show')))"
            expr_color = " with_variable( 'color', kolor_wersji(if (@DateCompare is '0', @DateCompare, to_datetime(@DateCompare)), @Pierwsze, @Modyfikowane, @Archiwalne, @Zamkniete, @Wczesniejsze, concat(" + '"startObiekt"' + ", ''),concat(" + '"startWersjaObiekt"' + ", ''),concat(" + '"koniecObiekt"' + ", ''),concat(" + '"koniecWersjaObiekt"' + ", '')),  if( var('color'), var('color'), 1111))"

            expression = ExpressYourself(expr_color, expr_show)
            expression.setSymbolExpression(layers_list)
            expression.setLabelExpression(layers_list)

            ChangeAppearance().setLegendScale(ChangeAppearance().getSelectedScale(self.cmbStylization.currentText()))
        else:
            # powrot do pierwotnej stylizacji z QML
            #self.back_to_qml_symb()
            pass