# -*- coding: utf-8 -*-

"""
/***************************************************************************
 QLearn
                                 A QGIS plugin
 QLearn preforms automatic training of a neural network model on raster data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-01
        copyright            : (C) 2025 by Adam B
        email                : adam {at} ardanika {dot} com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Adam B'
__date__ = '2025-02-01'
__copyright__ = '(C) 2025 by Adam B'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessingAlgorithm,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterFile)

from .QLearnPredict import QNNPredictor
import torch
import traceback


class QLearnPredictionAlgorithm(QgsProcessingAlgorithm):
    
    def flags(self):
        return super().flags() #| QgsProcessingAlgorithm.FlagNoThreading
    
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    INPUT_MODEL = 'INPUT_MODEL'
    INPUT_RASTER = 'INPUT_RASTER'
    ARGS_CONF = 'ARGS_CONF' # minimum confidence level
    OUTPUT_RASTER = 'OUTPUT_PREDICTED_RASTER'
    ARGS_OVERLAP = 'ARGS_OVERLAP' # number of pixels to overlap chunks

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # Input Rasters for prediction
        self.addParameter(
            QgsProcessingParameterRasterLayer(
                self.INPUT_RASTER,
                self.tr("Input Raster")
            )
        )

        # Input Model to predict with
        self.addParameter(
            QgsProcessingParameterFile(
            self.INPUT_MODEL,
            self.tr("PyTorch Model"))
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                self.ARGS_CONF,
                self.tr("Minimum Confidence level for predicted value (otherwise overwrite with NODATA)"),
                defaultValue=0.0,
                minValue=0.0,
                maxValue=1.0,
                type=QgsProcessingParameterNumber.Double,
                optional=True,
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                self.ARGS_OVERLAP,
                self.tr("Overlap between chunks to prevent edge artifacts"),
                defaultValue=8,
                minValue=0,
                type=QgsProcessingParameterNumber.Integer,
                optional=True,
            )
        )

        # Output predicted raster
        self.addParameter(
            QgsProcessingParameterRasterDestination(
                self.OUTPUT_RASTER,
                self.tr("Output Predicted Raster")
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        
        iRaster = self.parameterAsRasterLayer(parameters, self.INPUT_RASTER, context)
        iModel = self.parameterAsFile(parameters,self.INPUT_MODEL,context)
        oRaster = self.parameterAsOutputLayer(parameters,self.OUTPUT_RASTER,context)
        confidence = self.parameterAsDouble(parameters,self.ARGS_CONF, context)
        overlap = self.parameterAsInt(parameters,self.ARGS_OVERLAP, context)


        args = {
            "CONFIDENCE": confidence,
            "OVERLAP": overlap # number of pixels to overlap chunks
        }

        feedback.pushInfo(f"Args: {args}")
        
        predictor = QNNPredictor(iModel,context,feedback,args)
        predictor.predict(iRaster, oRaster)
        
        return {self.OUTPUT_RASTER: oRaster}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'QLearnPredict'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Prediction'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return QLearnPredictionAlgorithm()
