# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QHadoopTools
                                 A QGIS plugin
 This plugin Spatial Hadoop Tools
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-11-03
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Salomón Einstein
        email                : seramirezf@correo.udistrital.edu.co
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
import os, sys, tempfile, shutil, codecs, traceback, re

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
from .webhdfs import WebHDFS, WebHDFSError

from .resources import *
from .copyFromHDFStoLocal_dlg import CopyFromHDFStoLocalDlg
from .copyFromLocalToHDFS_dlg import CopyFromLocalToHDFSdlg
from .fixJSONtoGeoJSON_dlg import fixJSONtoGeoJSONdlg


class QHadoopTools:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'QHadoopTools_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&QHadoop Tools')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.dlgTool1 = CopyFromHDFStoLocalDlg()
        self.dlgTool3 = CopyFromLocalToHDFSdlg()
        self.dlgTool2 = fixJSONtoGeoJSONdlg()
        

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('QHadoopTools', message)


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        self.toolBar = self.iface.addToolBar("QHadoopTools")
        self.toolBar.setObjectName("QHadoopTools")

        self.act1 = QAction(
                            QIcon(":/plugins/Hadoop_Tools/icons/hdfsToLocal.png"), 
                            QCoreApplication.translate(u'&QHadoop Tools', "Copy from HDFS to Local"), 
                            self.iface.mainWindow()
                            )
                            
        self.act3 = QAction(
                            QIcon(":/plugins/Hadoop_Tools/icons/localToHdfs.png"), 
                            QCoreApplication.translate(u'&QHadoop Tools', "Copy from Local to HDFS"), 
                            self.iface.mainWindow()
                            )
                            
        self.act2 = QAction(
                            QIcon(":/plugins/Hadoop_Tools/icons/jsonToGeojson.png"), 
                            QCoreApplication.translate(u'&QHadoop Tools', "Fix JSON to GeoJSON"), 
                            self.iface.mainWindow()
                            )
        
                            
        self.toolBar.addAction(self.act1)
        self.toolBar.addAction(self.act3)
        self.toolBar.addAction(self.act2)


        self.act1.triggered.connect(self.runTool1)
        self.act3.triggered.connect(self.runTool3)
        self.act2.triggered.connect(self.runTool2)

        
        
    def runTool1(self):
        self.dlgTool1.btnFindPath.clicked.connect(self.saveFile)
        self.dlgTool1.btnExecute.clicked.connect(self.copyFromHDFStoLocal)
        self.dlgTool1.cbxProtocol.currentTextChanged.connect(self.changePortOut)  
        self.dlgTool1.show()

        
    def runTool2(self):
        self.dlgTool2.btnOFIn.clicked.connect(self.openFile)
        self.dlgTool2.btnFix.clicked.connect(self.fixJSONtoGeoJSON)
        self.dlgTool2.show()
        
    def runTool3(self):
        self.dlgTool3.btnFindPath.clicked.connect(self.openFile)
        self.dlgTool3.btnExecute.clicked.connect(self.copyFromLocalToHDFS)
        self.dlgTool3.cbxProtocol.currentTextChanged.connect(self.changePortIn)  
        self.dlgTool3.show()


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&QHadoop Tools'),
                action)
            self.iface.removeToolBarIcon(action)
         
         
    def changePortOut(self):
        if self.dlgTool1.cbxProtocol.currentText()=='http':
            self.dlgTool1.txtPort.setText('50070')
        elif self.dlgTool1.cbxProtocol.currentText()=='https':
            self.dlgTool1.txtPort.setText('50470') 

    def changePortIn(self):
        if self.dlgTool3.cbxProtocol.currentText()=='http':
            self.dlgTool3.txtPort.setText('50070')
        elif self.dlgTool3.cbxProtocol.currentText()=='https':
            self.dlgTool3.txtPort.setText('50470')              


    def saveFile(self):
        """ """
        dirName = QFileDialog.getSaveFileName(self.dlgTool1, "Save File", 
            filter="JSON Files (*.json;*.geojson;*.geojsonl; *.geojson;*.nlgeojson)")
        self.dlgTool1.txtOut.setText(dirName[0])
        
        
    def openFile(self):
        """ """
        dirName = QFileDialog.getOpenFileName(self.dlgTool2, "Open File", 
            filter="JSON Files (*.json;*.geojson;*.geojsonl; *.geojson;*.nlgeojson)")
        self.dlgTool2.txtIn.setText(dirName[0])

    
    def AddExceptionError(self, messages, message = ''):
        """ """
        for ei in sys.exc_info():
            if isinstance(ei, Exception):
                messages.addErrorMessage(f"{message if (message != None and len(message) > 0) else 'Unexpected error'}:{str(ei)}")
        messages.addErrorMessage(traceback.format_exc())


    def FixSchemeSpecifier(self, url, scheme, b_add):
        """ """
        if (url == None) : return None
        scheme += "://"
        schIndex = url.find(scheme)
        if schIndex >= 0 :
            if b_add == False :
                return url[schIndex + len(scheme) : ]
        else :
            if b_add == True :
                return scheme + url
        return url


    def CheckHDFSFileExist(self,whConn, webhdfs_file) :
        if webhdfs_file and len(unicode(webhdfs_file)) :
            (webhdfs_path, webhdfs_name) = os.path.split(webhdfs_file)
        
        files = whConn.listDirEx(webhdfs_path)
        for f in files :
            if f['type'] == 'FILE' and f['pathSuffix'] == webhdfs_name :
                return True
        return False
    

    def copyFromHDFStoLocal(self, messages):
        """ """
        webhdfs_host = self.FixSchemeSpecifier(self.dlgTool1.txtHost.text(), self.dlgTool1.cbxProtocol.currentText(), False)
        webhdfs_port =  int(self.dlgTool1.txtPort.text())
        webhdfs_user = self.dlgTool1.txtUser.text()
        webhdfs_file = unicode(self.dlgTool1.txtPath.text())
        print(webhdfs_file)
        out_local_file_name = unicode(self.dlgTool1.txtOut.text()) 

        try :
            if os.path.isfile(out_local_file_name):
                os.remove(out_local_file_name)
        except ValueError as e:
            print("Cannot delete: " + out_local_file_name + "\n Error:" + e)
            sys.exit()
            
        try:
            wh = WebHDFS(webhdfs_host, webhdfs_port, webhdfs_user)
            fs = wh.getFileStatus(webhdfs_file)
            if fs['type'] == 'FILE':
                wh.copyFromHDFS(webhdfs_file, out_local_file_name, overwrite = True)
            else: 
                temp_file = tempfile.NamedTemporaryFile(delete = False)
                temp_file_name = temp_file.name
                temp_file.close()
                
                with open(out_local_file_name, "wb") as out_local_file:
                    file_list = wh.listDirEx(webhdfs_file)
                    for file in file_list:
                        if file['length'] != 0 :
                            wh.copyFromHDFS(webhdfs_file + '/' + file['pathSuffix'], temp_file_name, overwrite = True)
                            temp_file = open(temp_file_name, "rb")
                            shutil.copyfileobj(temp_file, out_local_file, length = 1024 * 1024)
                            #out_local_file.write('\n')
                            temp_file.close()
                os.remove(temp_file_name)
        except WebHDFSError as whe:
            print(messages.addErrorMessage(str(whe)))
            messages.addErrorMessage(str(whe))
        except:
            self.AddExceptionError(messages)
        return


    def copyFromLocalToHDFS(self, messages):

        webhdfs_host = self.FixSchemeSpecifier(self.dlgTool1.txtHost.text(), self.dlgTool3.cbxProtocol.currentText(), False)
        webhdfs_port =  int(self.dlgTool3.txtPort.text())
        webhdfs_user = self.dlgTool3.txtUser.text()
        webhdfs_file = unicode(self.dlgTool3.txtPath.text())
        inLocal_file = unicode(self.dlgTool3.txtIn.text()) 

        try :
            wh = WebHDFS(webhdfs_host, webhdfs_port, webhdfs_user)
            b_file_exist = self.CheckHDFSFileExist(wh, webhdfs_file)
            
            if inLocal_file and b_file_exist:
                wh.appendToHDFS(unicode(inLocal_file), unicode(webhdfs_file))
            else:
                wh.copyToHDFS(unicode(inLocal_file), unicode(webhdfs_file), overwrite = True)
        except WebHDFSError as whe:
            messages.addErrorMessage(str(whe))
        except:
            self.AddExceptionError(messages)
            
        return
 
 
    def fixJSONtoGeoJSON(self):
        with open(self.dlgTool2.txtIn.text(),'r+') as f:
            file = f.read()
            if re.search('"attributes"',file) and re.search('"rings"',file):
                file = re.sub('"attributes"', '"type": "Feature", "properties"', file)
                file = re.sub('"rings"', '"type": "Polygon", "coordinates"', file)
                f.seek(0)
                f.write(file)
                f.truncate()
                QMessageBox.information(None,"test","Did fix!")
            else:
                QMessageBox.information(None,"test","Didn't fix!")