--
-- PostgreSQL database dump
--

-- Dumped from database version 11.11 (Ubuntu 11.11-1.pgdg20.04+1)
-- Dumped by pg_dump version 13.2 (Ubuntu 13.2-1.pgdg20.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 15 (class 2615 OID 905776)
-- Name: measure; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA measure;


ALTER SCHEMA measure OWNER TO postgres;

--
-- TOC entry 6 (class 2615 OID 905465)
-- Name: metadata; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA metadata;


ALTER SCHEMA metadata OWNER TO postgres;

--
-- TOC entry 6086 (class 0 OID 0)
-- Dependencies: 6
-- Name: SCHEMA metadata; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA metadata IS 'Schema where metadata about imported data are stored';


--
-- TOC entry 11 (class 2615 OID 907085)
-- Name: qgis; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA qgis;


ALTER SCHEMA qgis OWNER TO postgres;

--
-- TOC entry 6087 (class 0 OID 0)
-- Dependencies: 11
-- Name: SCHEMA qgis; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA qgis IS 'Schema where views for QGIS visualisation are stored';


--
-- TOC entry 12 (class 2615 OID 905432)
-- Name: ref; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ref;


ALTER SCHEMA ref OWNER TO postgres;

--
-- TOC entry 6088 (class 0 OID 0)
-- Dependencies: 12
-- Name: SCHEMA ref; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA ref IS 'Schema where references and constants are stored';


--
-- TOC entry 14 (class 2615 OID 905481)
-- Name: station; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA station;


ALTER SCHEMA station OWNER TO postgres;

--
-- TOC entry 6089 (class 0 OID 0)
-- Dependencies: 14
-- Name: SCHEMA station; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA station IS 'Main schema where data about drill station are stored';


--
-- TOC entry 9 (class 2615 OID 907042)
-- Name: tr; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tr;


ALTER SCHEMA tr OWNER TO postgres;

--
-- TOC entry 6090 (class 0 OID 0)
-- Dependencies: 9
-- Name: SCHEMA tr; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA tr IS 'Schema where descriptions and translations are stored';


--
-- TOC entry 16 (class 2615 OID 904800)
-- Name: utils; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA utils;


ALTER SCHEMA utils OWNER TO postgres;

--
-- TOC entry 3 (class 3079 OID 904809)
-- Name: btree_gist; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS btree_gist WITH SCHEMA utils;


--
-- TOC entry 6092 (class 0 OID 0)
-- Dependencies: 3
-- Name: EXTENSION btree_gist; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION btree_gist IS 'support for indexing common datatypes in GiST';


--
-- TOC entry 2 (class 3079 OID 903222)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 6093 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';


--
-- TOC entry 2298 (class 1247 OID 905447)
-- Name: rgb_hex; Type: DOMAIN; Schema: ref; Owner: postgres
--

CREATE DOMAIN ref.rgb_hex AS text
  CONSTRAINT rgb_hex_check CHECK ((VALUE ~ '^#[0123456789abcdef]{6}$'::text));


ALTER DOMAIN ref.rgb_hex OWNER TO postgres;

--
-- TOC entry 6094 (class 0 OID 0)
-- Dependencies: 2298
-- Name: DOMAIN rgb_hex; Type: COMMENT; Schema: ref; Owner: postgres
--

COMMENT ON DOMAIN ref.rgb_hex IS 'Text representation of RGB colors with html format #rrggbb';


--
-- TOC entry 2291 (class 1247 OID 905434)
-- Name: roc_code_authority; Type: TYPE; Schema: ref; Owner: postgres
--

CREATE TYPE ref.roc_code_authority AS ENUM (
    'USGS'
);


ALTER TYPE ref.roc_code_authority OWNER TO postgres;

--
-- TOC entry 2338 (class 1247 OID 905590)
-- Name: borehole_type; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.borehole_type AS ENUM (
    'Piezometer',
    'CoreDrill',
    'FilledUpDrill',
    'GeotechnicDrill',
    'Borehole',
    'Well',
    'DrainWell'
);


ALTER TYPE station.borehole_type OWNER TO postgres;

--
-- TOC entry 2366 (class 1247 OID 905685)
-- Name: chimney_type; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.chimney_type AS ENUM (
    'Chimney'
);


ALTER TYPE station.chimney_type OWNER TO postgres;

--
-- TOC entry 2386 (class 1247 OID 905748)
-- Name: device_type; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.device_type AS ENUM (
    'MeasurementDevice',
    'DrainagePump'
);


ALTER TYPE station.device_type OWNER TO postgres;

--
-- TOC entry 2357 (class 1247 OID 905659)
-- Name: hydrology_station_type; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.hydrology_station_type AS ENUM (
    'River',
    'Spring'
);


ALTER TYPE station.hydrology_station_type OWNER TO postgres;

--
-- TOC entry 2376 (class 1247 OID 905712)
-- Name: sample_family; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.sample_family AS ENUM (
    'Air',
    'Ground',
    'Water',
    'Animal',
    'Plant'
);


ALTER TYPE station.sample_family OWNER TO postgres;

--
-- TOC entry 2325 (class 1247 OID 905526)
-- Name: station_family; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.station_family AS ENUM (
    'Borehole',
    'Chimney',
    'Weather_Station',
    'Hydrology_Station',
    'Sample',
    'Device'
);


ALTER TYPE station.station_family OWNER TO postgres;

--
-- TOC entry 2348 (class 1247 OID 905630)
-- Name: weather_station_type; Type: TYPE; Schema: station; Owner: postgres
--

CREATE TYPE station.weather_station_type AS ENUM (
    'Pluviometer',
    'WeatherStation',
    'WeatherMast'
);


ALTER TYPE station.weather_station_type OWNER TO postgres;

--
-- TOC entry 1822 (class 1255 OID 906893)
-- Name: _create_cumulative_chemical_measure_over_time_table(text, text, text); Type: FUNCTION; Schema: measure; Owner: postgres
--

CREATE FUNCTION measure._create_cumulative_chemical_measure_over_time_table(table_name text, title text, unit text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
begin
  execute format($sql$
    create table measure.%s (
       id serial primary key
       , station_id bigint not null references station(id) on delete cascade
       , chemical_element text not null
       , radionuclide text
       , start_measure_time timestamp not null
       , end_measure_time timestamp not null
       , measure_value double precision
       , measure_uncertainty double precision
       , measure_legend text
       , reference text -- original file
       , campaign_id bigint references campaign(id) default 1
       , dataset_id int /*not null*/ references metadata.dataset(id) on delete cascade
       , unique (station_id, start_measure_time, campaign_id, chemical_element)
    )$sql$, table_name);
  execute format($sql$
    insert into measure_metadata (measure_table, name, unit_of_measure, measure_category, x_axis_type, storage_type) values ('%s', %s, %s, 'Rejets gazeux', 'TimeAxis', 'Cumulative')
    $sql$, table_name, quote_literal(title), quote_literal(unit));
  execute format($sql$
  select utils.create_measure_rls('measure', '%s');
  $sql$, table_name);
end;
$_$;


ALTER FUNCTION measure._create_cumulative_chemical_measure_over_time_table(table_name text, title text, unit text) OWNER TO postgres;

--
-- TOC entry 1819 (class 1255 OID 905815)
-- Name: _create_cumulative_measure_over_time_table(text, text, text, text); Type: FUNCTION; Schema: measure; Owner: postgres
--

CREATE FUNCTION measure._create_cumulative_measure_over_time_table(table_name text, title text, unit text, categorie text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
begin
  execute format($sql$
    create table measure.%s (
       id serial primary key
       , station_id bigint not null references station(id) on delete cascade
       , start_measure_time timestamp not null
       , end_measure_time timestamp not null
       , measure_value double precision
       , measure_uncertainty double precision
       , measure_legend text
       , periodicity text
       , reference text -- original file
       , campaign_id bigint references campaign(id) default 1
       , dataset_id int /*not null*/ references metadata.dataset(id) on delete cascade
       , unique (station_id, start_measure_time, campaign_id)
    )$sql$, table_name);
  execute format($sql$
    insert into measure_metadata (measure_table, name, unit_of_measure, measure_category, x_axis_type, storage_type) values ('%s', %s, %s, %s, 'TimeAxis', 'Cumulative')
    $sql$, table_name, quote_literal(title), quote_literal(unit), quote_literal(categorie));
  execute format($sql$
  select utils.create_measure_rls('measure', '%s');
  $sql$, table_name);
end;
$_$;


ALTER FUNCTION measure._create_cumulative_measure_over_time_table(table_name text, title text, unit text, categorie text) OWNER TO postgres;

--
-- TOC entry 1821 (class 1255 OID 906668)
-- Name: _create_instantaneous_chemical_measure_over_time_table(text, text, text, text); Type: FUNCTION; Schema: measure; Owner: postgres
--

CREATE FUNCTION measure._create_instantaneous_chemical_measure_over_time_table(table_name text, title text, unit text, categorie text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
begin
  execute format($sql$
    create table measure.%s (
       id serial primary key
       , station_id bigint not null references station(id) on delete cascade
       , chemical_element text not null
       , chemical_element_description text  -- null = insignificant ?
       , radionuclide text
       , measure_time timestamp not null
       , measure_value double precision
       , measure_uncertainty double precision
       , measure_legend text
       , detection_limit double precision
       , quantification_limit double precision
       , analysis_method text
       , sampling_method text
       , sample_code text
       , sample_family sample_family
       , sample_type text
       , sample_name text
       , sample_report text
       , report_number text
       , da_number text
       , campaign_id bigint references campaign(id) default 1
       , dataset_id int /*not null*/ references metadata.dataset(id) on delete cascade
       , unique (station_id, campaign_id, measure_time, chemical_element, sample_report, sample_code)
    )$sql$, table_name);
  execute format($sql$
    insert into measure_metadata (measure_table, name, unit_of_measure, measure_category, x_axis_type, storage_type) values ('%s', %s, %s, %s, 'TimeAxis', 'Instantaneous')
    $sql$, table_name, quote_literal(title), quote_literal(unit), quote_literal(categorie));
  execute format($sql$
  select utils.create_measure_rls('measure', '%s');
  $sql$, table_name);
end;
$_$;


ALTER FUNCTION measure._create_instantaneous_chemical_measure_over_time_table(table_name text, title text, unit text, categorie text) OWNER TO postgres;

--
-- TOC entry 1820 (class 1255 OID 906539)
-- Name: _create_instantaneous_measure_over_altitude_table(text, text, text, text); Type: FUNCTION; Schema: measure; Owner: postgres
--

CREATE FUNCTION measure._create_instantaneous_measure_over_altitude_table(table_name text, title text, unit text, categorie text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
begin
  execute format($sql$
    create table measure.%s (
       id serial primary key
       , station_id bigint not null references station(id) on delete cascade
       , measure_depth double precision not null
       , measure_value double precision
       , measure_uncertainty double precision
       , measure_legend text
       , campaign_id bigint references campaign(id) default 1
       , dataset_id int /*not null*/ references metadata.dataset(id) on delete cascade
       , unique (station_id, measure_depth, campaign_id)
    )$sql$, table_name);
  execute format($sql$
    insert into measure_metadata (measure_table, name, unit_of_measure, measure_category, x_axis_type, storage_type) values ('%s', %s, %s, %s, 'DepthAxis', 'Instantaneous')
    $sql$, table_name, quote_literal(title), quote_literal(unit), quote_literal(categorie));
  execute format($sql$
  select utils.create_measure_rls('measure', '%s');
  $sql$, table_name);
end;
$_$;


ALTER FUNCTION measure._create_instantaneous_measure_over_altitude_table(table_name text, title text, unit text, categorie text) OWNER TO postgres;

--
-- TOC entry 1818 (class 1255 OID 905814)
-- Name: _create_instantaneous_measure_over_time_table(text, text, text, text); Type: FUNCTION; Schema: measure; Owner: postgres
--

CREATE FUNCTION measure._create_instantaneous_measure_over_time_table(table_name text, title text, unit text, categorie text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
begin
  execute format($sql$
    create table measure.%s (
       id serial primary key
       , station_id bigint not null references station(id) on delete cascade
       , measure_time timestamp not null
       , measure_value double precision
       , measure_uncertainty double precision
       , measure_legend text
       , campaign_id bigint references campaign(id) default 1
       , dataset_id int /*not null*/ references metadata.dataset(id) on delete cascade
       , unique (station_id, measure_time, campaign_id)
    )$sql$, table_name);
  execute format($sql$
    insert into measure_metadata (measure_table, name, unit_of_measure, measure_category, x_axis_type, storage_type) values ('%s', %s, %s, %s, 'TimeAxis', 'Instantaneous')
    $sql$, table_name, quote_literal(title), quote_literal(unit), quote_literal(categorie));
  execute format($sql$
  select utils.create_measure_rls('measure', '%s');
  $sql$, table_name);
end;
$_$;


ALTER FUNCTION measure._create_instantaneous_measure_over_time_table(table_name text, title text, unit text, categorie text) OWNER TO postgres;

--
-- TOC entry 1792 (class 1255 OID 905479)
-- Name: delete_children_ft(); Type: FUNCTION; Schema: metadata; Owner: postgres
--

CREATE FUNCTION metadata.delete_children_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
begin
  delete from metadata.dataset
  using (
    select id, unnest(parent_ids) as parent_id
    from metadata.dataset
  ) to_del
  where
    to_del.parent_id = old.id
    and dataset.id = to_del.id
  ;
  return old;
end;
$$;


ALTER FUNCTION metadata.delete_children_ft() OWNER TO postgres;

--
-- TOC entry 1817 (class 1255 OID 905774)
-- Name: add_site_users_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.add_site_users_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $_$
begin
  -- trigger logic
  -- add <site>_admin and <site>_user roles each time a site is created
  insert into station.site_user(login, comment)
  values (NEW.name||'_admin', 'Admin role for site '||NEW.name);
  insert into station.site_user(login, comment)
  values (NEW.name||'_user', 'User role for site '||NEW.name);
  -- base admin has the edit and read privileges for the site privileges
  EXECUTE FORMAT(
  'INSERT INTO station.user_site_privilege VALUES (%L, $1, %L)',
  'postgres', 'EDIT'
  ) USING (select id from station.site where name=NEW.name);
  EXECUTE FORMAT(
  'INSERT INTO station.user_site_privilege VALUES (%L, $1, %L)',
  'postgres', 'RO'
  ) USING (select id from station.site where name=NEW.name);
  -- create admin role for the site
  PERFORM utils.create_role(NEW.name||'_admin');
  -- grant all access to this role on the schema tables and sequences
  EXECUTE FORMAT('GRANT ALL ON ALL TABLES IN SCHEMA metadata TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL SEQUENCES IN SCHEMA metadata TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL TABLES IN SCHEMA station TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL SEQUENCES IN SCHEMA station TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL TABLES IN SCHEMA measure TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL SEQUENCES IN SCHEMA measure TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL TABLES IN SCHEMA qgis TO %I', NEW.name||'_admin');
  EXECUTE FORMAT('GRANT ALL ON ALL SEQUENCES IN SCHEMA qgis TO %I', NEW.name||'_admin');
  -- site admin has the edit privilege for the corresponding site
  EXECUTE FORMAT(
  'INSERT INTO station.user_site_privilege VALUES (%L, $1, %L)',
  NEW.name||'_admin', 'EDIT'
  ) USING (select id from station.site where name=NEW.name);
  EXECUTE FORMAT(
  'INSERT INTO station.user_site_privilege VALUES (%L, $1, %L)',
  NEW.name||'_admin', 'RO'
  ) USING (select id from station.site where name=NEW.name);
  -- create user role and grant corresponding access
  PERFORM utils.create_role(NEW.name||'_user');
  -- grant select access to this role on the user_site_privilege table
  EXECUTE FORMAT('GRANT SELECT ON ALL TABLES IN SCHEMA metadata TO %I', NEW.name||'_user');
  EXECUTE FORMAT('GRANT SELECT ON ALL TABLES IN SCHEMA station TO %I', NEW.name||'_user');
  EXECUTE FORMAT('GRANT SELECT ON ALL TABLES IN SCHEMA measure TO %I', NEW.name||'_user');
  EXECUTE FORMAT('GRANT SELECT ON ALL TABLES IN SCHEMA qgis TO %I', NEW.name||'_user');
  -- user has the read privilege for the corresponding site
  EXECUTE FORMAT(
  'INSERT INTO station.user_site_privilege VALUES (%L, $1, %L)',
  NEW.name||'_user', 'RO'
  ) USING (select id from station.site where name=NEW.name);
  RETURN NEW;
end;
$_$;


ALTER FUNCTION station.add_site_users_ft() OWNER TO postgres;

--
-- TOC entry 1795 (class 1255 OID 905625)
-- Name: borehole_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.borehole_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.borehole s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_boreholes';
      return old;
    end;
    $$;


ALTER FUNCTION station.borehole_delete_ft() OWNER TO postgres;

--
-- TOC entry 1794 (class 1255 OID 905623)
-- Name: borehole_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.borehole_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.borehole_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.total_depth,new.top_of_casing_altitude,new.casing_height,new.casing_internal_diameter,new.casing_external_diameter,new.driller,new.drilling_date,new.drilling_method,new.location,new.num_bss,new.borehole_type,new.usage,new.condition --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.borehole_insert_ft() OWNER TO postgres;

--
-- TOC entry 1796 (class 1255 OID 905627)
-- Name: borehole_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.borehole_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.borehole_spec set (total_depth,top_of_casing_altitude,casing_height,casing_internal_diameter,casing_external_diameter,driller,drilling_date,drilling_method,location,num_bss,borehole_type,usage,condition) = (new.total_depth,new.top_of_casing_altitude,new.casing_height,new.casing_internal_diameter,new.casing_external_diameter,new.driller,new.drilling_date,new.drilling_method,new.location,new.num_bss,new.borehole_type,new.usage,new.condition) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.borehole_update_ft() OWNER TO postgres;

--
-- TOC entry 1807 (class 1255 OID 905707)
-- Name: chimney_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.chimney_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.chimney s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_chimneys';
      return old;
    end;
    $$;


ALTER FUNCTION station.chimney_delete_ft() OWNER TO postgres;

--
-- TOC entry 1806 (class 1255 OID 905705)
-- Name: chimney_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.chimney_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.chimney_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.chimney_type,new.nuclear_facility_name,new.facility_name,new.building_name,new.height,new.flow_rate,new.surface --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.chimney_insert_ft() OWNER TO postgres;

--
-- TOC entry 1808 (class 1255 OID 905709)
-- Name: chimney_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.chimney_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.chimney_spec set (chimney_type,nuclear_facility_name,facility_name,building_name,height,flow_rate,surface) = (new.chimney_type,new.nuclear_facility_name,new.facility_name,new.building_name,new.height,new.flow_rate,new.surface) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.chimney_update_ft() OWNER TO postgres;

--
-- TOC entry 1793 (class 1255 OID 905618)
-- Name: create_borehole_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_borehole_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, total_depth double precision, top_of_casing_altitude double precision, casing_height double precision, casing_internal_diameter double precision, casing_external_diameter double precision, driller text, drilling_date date, drilling_method text, location text, num_bss text, borehole_type station.borehole_type, usage text, condition text)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.total_depth,c.top_of_casing_altitude,c.casing_height,c.casing_internal_diameter,c.casing_external_diameter,c.driller,c.drilling_date,c.drilling_method,c.location,c.num_bss,c.borehole_type,c.usage,c.condition FROM station.borehole_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_borehole_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1805 (class 1255 OID 905700)
-- Name: create_chimney_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_chimney_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, chimney_type station.chimney_type, nuclear_facility_name text, facility_name text, building_name text, height double precision, flow_rate double precision, surface double precision)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.chimney_type,c.nuclear_facility_name,c.facility_name,c.building_name,c.height,c.flow_rate,c.surface FROM station.chimney_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_chimney_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1813 (class 1255 OID 905763)
-- Name: create_device_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_device_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, device_type station.device_type)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.device_type FROM station.device_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_device_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1801 (class 1255 OID 905673)
-- Name: create_hydrology_station_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_hydrology_station_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, hydrology_station_type station.hydrology_station_type, a double precision, b double precision)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.hydrology_station_type,c.a,c.b FROM station.hydrology_station_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_hydrology_station_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1825 (class 1255 OID 907092)
-- Name: create_qgis_borehole_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_qgis_borehole_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, total_depth double precision, top_of_casing_altitude double precision, casing_height double precision, casing_internal_diameter double precision, casing_external_diameter double precision, driller text, drilling_date date, drilling_method text, location text, num_bss text, borehole_type station.borehole_type, usage text, condition text)
    LANGUAGE sql
    AS $$
    SELECT id,site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id,total_depth,top_of_casing_altitude,casing_height,casing_internal_diameter,casing_external_diameter,driller,drilling_date,drilling_method,location,num_bss,borehole_type,usage,condition FROM station.borehole;
  $$;


ALTER FUNCTION station.create_qgis_borehole_view() OWNER TO postgres;

--
-- TOC entry 1824 (class 1255 OID 907087)
-- Name: create_qgis_station_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_qgis_station_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer)
    LANGUAGE sql
    AS $$
    SELECT id,site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id FROM station.station;
  $$;


ALTER FUNCTION station.create_qgis_station_view() OWNER TO postgres;

--
-- TOC entry 1809 (class 1255 OID 905736)
-- Name: create_sample_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_sample_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, sample_family station.sample_family, sample_type text)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.sample_family,c.sample_type FROM station.sample_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_sample_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1797 (class 1255 OID 905647)
-- Name: create_weather_station_aggregate_view(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.create_weather_station_aggregate_view() RETURNS TABLE(id integer, site_id bigint, station_family station.station_family, station_type text, name text, point public.geometry, orig_srid integer, ground_altitude double precision, dataset_id integer, weather_station_type station.weather_station_type, height double precision)
    LANGUAGE sql
    AS $$
    SELECT p.id,p.site_id,p.station_family,p.station_type,p.name,p.point,p.orig_srid,p.ground_altitude,p.dataset_id, c.weather_station_type,c.height FROM station.weather_station_spec c JOIN station.station p ON p.id = c.id;
  $$;


ALTER FUNCTION station.create_weather_station_aggregate_view() OWNER TO postgres;

--
-- TOC entry 1815 (class 1255 OID 905770)
-- Name: device_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.device_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.device s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_devices';
      return old;
    end;
    $$;


ALTER FUNCTION station.device_delete_ft() OWNER TO postgres;

--
-- TOC entry 1814 (class 1255 OID 905768)
-- Name: device_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.device_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.device_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.device_type --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.device_insert_ft() OWNER TO postgres;

--
-- TOC entry 1816 (class 1255 OID 905772)
-- Name: device_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.device_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.device_spec set (device_type) = (new.device_type) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.device_update_ft() OWNER TO postgres;

--
-- TOC entry 1803 (class 1255 OID 905680)
-- Name: hydrology_station_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.hydrology_station_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.hydrology_station s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_hydrology_stations';
      return old;
    end;
    $$;


ALTER FUNCTION station.hydrology_station_delete_ft() OWNER TO postgres;

--
-- TOC entry 1802 (class 1255 OID 905678)
-- Name: hydrology_station_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.hydrology_station_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.hydrology_station_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.hydrology_station_type,new.a,new.b --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.hydrology_station_insert_ft() OWNER TO postgres;

--
-- TOC entry 1804 (class 1255 OID 905682)
-- Name: hydrology_station_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.hydrology_station_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.hydrology_station_spec set (hydrology_station_type,a,b) = (new.hydrology_station_type,new.a,new.b) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.hydrology_station_update_ft() OWNER TO postgres;

--
-- TOC entry 1811 (class 1255 OID 905743)
-- Name: sample_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.sample_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.sample s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_samples';
      return old;
    end;
    $$;


ALTER FUNCTION station.sample_delete_ft() OWNER TO postgres;

--
-- TOC entry 1810 (class 1255 OID 905741)
-- Name: sample_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.sample_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.sample_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.sample_family,new.sample_type --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.sample_insert_ft() OWNER TO postgres;

--
-- TOC entry 1812 (class 1255 OID 905745)
-- Name: sample_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.sample_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.sample_spec set (sample_family,sample_type) = (new.sample_family,new.sample_type) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.sample_update_ft() OWNER TO postgres;

--
-- TOC entry 1799 (class 1255 OID 905654)
-- Name: weather_station_delete_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.weather_station_delete_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update station.weather_station s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_weather_stations';
      return old;
    end;
    $$;


ALTER FUNCTION station.weather_station_delete_ft() OWNER TO postgres;

--
-- TOC entry 1798 (class 1255 OID 905652)
-- Name: weather_station_insert_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.weather_station_insert_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      insert into station.station select --parent_schema.parent_table
        nextval('station.station_id_seq'::regclass) --parent_schema.parent_table
        , new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id --get_column_list(parent_rel)
      ;
      insert into station.weather_station_spec select --child_schema.child_table
        currval('station.station_id_seq'::regclass)  --parent_schema.parent_table
        , new.weather_station_type,new.height --get_column_list(child_rel)
      ;
      return new;
    end;
    $$;


ALTER FUNCTION station.weather_station_insert_ft() OWNER TO postgres;

--
-- TOC entry 1800 (class 1255 OID 905656)
-- Name: weather_station_update_ft(); Type: FUNCTION; Schema: station; Owner: postgres
--

CREATE FUNCTION station.weather_station_update_ft() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    begin
      update station.station set (site_id,station_family,station_type,name,point,orig_srid,ground_altitude,dataset_id) = (new.site_id,new.station_family,new.station_type,new.name,new.point,new.orig_srid,new.ground_altitude,new.dataset_id) where id=old.id;
      update station.weather_station_spec set (weather_station_type,height) = (new.weather_station_type,new.height) where id=old.id;
      return new;
    end;
    $$;


ALTER FUNCTION station.weather_station_update_ft() OWNER TO postgres;

--
-- TOC entry 1607 (class 1255 OID 904803)
-- Name: create_inheritance_view(text, text, regclass, regclass); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_inheritance_view(view_schema text, view_table text, child_rel regclass, parent_rel regclass) RETURNS void
    LANGUAGE plpgsql
    AS $_$
declare
  child_table text;
  child_schema text;
  parent_table text;
  parent_schema text;
  q text;
begin

  -- table and schema name from regclass
  select into child_table, child_schema
    relname, nspname from pg_class c join pg_namespace ns on ns.oid = c.relnamespace where c.oid = child_rel;
  select into parent_table, parent_schema
    relname, nspname from pg_class c join pg_namespace ns on ns.oid = c.relnamespace where c.oid = parent_rel;

  -- function to create aggregate view with accurate rights
  -- (compliant to row-level security policies)
  -- must declare 'security invoker' property to apply RLS on the view
  EXECUTE FORMAT(
  $SQL$
  CREATE FUNCTION create_%s_aggregate_view()
  RETURNS TABLE (%s, %s)
  LANGUAGE sql
  SECURITY INVOKER
  AS $aggview$
    SELECT %s, %s FROM %s.%s c JOIN %s.%s p ON p.id = c.id;
  $aggview$;
  $SQL$
  , view_table
  , array_to_string(utils.get_column_list_and_types(parent_schema, parent_table), ',')
  , array_to_string(array_remove(utils.get_column_list_and_types(child_schema, child_table), 'id int8'), ',')
  , array_to_string(utils.get_column_list(parent_schema, parent_table, 'p.'), ',')
  , array_to_string(array_remove(utils.get_column_list(child_schema, child_table, 'c.'), 'c.id'), ',')
  , view_schema
  , child_rel::text
  , view_schema
  , parent_rel::text
  );
  EXECUTE FORMAT(
  $SQL$
  CREATE VIEW %s AS SELECT * FROM create_%s_aggregate_view();
  $SQL$
  , view_schema || '.' || view_table
  , view_table
  );

  -- alter view owner, so as to apply row level security policies
  EXECUTE FORMAT(
  $SQL$
  ALTER VIEW %s OWNER TO postgres;
  $SQL$
  , view_schema || '.' || view_table
  , child_rel::text
  , parent_rel::text
  );

  -- create the insert trigger function
  q := format($sql$
    create function %s_insert_ft() returns trigger --view_table
    language plpgsql
    as $f$
    begin
      insert into %s select --parent_schema.parent_table
        nextval('%s_id_seq'::regclass) --parent_schema.parent_table
        , %s --get_column_list(parent_rel)
      ;
      insert into %s select --child_schema.child_table
        currval('%s_id_seq'::regclass)  --parent_schema.parent_table
        , %s --get_column_list(child_rel)
      ;
      return new;
    end;
    $f$;
    create trigger %s_insert_t instead of insert on %s -- view_table, view_schema.view_table
    for each row execute procedure %s_insert_ft(); -- view_table
  $sql$
  , view_table
  , parent_schema||'.'||parent_table
  , parent_schema||'.'||parent_table
  , array_to_string(array_remove(utils.get_column_list(parent_schema, parent_table, 'new.'), 'new.id'), ',')
  , child_schema||'.'||child_table
  , parent_schema||'.'||parent_table
  , array_to_string(array_remove(utils.get_column_list(child_schema, child_table, 'new.'), 'new.id'), ',')
  , view_table
  , view_schema || '.' || view_table
  , view_table
  );
  execute q;

  -- create the delete trigger function
  q := format($sql$
    create function %s_delete_ft() returns trigger
    language plpgsql
    as $f$
    begin
      -- update the dataset_id in the parent table (it now must correspond to the import_stations dataset)
      update %s s set dataset_id = (
             SELECT id FROM metadata.dataset WHERE data_type='import_stations' AND site_id=old.site_id
      ) FROM metadata.dataset d WHERE s.dataset_id=d.id AND d.data_type='import_%ss';
      return old;
    end;
    $f$;
    create trigger %s_delete_t instead of delete on %s
    for each row execute procedure %s_delete_ft();
  $sql$
  , view_table -- function name
  , view_schema||'.'||view_table -- station table
  , view_table -- data type in metadata.dataset
  , view_table -- trigger name
  , view_schema||'.'||view_table -- station view
  , view_table -- function name
  );
  execute q;

  -- create the update trigger function
  q := format($sql$
    create function %s_update_ft() returns trigger
    language plpgsql
    as $f$
    begin
      update %s set (%s) = (%s) where id=old.id;
      update %s set (%s) = (%s) where id=old.id;
      return new;
    end;
    $f$;
    create trigger %s_update_t instead of update on %s
    for each row execute procedure %s_update_ft();
  $sql$
  , view_table
  , parent_schema||'.'||parent_table
  , array_to_string(array_remove(utils.get_column_list(parent_schema, parent_table), 'id'), ',')
  , array_to_string(array_remove(utils.get_column_list(parent_schema, parent_table, 'new.'), 'new.id'), ',')
  , child_schema||'.'||child_table
  , array_to_string(array_remove(utils.get_column_list(child_schema, child_table), 'id'), ',')
  , array_to_string(array_remove(utils.get_column_list(child_schema, child_table, 'new.'), 'new.id'), ',')
  , view_table
  , view_schema||'.'||view_table
  , view_table
  );
  execute q;
end;
$_$;


ALTER FUNCTION utils.create_inheritance_view(view_schema text, view_table text, child_rel regclass, parent_rel regclass) OWNER TO postgres;

--
-- TOC entry 1612 (class 1255 OID 904808)
-- Name: create_measure_rls(text, text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_measure_rls(_schema text, _table text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
BEGIN
EXECUTE FORMAT($SQL$ALTER TABLE %s.%s ENABLE ROW LEVEL SECURITY;$SQL$, _schema, _table);
-- select
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_read ON %s.%s
FOR SELECT TO public USING
( station_id in (
SELECT DISTINCT s.id FROM station.user_site_privilege AS p JOIN station.station as s ON p.fk_site_id = s.site_id WHERE p.privilege = 'RO' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
)
);
$SQL$, _table, _schema, _table);
-- update
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_update ON %s.%s
FOR UPDATE TO public USING
( station_id = (
SELECT DISTINCT s.id FROM station.user_site_privilege AS p JOIN station.station as s ON p.fk_site_id = s.site_id WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
))
WITH CHECK (station_id = (
SELECT DISTINCT s.id FROM station.user_site_privilege AS p JOIN station.station as s ON p.fk_site_id = s.site_id WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
));
$SQL$, _table, _schema, _table);
-- insert
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_insert ON %s.%s
FOR INSERT TO public
WITH CHECK (station_id = (
SELECT DISTINCT s.id FROM station.user_site_privilege AS p JOIN station.station as s ON p.fk_site_id = s.site_id WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
));
$SQL$, _table, _schema, _table);
END;
$_$;


ALTER FUNCTION utils.create_measure_rls(_schema text, _table text) OWNER TO postgres;

--
-- TOC entry 1823 (class 1255 OID 907086)
-- Name: create_qgis_view(text, regclass); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_qgis_view(view_table text, parent_rel regclass) RETURNS void
    LANGUAGE plpgsql
    AS $_$
declare
  parent_table text;
  parent_schema text;
begin

  -- table and schema name from regclass
  select into parent_table, parent_schema
    relname, nspname from pg_class c join pg_namespace ns on ns.oid = c.relnamespace where c.oid = parent_rel;

  -- function to create aggregate view with accurate rights
  -- (compliant to row-level security policies)
  -- must declare 'security invoker' property to apply RLS on the view
  EXECUTE FORMAT(
  $SQL$
  CREATE FUNCTION create_qgis_%s_view()
  RETURNS TABLE (%s)
  LANGUAGE sql
  SECURITY INVOKER
  AS $mesureview$
    SELECT %s FROM %s;
  $mesureview$;
  $SQL$
  , view_table
  , array_to_string(utils.get_column_list_and_types(parent_schema, parent_table), ',')
  , array_to_string(utils.get_column_list(parent_schema, parent_table), ',')
  , parent_schema||'.'||parent_table
  );
  EXECUTE FORMAT(
  $SQL$
  CREATE VIEW %s AS SELECT * FROM create_qgis_%s_view();
  $SQL$
  , 'qgis.' || view_table
  , view_table
  );

  -- alter view owner, so as to apply row level security policies
  EXECUTE FORMAT(
  $SQL$
  ALTER VIEW %s OWNER TO postgres;
  $SQL$
  , 'qgis.' || view_table
  );
end;
$_$;


ALTER FUNCTION utils.create_qgis_view(view_table text, parent_rel regclass) OWNER TO postgres;

--
-- TOC entry 1609 (class 1255 OID 904805)
-- Name: create_role(text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_role(_role text) RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF NOT EXISTS (SELECT 1 FROM pg_roles WHERE rolname = _role) THEN
       EXECUTE FORMAT('CREATE ROLE %I WITH INHERIT NOLOGIN', _role);
    END IF;
    EXECUTE FORMAT('GRANT ALL PRIVILEGES ON SCHEMA metadata TO %I;', _role);
    EXECUTE FORMAT('GRANT ALL PRIVILEGES ON SCHEMA station TO %I;', _role);
    EXECUTE FORMAT('GRANT ALL PRIVILEGES ON SCHEMA measure TO %I;', _role);
    EXECUTE FORMAT('GRANT ALL PRIVILEGES ON SCHEMA qgis TO %I;', _role);
    END;
$$;


ALTER FUNCTION utils.create_role(_role text) OWNER TO postgres;

--
-- TOC entry 1610 (class 1255 OID 904806)
-- Name: create_simple_rls(text, text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_simple_rls(_schema text, _table text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
BEGIN
EXECUTE FORMAT($SQL$ALTER TABLE %s.%s ENABLE ROW LEVEL SECURITY;$SQL$, _schema, _table);
EXECUTE FORMAT($SQL$CREATE POLICY site_filter_%s ON %s.%s
FOR SELECT USING
( id in (
SELECT DISTINCT fk_site_id FROM station.user_site_privilege AS p WHERE p.fk_login = current_user OR p.fk_login = (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user)
)
);$SQL$, _table, _schema, _table);
END;
$_$;


ALTER FUNCTION utils.create_simple_rls(_schema text, _table text) OWNER TO postgres;

--
-- TOC entry 1611 (class 1255 OID 904807)
-- Name: create_station_rls(text, text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.create_station_rls(_schema text, _table text) RETURNS void
    LANGUAGE plpgsql
    AS $_$
BEGIN
EXECUTE FORMAT($SQL$ALTER TABLE %s.%s ENABLE ROW LEVEL SECURITY;$SQL$, _schema, _table);
-- select
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_read ON %s.%s
FOR SELECT TO public USING
( site_id in (
SELECT DISTINCT fk_site_id FROM station.user_site_privilege AS p WHERE p.privilege = 'RO' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
)
);
$SQL$, _table, _schema, _table);
-- update
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_update ON %s.%s
FOR UPDATE TO public USING
(site_id=(
SELECT DISTINCT fk_site_id FROM station.user_site_privilege AS p WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
))
WITH CHECK (site_id=(
SELECT DISTINCT fk_site_id FROM station.user_site_privilege AS p WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
));
$SQL$, _table, _schema, _table);
-- insert
EXECUTE FORMAT($SQL$
CREATE POLICY site_filter_%s_insert ON %s.%s
FOR INSERT TO public
WITH CHECK (site_id=(
SELECT DISTINCT fk_site_id FROM station.user_site_privilege AS p WHERE p.privilege = 'EDIT' AND (p.fk_login = current_user OR p.fk_login in (select r.rolname as role from pg_auth_members as m inner join pg_roles as r on m.roleid=r.oid inner join pg_user as u on u.usesysid=m.member where u.usename=current_user))
));
$SQL$, _table, _schema, _table);
END;
$_$;


ALTER FUNCTION utils.create_station_rls(_schema text, _table text) OWNER TO postgres;

--
-- TOC entry 1605 (class 1255 OID 904801)
-- Name: get_column_list(text, text, text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.get_column_list(tableschema text, tablename text, l_col_prefix text DEFAULT ''::text) RETURNS text[]
    LANGUAGE sql IMMUTABLE
    AS $$
SELECT array_agg(l_col_prefix||c.column_name)
FROM information_schema.columns AS c
WHERE c.table_name = tablename AND c.table_schema = tableschema;
$$;


ALTER FUNCTION utils.get_column_list(tableschema text, tablename text, l_col_prefix text) OWNER TO postgres;

--
-- TOC entry 1606 (class 1255 OID 904802)
-- Name: get_column_list_and_types(text, text); Type: FUNCTION; Schema: utils; Owner: postgres
--

CREATE FUNCTION utils.get_column_list_and_types(tableschema text, tablename text) RETURNS text[]
    LANGUAGE sql IMMUTABLE
    AS $$
SELECT array_agg(c.column_name||' '||c.udt_name)
FROM information_schema.columns AS c
WHERE c.table_name = tablename AND c.table_schema = tableschema;
$$;


ALTER FUNCTION utils.get_column_list_and_types(tableschema text, tablename text) OWNER TO postgres;


SET default_tablespace = '';

--
-- TOC entry 325 (class 1259 OID 907018)
-- Name: acoustic_imagery; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.acoustic_imagery (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    scan_date date NOT NULL,
    depth_range numrange NOT NULL,
    image_data bytea,
    image_format text,
    dataset_id integer
);


ALTER TABLE measure.acoustic_imagery OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 907016)
-- Name: acoustic_imagery_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.acoustic_imagery_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.acoustic_imagery_id_seq OWNER TO postgres;

--
-- TOC entry 6095 (class 0 OID 0)
-- Dependencies: 324
-- Name: acoustic_imagery_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.acoustic_imagery_id_seq OWNED BY measure.acoustic_imagery.id;


--
-- TOC entry 315 (class 1259 OID 906863)
-- Name: activity_isotopic_ratio; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.activity_isotopic_ratio (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.activity_isotopic_ratio OWNER TO postgres;

--
-- TOC entry 314 (class 1259 OID 906861)
-- Name: activity_isotopic_ratio_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.activity_isotopic_ratio_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.activity_isotopic_ratio_id_seq OWNER TO postgres;

--
-- TOC entry 6096 (class 0 OID 0)
-- Dependencies: 314
-- Name: activity_isotopic_ratio_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.activity_isotopic_ratio_id_seq OWNED BY measure.activity_isotopic_ratio.id;


--
-- TOC entry 251 (class 1259 OID 905818)
-- Name: atmospheric_pressure; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.atmospheric_pressure (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.atmospheric_pressure OWNER TO postgres;

--
-- TOC entry 250 (class 1259 OID 905816)
-- Name: atmospheric_pressure_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.atmospheric_pressure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.atmospheric_pressure_id_seq OWNER TO postgres;

--
-- TOC entry 6097 (class 0 OID 0)
-- Dependencies: 250
-- Name: atmospheric_pressure_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.atmospheric_pressure_id_seq OWNED BY measure.atmospheric_pressure.id;


--
-- TOC entry 249 (class 1259 OID 905803)
-- Name: campaign; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.campaign (
    id integer NOT NULL,
    instrument_id bigint,
    start_date date
);


ALTER TABLE measure.campaign OWNER TO postgres;

--
-- TOC entry 248 (class 1259 OID 905801)
-- Name: campaign_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.campaign_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.campaign_id_seq OWNER TO postgres;

--
-- TOC entry 6098 (class 0 OID 0)
-- Dependencies: 248
-- Name: campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.campaign_id_seq OWNED BY measure.campaign.id;


--
-- TOC entry 275 (class 1259 OID 906202)
-- Name: continuous_atmospheric_pressure; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_atmospheric_pressure (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_atmospheric_pressure OWNER TO postgres;

--
-- TOC entry 274 (class 1259 OID 906200)
-- Name: continuous_atmospheric_pressure_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_atmospheric_pressure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_atmospheric_pressure_id_seq OWNER TO postgres;

--
-- TOC entry 6099 (class 0 OID 0)
-- Dependencies: 274
-- Name: continuous_atmospheric_pressure_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_atmospheric_pressure_id_seq OWNED BY measure.continuous_atmospheric_pressure.id;


--
-- TOC entry 291 (class 1259 OID 906458)
-- Name: continuous_humidity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_humidity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_humidity OWNER TO postgres;

--
-- TOC entry 290 (class 1259 OID 906456)
-- Name: continuous_humidity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_humidity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_humidity_id_seq OWNER TO postgres;

--
-- TOC entry 6100 (class 0 OID 0)
-- Dependencies: 290
-- Name: continuous_humidity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_humidity_id_seq OWNED BY measure.continuous_humidity.id;


--
-- TOC entry 289 (class 1259 OID 906426)
-- Name: continuous_nebulosity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_nebulosity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_nebulosity OWNER TO postgres;

--
-- TOC entry 288 (class 1259 OID 906424)
-- Name: continuous_nebulosity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_nebulosity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_nebulosity_id_seq OWNER TO postgres;

--
-- TOC entry 6101 (class 0 OID 0)
-- Dependencies: 288
-- Name: continuous_nebulosity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_nebulosity_id_seq OWNED BY measure.continuous_nebulosity.id;


--
-- TOC entry 287 (class 1259 OID 906394)
-- Name: continuous_pasquill_index; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_pasquill_index (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_pasquill_index OWNER TO postgres;

--
-- TOC entry 286 (class 1259 OID 906392)
-- Name: continuous_pasquill_index_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_pasquill_index_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_pasquill_index_id_seq OWNER TO postgres;

--
-- TOC entry 6102 (class 0 OID 0)
-- Dependencies: 286
-- Name: continuous_pasquill_index_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_pasquill_index_id_seq OWNED BY measure.continuous_pasquill_index.id;


--
-- TOC entry 279 (class 1259 OID 906266)
-- Name: continuous_potential_evapotranspiration; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_potential_evapotranspiration (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_potential_evapotranspiration OWNER TO postgres;

--
-- TOC entry 278 (class 1259 OID 906264)
-- Name: continuous_potential_evapotranspiration_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_potential_evapotranspiration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_potential_evapotranspiration_id_seq OWNER TO postgres;

--
-- TOC entry 6103 (class 0 OID 0)
-- Dependencies: 278
-- Name: continuous_potential_evapotranspiration_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_potential_evapotranspiration_id_seq OWNED BY measure.continuous_potential_evapotranspiration.id;


--
-- TOC entry 277 (class 1259 OID 906234)
-- Name: continuous_rain; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_rain (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_rain OWNER TO postgres;

--
-- TOC entry 276 (class 1259 OID 906232)
-- Name: continuous_rain_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_rain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_rain_id_seq OWNER TO postgres;

--
-- TOC entry 6104 (class 0 OID 0)
-- Dependencies: 276
-- Name: continuous_rain_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_rain_id_seq OWNED BY measure.continuous_rain.id;


--
-- TOC entry 317 (class 1259 OID 906896)
-- Name: continuous_released_activity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_released_activity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    radionuclide text,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_released_activity OWNER TO postgres;

--
-- TOC entry 316 (class 1259 OID 906894)
-- Name: continuous_released_activity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_released_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_released_activity_id_seq OWNER TO postgres;

--
-- TOC entry 6105 (class 0 OID 0)
-- Dependencies: 316
-- Name: continuous_released_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_released_activity_id_seq OWNED BY measure.continuous_released_activity.id;


--
-- TOC entry 321 (class 1259 OID 906960)
-- Name: continuous_released_flow; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_released_flow (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_released_flow OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 906958)
-- Name: continuous_released_flow_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_released_flow_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_released_flow_id_seq OWNER TO postgres;

--
-- TOC entry 6106 (class 0 OID 0)
-- Dependencies: 320
-- Name: continuous_released_flow_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_released_flow_id_seq OWNED BY measure.continuous_released_flow.id;


--
-- TOC entry 319 (class 1259 OID 906928)
-- Name: continuous_released_mass; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_released_mass (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    radionuclide text,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_released_mass OWNER TO postgres;

--
-- TOC entry 318 (class 1259 OID 906926)
-- Name: continuous_released_mass_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_released_mass_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_released_mass_id_seq OWNER TO postgres;

--
-- TOC entry 6107 (class 0 OID 0)
-- Dependencies: 318
-- Name: continuous_released_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_released_mass_id_seq OWNED BY measure.continuous_released_mass.id;


--
-- TOC entry 281 (class 1259 OID 906298)
-- Name: continuous_temperature; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_temperature (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_temperature OWNER TO postgres;

--
-- TOC entry 280 (class 1259 OID 906296)
-- Name: continuous_temperature_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_temperature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_temperature_id_seq OWNER TO postgres;

--
-- TOC entry 6108 (class 0 OID 0)
-- Dependencies: 280
-- Name: continuous_temperature_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_temperature_id_seq OWNED BY measure.continuous_temperature.id;


--
-- TOC entry 283 (class 1259 OID 906330)
-- Name: continuous_wind_direction; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_wind_direction (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_wind_direction OWNER TO postgres;

--
-- TOC entry 282 (class 1259 OID 906328)
-- Name: continuous_wind_direction_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_wind_direction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_wind_direction_id_seq OWNER TO postgres;

--
-- TOC entry 6109 (class 0 OID 0)
-- Dependencies: 282
-- Name: continuous_wind_direction_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_wind_direction_id_seq OWNED BY measure.continuous_wind_direction.id;


--
-- TOC entry 285 (class 1259 OID 906362)
-- Name: continuous_wind_force; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.continuous_wind_force (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    start_measure_time timestamp without time zone NOT NULL,
    end_measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    periodicity text,
    reference text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.continuous_wind_force OWNER TO postgres;

--
-- TOC entry 284 (class 1259 OID 906360)
-- Name: continuous_wind_force_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.continuous_wind_force_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.continuous_wind_force_id_seq OWNER TO postgres;

--
-- TOC entry 6110 (class 0 OID 0)
-- Dependencies: 284
-- Name: continuous_wind_force_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.continuous_wind_force_id_seq OWNED BY measure.continuous_wind_force.id;


--
-- TOC entry 311 (class 1259 OID 906799)
-- Name: dosimetry; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.dosimetry (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.dosimetry OWNER TO postgres;

--
-- TOC entry 310 (class 1259 OID 906797)
-- Name: dosimetry_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.dosimetry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.dosimetry_id_seq OWNER TO postgres;

--
-- TOC entry 6111 (class 0 OID 0)
-- Dependencies: 310
-- Name: dosimetry_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.dosimetry_id_seq OWNED BY measure.dosimetry.id;


--
-- TOC entry 293 (class 1259 OID 906516)
-- Name: fracturing_rate; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.fracturing_rate (
    station_id bigint NOT NULL,
    depth numrange NOT NULL,
    value double precision,
    dataset_id integer
);


ALTER TABLE measure.fracturing_rate OWNER TO postgres;

--
-- TOC entry 261 (class 1259 OID 905978)
-- Name: groundwater_conductivity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.groundwater_conductivity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.groundwater_conductivity OWNER TO postgres;

--
-- TOC entry 260 (class 1259 OID 905976)
-- Name: groundwater_conductivity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.groundwater_conductivity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.groundwater_conductivity_id_seq OWNER TO postgres;

--
-- TOC entry 6112 (class 0 OID 0)
-- Dependencies: 260
-- Name: groundwater_conductivity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.groundwater_conductivity_id_seq OWNED BY measure.groundwater_conductivity.id;


--
-- TOC entry 255 (class 1259 OID 905882)
-- Name: groundwater_level; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.groundwater_level (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.groundwater_level OWNER TO postgres;

--
-- TOC entry 254 (class 1259 OID 905880)
-- Name: groundwater_level_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.groundwater_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.groundwater_level_id_seq OWNER TO postgres;

--
-- TOC entry 6113 (class 0 OID 0)
-- Dependencies: 254
-- Name: groundwater_level_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.groundwater_level_id_seq OWNED BY measure.groundwater_level.id;


--
-- TOC entry 257 (class 1259 OID 905914)
-- Name: groundwater_ph; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.groundwater_ph (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.groundwater_ph OWNER TO postgres;

--
-- TOC entry 256 (class 1259 OID 905912)
-- Name: groundwater_ph_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.groundwater_ph_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.groundwater_ph_id_seq OWNER TO postgres;

--
-- TOC entry 6114 (class 0 OID 0)
-- Dependencies: 256
-- Name: groundwater_ph_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.groundwater_ph_id_seq OWNED BY measure.groundwater_ph.id;


--
-- TOC entry 259 (class 1259 OID 905946)
-- Name: groundwater_temperature; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.groundwater_temperature (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.groundwater_temperature OWNER TO postgres;

--
-- TOC entry 258 (class 1259 OID 905944)
-- Name: groundwater_temperature_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.groundwater_temperature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.groundwater_temperature_id_seq OWNER TO postgres;

--
-- TOC entry 6115 (class 0 OID 0)
-- Dependencies: 258
-- Name: groundwater_temperature_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.groundwater_temperature_id_seq OWNED BY measure.groundwater_temperature.id;


--
-- TOC entry 247 (class 1259 OID 905790)
-- Name: instrument; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.instrument (
    id integer NOT NULL,
    model text,
    serial_number text,
    sensor_range double precision
);


ALTER TABLE measure.instrument OWNER TO postgres;

--
-- TOC entry 246 (class 1259 OID 905788)
-- Name: instrument_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.instrument_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.instrument_id_seq OWNER TO postgres;

--
-- TOC entry 6116 (class 0 OID 0)
-- Dependencies: 246
-- Name: instrument_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.instrument_id_seq OWNED BY measure.instrument.id;


--
-- TOC entry 253 (class 1259 OID 905850)
-- Name: manual_groundwater_level; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.manual_groundwater_level (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.manual_groundwater_level OWNER TO postgres;

--
-- TOC entry 252 (class 1259 OID 905848)
-- Name: manual_groundwater_level_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.manual_groundwater_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.manual_groundwater_level_id_seq OWNER TO postgres;

--
-- TOC entry 6117 (class 0 OID 0)
-- Dependencies: 252
-- Name: manual_groundwater_level_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.manual_groundwater_level_id_seq OWNED BY measure.manual_groundwater_level.id;


--
-- TOC entry 263 (class 1259 OID 906010)
-- Name: manual_water_level; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.manual_water_level (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.manual_water_level OWNER TO postgres;

--
-- TOC entry 262 (class 1259 OID 906008)
-- Name: manual_water_level_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.manual_water_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.manual_water_level_id_seq OWNER TO postgres;

--
-- TOC entry 6118 (class 0 OID 0)
-- Dependencies: 262
-- Name: manual_water_level_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.manual_water_level_id_seq OWNED BY measure.manual_water_level.id;


--
-- TOC entry 313 (class 1259 OID 906831)
-- Name: mass_isotopic_ratio; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.mass_isotopic_ratio (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.mass_isotopic_ratio OWNER TO postgres;

--
-- TOC entry 312 (class 1259 OID 906829)
-- Name: mass_isotopic_ratio_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.mass_isotopic_ratio_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.mass_isotopic_ratio_id_seq OWNER TO postgres;

--
-- TOC entry 6119 (class 0 OID 0)
-- Dependencies: 312
-- Name: mass_isotopic_ratio_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.mass_isotopic_ratio_id_seq OWNED BY measure.mass_isotopic_ratio.id;


--
-- TOC entry 303 (class 1259 OID 906671)
-- Name: massic_activity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.massic_activity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.massic_activity OWNER TO postgres;

--
-- TOC entry 302 (class 1259 OID 906669)
-- Name: massic_activity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.massic_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.massic_activity_id_seq OWNER TO postgres;

--
-- TOC entry 6120 (class 0 OID 0)
-- Dependencies: 302
-- Name: massic_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.massic_activity_id_seq OWNED BY measure.massic_activity.id;


--
-- TOC entry 307 (class 1259 OID 906735)
-- Name: massic_concentration; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.massic_concentration (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.massic_concentration OWNER TO postgres;

--
-- TOC entry 306 (class 1259 OID 906733)
-- Name: massic_concentration_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.massic_concentration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.massic_concentration_id_seq OWNER TO postgres;

--
-- TOC entry 6121 (class 0 OID 0)
-- Dependencies: 306
-- Name: massic_concentration_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.massic_concentration_id_seq OWNED BY measure.massic_concentration.id;


--
-- TOC entry 245 (class 1259 OID 905777)
-- Name: measure_metadata; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.measure_metadata (
    measure_table regclass NOT NULL,
    name text,
    unit_of_measure text,
    measure_category text,
    x_axis_type text,
    storage_type text DEFAULT 'Instantaneous'::text,
    CONSTRAINT measure_metadata_storage_type_check CHECK ((storage_type = ANY (ARRAY['Cumulative'::text, 'Instantaneous'::text, 'Image'::text]))),
    CONSTRAINT measure_metadata_x_axis_type_check CHECK ((x_axis_type = ANY (ARRAY['TimeAxis'::text, 'DepthAxis'::text])))
);


ALTER TABLE measure.measure_metadata OWNER TO postgres;

--
-- TOC entry 6122 (class 0 OID 0)
-- Dependencies: 245
-- Name: COLUMN measure_metadata.measure_table; Type: COMMENT; Schema: measure; Owner: postgres
--

COMMENT ON COLUMN measure.measure_metadata.measure_table IS 'Link to the table that holds this measure';


--
-- TOC entry 6123 (class 0 OID 0)
-- Dependencies: 245
-- Name: COLUMN measure_metadata.name; Type: COMMENT; Schema: measure; Owner: postgres
--

COMMENT ON COLUMN measure.measure_metadata.name IS 'Name of the measure';


--
-- TOC entry 323 (class 1259 OID 906992)
-- Name: optical_imagery; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.optical_imagery (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    scan_date date NOT NULL,
    depth_range numrange NOT NULL,
    image_data bytea,
    image_format text,
    dataset_id integer
);


ALTER TABLE measure.optical_imagery OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 906990)
-- Name: optical_imagery_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.optical_imagery_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.optical_imagery_id_seq OWNER TO postgres;

--
-- TOC entry 6124 (class 0 OID 0)
-- Dependencies: 322
-- Name: optical_imagery_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.optical_imagery_id_seq OWNED BY measure.optical_imagery.id;

--
-- Name: radionuclide; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.radionuclide (
    name text NOT NULL,
    periode double precision,
    atomic_mass double precision,
    radioactive_decay double precision,
    specific_activity double precision,
    water_quality_limit double precision,
    atomic_number integer,
    mass_number integer
);

ALTER TABLE measure.radionuclide OWNER TO postgres;

--
-- TOC entry 292 (class 1259 OID 906488)
-- Name: stratigraphic_logvalue; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.stratigraphic_logvalue (
    station_id bigint NOT NULL,
    depth numrange NOT NULL,
    rock_code integer,
    rock_description text,
    formation_code text,
    formation_description text,
    dataset_id integer
);


ALTER TABLE measure.stratigraphic_logvalue OWNER TO postgres;

--
-- TOC entry 299 (class 1259 OID 906606)
-- Name: tool_injection_pressure; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.tool_injection_pressure (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_depth double precision NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.tool_injection_pressure OWNER TO postgres;

--
-- TOC entry 298 (class 1259 OID 906604)
-- Name: tool_injection_pressure_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.tool_injection_pressure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.tool_injection_pressure_id_seq OWNER TO postgres;

--
-- TOC entry 6125 (class 0 OID 0)
-- Dependencies: 298
-- Name: tool_injection_pressure_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.tool_injection_pressure_id_seq OWNED BY measure.tool_injection_pressure.id;


--
-- TOC entry 295 (class 1259 OID 906542)
-- Name: tool_instant_speed; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.tool_instant_speed (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_depth double precision NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.tool_instant_speed OWNER TO postgres;

--
-- TOC entry 294 (class 1259 OID 906540)
-- Name: tool_instant_speed_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.tool_instant_speed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.tool_instant_speed_id_seq OWNER TO postgres;

--
-- TOC entry 6126 (class 0 OID 0)
-- Dependencies: 294
-- Name: tool_instant_speed_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.tool_instant_speed_id_seq OWNED BY measure.tool_instant_speed.id;


--
-- TOC entry 301 (class 1259 OID 906638)
-- Name: tool_rotation_couple; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.tool_rotation_couple (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_depth double precision NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.tool_rotation_couple OWNER TO postgres;

--
-- TOC entry 300 (class 1259 OID 906636)
-- Name: tool_rotation_couple_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.tool_rotation_couple_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.tool_rotation_couple_id_seq OWNER TO postgres;

--
-- TOC entry 6127 (class 0 OID 0)
-- Dependencies: 300
-- Name: tool_rotation_couple_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.tool_rotation_couple_id_seq OWNED BY measure.tool_rotation_couple.id;


--
-- TOC entry 305 (class 1259 OID 906703)
-- Name: volumic_activity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.volumic_activity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.volumic_activity OWNER TO postgres;

--
-- TOC entry 304 (class 1259 OID 906701)
-- Name: volumic_activity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.volumic_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.volumic_activity_id_seq OWNER TO postgres;

--
-- TOC entry 6128 (class 0 OID 0)
-- Dependencies: 304
-- Name: volumic_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.volumic_activity_id_seq OWNED BY measure.volumic_activity.id;


--
-- TOC entry 309 (class 1259 OID 906767)
-- Name: volumic_concentration; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.volumic_concentration (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    chemical_element text NOT NULL,
    chemical_element_description text,
    radionuclide text,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    detection_limit double precision,
    quantification_limit double precision,
    analysis_method text,
    sampling_method text,
    sample_code text,
    sample_family station.sample_family,
    sample_type text,
    sample_name text,
    sample_report text,
    report_number text,
    da_number text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.volumic_concentration OWNER TO postgres;

--
-- TOC entry 308 (class 1259 OID 906765)
-- Name: volumic_concentration_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.volumic_concentration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.volumic_concentration_id_seq OWNER TO postgres;

--
-- TOC entry 6129 (class 0 OID 0)
-- Dependencies: 308
-- Name: volumic_concentration_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.volumic_concentration_id_seq OWNED BY measure.volumic_concentration.id;


--
-- TOC entry 273 (class 1259 OID 906170)
-- Name: water_conductivity; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.water_conductivity (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.water_conductivity OWNER TO postgres;

--
-- TOC entry 272 (class 1259 OID 906168)
-- Name: water_conductivity_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.water_conductivity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.water_conductivity_id_seq OWNER TO postgres;

--
-- TOC entry 6130 (class 0 OID 0)
-- Dependencies: 272
-- Name: water_conductivity_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.water_conductivity_id_seq OWNED BY measure.water_conductivity.id;


--
-- TOC entry 267 (class 1259 OID 906074)
-- Name: water_discharge; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.water_discharge (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.water_discharge OWNER TO postgres;

--
-- TOC entry 266 (class 1259 OID 906072)
-- Name: water_discharge_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.water_discharge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.water_discharge_id_seq OWNER TO postgres;

--
-- TOC entry 6131 (class 0 OID 0)
-- Dependencies: 266
-- Name: water_discharge_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.water_discharge_id_seq OWNED BY measure.water_discharge.id;


--
-- TOC entry 265 (class 1259 OID 906042)
-- Name: water_level; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.water_level (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.water_level OWNER TO postgres;

--
-- TOC entry 264 (class 1259 OID 906040)
-- Name: water_level_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.water_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.water_level_id_seq OWNER TO postgres;

--
-- TOC entry 6132 (class 0 OID 0)
-- Dependencies: 264
-- Name: water_level_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.water_level_id_seq OWNED BY measure.water_level.id;


--
-- TOC entry 269 (class 1259 OID 906106)
-- Name: water_ph; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.water_ph (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.water_ph OWNER TO postgres;

--
-- TOC entry 268 (class 1259 OID 906104)
-- Name: water_ph_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.water_ph_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.water_ph_id_seq OWNER TO postgres;

--
-- TOC entry 6133 (class 0 OID 0)
-- Dependencies: 268
-- Name: water_ph_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.water_ph_id_seq OWNED BY measure.water_ph.id;


--
-- TOC entry 271 (class 1259 OID 906138)
-- Name: water_temperature; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.water_temperature (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_time timestamp without time zone NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.water_temperature OWNER TO postgres;

--
-- TOC entry 270 (class 1259 OID 906136)
-- Name: water_temperature_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.water_temperature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.water_temperature_id_seq OWNER TO postgres;

--
-- TOC entry 6134 (class 0 OID 0)
-- Dependencies: 270
-- Name: water_temperature_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.water_temperature_id_seq OWNED BY measure.water_temperature.id;


--
-- TOC entry 297 (class 1259 OID 906574)
-- Name: weight_on_tool; Type: TABLE; Schema: measure; Owner: postgres
--

CREATE TABLE measure.weight_on_tool (
    id integer NOT NULL,
    station_id bigint NOT NULL,
    measure_depth double precision NOT NULL,
    measure_value double precision,
    measure_uncertainty double precision,
    measure_legend text,
    campaign_id bigint DEFAULT 1,
    dataset_id integer
);


ALTER TABLE measure.weight_on_tool OWNER TO postgres;

--
-- TOC entry 296 (class 1259 OID 906572)
-- Name: weight_on_tool_id_seq; Type: SEQUENCE; Schema: measure; Owner: postgres
--

CREATE SEQUENCE measure.weight_on_tool_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE measure.weight_on_tool_id_seq OWNER TO postgres;

--
-- TOC entry 6135 (class 0 OID 0)
-- Dependencies: 296
-- Name: weight_on_tool_id_seq; Type: SEQUENCE OWNED BY; Schema: measure; Owner: postgres
--

ALTER SEQUENCE measure.weight_on_tool_id_seq OWNED BY measure.weight_on_tool.id;


--
-- TOC entry 224 (class 1259 OID 905468)
-- Name: dataset; Type: TABLE; Schema: metadata; Owner: postgres
--

CREATE TABLE metadata.dataset (
    id integer NOT NULL,
    site_id integer NOT NULL,
    data_type text NOT NULL,
    data_name text NOT NULL,
    import_time timestamp without time zone NOT NULL,
    parent_ids bigint[]
);


ALTER TABLE metadata.dataset OWNER TO postgres;

--
-- TOC entry 223 (class 1259 OID 905466)
-- Name: dataset_id_seq; Type: SEQUENCE; Schema: metadata; Owner: postgres
--

CREATE SEQUENCE metadata.dataset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE metadata.dataset_id_seq OWNER TO postgres;

--
-- TOC entry 6136 (class 0 OID 0)
-- Dependencies: 223
-- Name: dataset_id_seq; Type: SEQUENCE OWNED BY; Schema: metadata; Owner: postgres
--

ALTER SEQUENCE metadata.dataset_id_seq OWNED BY metadata.dataset.id;


--
-- TOC entry 334 (class 1259 OID 907093)
-- Name: borehole; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.borehole AS
 SELECT create_qgis_borehole_view.id,
    create_qgis_borehole_view.site_id,
    create_qgis_borehole_view.station_family,
    create_qgis_borehole_view.station_type,
    create_qgis_borehole_view.name,
    create_qgis_borehole_view.point,
    create_qgis_borehole_view.orig_srid,
    create_qgis_borehole_view.ground_altitude,
    create_qgis_borehole_view.dataset_id,
    create_qgis_borehole_view.total_depth,
    create_qgis_borehole_view.top_of_casing_altitude,
    create_qgis_borehole_view.casing_height,
    create_qgis_borehole_view.casing_internal_diameter,
    create_qgis_borehole_view.casing_external_diameter,
    create_qgis_borehole_view.driller,
    create_qgis_borehole_view.drilling_date,
    create_qgis_borehole_view.drilling_method,
    create_qgis_borehole_view.location,
    create_qgis_borehole_view.num_bss,
    create_qgis_borehole_view.borehole_type,
    create_qgis_borehole_view.usage,
    create_qgis_borehole_view.condition
   FROM station.create_qgis_borehole_view() create_qgis_borehole_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, total_depth, top_of_casing_altitude, casing_height, casing_internal_diameter, casing_external_diameter, driller, drilling_date, drilling_method, location, num_bss, borehole_type, usage, condition);


ALTER TABLE qgis.borehole OWNER TO postgres;

--
-- TOC entry 230 (class 1259 OID 905541)
-- Name: station; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.station (
    id integer NOT NULL,
    site_id bigint,
    station_family station.station_family,
    station_type text,
    name text,
    point public.geometry(Point,4326) NOT NULL,
    orig_srid integer NOT NULL,
    ground_altitude double precision,
    dataset_id integer
);


ALTER TABLE station.station OWNER TO postgres;

--
-- TOC entry 6138 (class 0 OID 0)
-- Dependencies: 230
-- Name: COLUMN station.point; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.station.point IS 'Station point geometry, stored in EPSG:4326 (gives 1cm accuracy for most of the projected systems)';


--
-- TOC entry 6139 (class 0 OID 0)
-- Dependencies: 230
-- Name: COLUMN station.orig_srid; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.station.orig_srid IS 'Original SRID of the point geometry. Allows to filter data on local projection views';


--
-- TOC entry 6140 (class 0 OID 0)
-- Dependencies: 230
-- Name: COLUMN station.ground_altitude; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.station.ground_altitude IS 'Altitude of the ground at point location. Expressed in NGF IGN69 (gravity-related height in meters)';


--
-- TOC entry 374 (class 1259 OID 907285)
-- Name: measure_acoustic_imagery; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_acoustic_imagery AS
 SELECT m.id,
    m.station_id,
    m.scan_date,
    m.depth_range,
    m.image_data,
    m.image_format,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom,
    lower(m.depth_range) AS depth_from,
    upper(m.depth_range) AS depth_to
   FROM (measure.acoustic_imagery m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_acoustic_imagery OWNER TO postgres;

--
-- TOC entry 372 (class 1259 OID 907276)
-- Name: measure_activity_isotopic_ratio; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_activity_isotopic_ratio AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.activity_isotopic_ratio m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_activity_isotopic_ratio OWNER TO postgres;

--
-- TOC entry 354 (class 1259 OID 907186)
-- Name: measure_atmospheric_pressure; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_atmospheric_pressure AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.atmospheric_pressure m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_atmospheric_pressure OWNER TO postgres;

--
-- TOC entry 342 (class 1259 OID 907126)
-- Name: measure_continuous_atmospheric_pressure; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_atmospheric_pressure AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_atmospheric_pressure m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_atmospheric_pressure OWNER TO postgres;

--
-- TOC entry 350 (class 1259 OID 907166)
-- Name: measure_continuous_humidity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_humidity AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_humidity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_humidity OWNER TO postgres;

--
-- TOC entry 349 (class 1259 OID 907161)
-- Name: measure_continuous_nebulosity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_nebulosity AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_nebulosity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_nebulosity OWNER TO postgres;

--
-- TOC entry 348 (class 1259 OID 907156)
-- Name: measure_continuous_pasquill_index; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_pasquill_index AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_pasquill_index m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_pasquill_index OWNER TO postgres;

--
-- TOC entry 344 (class 1259 OID 907136)
-- Name: measure_continuous_potential_evapotranspiration; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_potential_evapotranspiration AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_potential_evapotranspiration m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_potential_evapotranspiration OWNER TO postgres;

--
-- TOC entry 343 (class 1259 OID 907131)
-- Name: measure_continuous_rain; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_rain AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_rain m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_rain OWNER TO postgres;

--
-- TOC entry 351 (class 1259 OID 907171)
-- Name: measure_continuous_released_activity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_released_activity AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.radionuclide,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_released_activity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_released_activity OWNER TO postgres;

--
-- TOC entry 353 (class 1259 OID 907181)
-- Name: measure_continuous_released_flow; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_released_flow AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_released_flow m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_released_flow OWNER TO postgres;

--
-- TOC entry 352 (class 1259 OID 907176)
-- Name: measure_continuous_released_mass; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_released_mass AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.radionuclide,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_released_mass m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_released_mass OWNER TO postgres;

--
-- TOC entry 345 (class 1259 OID 907141)
-- Name: measure_continuous_temperature; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_temperature AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_temperature m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_temperature OWNER TO postgres;

--
-- TOC entry 346 (class 1259 OID 907146)
-- Name: measure_continuous_wind_direction; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_wind_direction AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_wind_direction m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_wind_direction OWNER TO postgres;

--
-- TOC entry 347 (class 1259 OID 907151)
-- Name: measure_continuous_wind_force; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_continuous_wind_force AS
 SELECT m.id,
    m.station_id,
    m.start_measure_time,
    m.end_measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.periodicity,
    m.reference,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.start_measure_time) AS start_epoch,
    date_part('epoch'::text, m.end_measure_time) AS end_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.continuous_wind_force m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_continuous_wind_force OWNER TO postgres;

--
-- TOC entry 370 (class 1259 OID 907266)
-- Name: measure_dosimetry; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_dosimetry AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.dosimetry m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_dosimetry OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 907101)
-- Name: measure_fracturing_rate; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_fracturing_rate AS
 SELECT fracturing_rate.station_id,
    fracturing_rate.depth,
    fracturing_rate.value,
    fracturing_rate.dataset_id,
    lower(fracturing_rate.depth) AS depth_from,
    upper(fracturing_rate.depth) AS depth_to,
    NULL::public.geometry(Polygon,4326) AS geom
   FROM measure.fracturing_rate;


ALTER TABLE qgis.measure_fracturing_rate OWNER TO postgres;

--
-- TOC entry 359 (class 1259 OID 907211)
-- Name: measure_groundwater_conductivity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_groundwater_conductivity AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.groundwater_conductivity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_groundwater_conductivity OWNER TO postgres;

--
-- TOC entry 356 (class 1259 OID 907196)
-- Name: measure_groundwater_level; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_groundwater_level AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.groundwater_level m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_groundwater_level OWNER TO postgres;

--
-- TOC entry 357 (class 1259 OID 907201)
-- Name: measure_groundwater_ph; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_groundwater_ph AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.groundwater_ph m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_groundwater_ph OWNER TO postgres;

--
-- TOC entry 358 (class 1259 OID 907206)
-- Name: measure_groundwater_temperature; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_groundwater_temperature AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.groundwater_temperature m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_groundwater_temperature OWNER TO postgres;

--
-- TOC entry 355 (class 1259 OID 907191)
-- Name: measure_manual_groundwater_level; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_manual_groundwater_level AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.manual_groundwater_level m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_manual_groundwater_level OWNER TO postgres;

--
-- TOC entry 360 (class 1259 OID 907216)
-- Name: measure_manual_water_level; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_manual_water_level AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.manual_water_level m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_manual_water_level OWNER TO postgres;

--
-- TOC entry 371 (class 1259 OID 907271)
-- Name: measure_mass_isotopic_ratio; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_mass_isotopic_ratio AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.mass_isotopic_ratio m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_mass_isotopic_ratio OWNER TO postgres;

--
-- TOC entry 366 (class 1259 OID 907246)
-- Name: measure_massic_activity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_massic_activity AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.massic_activity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_massic_activity OWNER TO postgres;

--
-- TOC entry 368 (class 1259 OID 907256)
-- Name: measure_massic_concentration; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_massic_concentration AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.massic_concentration m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_massic_concentration OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 907105)
-- Name: measure_metadata; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_metadata AS
 SELECT ('measure_'::text || (pg_class.relname)::text) AS measure_table,
    m.name,
    m.unit_of_measure,
    m.x_axis_type
   FROM (measure.measure_metadata m
     JOIN pg_class ON ((pg_class.oid = (m.measure_table)::oid)));


ALTER TABLE qgis.measure_metadata OWNER TO postgres;

--
-- TOC entry 373 (class 1259 OID 907281)
-- Name: measure_optical_imagery; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_optical_imagery AS
 SELECT m.id,
    m.station_id,
    m.scan_date,
    m.depth_range,
    m.image_data,
    m.image_format,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom,
    lower(m.depth_range) AS depth_from,
    upper(m.depth_range) AS depth_to
   FROM (measure.optical_imagery m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_optical_imagery OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 907097)
-- Name: measure_stratigraphic_logvalue; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_stratigraphic_logvalue AS
 SELECT stratigraphic_logvalue.station_id,
    stratigraphic_logvalue.depth,
    stratigraphic_logvalue.rock_code,
    stratigraphic_logvalue.rock_description,
    stratigraphic_logvalue.formation_code,
    stratigraphic_logvalue.formation_description,
    stratigraphic_logvalue.dataset_id,
    lower(stratigraphic_logvalue.depth) AS depth_from,
    upper(stratigraphic_logvalue.depth) AS depth_to,
    NULL::public.geometry(Polygon,4326) AS geom
   FROM measure.stratigraphic_logvalue;


ALTER TABLE qgis.measure_stratigraphic_logvalue OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 907118)
-- Name: measure_tool_injection_pressure; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_tool_injection_pressure AS
 SELECT m.id,
    m.station_id,
    m.measure_depth,
    m.measure_value,
    m.campaign_id,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom
   FROM (measure.tool_injection_pressure m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_tool_injection_pressure OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 907110)
-- Name: measure_tool_instant_speed; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_tool_instant_speed AS
 SELECT m.id,
    m.station_id,
    m.measure_depth,
    m.measure_value,
    m.campaign_id,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom
   FROM (measure.tool_instant_speed m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_tool_instant_speed OWNER TO postgres;

--
-- TOC entry 341 (class 1259 OID 907122)
-- Name: measure_tool_rotation_couple; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_tool_rotation_couple AS
 SELECT m.id,
    m.station_id,
    m.measure_depth,
    m.measure_value,
    m.campaign_id,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom
   FROM (measure.tool_rotation_couple m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_tool_rotation_couple OWNER TO postgres;

--
-- TOC entry 367 (class 1259 OID 907251)
-- Name: measure_volumic_activity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_volumic_activity AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model,
    r.specific_activity
   FROM ((((measure.volumic_activity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)))
     LEFT JOIN measure.radionuclide r ON ((m.radionuclide = r.name)));


ALTER TABLE qgis.measure_volumic_activity OWNER TO postgres;

--
-- TOC entry 369 (class 1259 OID 907261)
-- Name: measure_volumic_concentration; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_volumic_concentration AS
 SELECT m.id,
    m.station_id,
    m.chemical_element,
    m.chemical_element_description,
    m.radionuclide,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.detection_limit,
    m.quantification_limit,
    m.analysis_method,
    m.sampling_method,
    m.sample_code,
    m.sample_family,
    m.sample_type,
    m.sample_name,
    m.sample_report,
    m.report_number,
    m.da_number,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.volumic_concentration m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_volumic_concentration OWNER TO postgres;

--
-- TOC entry 365 (class 1259 OID 907241)
-- Name: measure_water_conductivity; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_water_conductivity AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.water_conductivity m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_water_conductivity OWNER TO postgres;

--
-- TOC entry 362 (class 1259 OID 907226)
-- Name: measure_water_discharge; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_water_discharge AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.water_discharge m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_water_discharge OWNER TO postgres;

--
-- TOC entry 361 (class 1259 OID 907221)
-- Name: measure_water_level; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_water_level AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.water_level m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_water_level OWNER TO postgres;

--
-- TOC entry 363 (class 1259 OID 907231)
-- Name: measure_water_ph; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_water_ph AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.water_ph m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_water_ph OWNER TO postgres;

--
-- TOC entry 364 (class 1259 OID 907236)
-- Name: measure_water_temperature; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_water_temperature AS
 SELECT m.id,
    m.station_id,
    m.measure_time,
    m.measure_value,
    m.measure_uncertainty,
    m.measure_legend,
    m.campaign_id,
    m.dataset_id,
    date_part('epoch'::text, m.measure_time) AS measure_epoch,
    s.name AS station_name,
    s.point AS geom,
    i.model AS instrument_model,
    i.serial_number AS instrument_serial_model
   FROM (((measure.water_temperature m
     JOIN station.station s ON ((s.id = m.station_id)))
     LEFT JOIN measure.campaign c ON ((m.campaign_id = c.id)))
     LEFT JOIN measure.instrument i ON ((c.instrument_id = i.id)));


ALTER TABLE qgis.measure_water_temperature OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 907114)
-- Name: measure_weight_on_tool; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.measure_weight_on_tool AS
 SELECT m.id,
    m.station_id,
    m.measure_depth,
    m.measure_value,
    m.campaign_id,
    m.dataset_id,
    s.name AS station_name,
    s.point AS geom
   FROM (measure.weight_on_tool m
     JOIN station.station s ON ((s.id = m.station_id)));


ALTER TABLE qgis.measure_weight_on_tool OWNER TO postgres;

--
-- TOC entry 375 (class 1259 OID 907289)
-- Name: site; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.site AS
SELECT
    NULL::integer AS id,
    NULL::text AS name,
    NULL::public.geometry(Polygon,4326) AS site_extent;


ALTER TABLE qgis.site OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 907088)
-- Name: station; Type: VIEW; Schema: qgis; Owner: postgres
--

CREATE VIEW qgis.station AS
 SELECT create_qgis_station_view.id,
    create_qgis_station_view.site_id,
    create_qgis_station_view.station_family,
    create_qgis_station_view.station_type,
    create_qgis_station_view.name,
    create_qgis_station_view.point,
    create_qgis_station_view.orig_srid,
    create_qgis_station_view.ground_altitude,
    create_qgis_station_view.dataset_id
   FROM station.create_qgis_station_view() create_qgis_station_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id);


ALTER TABLE qgis.station OWNER TO postgres;

--
-- TOC entry 222 (class 1259 OID 905451)
-- Name: geologic_code; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.geologic_code (
    id integer NOT NULL,
    parent_id bigint,
    name_en text,
    code text,
    color ref.rgb_hex
);


ALTER TABLE ref.geologic_code OWNER TO postgres;

--
-- TOC entry 221 (class 1259 OID 905449)
-- Name: geologic_code_id_seq; Type: SEQUENCE; Schema: ref; Owner: postgres
--

CREATE SEQUENCE ref.geologic_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ref.geologic_code_id_seq OWNER TO postgres;

--
-- TOC entry 6141 (class 0 OID 0)
-- Dependencies: 221
-- Name: geologic_code_id_seq; Type: SEQUENCE OWNED BY; Schema: ref; Owner: postgres
--

ALTER SEQUENCE ref.geologic_code_id_seq OWNED BY ref.geologic_code.id;


--
-- TOC entry 220 (class 1259 OID 905437)
-- Name: rock_code; Type: TABLE; Schema: ref; Owner: postgres
--

CREATE TABLE ref.rock_code (
    code integer NOT NULL,
    authority ref.roc_code_authority DEFAULT 'USGS'::ref.roc_code_authority,
    description text,
    svg_pattern text
);


ALTER TABLE ref.rock_code OWNER TO postgres;

--
-- TOC entry 232 (class 1259 OID 905572)
-- Name: barometer; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.barometer (
    id integer NOT NULL,
    barometer_station_id bigint,
    site_id bigint,
    data_type text,
    campaign text,
    station text NOT NULL,
    barometer text NOT NULL
);


ALTER TABLE station.barometer OWNER TO postgres;

--
-- TOC entry 231 (class 1259 OID 905570)
-- Name: barometer_id_seq; Type: SEQUENCE; Schema: station; Owner: postgres
--

CREATE SEQUENCE station.barometer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE station.barometer_id_seq OWNER TO postgres;

--
-- TOC entry 6142 (class 0 OID 0)
-- Dependencies: 231
-- Name: barometer_id_seq; Type: SEQUENCE OWNED BY; Schema: station; Owner: postgres
--

ALTER SEQUENCE station.barometer_id_seq OWNED BY station.barometer.id;


--
-- TOC entry 234 (class 1259 OID 905619)
-- Name: borehole; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.borehole AS
 SELECT create_borehole_aggregate_view.id,
    create_borehole_aggregate_view.site_id,
    create_borehole_aggregate_view.station_family,
    create_borehole_aggregate_view.station_type,
    create_borehole_aggregate_view.name,
    create_borehole_aggregate_view.point,
    create_borehole_aggregate_view.orig_srid,
    create_borehole_aggregate_view.ground_altitude,
    create_borehole_aggregate_view.dataset_id,
    create_borehole_aggregate_view.total_depth,
    create_borehole_aggregate_view.top_of_casing_altitude,
    create_borehole_aggregate_view.casing_height,
    create_borehole_aggregate_view.casing_internal_diameter,
    create_borehole_aggregate_view.casing_external_diameter,
    create_borehole_aggregate_view.driller,
    create_borehole_aggregate_view.drilling_date,
    create_borehole_aggregate_view.drilling_method,
    create_borehole_aggregate_view.location,
    create_borehole_aggregate_view.num_bss,
    create_borehole_aggregate_view.borehole_type,
    create_borehole_aggregate_view.usage,
    create_borehole_aggregate_view.condition
   FROM station.create_borehole_aggregate_view() create_borehole_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, total_depth, top_of_casing_altitude, casing_height, casing_internal_diameter, casing_external_diameter, driller, drilling_date, drilling_method, location, num_bss, borehole_type, usage, condition);


ALTER TABLE station.borehole OWNER TO postgres;

--
-- TOC entry 233 (class 1259 OID 905605)
-- Name: borehole_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.borehole_spec (
    id bigint NOT NULL,
    total_depth double precision,
    top_of_casing_altitude double precision,
    casing_height double precision,
    casing_internal_diameter double precision,
    casing_external_diameter double precision,
    driller text,
    drilling_date date,
    drilling_method text,
    location text,
    num_bss text,
    borehole_type station.borehole_type,
    usage text,
    condition text
);


ALTER TABLE station.borehole_spec OWNER TO postgres;

--
-- TOC entry 6143 (class 0 OID 0)
-- Dependencies: 233
-- Name: COLUMN borehole_spec.num_bss; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.borehole_spec.num_bss IS 'BRGM BSS number if available';


--
-- TOC entry 240 (class 1259 OID 905701)
-- Name: chimney; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.chimney AS
 SELECT create_chimney_aggregate_view.id,
    create_chimney_aggregate_view.site_id,
    create_chimney_aggregate_view.station_family,
    create_chimney_aggregate_view.station_type,
    create_chimney_aggregate_view.name,
    create_chimney_aggregate_view.point,
    create_chimney_aggregate_view.orig_srid,
    create_chimney_aggregate_view.ground_altitude,
    create_chimney_aggregate_view.dataset_id,
    create_chimney_aggregate_view.chimney_type,
    create_chimney_aggregate_view.nuclear_facility_name,
    create_chimney_aggregate_view.facility_name,
    create_chimney_aggregate_view.building_name,
    create_chimney_aggregate_view.height,
    create_chimney_aggregate_view.flow_rate,
    create_chimney_aggregate_view.surface
   FROM station.create_chimney_aggregate_view() create_chimney_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, chimney_type, nuclear_facility_name, facility_name, building_name, height, flow_rate, surface);


ALTER TABLE station.chimney OWNER TO postgres;

--
-- TOC entry 239 (class 1259 OID 905687)
-- Name: chimney_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.chimney_spec (
    id bigint NOT NULL,
    chimney_type station.chimney_type,
    nuclear_facility_name text,
    facility_name text,
    building_name text,
    height double precision,
    flow_rate double precision,
    surface double precision
);


ALTER TABLE station.chimney_spec OWNER TO postgres;

--
-- TOC entry 244 (class 1259 OID 905764)
-- Name: device; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.device AS
 SELECT create_device_aggregate_view.id,
    create_device_aggregate_view.site_id,
    create_device_aggregate_view.station_family,
    create_device_aggregate_view.station_type,
    create_device_aggregate_view.name,
    create_device_aggregate_view.point,
    create_device_aggregate_view.orig_srid,
    create_device_aggregate_view.ground_altitude,
    create_device_aggregate_view.dataset_id,
    create_device_aggregate_view.device_type
   FROM station.create_device_aggregate_view() create_device_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, device_type);


ALTER TABLE station.device OWNER TO postgres;

--
-- TOC entry 243 (class 1259 OID 905753)
-- Name: device_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.device_spec (
    id bigint NOT NULL,
    device_type station.device_type
);


ALTER TABLE station.device_spec OWNER TO postgres;

--
-- TOC entry 238 (class 1259 OID 905674)
-- Name: hydrology_station; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.hydrology_station AS
 SELECT create_hydrology_station_aggregate_view.id,
    create_hydrology_station_aggregate_view.site_id,
    create_hydrology_station_aggregate_view.station_family,
    create_hydrology_station_aggregate_view.station_type,
    create_hydrology_station_aggregate_view.name,
    create_hydrology_station_aggregate_view.point,
    create_hydrology_station_aggregate_view.orig_srid,
    create_hydrology_station_aggregate_view.ground_altitude,
    create_hydrology_station_aggregate_view.dataset_id,
    create_hydrology_station_aggregate_view.hydrology_station_type,
    create_hydrology_station_aggregate_view.a,
    create_hydrology_station_aggregate_view.b
   FROM station.create_hydrology_station_aggregate_view() create_hydrology_station_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, hydrology_station_type, a, b);


ALTER TABLE station.hydrology_station OWNER TO postgres;

--
-- TOC entry 237 (class 1259 OID 905663)
-- Name: hydrology_station_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.hydrology_station_spec (
    id bigint NOT NULL,
    hydrology_station_type station.hydrology_station_type,
    a double precision,
    b double precision
);


ALTER TABLE station.hydrology_station_spec OWNER TO postgres;

--
-- TOC entry 242 (class 1259 OID 905737)
-- Name: sample; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.sample AS
 SELECT create_sample_aggregate_view.id,
    create_sample_aggregate_view.site_id,
    create_sample_aggregate_view.station_family,
    create_sample_aggregate_view.station_type,
    create_sample_aggregate_view.name,
    create_sample_aggregate_view.point,
    create_sample_aggregate_view.orig_srid,
    create_sample_aggregate_view.ground_altitude,
    create_sample_aggregate_view.dataset_id,
    create_sample_aggregate_view.sample_family,
    create_sample_aggregate_view.sample_type
   FROM station.create_sample_aggregate_view() create_sample_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, sample_family, sample_type);


ALTER TABLE station.sample OWNER TO postgres;

--
-- TOC entry 241 (class 1259 OID 905723)
-- Name: sample_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.sample_spec (
    id bigint NOT NULL,
    sample_family station.sample_family,
    sample_type text
);


ALTER TABLE station.sample_spec OWNER TO postgres;

--
-- TOC entry 226 (class 1259 OID 905484)
-- Name: site; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.site (
    id integer NOT NULL,
    name text
);


ALTER TABLE station.site OWNER TO postgres;

--
-- TOC entry 225 (class 1259 OID 905482)
-- Name: site_id_seq; Type: SEQUENCE; Schema: station; Owner: postgres
--

CREATE SEQUENCE station.site_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE station.site_id_seq OWNER TO postgres;

--
-- TOC entry 6144 (class 0 OID 0)
-- Dependencies: 225
-- Name: site_id_seq; Type: SEQUENCE OWNED BY; Schema: station; Owner: postgres
--

ALTER SEQUENCE station.site_id_seq OWNED BY station.site.id;


--
-- TOC entry 227 (class 1259 OID 905495)
-- Name: site_user; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.site_user (
    login text NOT NULL,
    comment text
);


ALTER TABLE station.site_user OWNER TO postgres;

--
-- TOC entry 6145 (class 0 OID 0)
-- Dependencies: 227
-- Name: TABLE site_user; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON TABLE station.site_user IS 'Table for users, part of the site filtering';


--
-- TOC entry 6146 (class 0 OID 0)
-- Dependencies: 227
-- Name: COLUMN site_user.login; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.site_user.login IS 'Unique login for user';


--
-- TOC entry 6147 (class 0 OID 0)
-- Dependencies: 227
-- Name: COLUMN site_user.comment; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.site_user.comment IS 'Free comment for user';


--
-- TOC entry 229 (class 1259 OID 905539)
-- Name: station_id_seq; Type: SEQUENCE; Schema: station; Owner: postgres
--

CREATE SEQUENCE station.station_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE station.station_id_seq OWNER TO postgres;

--
-- TOC entry 6148 (class 0 OID 0)
-- Dependencies: 229
-- Name: station_id_seq; Type: SEQUENCE OWNED BY; Schema: station; Owner: postgres
--

ALTER SEQUENCE station.station_id_seq OWNED BY station.station.id;


--
-- TOC entry 228 (class 1259 OID 905503)
-- Name: user_site_privilege; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.user_site_privilege (
    fk_login text NOT NULL,
    fk_site_id integer NOT NULL,
    privilege text NOT NULL
);


ALTER TABLE station.user_site_privilege OWNER TO postgres;

--
-- TOC entry 6149 (class 0 OID 0)
-- Dependencies: 228
-- Name: TABLE user_site_privilege; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON TABLE station.user_site_privilege IS 'Relation table between users and sites';


--
-- TOC entry 6150 (class 0 OID 0)
-- Dependencies: 228
-- Name: COLUMN user_site_privilege.privilege; Type: COMMENT; Schema: station; Owner: postgres
--

COMMENT ON COLUMN station.user_site_privilege.privilege IS 'Read only RO / Editing EDIT';


--
-- TOC entry 236 (class 1259 OID 905648)
-- Name: weather_station; Type: VIEW; Schema: station; Owner: postgres
--

CREATE VIEW station.weather_station AS
 SELECT create_weather_station_aggregate_view.id,
    create_weather_station_aggregate_view.site_id,
    create_weather_station_aggregate_view.station_family,
    create_weather_station_aggregate_view.station_type,
    create_weather_station_aggregate_view.name,
    create_weather_station_aggregate_view.point,
    create_weather_station_aggregate_view.orig_srid,
    create_weather_station_aggregate_view.ground_altitude,
    create_weather_station_aggregate_view.dataset_id,
    create_weather_station_aggregate_view.weather_station_type,
    create_weather_station_aggregate_view.height
   FROM station.create_weather_station_aggregate_view() create_weather_station_aggregate_view(id, site_id, station_family, station_type, name, point, orig_srid, ground_altitude, dataset_id, weather_station_type, height);


ALTER TABLE station.weather_station OWNER TO postgres;

--
-- TOC entry 235 (class 1259 OID 905637)
-- Name: weather_station_spec; Type: TABLE; Schema: station; Owner: postgres
--

CREATE TABLE station.weather_station_spec (
    id bigint NOT NULL,
    weather_station_type station.weather_station_type,
    height double precision
);


ALTER TABLE station.weather_station_spec OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 907049)
-- Name: borehole_type_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.borehole_type_fr (
    borehole_type station.borehole_type,
    description text
);


ALTER TABLE tr.borehole_type_fr OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 907067)
-- Name: chimney_type_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.chimney_type_fr (
    chimney_type station.chimney_type,
    description text
);


ALTER TABLE tr.chimney_type_fr OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 907079)
-- Name: device_type_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.device_type_fr (
    device_type station.device_type,
    description text
);


ALTER TABLE tr.device_type_fr OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 907061)
-- Name: hydrology_station_type_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.hydrology_station_type_fr (
    hydrology_station_type station.hydrology_station_type,
    description text
);


ALTER TABLE tr.hydrology_station_type_fr OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 907073)
-- Name: sample_family_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.sample_family_fr (
    sample_family station.sample_family,
    description text
);


ALTER TABLE tr.sample_family_fr OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 907043)
-- Name: station_family_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.station_family_fr (
    station_family station.station_family,
    description text
);


ALTER TABLE tr.station_family_fr OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 907055)
-- Name: weather_station_type_fr; Type: TABLE; Schema: tr; Owner: postgres
--

CREATE TABLE tr.weather_station_type_fr (
    weather_station_type station.weather_station_type,
    description text
);


ALTER TABLE tr.weather_station_type_fr OWNER TO postgres;

--
-- TOC entry 5278 (class 2604 OID 907021)
-- Name: acoustic_imagery id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.acoustic_imagery ALTER COLUMN id SET DEFAULT nextval('measure.acoustic_imagery_id_seq'::regclass);


--
-- TOC entry 5269 (class 2604 OID 906866)
-- Name: activity_isotopic_ratio id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.activity_isotopic_ratio ALTER COLUMN id SET DEFAULT nextval('measure.activity_isotopic_ratio_id_seq'::regclass);


--
-- TOC entry 5207 (class 2604 OID 905821)
-- Name: atmospheric_pressure id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.atmospheric_pressure ALTER COLUMN id SET DEFAULT nextval('measure.atmospheric_pressure_id_seq'::regclass);


--
-- TOC entry 5206 (class 2604 OID 905806)
-- Name: campaign id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.campaign ALTER COLUMN id SET DEFAULT nextval('measure.campaign_id_seq'::regclass);


--
-- TOC entry 5231 (class 2604 OID 906205)
-- Name: continuous_atmospheric_pressure id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_atmospheric_pressure ALTER COLUMN id SET DEFAULT nextval('measure.continuous_atmospheric_pressure_id_seq'::regclass);


--
-- TOC entry 5247 (class 2604 OID 906461)
-- Name: continuous_humidity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_humidity ALTER COLUMN id SET DEFAULT nextval('measure.continuous_humidity_id_seq'::regclass);


--
-- TOC entry 5245 (class 2604 OID 906429)
-- Name: continuous_nebulosity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_nebulosity ALTER COLUMN id SET DEFAULT nextval('measure.continuous_nebulosity_id_seq'::regclass);


--
-- TOC entry 5243 (class 2604 OID 906397)
-- Name: continuous_pasquill_index id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_pasquill_index ALTER COLUMN id SET DEFAULT nextval('measure.continuous_pasquill_index_id_seq'::regclass);


--
-- TOC entry 5235 (class 2604 OID 906269)
-- Name: continuous_potential_evapotranspiration id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_potential_evapotranspiration ALTER COLUMN id SET DEFAULT nextval('measure.continuous_potential_evapotranspiration_id_seq'::regclass);


--
-- TOC entry 5233 (class 2604 OID 906237)
-- Name: continuous_rain id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_rain ALTER COLUMN id SET DEFAULT nextval('measure.continuous_rain_id_seq'::regclass);


--
-- TOC entry 5271 (class 2604 OID 906899)
-- Name: continuous_released_activity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_released_activity ALTER COLUMN id SET DEFAULT nextval('measure.continuous_released_activity_id_seq'::regclass);


--
-- TOC entry 5275 (class 2604 OID 906963)
-- Name: continuous_released_flow id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_released_flow ALTER COLUMN id SET DEFAULT nextval('measure.continuous_released_flow_id_seq'::regclass);


--
-- TOC entry 5273 (class 2604 OID 906931)
-- Name: continuous_released_mass id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_released_mass ALTER COLUMN id SET DEFAULT nextval('measure.continuous_released_mass_id_seq'::regclass);


--
-- TOC entry 5237 (class 2604 OID 906301)
-- Name: continuous_temperature id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_temperature ALTER COLUMN id SET DEFAULT nextval('measure.continuous_temperature_id_seq'::regclass);


--
-- TOC entry 5239 (class 2604 OID 906333)
-- Name: continuous_wind_direction id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_wind_direction ALTER COLUMN id SET DEFAULT nextval('measure.continuous_wind_direction_id_seq'::regclass);


--
-- TOC entry 5241 (class 2604 OID 906365)
-- Name: continuous_wind_force id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.continuous_wind_force ALTER COLUMN id SET DEFAULT nextval('measure.continuous_wind_force_id_seq'::regclass);


--
-- TOC entry 5265 (class 2604 OID 906802)
-- Name: dosimetry id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.dosimetry ALTER COLUMN id SET DEFAULT nextval('measure.dosimetry_id_seq'::regclass);


--
-- TOC entry 5217 (class 2604 OID 905981)
-- Name: groundwater_conductivity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.groundwater_conductivity ALTER COLUMN id SET DEFAULT nextval('measure.groundwater_conductivity_id_seq'::regclass);


--
-- TOC entry 5211 (class 2604 OID 905885)
-- Name: groundwater_level id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.groundwater_level ALTER COLUMN id SET DEFAULT nextval('measure.groundwater_level_id_seq'::regclass);


--
-- TOC entry 5213 (class 2604 OID 905917)
-- Name: groundwater_ph id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.groundwater_ph ALTER COLUMN id SET DEFAULT nextval('measure.groundwater_ph_id_seq'::regclass);


--
-- TOC entry 5215 (class 2604 OID 905949)
-- Name: groundwater_temperature id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.groundwater_temperature ALTER COLUMN id SET DEFAULT nextval('measure.groundwater_temperature_id_seq'::regclass);


--
-- TOC entry 5205 (class 2604 OID 905793)
-- Name: instrument id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.instrument ALTER COLUMN id SET DEFAULT nextval('measure.instrument_id_seq'::regclass);


--
-- TOC entry 5209 (class 2604 OID 905853)
-- Name: manual_groundwater_level id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.manual_groundwater_level ALTER COLUMN id SET DEFAULT nextval('measure.manual_groundwater_level_id_seq'::regclass);


--
-- TOC entry 5219 (class 2604 OID 906013)
-- Name: manual_water_level id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.manual_water_level ALTER COLUMN id SET DEFAULT nextval('measure.manual_water_level_id_seq'::regclass);


--
-- TOC entry 5267 (class 2604 OID 906834)
-- Name: mass_isotopic_ratio id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.mass_isotopic_ratio ALTER COLUMN id SET DEFAULT nextval('measure.mass_isotopic_ratio_id_seq'::regclass);


--
-- TOC entry 5257 (class 2604 OID 906674)
-- Name: massic_activity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.massic_activity ALTER COLUMN id SET DEFAULT nextval('measure.massic_activity_id_seq'::regclass);


--
-- TOC entry 5261 (class 2604 OID 906738)
-- Name: massic_concentration id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.massic_concentration ALTER COLUMN id SET DEFAULT nextval('measure.massic_concentration_id_seq'::regclass);


--
-- TOC entry 5277 (class 2604 OID 906995)
-- Name: optical_imagery id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.optical_imagery ALTER COLUMN id SET DEFAULT nextval('measure.optical_imagery_id_seq'::regclass);


--
-- TOC entry 5253 (class 2604 OID 906609)
-- Name: tool_injection_pressure id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.tool_injection_pressure ALTER COLUMN id SET DEFAULT nextval('measure.tool_injection_pressure_id_seq'::regclass);


--
-- TOC entry 5249 (class 2604 OID 906545)
-- Name: tool_instant_speed id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.tool_instant_speed ALTER COLUMN id SET DEFAULT nextval('measure.tool_instant_speed_id_seq'::regclass);


--
-- TOC entry 5255 (class 2604 OID 906641)
-- Name: tool_rotation_couple id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.tool_rotation_couple ALTER COLUMN id SET DEFAULT nextval('measure.tool_rotation_couple_id_seq'::regclass);


--
-- TOC entry 5259 (class 2604 OID 906706)
-- Name: volumic_activity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.volumic_activity ALTER COLUMN id SET DEFAULT nextval('measure.volumic_activity_id_seq'::regclass);


--
-- TOC entry 5263 (class 2604 OID 906770)
-- Name: volumic_concentration id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.volumic_concentration ALTER COLUMN id SET DEFAULT nextval('measure.volumic_concentration_id_seq'::regclass);


--
-- TOC entry 5229 (class 2604 OID 906173)
-- Name: water_conductivity id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.water_conductivity ALTER COLUMN id SET DEFAULT nextval('measure.water_conductivity_id_seq'::regclass);


--
-- TOC entry 5223 (class 2604 OID 906077)
-- Name: water_discharge id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.water_discharge ALTER COLUMN id SET DEFAULT nextval('measure.water_discharge_id_seq'::regclass);


--
-- TOC entry 5221 (class 2604 OID 906045)
-- Name: water_level id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.water_level ALTER COLUMN id SET DEFAULT nextval('measure.water_level_id_seq'::regclass);


--
-- TOC entry 5225 (class 2604 OID 906109)
-- Name: water_ph id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.water_ph ALTER COLUMN id SET DEFAULT nextval('measure.water_ph_id_seq'::regclass);


--
-- TOC entry 5227 (class 2604 OID 906141)
-- Name: water_temperature id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.water_temperature ALTER COLUMN id SET DEFAULT nextval('measure.water_temperature_id_seq'::regclass);


--
-- TOC entry 5251 (class 2604 OID 906577)
-- Name: weight_on_tool id; Type: DEFAULT; Schema: measure; Owner: postgres
--

ALTER TABLE ONLY measure.weight_on_tool ALTER COLUMN id SET DEFAULT nextval('measure.weight_on_tool_id_seq'::regclass);


--
-- TOC entry 5198 (class 2604 OID 905471)
-- Name: dataset id; Type: DEFAULT; Schema: metadata; Owner: postgres
--

ALTER TABLE ONLY metadata.dataset ALTER COLUMN id SET DEFAULT nextval('metadata.dataset_id_seq'::regclass);


--
-- TOC entry 5197 (class 2604 OID 905454)
-- Name: geologic_code id; Type: DEFAULT; Schema: ref; Owner: postgres
--

ALTER TABLE ONLY ref.geologic_code ALTER COLUMN id SET DEFAULT nextval('ref.geologic_code_id_seq'::regclass);


--
-- TOC entry 5201 (class 2604 OID 905575)
-- Name: barometer id; Type: DEFAULT; Schema: station; Owner: postgres
--

ALTER TABLE ONLY station.barometer ALTER COLUMN id SET DEFAULT nextval('station.barometer_id_seq'::regclass);


--
-- TOC entry 5199 (class 2604 OID 905487)
-- Name: site id; Type: DEFAULT; Schema: station; Owner: postgres
--

ALTER TABLE ONLY station.site ALTER COLUMN id SET DEFAULT nextval('station.site_id_seq'::regclass);


--
-- TOC entry 5200 (class 2604 OID 905544)
-- Name: station id; Type: DEFAULT; Schema: station; Owner: postgres
--

ALTER TABLE ONLY station.station ALTER COLUMN id SET DEFAULT nextval('station.station_id_seq'::regclass);


--
-- Data for Name: acoustic_imagery; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: atmospheric_pressure; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: campaign; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.campaign VALUES (0, NULL, NULL);
INSERT INTO measure.campaign VALUES (1, NULL, NULL);
INSERT INTO measure.campaign VALUES (207, NULL, NULL);
INSERT INTO measure.campaign VALUES (214, NULL, NULL);



--
-- Data for Name: continuous_atmospheric_pressure; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_humidity; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_nebulosity; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_pasquill_index; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_potential_evapotranspiration; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: volumic_activity; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.volumic_activity VALUES (1,3,'HTO','HTO','HTO','2017-01-01 00:00:00',2e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (2,3,'HTO','HTO','HTO','2017-01-01 01:00:00',1.9e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (3,3,'HTO','HTO','HTO','2017-01-01 02:00:00',1.8e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (4,3,'HTO','HTO','HTO','2017-01-01 03:00:00',1.7e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (5,3,'HTO','HTO','HTO','2017-01-01 04:00:00',1.65e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (6,3,'HTO','HTO','HTO','2017-01-01 05:00:00',1.6e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (7,3,'HTO','HTO','HTO','2017-01-01 06:00:00',1.57e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (8,3,'HTO','HTO','HTO','2017-01-01 07:00:00',1.54e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (9,3,'HTO','HTO','HTO','2017-01-01 08:00:00',1.5e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);
INSERT INTO measure.volumic_activity VALUES (10,3,'HTO','HTO','HTO','2017-01-01 09:00:00',1.48e-08, null, null, null, null, null,'animal', null, null, null, null, null, null, null,1,16);

--
-- Data for Name: radionuclide; Type: TABLE DATA; Schema: measure; Owner: ceadam_admin
--

INSERT INTO measure.radionuclide VALUES ('Ac-225', 864000, 4.65880259051187036e-16, 8.02253681203639994e-07, 2.14647429370929997e+18, 0, 89, 225);
INSERT INTO measure.radionuclide VALUES ('Ac-227', 686648465.279999971, 3.73541070103685013e-13, 1.00946439933758002e-09, 2677081799124330, 0, 89, 227);
INSERT INTO measure.radionuclide VALUES ('Ac-228', 22140, 1.20973573933624993e-17, 3.13074607298981995e-05, 8.26626814008715018e+19, 0, 89, 228);
INSERT INTO measure.radionuclide VALUES ('Ag-105', 3568320, 8.97906552611320955e-16, 1.94250286005723998e-07, 1.11370163976615002e+18, 0, 47, 105);
INSERT INTO measure.radionuclide VALUES ('Ag-108', 144, 3.72704207240950016e-20, 0.00481352208722183976, 2.68309286713662017e+22, 0, 47, 108);
INSERT INTO measure.radionuclide VALUES ('Ag-108m', 13182352637.7600002, 3.41188770099096015e-12, 5.25814473036071985e-11, 293092882192329, 0, 47, 108);
INSERT INTO measure.radionuclide VALUES ('Ag-108m+', 13182321101.7600002, 3.41187953876881987e-12, 5.25815730939372971e-11, 293093583356947, 0, 47, 108);
INSERT INTO measure.radionuclide VALUES ('Ag-110', 24.5599999999999987, 6.47439355891300027e-21, 0.0282226050716589995, 1.54454620483078991e+23, 0, 47, 110);
INSERT INTO measure.radionuclide VALUES ('Ag-110m', 21580999.7760000005, 5.68908330393474032e-15, 3.21183998774137972e-08, 175775242965483008, 0, 47, 110);
INSERT INTO measure.radionuclide VALUES ('Ag-111', 643680, 1.71226524543279989e-16, 1.07685057879683004e-06, 5.84021665257380966e+18, 0, 47, 111);
INSERT INTO measure.radionuclide VALUES ('Ag-111m', 64.7999999999999972, 1.72375695848939008e-20, 0.0106967157493818993, 5.80128187488998963e+22, 0, 47, 111);
INSERT INTO measure.radionuclide VALUES ('Ag-112', 11268, 3.02442562246266999e-18, 6.15146592616209965e-05, 3.30641293531213005e+20, 0, 47, 112);
INSERT INTO measure.radionuclide VALUES ('Ag-113', 19332, 5.23519999990463997e-18, 3.5854913126419698e-05, 1.91014669930130014e+20, 0, 47, 113);
INSERT INTO measure.radionuclide VALUES ('Ag-115', 1200, 3.30717467844978021e-19, 0.000577622650466620962, 3.02372900505135979e+21, 0, 47, 115);
INSERT INTO measure.radionuclide VALUES ('Al-26', 22610996640000, 1.40887058268140999e-09, 3.06553130583255009e-14, 709788402350.458984, 0, 13, 26);
INSERT INTO measure.radionuclide VALUES ('Al-28', 134.460000000000008, 9.02254768362464944e-21, 0.00515504373464186968, 1.10833440294800007e+23, 0, 13, 28);
INSERT INTO measure.radionuclide VALUES ('Al-29', 393.600000000000023, 2.73546482968819975e-20, 0.00176104466605677009, 3.65568582402129999e+22, 0, 13, 29);
INSERT INTO measure.radionuclide VALUES ('Am-240', 182880.288, 1.05185575245427e-16, 3.79016890305830011e-06, 9.50700699850456064e+18, 0, 95, 240);
INSERT INTO measure.radionuclide VALUES ('Am-241', 13649043179.5200005, 7.8831047588396205e-12, 5.07835729906688978e-11, 126853572366733, 0, 95, 241);
INSERT INTO measure.radionuclide VALUES ('Am-242', 57744, 3.34888534065520989e-17, 1.20037957287328003e-05, 2.98606819367650017e+19, 0, 95, 242);
INSERT INTO measure.radionuclide VALUES ('Am-242m', 4446669346.56000042, 2.57886287569888989e-12, 1.55880081593242998e-10, 387767806277406, 0, 95, 242);
INSERT INTO measure.radionuclide VALUES ('Am-243', 232262009280, 1.35257856313894011e-10, 2.98433300697202001e-12, 7393285885585, 0, 95, 243);
INSERT INTO measure.radionuclide VALUES ('Am-245', 7380, 4.33311777978626986e-18, 9.39223821896944969e-05, 2.30780710523249e+20, 0, 95, 245);
INSERT INTO measure.radionuclide VALUES ('Am-246', 2340, 1.37952321152378994e-18, 0.000296216743829035988, 7.24888129207641965e+20, 0, 95, 246);
INSERT INTO measure.radionuclide VALUES ('Am-246m', 1500, 8.84309750976789916e-19, 0.000462098120373296976, 1.13082548156392001e+21, 0, 95, 246);
INSERT INTO measure.radionuclide VALUES ('Ar-37', 3027456, 2.68446417002081013e-16, 2.28953676142590998e-07, 3.72513819021189018e+18, 0, 18, 37);
INSERT INTO measure.radionuclide VALUES ('Ar-39', 8483360916.96000004, 7.92885724707322984e-13, 8.17066711348094039e-11, 1261215795465520, 0, 18, 39);
INSERT INTO measure.radionuclide VALUES ('Ar-41', 6576.01199999999972, 6.46136837126708957e-19, 0.000105405400805221001, 1.54765978743275992e+21, 0, 18, 41);
INSERT INTO measure.radionuclide VALUES ('Ar-43', 322.199999999999989, 3.32025958696016988e-20, 0.00215129478758518001, 3.01181270261925004e+22, 0, 18, 43);
INSERT INTO measure.radionuclide VALUES ('As-68', 151.600200000000001, 2.47051067411439988e-20, 0.00457220492162902989, 4.0477461217951097e+22, 0, 33, 68);
INSERT INTO measure.radionuclide VALUES ('As-69', 913.799999999999955, 1.5110481105837099e-19, 0.000758532699233907992, 6.61792297012771999e+21, 0, 33, 69);
INSERT INTO measure.radionuclide VALUES ('As-70', 3156, 5.29435528958787e-19, 0.000219628384207841003, 1.88880410418743004e+21, 0, 33, 70);
INSERT INTO measure.radionuclide VALUES ('As-71', 235008, 3.99870202790957013e-17, 2.94946206324867999e-06, 2.50081149588127007e+19, 0, 33, 71);
INSERT INTO measure.radionuclide VALUES ('As-72', 93599.7119999999995, 1.61504659532134995e-17, 7.40544138169939038e-06, 6.19177182192088023e+19, 0, 33, 72);
INSERT INTO measure.radionuclide VALUES ('As-73', 6937920, 1.21375266245872992e-15, 9.99070586804034954e-08, 823891086652094976, 0, 33, 73);
INSERT INTO measure.radionuclide VALUES ('As-74', 1536190.27200000011, 2.72429904416020016e-16, 4.51211801815098002e-07, 3.67066898233362995e+18, 0, 33, 74);
INSERT INTO measure.radionuclide VALUES ('As-76', 94392, 1.71920168484533999e-17, 7.34328312314545032e-06, 5.8166532107020501e+19, 0, 33, 76);
INSERT INTO measure.radionuclide VALUES ('As-77', 139788.288, 2.57952391696691009e-17, 4.95854975031918011e-06, 3.87668435024953999e+19, 0, 33, 77);
INSERT INTO measure.radionuclide VALUES ('As-78', 5442.01199999999972, 1.01726041617764009e-18, 0.00012736965309153, 9.83032450783349965e+20, 0, 33, 78);
INSERT INTO measure.radionuclide VALUES ('As-79', 540.600000000000023, 1.02348428885816e-19, 0.00128218124409905008, 9.77054568288134942e+21, 0, 33, 79);
INSERT INTO measure.radionuclide VALUES ('Au-194', 136872.288, 6.3634891029483097e-17, 5.06418933071349967e-06, 1.57146493664409006e+19, 0, 79, 194);
INSERT INTO measure.radionuclide VALUES ('Au-195', 16078500, 7.51377505300992057e-15, 4.31101894181636995e-08, 133088892460176992, 0, 79, 195);
INSERT INTO measure.radionuclide VALUES ('Au-196', 534211.199999999953, 2.50926834567042019e-16, 1.29751525344272996e-06, 3.98522542128839014e+18, 0, 79, 196);
INSERT INTO measure.radionuclide VALUES ('Au-196m', 8.09999999999999964, 3.80468878225135966e-21, 0.085573725995055, 2.62833586984812001e+23, 0, 79, 196);
INSERT INTO measure.radionuclide VALUES ('Au-196n', 34560, 1.62333388042724998e-17, 2.00563420300909992e-05, 6.16016219495651983e+19, 0, 79, 196);
INSERT INTO measure.radionuclide VALUES ('Au-198', 232788.383999999991, 1.10459873987250001e-16, 2.97758491488967999e-06, 9.05306120587668992e+18, 0, 79, 198);
INSERT INTO measure.radionuclide VALUES ('Au-198m', 198720, 9.42941644319601966e-17, 3.48805948349409019e-06, 1.06051101467850998e+19, 0, 79, 198);
INSERT INTO measure.radionuclide VALUES ('Ba-133', 332389440, 1.05944131836108999e-13, 2.08534657587180017e-09, 9438937132893410, 0, 56, 133);
INSERT INTO measure.radionuclide VALUES ('Ba-137m', 153.120000000000005, 5.02725060773186018e-20, 0.00452682327951896973, 1.98915884253314988e+22, 0, 56, 137);
INSERT INTO measure.radionuclide VALUES ('Ba-139', 4983.58799999999974, 1.66010278967989009e-18, 0.000139085971906174004, 6.02372338759112983e+20, 0, 56, 139);
INSERT INTO measure.radionuclide VALUES ('Ba-140', 1102900.32000000007, 3.70034609827639984e-16, 6.28476724496685034e-07, 2.7024499153357399e+18, 0, 56, 140);
INSERT INTO measure.radionuclide VALUES ('Ba-141', 1096.20000000000005, 3.70413629300615011e-19, 0.00063231817237725395, 2.69968467922770985e+21, 0, 56, 141);
INSERT INTO measure.radionuclide VALUES ('Ba-142', 636, 2.16433014174027007e-19, 0.00108985405748419006, 4.62036720144706018e+21, 0, 56, 142);
INSERT INTO measure.radionuclide VALUES ('Be-10', 50457600000000, 1.2092180946039701e-09, 1.37372205685554997e-14, 826980678227.040039, 0, 4, 10);
INSERT INTO measure.radionuclide VALUES ('Be-7', 4598209.72800000012, 7.71373764134068037e-17, 1.50742837226224004e-07, 1.29638840014553006e+19, 0, 4, 7);
INSERT INTO measure.radionuclide VALUES ('Bi-207', 1001575476, 4.96857757917522992e-13, 6.92056861583884981e-10, 2012648457359900, 0, 83, 207);
INSERT INTO measure.radionuclide VALUES ('Bi-210', 433036.799999999988, 2.17932573447358004e-16, 1.60066576457230997e-06, 4.58857519177394995e+18, 0, 83, 210);
INSERT INTO measure.radionuclide VALUES ('Bi-210m', 94609892160000, 4.76139147342808028e-08, 7.32637110914074013e-15, 21002263846.2034988, 0, 83, 210);
INSERT INTO measure.radionuclide VALUES ('Bi-211', 130.199999999999989, 6.58372204357305013e-20, 0.00532371106420849016, 1.51889765907748996e+22, 0, 83, 211);
INSERT INTO measure.radionuclide VALUES ('Bi-212', 3632.40000000000009, 1.84547248987262013e-18, 0.000190823472238724998, 5.41866652300531007e+20, 0, 83, 212);
INSERT INTO measure.radionuclide VALUES ('Bi-214', 1194, 6.1234496024548901e-19, 0.000580525276850876021, 1.63306643301040993e+21, 0, 83, 214);
INSERT INTO measure.radionuclide VALUES ('Bk-247', 43519680000, 2.57608799829192995e-11, 1.59272122533977009e-11, 38818549702612.8984, 0, 97, 247);
INSERT INTO measure.radionuclide VALUES ('Bk-249', 27648000, 1.64983729071993988e-14, 2.50704275376137995e-08, 60612037661218800, 0, 97, 249);
INSERT INTO measure.radionuclide VALUES ('Bk-250', 11581.2000000000007, 6.93859626559106013e-18, 5.98510672952669e-05, 1.44121370047003001e+20, 0, 97, 250);
INSERT INTO measure.radionuclide VALUES ('Br-73', 204, 3.56887284865754987e-20, 0.0033977802968624799, 2.80200512152221012e+22, 0, 35, 73);
INSERT INTO measure.radionuclide VALUES ('Br-74', 1524, 2.70268066331053018e-19, 0.000454820984619386985, 3.70003017217392981e+21, 0, 35, 74);
INSERT INTO measure.radionuclide VALUES ('Br-74m', 2760, 4.89461852410567966e-19, 0.000251140282811573975, 2.04306013854820991e+21, 0, 35, 74);
INSERT INTO measure.radionuclide VALUES ('Br-75', 5802.01199999999972, 1.04284060709030998e-18, 0.000119466691995801994, 9.58919314419635061e+20, 0, 35, 75);
INSERT INTO measure.radionuclide VALUES ('Br-76', 58320, 1.06220699063671e-17, 1.18852397215353999e-05, 9.41436093732147036e+19, 0, 35, 76);
INSERT INTO measure.radionuclide VALUES ('Br-77', 205329.600000000006, 3.78896273528472028e-17, 3.37577816622612999e-06, 2.63924474814043013e+19, 0, 35, 77);
INSERT INTO measure.radionuclide VALUES ('Br-80', 1056, 2.02456606402491007e-19, 0.000656389375530251054, 4.93933005086513955e+21, 0, 35, 80);
INSERT INTO measure.radionuclide VALUES ('Br-80m', 15876, 3.04375102580108987e-18, 4.36600642831912972e-05, 3.28541983731015025e+20, 0, 35, 80);
INSERT INTO measure.radionuclide VALUES ('Br-82', 127152.288, 2.49871129194242002e-17, 5.45131504483777038e-06, 4.00206299633211965e+19, 0, 35, 82);
INSERT INTO measure.radionuclide VALUES ('Br-83', 8640, 1.71858051116659992e-18, 8.02253681203639969e-05, 5.81875561547701027e+20, 0, 35, 83);
INSERT INTO measure.radionuclide VALUES ('Br-84', 1908, 3.84092391351090009e-19, 0.000363284685828064004, 2.60354024843446007e+21, 0, 35, 84);
INSERT INTO measure.radionuclide VALUES ('Br-84m', 360, 7.24702625190735052e-20, 0.00192540883488873994, 1.3798763316702601e+22, 0, 35, 84);
INSERT INTO measure.radionuclide VALUES ('Br-85', 174, 3.54442851407770012e-20, 0.00398360448597669982, 2.82132929477407985e+22, 0, 35, 85);
INSERT INTO measure.radionuclide VALUES ('C-11', 1222.20000000000005, 3.22190708782713983e-20, 0.000567130731925989976, 3.10375182381315009e+22, 0, 6, 11);
INSERT INTO measure.radionuclide VALUES ('C-14', 179754569280, 6.0309540855206402e-12, 3.85607544406976009e-12, 165811244095000, 0, 6, 14);
INSERT INTO measure.radionuclide VALUES ('C-15', 2.44899999999999984, 8.80355520382991047e-23, 0.283032740122476978, 1.13590473035820996e+25, 0, 6, 15);
INSERT INTO measure.radionuclide VALUES ('Ca-41', 3248208000000, 3.19158000844535012e-10, 2.13393717569793998e-13, 3133244340902.83008, 0, 20, 41);
INSERT INTO measure.radionuclide VALUES ('Ca-45', 14083200, 1.51876964450686992e-15, 4.92180172517570978e-08, 658427697456839040, 0, 20, 45);
INSERT INTO measure.radionuclide VALUES ('Ca-47', 392083.200000000012, 4.41625497475517984e-17, 1.76785738475900996e-06, 2.26436201196792996e+19, 0, 20, 47);
INSERT INTO measure.radionuclide VALUES ('Cd-109', 39942236.1599999964, 1.04336657762046992e-14, 1.73537399804895003e-08, 95843591451877792, 0, 48, 109);
INSERT INTO measure.radionuclide VALUES ('Cd-111m', 2912.40000000000009, 7.74732988565509979e-19, 0.000237998619887359007, 1.29076728983954994e+21, 0, 48, 111);
INSERT INTO measure.radionuclide VALUES ('Cd-113', 2.4282688464e+23, 65.7587061061541931, 2.85449109799996984e-24, 15.2071118672210996, 0, 48, 113);
INSERT INTO measure.radionuclide VALUES ('Cd-113m', 444667060.800000012, 1.20418011414118999e-13, 1.55880037372884007e-09, 8304405530838610, 0, 48, 113);
INSERT INTO measure.radionuclide VALUES ('Cd-115', 192456, 5.30404674929776006e-17, 3.60158779440466993e-06, 1.88535291498401014e+19, 0, 48, 115);
INSERT INTO measure.radionuclide VALUES ('Cd-115m', 3853440, 1.06199993274379008e-15, 1.79877506996332006e-07, 941619645319928960, 0, 48, 115);
INSERT INTO measure.radionuclide VALUES ('Cd-117', 8964, 2.51342399758115013e-18, 7.73256560196279932e-05, 3.97863631827488014e+20, 0, 48, 117);
INSERT INTO measure.radionuclide VALUES ('Cd-117m', 12096, 3.39160828589263996e-18, 5.73038343716885992e-05, 2.94845370015013011e+20, 0, 48, 117);
INSERT INTO measure.radionuclide VALUES ('Cd-118', 3018, 8.53452373324818978e-19, 0.000229671033982752, 1.17171154625099006e+21, 0, 48, 118);
INSERT INTO measure.radionuclide VALUES ('Ce-139', 11892199.6799999997, 3.96145786212629004e-15, 5.82858679816538032e-08, 252432320323420992, 0, 58, 139);
INSERT INTO measure.radionuclide VALUES ('Ce-141', 2808000, 9.48842794267584007e-16, 2.46847286524196999e-07, 1.05391536516005005e+18, 0, 58, 141);
INSERT INTO measure.radionuclide VALUES ('Ce-143', 118939.967999999993, 4.07607252252229015e-17, 5.82770612953205e-06, 2.45334202096384e+19, 0, 58, 143);
INSERT INTO measure.radionuclide VALUES ('Ce-144', 24624000, 8.49765592509365047e-15, 2.81492519720576011e-08, 117679511716518000, 0, 58, 144);
INSERT INTO measure.radionuclide VALUES ('Ce-146', 811.200000000000045, 2.8383035831676502e-19, 0.00085447137642991305, 3.52323129185484984e+21, 0, 58, 146);
INSERT INTO measure.radionuclide VALUES ('Cf-248', 28814400, 1.71253442069358015e-14, 2.40555826447868007e-08, 58392986903877696, 0, 98, 248);
INSERT INTO measure.radionuclide VALUES ('Cf-249', 11069354859.8400002, 6.60540886573204989e-12, 6.2618570760135906e-11, 151391082721292, 0, 98, 249);
INSERT INTO measure.radionuclide VALUES ('Cf-250', 412499394.720000029, 2.47139049473523019e-13, 1.68035926702498003e-09, 4046305114996140, 0, 98, 250);
INSERT INTO measure.radionuclide VALUES ('Cf-251', 28319907947.0400009, 1.70350576065784997e-11, 2.44756155936725996e-11, 58702472459724.7969, 0, 98, 251);
INSERT INTO measure.radionuclide VALUES ('Cf-252', 83414296.799999997, 5.03754665578325995e-14, 8.30969278829843933e-09, 19850932772046300, 0, 98, 252);
INSERT INTO measure.radionuclide VALUES ('Cl-34', 1.52600000000000002, 1.2434018189615101e-22, 0.454224888964577023, 8.0424524457845798e+24, 0, 17, 34);
INSERT INTO measure.radionuclide VALUES ('Cl-34m+', 1926, 1.56932628002613009e-19, 0.000359889501848361976, 6.37216117978570005e+21, 0, 17, 34);
INSERT INTO measure.radionuclide VALUES ('Cl-36', 9492336000000, 8.18942954570537957e-10, 7.30217704640822992e-14, 1221086272760.48999, 0, 17, 36);
INSERT INTO measure.radionuclide VALUES ('Cl-38', 2232, 2.03261831541592004e-19, 0.000310549812078827982, 4.91976281240670044e+21, 0, 17, 38);
INSERT INTO measure.radionuclide VALUES ('Cl-38m', 0.714999999999999969, 6.51129971112177952e-23, 0.969436616167756005, 1.53579169192892001e+25, 0, 17, 38);
INSERT INTO measure.radionuclide VALUES ('Cl-39', 3336, 3.11794677076108991e-19, 0.000207777931822525987, 3.20723884505539019e+21, 0, 17, 39);
INSERT INTO measure.radionuclide VALUES ('Cl-40', 81, 7.76467098418645064e-21, 0.00855737259950549965, 1.28788457622558007e+23, 0, 17, 40);
INSERT INTO measure.radionuclide VALUES ('Cm-242', 14077200.3839999996, 8.16412614357221965e-15, 4.92389936672187013e-08, 122487083420106000, 0, 96, 242);
INSERT INTO measure.radionuclide VALUES ('Cm-243', 946100183.039999962, 5.50961747953812959e-13, 7.32636134085432009e-10, 1815008035882430, 0, 96, 243);
INSERT INTO measure.radionuclide VALUES ('Cm-244', 567660299.039999962, 3.31937558793407011e-13, 1.22105981646446002e-09, 3012614793080360, 0, 96, 244);
INSERT INTO measure.radionuclide VALUES ('Cm-245', 268061991840, 1.57390810694692e-10, 2.58577195447264e-12, 6353611088132.76953, 0, 96, 245);
INSERT INTO measure.radionuclide VALUES ('Cm-246', 149168118240, 8.7940547662993799e-11, 4.64675152263250027e-12, 11371318766767.3008, 0, 96, 246);
INSERT INTO measure.radionuclide VALUES ('Cm-247', 504588614400000, 2.98684336288914975e-07, 1.37368771466267998e-15, 3348016211.4450798, 0, 96, 247);
INSERT INTO measure.radionuclide VALUES ('Cm-248', 10722492288000, 6.37272930160665023e-09, 6.46442228114890962e-14, 156918637631.11499, 0, 96, 248);
INSERT INTO measure.radionuclide VALUES ('Cm-250', 252293676480, 1.51155662751386998e-10, 2.74738229760940003e-12, 6615696572643.44043, 0, 96, 250);
INSERT INTO measure.radionuclide VALUES ('Co-55', 63108, 8.31811947711485026e-18, 1.09835073296562004e-05, 1.20219480226418999e+20, 0, 27, 55);
INSERT INTO measure.radionuclide VALUES ('Co-56', 6679579.6799999997, 8.96427579493832031e-16, 1.03771077487909002e-07, 1.11553908299503002e+18, 0, 27, 56);
INSERT INTO measure.radionuclide VALUES ('Co-57', 23483500.1279999986, 3.20786239719388015e-15, 2.95163487888028992e-08, 311734069664198976, 0, 27, 57);
INSERT INTO measure.radionuclide VALUES ('Co-58', 6122299.6799999997, 8.50982492451795984e-16, 1.13216800351064005e-07, 1.17511230709208013e+18, 0, 27, 58);
INSERT INTO measure.radionuclide VALUES ('Co-58m', 32040, 4.45347018004115995e-18, 2.1633807133581299e-05, 2.24543998179584999e+20, 0, 27, 58);
INSERT INTO measure.radionuclide VALUES ('Co-60', 166226571.360000014, 2.39017525081442989e-14, 4.16989398800016984e-09, 41837936346268400, 0, 27, 60);
INSERT INTO measure.radionuclide VALUES ('Co-60m', 628.200000000000045, 9.03290057827023013e-20, 0.00110338615179869995, 1.10706410563803e+22, 0, 27, 60);
INSERT INTO measure.radionuclide VALUES ('Co-61', 5940, 8.68349038398183963e-19, 0.000116691444538711002, 1.15161064938203998e+21, 0, 27, 61);
INSERT INTO measure.radionuclide VALUES ('Co-62', 90, 1.33724889172099999e-20, 0.00770163533955495021, 7.4780394748581897e+22, 0, 27, 62);
INSERT INTO measure.radionuclide VALUES ('Co-62m', 834.600000000000023, 1.24007547225593999e-19, 0.000830514235034682008, 8.06402531436899965e+21, 0, 27, 62);
INSERT INTO measure.radionuclide VALUES ('Cr-48', 77616, 8.92833634234986012e-18, 8.93046769428913067e-06, 1.12002948999209992e+20, 0, 24, 48);
INSERT INTO measure.radionuclide VALUES ('Cr-49', 2514, 2.95215666622836996e-19, 0.000275714868957813999, 3.38735410433885995e+21, 0, 24, 49);
INSERT INTO measure.radionuclide VALUES ('Cr-51', 2393540.06399999978, 2.92542470773413003e-16, 2.89590799412641974e-07, 3.41830708326294989e+18, 0, 24, 51);
INSERT INTO measure.radionuclide VALUES ('Cr-55', 212.400000000000006, 2.79959526040945026e-20, 0.00326340480489615984, 3.57194489554089007e+22, 0, 24, 55);
INSERT INTO measure.radionuclide VALUES ('Cr-56', 356.399999999999977, 4.78303732625884973e-20, 0.00194485740897852003, 2.09072171465191006e+22, 0, 24, 56);
INSERT INTO measure.radionuclide VALUES ('Cs-129', 115920.288, 3.58366338505757989e-17, 5.97951568719313022e-06, 2.79044065402346004e+19, 0, 55, 129);
INSERT INTO measure.radionuclide VALUES ('Cs-130', 1752.59999999999991, 5.46014539412059043e-19, 0.000395496508364684017, 1.83145306181183996e+21, 0, 55, 130);
INSERT INTO measure.radionuclide VALUES ('Cs-131', 837216, 2.62837218683104995e-16, 8.27919175648752e-07, 3.80463621175990989e+18, 0, 55, 131);
INSERT INTO measure.radionuclide VALUES ('Cs-132', 564192, 1.7847562137411599e-16, 1.22856612741751993e-06, 5.60300612655566029e+18, 0, 55, 132);
INSERT INTO measure.radionuclide VALUES ('Cs-134', 65124993.6000000015, 2.09136839050207987e-14, 1.06433358722041003e-08, 47815583545275296, 0, 55, 134);
INSERT INTO measure.radionuclide VALUES ('Cs-134m', 10468.7999999999993, 3.36186096861099999e-18, 6.62107577334503984e-05, 2.97454299668187972e+20, 0, 55, 134);
INSERT INTO measure.radionuclide VALUES ('Cs-135', 72532800000000, 2.34663886484083015e-08, 9.55632735203860048e-15, 42614141229.0905991, 0, 55, 135);
INSERT INTO measure.radionuclide VALUES ('Cs-135m', 3180, 1.02881890540470004e-18, 0.00021797081149683799, 9.71988359415529996e+20, 0, 55, 135);
INSERT INTO measure.radionuclide VALUES ('Cs-136', 1125790.27200000011, 3.6692258767338801e-16, 6.15698321258850977e-07, 2.72537051027815014e+18, 0, 55, 136);
INSERT INTO measure.radionuclide VALUES ('Cs-137', 947361307.679999948, 3.11038578224656021e-13, 7.31660850977118986e-10, 3215035272176830, 0, 55, 137);
INSERT INTO measure.radionuclide VALUES ('Cs-138', 2004.59999999999991, 6.62956236042043956e-19, 0.000345778300189537001, 1.50839519358043999e+21, 0, 55, 138);
INSERT INTO measure.radionuclide VALUES ('Cs-139', 556.200000000000045, 1.85277990800996005e-19, 0.00124621931060759999, 5.39729514378254038e+21, 0, 55, 139);
INSERT INTO measure.radionuclide VALUES ('Cu-60', 1422, 2.04469669250243005e-19, 0.000487445274655376004, 4.89070092237560978e+21, 0, 29, 60);
INSERT INTO measure.radionuclide VALUES ('Cu-61', 11999.8799999999992, 1.75422293920767985e-18, 5.77628426750889014e-05, 5.70052971973828018e+20, 0, 29, 61);
INSERT INTO measure.radionuclide VALUES ('Cu-62', 585, 8.69211779618649965e-20, 0.00118486697531615002, 1.15046761151663996e+22, 0, 29, 62);
INSERT INTO measure.radionuclide VALUES ('Cu-64', 45723.5999999999985, 7.01291279432192983e-18, 1.51595058254369002e-05, 1.42594101670515999e+20, 0, 29, 64);
INSERT INTO measure.radionuclide VALUES ('Cu-66', 306, 4.83997824680954982e-20, 0.00226518686457497995, 2.06612498859718009e+22, 0, 29, 66);
INSERT INTO measure.radionuclide VALUES ('Cu-67', 222840.288, 3.57805128792810007e-17, 3.11051106054908996e-06, 2.79481740067246981e+19, 0, 29, 67);
INSERT INTO measure.radionuclide VALUES ('Cu-68', 31.1000000000000014, 5.0681253695547903e-21, 0.0222876906932457999, 1.97311614666676002e+23, 0, 29, 68);
INSERT INTO measure.radionuclide VALUES ('Cu-68m', 225, 3.66665018697693022e-20, 0.00308065413582197991, 2.72728498494828005e+22, 0, 29, 68);
INSERT INTO measure.radionuclide VALUES ('Dy-166', 293868, 1.16906439272107995e-16, 2.35870248056932013e-06, 8.55384875483573043e+18, 0, 66, 166);
INSERT INTO measure.radionuclide VALUES ('Er-169', 812160, 3.28932168679429003e-16, 8.53461362982596002e-07, 3.04014047642320998e+18, 0, 68, 169);
INSERT INTO measure.radionuclide VALUES ('Es-254', 23820499.8720000014, 1.44998208095596993e-14, 2.90987672082696984e-08, 68966369525111600, 0, 99, 254);
INSERT INTO measure.radionuclide VALUES ('Eu-147', 2073600, 7.30500246192260995e-16, 3.34272367168182996e-07, 1.36892493221255987e+18, 0, 63, 147);
INSERT INTO measure.radionuclide VALUES ('Eu-150', 1146629092.31999993, 4.12185076053756982e-13, 6.04508628991338041e-10, 2426094631018570, 0, 63, 150);
INSERT INTO measure.radionuclide VALUES ('Eu-150b', 1078531200, 3.87705551582398003e-13, 6.4267698566341499e-10, 2579276969129170, 0, 63, 150);
INSERT INTO measure.radionuclide VALUES ('Eu-150m', 46080, 1.65646314329310995e-17, 1.50422565225682994e-05, 6.03695895105738998e+19, 0, 63, 150);
INSERT INTO measure.radionuclide VALUES ('Eu-152', 426524084.639999986, 1.55369295054709011e-13, 1.6251067771354201e-09, 6436278156812650, 0, 63, 152);
INSERT INTO measure.radionuclide VALUES ('Eu-154', 270986325.120000005, 1.00010625613787e-13, 2.55786774573587989e-09, 9998937551512990, 0, 63, 154);
INSERT INTO measure.radionuclide VALUES ('Eu-155', 149890608, 5.56780692853852028e-14, 4.62435365236457021e-09, 17960392894990100, 0, 63, 155);
INSERT INTO measure.radionuclide VALUES ('Eu-156', 1312420.32000000007, 4.90654280410700032e-16, 5.28144200449400006e-07, 2.03809492737524992e+18, 0, 63, 156);
INSERT INTO measure.radionuclide VALUES ('Eu-157', 54648, 2.05613664108580005e-17, 1.26838526672511996e-05, 4.86349000362117038e+19, 0, 63, 157);
INSERT INTO measure.radionuclide VALUES ('Eu-158', 2754, 1.04279531317624006e-18, 0.000251687429397221018, 9.58960965171687981e+20, 0, 63, 158);
INSERT INTO measure.radionuclide VALUES ('F-18', 6583.68000000000029, 2.84000605917603985e-19, 0.000105282635328562003, 3.52111924821078992e+21, 0, 9, 18);
INSERT INTO measure.radionuclide VALUES ('Fe-52', 29790, 3.71237547166159024e-18, 2.32677804820391011e-05, 2.69369304811299013e+20, 0, 26, 52);
INSERT INTO measure.radionuclide VALUES ('Fe-53', 510.600000000000023, 6.48536954444002009e-20, 0.0013575150422247299, 1.54193218003638996e+22, 0, 26, 53);
INSERT INTO measure.radionuclide VALUES ('Fe-53m', 154.800000000000011, 1.96618724144010014e-20, 0.00447769496485752976, 5.08598560159289007e+22, 0, 26, 53);
INSERT INTO measure.radionuclide VALUES ('Fe-55', 86250960, 1.13685394925500994e-14, 8.03639960134872952e-09, 87962046545671504, 0, 26, 55);
INSERT INTO measure.radionuclide VALUES ('Fe-59', 3844369.72800000012, 5.43569660089411997e-16, 1.80301903719482002e-07, 1.83969061083267994e+18, 0, 26, 59);
INSERT INTO measure.radionuclide VALUES ('Fe-60', 47304000000000, 6.80185178214732996e-09, 1.46530352731258996e-14, 147018787240.363007, 0, 26, 60);
INSERT INTO measure.radionuclide VALUES ('Fe-61', 358.800000000000011, 5.24517904002136015e-20, 0.00193184832931980006, 1.90651261352545018e+22, 0, 26, 61);
INSERT INTO measure.radionuclide VALUES ('Fr-221', 294, 1.55710411273619998e-19, 0.00235764347129232979, 6.42217814352028972e+21, 0, 87, 221);
INSERT INTO measure.radionuclide VALUES ('Fr-223', 1308, 6.99021694861555985e-19, 0.000529929037125339967, 1.43057076389889992e+21, 0, 87, 223);
INSERT INTO measure.radionuclide VALUES ('Ga-65', 912, 1.42064720969929997e-19, 0.000760029803245554011, 7.03904525467420983e+21, 0, 31, 65);
INSERT INTO measure.radionuclide VALUES ('Ga-66', 34164, 5.40369336026148979e-18, 2.02888180704819001e-05, 1.85058613309546988e+20, 0, 31, 66);
INSERT INTO measure.radionuclide VALUES ('Ga-67', 281767.679999999993, 4.52422324243502004e-17, 2.45999534282975982e-06, 2.21032417370674012e+19, 0, 31, 67);
INSERT INTO measure.radionuclide VALUES ('Ga-68', 4059, 6.61463693730638954e-19, 0.000170767967617625998, 1.51179877214427991e+21, 0, 31, 68);
INSERT INTO measure.radionuclide VALUES ('Ga-70', 1268.40000000000009, 2.12780743007390994e-19, 0.000546473652286302023, 4.69967340966219979e+21, 0, 31, 70);
INSERT INTO measure.radionuclide VALUES ('Ga-72', 50760, 8.75854887016231037e-18, 1.36553818077215005e-05, 1.14174164559005008e+20, 0, 31, 72);
INSERT INTO measure.radionuclide VALUES ('Ga-73', 17496, 3.06083330196629982e-18, 3.96174657384514031e-05, 3.26708416089694994e+20, 0, 31, 73);
INSERT INTO measure.radionuclide VALUES ('Gd-147', 137015.712, 4.82687168924614018e-17, 5.05888828691373005e-06, 2.07173520321229005e+19, 0, 64, 147);
INSERT INTO measure.radionuclide VALUES ('Gd-148', 2352638895.84000015, 8.3443984928333296e-13, 2.94625402047712001e-10, 1198408729950830, 0, 64, 148);
INSERT INTO measure.radionuclide VALUES ('Gd-153', 20770599.743999999, 7.61585234349606948e-15, 3.33715534988426991e-08, 131305066707864992, 0, 64, 153);
INSERT INTO measure.radionuclide VALUES ('Gd-159', 66524.3999999999942, 2.53487260706313986e-17, 1.04194427993330005e-05, 3.94497142465310966e+19, 0, 64, 159);
INSERT INTO measure.radionuclide VALUES ('Ge-66', 8136, 1.28686480444582992e-18, 8.51950811897670947e-05, 7.77082407215755035e+20, 0, 32, 66);
INSERT INTO measure.radionuclide VALUES ('Ge-67', 1134, 1.82081534579172002e-19, 0.000611240899964677958, 5.49204510117516961e+21, 0, 32, 67);
INSERT INTO measure.radionuclide VALUES ('Ge-68', 23410099.8720000014, 3.81496209212522006e-15, 2.96088946373523995e-08, 262125802524796000, 0, 32, 68);
INSERT INTO measure.radionuclide VALUES ('Ge-69', 140579.712, 2.32460831915081987e-17, 4.93063451830051958e-06, 4.30179997103900017e+19, 0, 32, 69);
INSERT INTO measure.radionuclide VALUES ('Ge-71', 987552, 1.68033691834581989e-16, 7.01884235523745028e-07, 5.9511874617647104e+18, 0, 32, 71);
INSERT INTO measure.radionuclide VALUES ('Ge-75', 4966.8119999999999, 8.9272363472937601e-19, 0.000139555751367264008, 1.12016749764124004e+21, 0, 32, 75);
INSERT INTO measure.radionuclide VALUES ('Ge-77', 40680, 7.50671135926735939e-18, 1.70390162379533993e-05, 1.33214126951272006e+20, 0, 32, 77);
INSERT INTO measure.radionuclide VALUES ('Ge-78', 5280.01199999999972, 9.86978199339317088e-19, 0.000131277576747920998, 1.01319360515702994e+21, 0, 32, 78);
INSERT INTO measure.radionuclide VALUES ('H-3', 388838880, 2.79556108246254983e-15, 1.78260769746057e-09, 357709944623753984, 0, 1, 3);
INSERT INTO measure.radionuclide VALUES ('HT', 388847079.360000014, 2.79562003184465997e-15, 1.78257010879647005e-09, 357702401831825024, 0, 1, 3);
INSERT INTO measure.radionuclide VALUES ('HTO', 388838880, 2.79556108246254983e-15, 1.78260769746057e-09, 357709944623753984, 0, 1, 3);
INSERT INTO measure.radionuclide VALUES ('Hf-172', 58972320, 2.43083067467763007e-14, 1.17537716094591996e-08, 41138200633107296, 0, 72, 172);
INSERT INTO measure.radionuclide VALUES ('Hf-175', 6048000, 2.53645918816756994e-15, 1.14607668743377002e-07, 394250380477217984, 0, 72, 175);
INSERT INTO measure.radionuclide VALUES ('Hf-178m', 977637129.120000005, 4.17038103585916986e-13, 7.09002512193729044e-10, 2397862428879920, 0, 72, 178);
INSERT INTO measure.radionuclide VALUES ('Hf-179n', 2168640, 9.30290407062700974e-16, 3.19622980559218996e-07, 1.07493315249525005e+18, 0, 72, 179);
INSERT INTO measure.radionuclide VALUES ('Hf-181', 3661630.27199999988, 1.58829479423917003e-15, 1.89300155687576997e-07, 629606042673598976, 0, 72, 181);
INSERT INTO measure.radionuclide VALUES ('Hf-182', 283823684640000, 1.2379356488652301e-07, 2.44217525904903986e-15, 8077964318.39297962, 0, 72, 182);
INSERT INTO measure.radionuclide VALUES ('Hf-183', 3841.19999999999982, 1.68459713449247992e-18, 0.000180450687430996995, 5.9361373679486396e+20, 0, 72, 183);
INSERT INTO measure.radionuclide VALUES ('Hg-194', 14002008913.4400005, 6.50983719509829011e-12, 4.95034094639533986e-11, 153613672666495, 0, 80, 194);
INSERT INTO measure.radionuclide VALUES ('Hg-197', 232560.288, 1.09794309166854002e-16, 2.98050534130722e-06, 9.10794018003526042e+18, 0, 80, 197);
INSERT INTO measure.radionuclide VALUES ('Hg-203', 4026507.83999999985, 1.95885655689752984e-15, 1.72145990546474002e-07, 510501902999889984, 0, 80, 203);
INSERT INTO measure.radionuclide VALUES ('Ho-166', 96480.2880000000005, 3.83817459880882022e-17, 7.18433987842102027e-06, 2.60540518482497004e+19, 0, 67, 166);
INSERT INTO measure.radionuclide VALUES ('Ho-166m', 37843200000, 1.50547652778194009e-11, 1.83162940914073003e-11, 66424150861609.7031, 0, 67, 166);
INSERT INTO measure.radionuclide VALUES ('I-123', 47604.2039999999979, 1.40322872615627989e-17, 1.45606295729667993e-05, 7.12642195359839027e+19, 0, 53, 123);
INSERT INTO measure.radionuclide VALUES ('I-125', 5132759.61600000039, 1.53758447759101997e-15, 1.35043764449682002e-07, 650370769589670016, 0, 53, 125);
INSERT INTO measure.radionuclide VALUES ('I-126', 1121470.27200000011, 3.38638520913236992e-16, 6.18070044178527999e-07, 2.9530013221862999e+18, 0, 53, 126);
INSERT INTO measure.radionuclide VALUES ('I-128', 1499.40000000000009, 4.59944599454386959e-19, 0.000462283033586731993, 2.17417489233759987e+21, 0, 53, 128);
INSERT INTO measure.radionuclide VALUES ('I-129', 507729600000000, 1.56964066292686997e-07, 1.36518962171980007e-15, 6370884901.35906982, 0, 53, 129);
INSERT INTO measure.radionuclide VALUES ('I-130', 44496, 1.38625259304342006e-17, 1.55777413825950012e-05, 7.21369254794013e+19, 0, 53, 130);
INSERT INTO measure.radionuclide VALUES ('I-130m', 530.399999999999977, 1.65243701759760011e-19, 0.00130683857571634011, 6.05166786600950039e+21, 0, 53, 130);
INSERT INTO measure.radionuclide VALUES ('I-131', 693213.119999999995, 2.17628674577931007e-16, 9.99904878545785958e-07, 4.59498272430964019e+18, 0, 53, 131);
INSERT INTO measure.radionuclide VALUES ('I-132', 8262, 2.61358825327716014e-18, 8.38958097990734965e-05, 3.82615738629108007e+20, 0, 53, 132);
INSERT INTO measure.radionuclide VALUES ('I-132m', 4979.98800000000028, 1.57536167250800995e-18, 0.000139186516224526008, 6.34774869448216936e+20, 0, 53, 132);
INSERT INTO measure.radionuclide VALUES ('I-133', 74880, 2.38668731229481997e-17, 9.25677324465738986e-06, 4.18990788968703017e+19, 0, 53, 133);
INSERT INTO measure.radionuclide VALUES ('I-134', 3150, 1.01156408099539993e-18, 0.000220046723987283997, 9.88568118211530981e+20, 0, 53, 134);
INSERT INTO measure.radionuclide VALUES ('I-134m', 216, 6.93643941253989027e-20, 0.00320901472481455998, 1.44166183905848008e+22, 0, 53, 134);
INSERT INTO measure.radionuclide VALUES ('I-135', 23652, 7.65208325491575013e-18, 2.93060705462516986e-05, 1.30683366435877994e+20, 0, 53, 135);
INSERT INTO measure.radionuclide VALUES ('I-136', 83.4000000000000057, 2.71821000527889982e-20, 0.0083111172729010193, 3.67889161638707011e+22, 0, 53, 136);
INSERT INTO measure.radionuclide VALUES ('In-111', 242326.079999999987, 6.44616152196692979e-17, 2.86039034906991982e-06, 1.55131080192800993e+19, 0, 49, 111);
INSERT INTO measure.radionuclide VALUES ('In-111m', 474, 1.26089629370982997e-19, 0.00146233582396613007, 7.93086636060909974e+21, 0, 49, 111);
INSERT INTO measure.radionuclide VALUES ('In-113m', 5968.4399999999996, 1.61628269643237998e-18, 0.000116135402309472003, 6.18703647701789049e+20, 0, 49, 113);
INSERT INTO measure.radionuclide VALUES ('In-115', 1.39073760000000005e+22, 3.83284347924002011, 4.98402560310403014e-23, 260.902905484227972, 0, 49, 115);
INSERT INTO measure.radionuclide VALUES ('In-115m', 16149.6000000000004, 4.45079568225772031e-18, 4.29203931094235014e-05, 2.24678927407590998e+20, 0, 49, 115);
INSERT INTO measure.radionuclide VALUES ('In-116m', 3276, 9.10709632323023917e-19, 0.000211583388449311993, 1.09804482626281e+21, 0, 49, 116);
INSERT INTO measure.radionuclide VALUES ('In-117', 2592, 7.26773204119851984e-19, 0.000267417893734547027, 1.37594506007005993e+21, 0, 49, 117);
INSERT INTO measure.radionuclide VALUES ('In-117m', 6972.01199999999972, 1.95488869614277002e-18, 9.94185294804348003e-05, 5.11538074762579018e+20, 0, 49, 117);
INSERT INTO measure.radionuclide VALUES ('In-118', 5, 1.41393700020679007e-21, 0.138629436111988996, 7.0724508931709704e+23, 0, 49, 118);
INSERT INTO measure.radionuclide VALUES ('In-119', 144, 4.10664820941416979e-20, 0.00481352208722183976, 2.43507587941810989e+22, 0, 49, 119);
INSERT INTO measure.radionuclide VALUES ('In-119m', 1080, 3.07998615706061982e-19, 0.000641802944962911975, 3.24676783922413987e+21, 0, 49, 119);
INSERT INTO measure.radionuclide VALUES ('Ir-192', 6378219.93599999975, 2.93480173438925991e-15, 1.08674079526120003e-07, 340738520180854016, 0, 77, 192);
INSERT INTO measure.radionuclide VALUES ('Ir-192m', 7600176946.07999992, 3.49705916491318995e-12, 9.12014530026771032e-11, 285954555768811, 0, 77, 192);
INSERT INTO measure.radionuclide VALUES ('Ir-194', 69480, 3.23027567766565987e-17, 9.97621157973439033e-06, 3.09571101597942989e+19, 0, 77, 194);
INSERT INTO measure.radionuclide VALUES ('K-40', 39893040000000000, 3.82415222418504967e-06, 1.73751406400701997e-17, 261495866.633056015, 0, 19, 40);
INSERT INTO measure.radionuclide VALUES ('K-42', 44492.4000000000015, 4.47829987236614997e-18, 1.55790018196353994e-05, 2.23299026081440006e+20, 0, 19, 42);
INSERT INTO measure.radionuclide VALUES ('K-43', 79920, 8.2357276905604293e-18, 8.67301276976908967e-06, 1.21422178776767005e+20, 0, 19, 43);
INSERT INTO measure.radionuclide VALUES ('K-44', 1327.79999999999995, 1.40011396865222996e-19, 0.000522026796625957019, 7.14227571747331978e+21, 0, 19, 44);
INSERT INTO measure.radionuclide VALUES ('K-45', 1038, 1.11940673355354991e-19, 0.000667771850250429037, 8.93330341890574044e+21, 0, 19, 45);
INSERT INTO measure.radionuclide VALUES ('Kr-76', 53280, 9.70411324779213002e-18, 1.30095191546535998e-05, 1.03049085935546008e+20, 0, 36, 76);
INSERT INTO measure.radionuclide VALUES ('Kr-77', 4464, 8.2374531730013601e-19, 0.000155274906039413991, 1.21396744721724001e+21, 0, 36, 77);
INSERT INTO measure.radionuclide VALUES ('Kr-79', 126144, 2.38820573684283996e-17, 5.4948882274221903e-06, 4.18724394039007969e+19, 0, 36, 79);
INSERT INTO measure.radionuclide VALUES ('Kr-81', 6622560000000, 1.28554998682585004e-09, 1.04664537665184999e-13, 777877181165.939941, 0, 36, 81);
INSERT INTO measure.radionuclide VALUES ('Kr-81m', 13.1999999999999993, 2.56234142478153008e-21, 0.0525111500424201016, 3.90268053401690012e+23, 0, 36, 81);
INSERT INTO measure.radionuclide VALUES ('Kr-83m', 6588, 1.31041763976453009e-18, 0.000105213597534904, 7.6311549055436102e+20, 0, 36, 83);
INSERT INTO measure.radionuclide VALUES ('Kr-85', 339075072, 6.90705375637786947e-14, 2.04422925127314e-09, 14477953050193300, 0, 36, 85);
INSERT INTO measure.radionuclide VALUES ('Kr-85m', 16128, 3.28531856753132986e-18, 4.29778757787665019e-05, 3.04384484927263015e+20, 0, 36, 85);
INSERT INTO measure.radionuclide VALUES ('Kr-87', 4578.01199999999972, 9.54496251211170067e-19, 0.000151407899446298009, 1.04767305134104995e+21, 0, 36, 87);
INSERT INTO measure.radionuclide VALUES ('Kr-88', 10224, 2.15616285818652985e-18, 6.77960857355189035e-05, 4.63786859236162994e+20, 0, 36, 88);
INSERT INTO measure.radionuclide VALUES ('Kr-89', 189, 4.03115835262345992e-20, 0.00366744539978806992, 2.4806765513173199e+22, 0, 36, 89);
INSERT INTO measure.radionuclide VALUES ('Kr-90', 32.3200000000000003, 6.97094906135850038e-21, 0.021446385537127001, 1.43452489926115995e+23, 0, 36, 90);
INSERT INTO measure.radionuclide VALUES ('Kr-91', 8.57000000000000028, 1.86896109890046009e-21, 0.0808806511738558997, 5.35056615457816014e+23, 0, 36, 91);
INSERT INTO measure.radionuclide VALUES ('Kr-92', 1.84000000000000008, 4.05680093889839986e-22, 0.376710424217362005, 2.46499647150925994e+24, 0, 36, 92);
INSERT INTO measure.radionuclide VALUES ('La-137', 1892204150400, 6.21250291604697973e-10, 3.66317334423675999e-13, 1609657192139.07007, 0, 57, 137);
INSERT INTO measure.radionuclide VALUES ('La-140', 145025.856, 4.86576937795063013e-17, 4.7794731207099098e-06, 2.05517344190526013e+19, 0, 57, 140);
INSERT INTO measure.radionuclide VALUES ('La-141', 14112, 4.76854327375503986e-18, 4.91175723185902018e-05, 2.09707649190009012e+20, 0, 57, 141);
INSERT INTO measure.radionuclide VALUES ('La-142', 5465.98800000000028, 1.86009474572179015e-18, 0.000126810959072714001, 5.37607023674463027e+20, 0, 57, 142);
INSERT INTO measure.radionuclide VALUES ('La-143', 848.399999999999977, 2.9074666710082698e-19, 0.000817005163319125031, 3.43942033788889989e+21, 0, 57, 143);
INSERT INTO measure.radionuclide VALUES ('Lu-172', 578880, 2.38613515791372002e-16, 1.19739355403528007e-06, 4.19087743912348979e+18, 0, 71, 172);
INSERT INTO measure.radionuclide VALUES ('Lu-173', 42135249.6000000015, 1.74690674526663997e-14, 1.64505298328634012e-08, 57244040227651800, 0, 71, 173);
INSERT INTO measure.radionuclide VALUES ('Lu-174', 112245454.079999998, 4.68054103549119018e-14, 6.17528064936975041e-09, 21365051442072400, 0, 71, 174);
INSERT INTO measure.radionuclide VALUES ('Lu-176', 1.2614431536e+18, 0.000532057291765650978, 5.49487449023597012e-19, 1879496.84268298, 0, 71, 176);
INSERT INTO measure.radionuclide VALUES ('Lu-177', 574300.800000000047, 2.43607545110508001e-16, 1.2069409977488199e-06, 4.10496316748468992e+18, 0, 71, 177);
INSERT INTO measure.radionuclide VALUES ('Lu-177m', 13849900.1280000005, 5.87486587204438974e-15, 5.00470887265553017e-08, 170216652053030016, 0, 71, 177);
INSERT INTO measure.radionuclide VALUES ('Mg-27', 567.480000000000018, 3.67191290842176979e-20, 0.00122144777007110006, 2.7233761391955499e+22, 0, 12, 27);
INSERT INTO measure.radionuclide VALUES ('Mg-28', 75240, 5.04876162216211999e-18, 9.21248246358246973e-06, 1.98068372967022985e+20, 0, 12, 28);
INSERT INTO measure.radionuclide VALUES ('Mn-51', 2772, 3.38798477276669023e-19, 0.000250053095440096011, 2.95160712656739998e+21, 0, 25, 51);
INSERT INTO measure.radionuclide VALUES ('Mn-52', 483408, 6.02414233637121043e-17, 1.43387610581526008e-06, 1.65998733788612997e+19, 0, 25, 52);
INSERT INTO measure.radionuclide VALUES ('Mn-52m', 1272, 1.58514320240131995e-19, 0.00054492702874209503, 6.30857829428349003e+21, 0, 25, 52);
INSERT INTO measure.radionuclide VALUES ('Mn-53', 116055002880000, 1.47406890160175001e-08, 5.97257475644245965e-15, 67839434026.0067978, 0, 25, 53);
INSERT INTO measure.radionuclide VALUES ('Mn-54', 26968000.0320000015, 3.48996078916682983e-15, 2.57025800851921986e-08, 286536170579364992, 0, 25, 54);
INSERT INTO measure.radionuclide VALUES ('Mn-56', 9296.63999999999942, 1.24764803952837e-18, 7.45588923051709954e-05, 8.01508092280588993e+20, 0, 25, 56);
INSERT INTO measure.radionuclide VALUES ('Mo-101', 876.600000000000023, 2.12178262055099008e-19, 0.000790722314122684999, 4.71301814952332991e+21, 0, 42, 101);
INSERT INTO measure.radionuclide VALUES ('Mo-102', 678, 1.65732588451356994e-19, 0.00102234097427720996, 6.03381633838115036e+21, 0, 42, 102);
INSERT INTO measure.radionuclide VALUES ('Mo-91', 929.399999999999977, 2.02685232825913998e-19, 0.000745800710738051984, 4.9337585479594195e+21, 0, 42, 91);
INSERT INTO measure.radionuclide VALUES ('Mo-93', 126144000000, 2.8114320699542301e-11, 5.49488822742218962e-12, 35569061429120, 0, 42, 93);
INSERT INTO measure.radionuclide VALUES ('Mo-98', 3.15366307200000013e+21, 0.740660895866590008, 2.19791133274221996e-22, 1350.14553297022007, 0, 42, 98);
INSERT INTO measure.radionuclide VALUES ('Mo-99', 237384, 5.6320264516698004e-17, 2.91994060492681e-06, 1.77555984259185992e+19, 0, 42, 99);
INSERT INTO measure.radionuclide VALUES ('Mo-99+', 237600, 5.63715113451935992e-17, 2.9172861134677798e-06, 1.77394569728041001e+19, 0, 42, 99);
INSERT INTO measure.radionuclide VALUES ('N-13', 598.019999999999982, 1.86310404461485997e-20, 0.0011590702327011601, 5.36738676989305008e+22, 0, 7, 13);
INSERT INTO measure.radionuclide VALUES ('N-16', 7.12999999999999989, 2.73393106751849011e-22, 0.0972155933464158989, 3.65773669965889997e+24, 0, 7, 16);
INSERT INTO measure.radionuclide VALUES ('N-17', 4.16999999999999993, 1.69888125329930999e-22, 0.166222345458020004, 5.8862265862193103e+24, 0, 7, 17);
INSERT INTO measure.radionuclide VALUES ('N-18', 0.621999999999999997, 2.68312519564665013e-23, 1.11438453466229004, 3.72699716592610985e+25, 0, 7, 18);
INSERT INTO measure.radionuclide VALUES ('Na-22', 82078747.200000003, 4.32744391038540988e-15, 8.44490448752786983e-09, 231083295522352992, 0, 11, 22);
INSERT INTO measure.radionuclide VALUES ('Na-24', 53846.6039999999994, 3.09704565685760997e-18, 1.28726257381049992e-05, 3.22888362264132977e+20, 0, 11, 24);
INSERT INTO measure.radionuclide VALUES ('Na-24m', 0.0201999999999999992, 1.16182484355974992e-24, 34.3142168594032029, 8.60714939556697998e+26, 0, 11, 24);
INSERT INTO measure.radionuclide VALUES ('Nb-88', 870, 1.83476299552258007e-19, 0.000796720897195338966, 5.45029522854084031e+21, 0, 41, 88);
INSERT INTO measure.radionuclide VALUES ('Nb-89', 7308, 1.55871456301441006e-18, 9.48477258565880057e-05, 6.41554280513100972e+20, 0, 41, 89);
INSERT INTO measure.radionuclide VALUES ('Nb-89m', 3960, 8.44623654835392972e-19, 0.000175037166808066991, 1.18395926312871998e+21, 0, 41, 89);
INSERT INTO measure.radionuclide VALUES ('Nb-90', 52560, 1.13364196369121994e-17, 1.31877317458133001e-05, 8.82112723442176e+19, 0, 41, 90);
INSERT INTO measure.radionuclide VALUES ('Nb-91', 21444970069.4399986, 4.6767578561106202e-12, 3.23221332702026004e-11, 213823343172109, 0, 41, 91);
INSERT INTO measure.radionuclide VALUES ('Nb-91m', 5261760, 1.14749413672701007e-15, 1.31732952578594988e-07, 871464147827624960, 0, 41, 91);
INSERT INTO measure.radionuclide VALUES ('Nb-93m', 508558681.439999998, 1.13344922188455005e-13, 1.36296401154194996e-09, 8822627257508080, 0, 41, 93);
INSERT INTO measure.radionuclide VALUES ('Nb-94', 630300571200, 1.41988640837099008e-10, 1.09970895193747991e-12, 7042816904961.29004, 0, 41, 94);
INSERT INTO measure.radionuclide VALUES ('Nb-95', 3023219.80800000019, 6.88289869317764012e-16, 2.29274490305252989e-07, 1.45287624382908006e+18, 0, 41, 95);
INSERT INTO measure.radionuclide VALUES ('Nb-95m', 311759.712, 7.09776546393359987e-17, 2.22333789094578002e-06, 1.40889411615722004e+19, 0, 41, 95);
INSERT INTO measure.radionuclide VALUES ('Nb-96', 84060, 1.93392071979470003e-17, 8.24586224791750022e-06, 5.17084278463159992e+19, 0, 41, 96);
INSERT INTO measure.radionuclide VALUES ('Nb-97', 4326.01199999999972, 1.00562833512447993e-18, 0.00016022775261833401, 9.94403165734403965e+20, 0, 41, 97);
INSERT INTO measure.radionuclide VALUES ('Nb-97m', 52.7000000000000028, 1.22506856802662995e-20, 0.0131526979233385997, 8.16280840190705931e+22, 0, 41, 97);
INSERT INTO measure.radionuclide VALUES ('Nb-98', 3078, 7.22890868627757972e-19, 0.000225194015776460012, 1.38333466834111011e+21, 0, 41, 98);
INSERT INTO measure.radionuclide VALUES ('Nd-147', 948672, 3.34203862632958987e-16, 7.30649982881274978e-07, 2.99218564418046003e+18, 0, 60, 147);
INSERT INTO measure.radionuclide VALUES ('Nd-149', 6220.80000000000018, 2.22131707515606001e-18, 0.000111424122389395001, 4.50183366969231016e+20, 0, 60, 149);
INSERT INTO measure.radionuclide VALUES ('Nd-151', 746.399999999999977, 2.7010126969509601e-19, 0.000928653778885242965, 3.70231506548950984e+21, 0, 60, 151);
INSERT INTO measure.radionuclide VALUES ('Nd-152', 684, 2.49159664470338009e-19, 0.00101337307099406992, 4.01349071538441998e+21, 0, 60, 152);
INSERT INTO measure.radionuclide VALUES ('Ne-24', 202.800000000000011, 1.16642613006890004e-20, 0.00341788550571965003, 8.57319614351345986e+22, 0, 10, 24);
INSERT INTO measure.radionuclide VALUES ('Ni-56', 524880, 7.04410951685394957e-17, 1.32058219128171002e-06, 1.4196258556278399e+19, 0, 28, 56);
INSERT INTO measure.radionuclide VALUES ('Ni-57', 129239.712, 1.7654234253378901e-17, 5.36326775906112995e-06, 5.66436349290315039e+19, 0, 28, 57);
INSERT INTO measure.radionuclide VALUES ('Ni-59', 2396789611200, 3.38890951298692998e-10, 2.89198174641997984e-13, 2950801714143.77979, 0, 28, 59);
INSERT INTO measure.radionuclide VALUES ('Ni-63', 3172524753.5999999, 4.7898687862843995e-13, 2.18484404187359007e-10, 2087739862234770, 0, 28, 63);
INSERT INTO measure.radionuclide VALUES ('Ni-65', 9072, 1.41317011912192995e-18, 7.6405112495584799e-05, 7.07628888036030939e+20, 0, 28, 65);
INSERT INTO measure.radionuclide VALUES ('Ni-66+', 195842.880000000005, 3.09763163069454998e-17, 3.53930242733331017e-06, 3.22827282008279982e+19, 0, 28, 66);
INSERT INTO measure.radionuclide VALUES ('Np-234', 380160, 2.13186806541822996e-16, 1.82330382091736004e-06, 4.69072179569338982e+18, 0, 93, 234);
INSERT INTO measure.radionuclide VALUES ('Np-235', 34185024, 1.92522635887135015e-14, 2.02763403225910999e-08, 51941944145531296, 0, 93, 235);
INSERT INTO measure.radionuclide VALUES ('Np-236', 4793566608000, 2.71112047600279001e-09, 1.44599467837402999e-13, 368851184907.273987, 0, 93, 236);
INSERT INTO measure.radionuclide VALUES ('Np-237', 67487040000000, 3.83307020763275999e-08, 1.0270819116677e-14, 26088747292.1500015, 0, 93, 237);
INSERT INTO measure.radionuclide VALUES ('Np-238', 182908.799999999988, 1.04325291111957004e-16, 3.78957808787737994e-06, 9.58540339874865971e+18, 0, 93, 238);
INSERT INTO measure.radionuclide VALUES ('Np-239', 203472, 1.16541499735851003e-16, 3.40659737241460984e-06, 8.58063438574726042e+18, 0, 93, 239);
INSERT INTO measure.radionuclide VALUES ('Np-240', 3899.98799999999983, 2.24312027127965019e-18, 0.000177730593160784997, 4.45807571178302996e+20, 0, 93, 240);
INSERT INTO measure.radionuclide VALUES ('Np-240m', 444, 2.55371401257687984e-19, 0.00156114229855844008, 3.9158652655507399e+21, 0, 93, 240);
INSERT INTO measure.radionuclide VALUES ('O-15', 122.459999999999994, 4.40213707742347973e-21, 0.00566019255724274032, 2.27162394630675e+23, 0, 8, 15);
INSERT INTO measure.radionuclide VALUES ('O-19', 26.9100000000000001, 1.22530821836564003e-21, 0.0257579777242640008, 8.16121188947733959e+23, 0, 8, 19);
INSERT INTO measure.radionuclide VALUES ('Os-194', 189216315.360000014, 8.79707630001328043e-14, 3.66325271286026981e-09, 11367413057432400, 0, 76, 194);
INSERT INTO measure.radionuclide VALUES ('P-32', 1232928, 9.45509162191706978e-17, 5.62195992434225999e-07, 1.05763121076688998e+19, 0, 15, 32);
INSERT INTO measure.radionuclide VALUES ('P-33', 2193090.33600000013, 1.7343969803150701e-16, 3.1605956634881902e-07, 5.76569269521179034e+18, 0, 15, 33);
INSERT INTO measure.radionuclide VALUES ('Pa-231', 1033144588800, 5.71940871719069021e-10, 6.70910139852774994e-13, 1748432485676.92993, 0, 91, 231);
INSERT INTO measure.radionuclide VALUES ('Pa-233', 2332800, 1.30260120430712008e-15, 2.97130993038385009e-07, 767694668708617984, 0, 91, 233);
INSERT INTO measure.radionuclide VALUES ('Pa-234', 24408, 1.36875620109239004e-17, 2.83983603965890011e-05, 7.30590297382332989e+19, 0, 91, 234);
INSERT INTO measure.radionuclide VALUES ('Pa-234m', 70.2000000000000028, 3.93668818898252993e-20, 0.00987389146096787941, 2.5402062647447299e+22, 0, 91, 234);
INSERT INTO measure.radionuclide VALUES ('Pb-201', 33840, 1.63006326194688007e-17, 2.04830727115822998e-05, 6.13473123003609006e+19, 0, 82, 201);
INSERT INTO measure.radionuclide VALUES ('Pb-202', 1671439536000, 8.09133323930326016e-10, 4.14700720923921982e-13, 1235890267307.92993, 0, 82, 202);
INSERT INTO measure.radionuclide VALUES ('Pb-203', 186804.576000000001, 9.08785933361209005e-17, 3.71054711507679985e-06, 1.10036914447105004e+19, 0, 82, 203);
INSERT INTO measure.radionuclide VALUES ('Pb-205', 482510260800000, 2.37049182539886008e-07, 1.43654391807276997e-15, 4218533847.21857023, 0, 82, 205);
INSERT INTO measure.radionuclide VALUES ('Pb-210', 698838390.720000029, 3.51701400235314008e-13, 9.91856185585066077e-10, 2843321065343860, 0, 82, 210);
INSERT INTO measure.radionuclide VALUES ('Pb-212', 38304, 1.94606811617885015e-17, 1.80959476963226984e-05, 5.13856627980485018e+19, 0, 82, 212);
INSERT INTO measure.radionuclide VALUES ('Pb-214', 1608, 8.24665574601965019e-19, 0.000431061679452701999, 1.21261276182488993e+21, 0, 82, 214);
INSERT INTO measure.radionuclide VALUES ('Pd-103', 1467070.27200000011, 3.62131404689622009e-16, 4.72470333418320018e-07, 2.76142855065852979e+18, 0, 46, 103);
INSERT INTO measure.radionuclide VALUES ('Pd-107', 204984000000000, 5.25631990498162968e-08, 3.38146967841366004e-15, 19024717256.1217003, 0, 46, 107);
INSERT INTO measure.radionuclide VALUES ('Pd-111', 1404, 3.73480674339368005e-19, 0.000493694573048394036, 2.67751471148769005e+21, 0, 46, 111);
INSERT INTO measure.radionuclide VALUES ('Pm-143', 22982400, 7.87606813057290998e-15, 3.01599128272045e-08, 126966905748092000, 0, 61, 143);
INSERT INTO measure.radionuclide VALUES ('Pm-144', 31363200, 1.08233301782772002e-14, 2.21006523747558991e-08, 92393005066688000, 0, 61, 144);
INSERT INTO measure.radionuclide VALUES ('Pm-145', 558199499.039999962, 1.93970413817771005e-13, 1.24175528955513003e-09, 5155425409049590, 0, 61, 145);
INSERT INTO measure.radionuclide VALUES ('Pm-146', 174412370.879999995, 6.10250563631003053e-14, 3.97418587375805018e-09, 16386711616454400, 0, 61, 146);
INSERT INTO measure.radionuclide VALUES ('Pm-147', 82731542.400000006, 2.91451640099660022e-14, 8.37826976812105042e-09, 34311009526591000, 0, 61, 147);
INSERT INTO measure.radionuclide VALUES ('Pm-148', 463795.200000000012, 1.64500041834151997e-16, 1.49451132862079008e-06, 6.07902580966023987e+18, 0, 61, 148);
INSERT INTO measure.radionuclide VALUES ('Pm-149', 191088.288, 6.82336157723667026e-17, 3.62736611340589013e-06, 1.46555328877204009e+19, 0, 61, 149);
INSERT INTO measure.radionuclide VALUES ('Pm-150', 9648, 3.46821970626995e-18, 7.18436132421169954e-05, 2.88332367811696001e+20, 0, 61, 150);
INSERT INTO measure.radionuclide VALUES ('Pm-151', 102239.712, 3.69976902792885e-17, 6.77962767109463006e-06, 2.70287142913838981e+19, 0, 61, 151);
INSERT INTO measure.radionuclide VALUES ('Pm-152', 247.199999999999989, 9.00471769840171004e-20, 0.00280399344886709005, 1.11052898435393997e+22, 0, 61, 152);
INSERT INTO measure.radionuclide VALUES ('Po-210', 11956699.8719999995, 6.01739707351120022e-15, 5.79714459658843981e-08, 166184811768868992, 0, 84, 210);
INSERT INTO measure.radionuclide VALUES ('Po-211', 0.516000000000000014, 2.60921703109347017e-22, 1.34330848945726, 3.83256734906762996e+24, 0, 84, 211);
INSERT INTO measure.radionuclide VALUES ('Po-212', 2.97999999999999995e-07, 1.51401498178075003e-28, 2325997.25020116009, 6.60495445575989021e+30, 0, 84, 212);
INSERT INTO measure.radionuclide VALUES ('Po-216', 0.149999999999999994, 7.76467098418645013e-23, 4.62098120373296961, 1.28788457622557994e+25, 0, 84, 216);
INSERT INTO measure.radionuclide VALUES ('Po-218', 185.879999999999995, 9.71107269363720985e-20, 0.00372900355369026014, 1.02975235748693992e+22, 0, 84, 218);
INSERT INTO measure.radionuclide VALUES ('Pr-143', 1171579.67999999993, 4.01500338523166009e-16, 5.91634689806113024e-07, 2.49065792491804006e+18, 0, 59, 143);
INSERT INTO measure.radionuclide VALUES ('Pr-144', 1036.79999999999995, 3.57796038951311977e-19, 0.000668544734336366971, 2.79488840326731006e+21, 0, 59, 144);
INSERT INTO measure.radionuclide VALUES ('Pr-144m', 414, 1.42869946109030994e-19, 0.00167426855207716005, 6.99937269687814036e+21, 0, 59, 144);
INSERT INTO measure.radionuclide VALUES ('Pr-145', 21024, 7.30569265489897953e-18, 3.29693293645332011e-05, 1.36879560534130999e+20, 0, 59, 145);
INSERT INTO measure.radionuclide VALUES ('Pr-146', 1449, 5.06989878206352027e-19, 0.000478362443450617994, 1.97242596546077e+21, 0, 59, 146);
INSERT INTO measure.radionuclide VALUES ('Pr-147', 804, 2.8323794267871202e-19, 0.000862123358905403999, 3.53060042218404001e+21, 0, 59, 147);
INSERT INTO measure.radionuclide VALUES ('Pt-193', 1576833743.51999998, 7.29325270534814008e-13, 4.39581651146441004e-10, 1371130331555220, 0, 78, 193);
INSERT INTO measure.radionuclide VALUES ('Pt-197', 71609.3999999999942, 3.38075974641590007e-17, 9.67955576446591014e-06, 2.95791501025811005e+19, 0, 78, 197);
INSERT INTO measure.radionuclide VALUES ('Pt-197m', 5717.98800000000028, 2.69952599252180988e-18, 0.000121222216723775007, 3.70435403389403988e+20, 0, 78, 197);
INSERT INTO measure.radionuclide VALUES ('Pu-234', 31680, 1.77655672118186005e-17, 2.1879645851008401e-05, 5.62886615483207025e+19, 0, 94, 234);
INSERT INTO measure.radionuclide VALUES ('Pu-235', 1518, 8.54904654379269e-19, 0.00045661869602104402, 1.16972108512624994e+21, 0, 94, 235);
INSERT INTO measure.radionuclide VALUES ('Pu-236', 90131780.1599999964, 5.09762635450913981e-14, 7.69037490804559053e-09, 19616973282387500, 0, 94, 236);
INSERT INTO measure.radionuclide VALUES ('Pu-237', 3913920, 2.22299424408863993e-15, 1.77097942870560998e-07, 449843719865305984, 0, 94, 237);
INSERT INTO measure.radionuclide VALUES ('Pu-238', 2765704677.11999989, 1.57746891111989006e-12, 2.50622268637061007e-10, 633926914787861, 0, 94, 238);
INSERT INTO measure.radionuclide VALUES ('Pu-239', 760443336000, 4.35554802830728006e-10, 9.11504050000570927e-13, 2295922335147.87988, 0, 94, 239);
INSERT INTO measure.radionuclide VALUES ('Pu-240', 206970768000, 1.19041475323287996e-10, 3.34901004261599991e-12, 8400433523561.79004, 0, 94, 240);
INSERT INTO measure.radionuclide VALUES ('Pu-241', 451920025.439999998, 2.61009717406891991e-13, 1.53378284107920009e-09, 3831274980621060, 0, 94, 241);
INSERT INTO measure.radionuclide VALUES ('Pu-242', 11778979824000, 6.83126434962368988e-09, 5.88461132387405952e-14, 146385785825.296997, 0, 94, 242);
INSERT INTO measure.radionuclide VALUES ('Pu-243', 17841.5999999999985, 1.03900615373595999e-17, 3.88500572011447971e-05, 9.62458207205316035e+19, 0, 94, 243);
INSERT INTO measure.radionuclide VALUES ('Pu-244', 2522936764800000, 1.47527926845354004e-06, 2.74738229760940018e-16, 677837763.590515971, 0, 94, 244);
INSERT INTO measure.radionuclide VALUES ('Pu-245', 37800, 2.21940178964662999e-17, 1.83372269989404008e-05, 4.50571863402534011e+19, 0, 94, 245);
INSERT INTO measure.radionuclide VALUES ('Pu-246', 937440, 5.52658221970455045e-16, 7.39404314473401045e-07, 1.80943657444304e+18, 0, 94, 246);
INSERT INTO measure.radionuclide VALUES ('Ra-223', 987552, 5.27767792663547035e-16, 7.01884235523745028e-07, 1.89477268962015002e+18, 0, 88, 223);
INSERT INTO measure.radionuclide VALUES ('Ra-224', 314496, 1.68826723564434003e-16, 2.20399362968033015e-06, 5.92323287976589005e+18, 0, 88, 224);
INSERT INTO measure.radionuclide VALUES ('Ra-225', 1278720, 6.89502783395757035e-16, 5.42063298110567999e-07, 1.4503204687225001e+18, 0, 88, 225);
INSERT INTO measure.radionuclide VALUES ('Ra-226', 50457600000, 2.73283289380496998e-11, 1.37372205685555003e-11, 36592065408276.1016, 0, 88, 226);
INSERT INTO measure.radionuclide VALUES ('Ra-228', 181335784.319999993, 9.90823753895544977e-14, 3.82245116792150006e-09, 10092612294248900, 0, 88, 228);
INSERT INTO measure.radionuclide VALUES ('Rb-77', 226.199999999999989, 4.17408581481385982e-20, 0.00306431114305900009, 2.39573416639157995e+22, 0, 37, 77);
INSERT INTO measure.radionuclide VALUES ('Rb-78', 1059.59999999999991, 1.98068129394392008e-19, 0.000654159287051666043, 5.0487678308346495e+21, 0, 37, 78);
INSERT INTO measure.radionuclide VALUES ('Rb-78m', 344.399999999999977, 6.43777498711103043e-20, 0.0020126224754934501, 1.55333170544495003e+22, 0, 37, 78);
INSERT INTO measure.radionuclide VALUES ('Rb-79', 1374, 2.60130856990587022e-19, 0.000504473930538533997, 3.84421906562274977e+21, 0, 37, 79);
INSERT INTO measure.radionuclide VALUES ('Rb-80', 34, 6.51848922129233017e-21, 0.0203866817811748993, 1.53409780403340996e+23, 0, 37, 80);
INSERT INTO measure.radionuclide VALUES ('Rb-81', 16473.5999999999985, 3.19780209812735e-18, 4.20762420211699998e-05, 3.1271478637955901e+20, 0, 37, 81);
INSERT INTO measure.radionuclide VALUES ('Rb-81m', 1815, 3.52321945907459995e-19, 0.000381899273035782023, 2.83831311564866008e+21, 0, 37, 81);
INSERT INTO measure.radionuclide VALUES ('Rb-82', 76.3799999999999955, 1.50096841732459996e-20, 0.00907498272532004935, 6.66236536663740001e+22, 0, 37, 82);
INSERT INTO measure.radionuclide VALUES ('Rb-82m', 23299.2000000000007, 4.57860216665742979e-18, 2.97498274859198996e-05, 2.18407270079557992e+20, 0, 37, 82);
INSERT INTO measure.radionuclide VALUES ('Rb-83', 7447680, 1.48141640062561006e-15, 9.30688725294247055e-08, 675029653767634048, 0, 37, 83);
INSERT INTO measure.radionuclide VALUES ('Rb-84', 2894400, 5.8266091065335099e-16, 2.39478710807057019e-07, 1.71626409411724006e+18, 0, 37, 84);
INSERT INTO measure.radionuclide VALUES ('Rb-86', 1610500.32000000007, 3.3192297500201301e-16, 4.30392451309755001e-07, 3.01274715916828979e+18, 0, 37, 86);
INSERT INTO measure.radionuclide VALUES ('Rb-87', 1.5168847536e+18, 0.000316264092542916004, 4.56954411938619006e-19, 3161914.43663273985, 0, 37, 87);
INSERT INTO measure.radionuclide VALUES ('Rb-88', 1068, 2.25232974622771016e-19, 0.000649014214007438998, 4.43984723673270977e+21, 0, 37, 88);
INSERT INTO measure.radionuclide VALUES ('Rb-89', 924, 1.97078852794924988e-19, 0.00075015928632028695, 5.07411112769452979e+21, 0, 37, 89);
INSERT INTO measure.radionuclide VALUES ('Rb-90', 157.999799999999993, 3.40782350713128009e-20, 0.00438701302507943022, 2.93442426788646004e+22, 0, 37, 90);
INSERT INTO measure.radionuclide VALUES ('Rb-90m', 258, 5.5646808720002898e-20, 0.00268661697891451993, 1.7970482458961501e+22, 0, 37, 90);
INSERT INTO measure.radionuclide VALUES ('Rb-91', 58.3999999999999986, 1.27359776167779005e-20, 0.0118689585712318992, 7.85177259327650949e+22, 0, 37, 91);
INSERT INTO measure.radionuclide VALUES ('Rb-92', 4.49199999999999999, 9.9038857703976193e-22, 0.154307030400700013, 1.00970469892631994e+24, 0, 37, 92);
INSERT INTO measure.radionuclide VALUES ('Re-184', 3274560, 1.44393892200859995e-15, 2.11676433035261007e-07, 692550068952322048, 0, 75, 184);
INSERT INTO measure.radionuclide VALUES ('Re-186', 324000, 1.44422880305868009e-16, 2.13934314987637007e-06, 6.92411062486870016e+18, 0, 75, 186);
INSERT INTO measure.radionuclide VALUES ('Re-186m', 5991840000000, 2.67086046645651981e-09, 1.15681857419415008e-13, 374411172938.10498, 0, 75, 186);
INSERT INTO measure.radionuclide VALUES ('Re-188', 61128, 2.7540770336177099e-17, 1.13392746459879007e-05, 3.63098049834292019e+19, 0, 75, 188);
INSERT INTO measure.radionuclide VALUES ('Re-188m', 1115.40000000000009, 5.02535257704682986e-19, 0.000621433728312663987, 1.98991013002247012e+21, 0, 75, 188);
INSERT INTO measure.radionuclide VALUES ('Rh-101', 100914884.640000001, 2.44261291791079996e-14, 6.86863174875196005e-09, 40939765472759200, 0, 45, 101);
INSERT INTO measure.radionuclide VALUES ('Rh-102', 91523148.4800000042, 2.23722246324606012e-14, 7.57346302079428967e-09, 44698281750178096, 0, 45, 102);
INSERT INTO measure.radionuclide VALUES ('Rh-102m', 17971200, 4.39294025601332013e-15, 3.85698885194058026e-08, 227637969496884992, 0, 45, 102);
INSERT INTO measure.radionuclide VALUES ('Rh-103m', 3366.84000000000015, 8.31070277842291977e-19, 0.000205874701666829011, 1.20326767381971993e+21, 0, 45, 103);
INSERT INTO measure.radionuclide VALUES ('Rh-105', 127295.712, 3.20317835631680004e-17, 5.44517305154744983e-06, 3.12189921622054011e+19, 0, 45, 105);
INSERT INTO measure.radionuclide VALUES ('Rh-105m', 40, 1.00653142387601994e-20, 0.0173286795139986002, 9.93510958802588045e+22, 0, 45, 105);
INSERT INTO measure.radionuclide VALUES ('Rh-106', 30, 7.62088078077558975e-21, 0.0231049060186648003, 1.31218428521096992e+23, 0, 45, 106);
INSERT INTO measure.radionuclide VALUES ('Rh-107', 1302, 3.3386647329967598e-19, 0.000532371106420849037, 2.99520940247991976e+21, 0, 45, 107);
INSERT INTO measure.radionuclide VALUES ('Rh-108', 16.8000000000000007, 4.34821575114441028e-21, 0.0412587607476158011, 2.29979388611709989e+23, 0, 45, 108);
INSERT INTO measure.radionuclide VALUES ('Rn-220', 55.7999999999999972, 2.94194756178619986e-20, 0.0124219924831531006, 3.39910885220826984e+22, 0, 86, 220);
INSERT INTO measure.radionuclide VALUES ('Rn-222', 330315.840000000026, 1.75735872746687998e-16, 2.09843760614067008e-06, 5.69035783286794957e+18, 0, 86, 222);
INSERT INTO measure.radionuclide VALUES ('Ru-103', 3392059.68000000017, 8.3729549985007801e-16, 2.04344040479838003e-07, 1.1943214793093399e+18, 0, 44, 103);
INSERT INTO measure.radionuclide VALUES ('Ru-105', 15984, 4.02209956980858008e-18, 4.33650638488454026e-05, 2.48626366066713985e+20, 0, 44, 105);
INSERT INTO measure.radionuclide VALUES ('Ru-106+', 32171135.0399999991, 8.17241282406907007e-15, 2.15456240414930992e-08, 122362883707348000, 0, 44, 106);
INSERT INTO measure.radionuclide VALUES ('Ru-108', 273, 7.06585059560967019e-20, 0.00253900066139174001, 1.41525777607205994e+22, 0, 44, 108);
INSERT INTO measure.radionuclide VALUES ('S-35', 7544448, 6.32810332316549964e-16, 9.18751352729776031e-08, 1.58025232669520998e+18, 0, 16, 35);
INSERT INTO measure.radionuclide VALUES ('S-37', 299.399999999999977, 2.65479852557471008e-20, 0.0023151208435535902, 3.76676418329530021e+22, 0, 16, 37);
INSERT INTO measure.radionuclide VALUES ('S-38', 10217.9879999999994, 9.30522829547494005e-19, 6.78359751998089031e-05, 1.07466465974434005e+21, 0, 16, 38);
INSERT INTO measure.radionuclide VALUES ('Sb-124', 5201280, 1.54564575900680002e-15, 1.33264731096949988e-07, 646978775164226048, 0, 51, 124);
INSERT INTO measure.radionuclide VALUES ('Sb-125', 86993948.1599999964, 2.60601614613338005e-14, 7.9677632205530307e-09, 38372747670183400, 0, 51, 125);
INSERT INTO measure.radionuclide VALUES ('Sb-126', 1071360, 3.23507251885144018e-16, 6.46978775164226021e-07, 3.09112081467352013e+18, 0, 51, 126);
INSERT INTO measure.radionuclide VALUES ('Sb-126m', 1146, 3.46045503528575995e-19, 0.000604840471692796953, 2.88979336475446975e+21, 0, 51, 126);
INSERT INTO measure.radionuclide VALUES ('Sb-127', 332640, 1.01240956739146006e-16, 2.08377579533413018e-06, 9.87742542355233997e+18, 0, 51, 127);
INSERT INTO measure.radionuclide VALUES ('Sb-128', 32436, 9.94982194738061033e-18, 2.13696874016508001e-05, 1.00504311060888994e+20, 0, 51, 128);
INSERT INTO measure.radionuclide VALUES ('Sb-128m', 624, 1.91413518780537001e-19, 0.00111081278935888997, 5.22429139995350952e+21, 0, 51, 128);
INSERT INTO measure.radionuclide VALUES ('Sb-129', 15696, 4.85240172038425032e-18, 4.41607530937784029e-05, 2.06083514437632e+20, 0, 51, 129);
INSERT INTO measure.radionuclide VALUES ('Sb-129m', 1062, 3.28316171448016993e-19, 0.00065268096097923303, 3.04584448456974978e+21, 0, 51, 129);
INSERT INTO measure.radionuclide VALUES ('Sb-130', 2370, 7.38362694514767039e-19, 0.000292467164793226025, 1.35434794773478008e+21, 0, 51, 130);
INSERT INTO measure.radionuclide VALUES ('Sb-130m', 378, 1.1776417659349401e-19, 0.00183372269989403995, 8.49154665643238018e+21, 0, 51, 130);
INSERT INTO measure.radionuclide VALUES ('Sb-131', 1381.79999999999995, 4.33804978376326035e-19, 0.000501626270487730004, 2.30518331934055989e+21, 0, 51, 131);
INSERT INTO measure.radionuclide VALUES ('Sb-132', 167.400000000000006, 5.29550561121516011e-20, 0.00414066416105104973, 1.88839380678236994e+22, 0, 51, 132);
INSERT INTO measure.radionuclide VALUES ('Sc-43', 14007.6000000000004, 1.44347821819687008e-18, 4.9483650344094997e-05, 6.92771104817329996e+20, 0, 21, 43);
INSERT INTO measure.radionuclide VALUES ('Sc-44', 14292, 1.50703636390854009e-18, 4.84989630954342024e-05, 6.63553995078440059e+20, 0, 21, 44);
INSERT INTO measure.radionuclide VALUES ('Sc-46', 7239279.74399999995, 7.98052088652373966e-16, 9.57480861455082951e-08, 1.25305104042599987e+18, 0, 21, 46);
INSERT INTO measure.radionuclide VALUES ('Sc-47', 289526.400000000023, 3.26109969599042986e-17, 2.39407245957516991e-06, 3.06645025673245e+19, 0, 21, 47);
INSERT INTO measure.radionuclide VALUES ('Sc-48', 157211.712, 1.80844032376397e-17, 4.4090047219888103e-06, 5.52962675549430006e+19, 0, 21, 48);
INSERT INTO measure.radionuclide VALUES ('Sc-49', 3432, 4.03015182119958991e-19, 0.000201965961701615988, 2.48129610090556005e+21, 0, 21, 49);
INSERT INTO measure.radionuclide VALUES ('Se-70', 2466, 4.13684415213044989e-19, 0.000281081581735581989, 2.41730160292601004e+21, 0, 34, 70);
INSERT INTO measure.radionuclide VALUES ('Se-71', 284.399999999999977, 4.83911550558909003e-20, 0.00243722637327688013, 2.06649334748265012e+22, 0, 34, 71);
INSERT INTO measure.radionuclide VALUES ('Se-72', 725760, 1.25228613632958994e-16, 9.55063906194810072e-07, 7.98539543790659994e+18, 0, 34, 72);
INSERT INTO measure.radionuclide VALUES ('Se-73', 25740, 4.50307780021790996e-18, 2.69287948935488007e-05, 2.22070335971457008e+20, 0, 34, 73);
INSERT INTO measure.radionuclide VALUES ('Se-73m', 2388, 4.17768056989912979e-19, 0.000290262638425438011, 2.39367271687827017e+21, 0, 34, 73);
INSERT INTO measure.radionuclide VALUES ('Se-75', 10336900.3200000003, 1.85793124956323017e-15, 6.70556123307905961e-08, 538233048308478976, 0, 34, 75);
INSERT INTO measure.radionuclide VALUES ('Se-79', 11889072000000, 2.25088390697437994e-09, 5.83012013519596013e-14, 444269914099.742981, 0, 34, 79);
INSERT INTO measure.radionuclide VALUES ('Se-79m', 234, 4.43017616708859973e-20, 0.00296216743829036009, 2.25724657955797016e+22, 0, 34, 79);
INSERT INTO measure.radionuclide VALUES ('Se-81', 1103.40000000000009, 2.1418844909878299e-19, 0.000628192115787516042, 4.66878584819858014e+21, 0, 34, 81);
INSERT INTO measure.radionuclide VALUES ('Se-83', 1338, 2.66141287493160996e-19, 0.000518047220149436003, 3.75740272927662984e+21, 0, 34, 83);
INSERT INTO measure.radionuclide VALUES ('Si-31', 9432, 7.00718419261803969e-19, 7.3488886827814402e-05, 1.42710677001110998e+21, 0, 14, 31);
INSERT INTO measure.radionuclide VALUES ('Si-32', 4162837777.92000008, 3.19240155121883013e-13, 1.66508333386530013e-10, 3132438021834100, 0, 14, 32);
INSERT INTO measure.radionuclide VALUES ('Sm-145', 29376000, 1.02079541205438003e-14, 2.35956965059893989e-08, 97962822735211296, 0, 62, 145);
INSERT INTO measure.radionuclide VALUES ('Sm-146', 3153663072000000, 1.10343357955634992e-06, 2.19791133274222e-16, 906262070.075903058, 0, 62, 146);
INSERT INTO measure.radionuclide VALUES ('Sm-147', 3.342816e+18, 0.00117762727188244006, 2.07354272732912993e-19, 849165.116906214971, 0, 62, 147);
INSERT INTO measure.radionuclide VALUES ('Sm-151', 2838807648, 1.02728503502807002e-12, 2.44168420867924002e-10, 973439664652253, 0, 62, 151);
INSERT INTO measure.radionuclide VALUES ('Sm-153', 166622.399999999994, 6.10946054114545954e-17, 4.15998797616613999e-06, 1.63680572656995e+19, 0, 62, 153);
INSERT INTO measure.radionuclide VALUES ('Sm-155', 1338, 4.97010838089637954e-19, 0.000518047220149436003, 2.01202855825781005e+21, 0, 62, 155);
INSERT INTO measure.radionuclide VALUES ('Sm-156', 33840, 1.26512372569011001e-17, 2.04830727115822998e-05, 7.90436523870034985e+19, 0, 62, 156);
INSERT INTO measure.radionuclide VALUES ('Sn-111', 2118, 5.63413154024773034e-19, 0.000327264957771456996, 1.77489643764339992e+21, 0, 50, 111);
INSERT INTO measure.radionuclide VALUES ('Sn-113', 9943780.3200000003, 2.69282426703474982e-15, 6.97066063663748934e-08, 371357318872192000, 0, 50, 113);
INSERT INTO measure.radionuclide VALUES ('Sn-113m', 1254, 3.3958932339542801e-19, 0.000552748947814947988, 2.94473333260707011e+21, 0, 50, 113);
INSERT INTO measure.radionuclide VALUES ('Sn-117m', 1175040, 3.2947051920099899e-16, 5.89892412649735956e-07, 3.03517292662514022e+18, 0, 50, 117);
INSERT INTO measure.radionuclide VALUES ('Sn-119m', 25315200, 7.21948755215009931e-15, 2.73806717134348012e-08, 138513986315023008, 0, 50, 119);
INSERT INTO measure.radionuclide VALUES ('Sn-121', 97308, 2.82170731788997003e-17, 7.12322913388359973e-06, 3.5439536682627498e+19, 0, 50, 121);
INSERT INTO measure.radionuclide VALUES ('Sn-121m', 1734519104.6400001, 5.02970490667021025e-13, 3.99619225124538992e-10, 1988188210950180, 0, 50, 121);
INSERT INTO measure.radionuclide VALUES ('Sn-123', 11162899.8719999995, 3.29048706866239018e-15, 6.20938276351086997e-08, 303906375905166016, 0, 50, 123);
INSERT INTO measure.radionuclide VALUES ('Sn-123m', 2403.59999999999991, 7.08508972482604023e-19, 0.000288378757097664017, 1.41141472986011009e+21, 0, 50, 123);
INSERT INTO measure.radionuclide VALUES ('Sn-125', 832896, 2.49504760958525009e-16, 8.32213362244439976e-07, 4.0079395525692201e+18, 0, 50, 125);
INSERT INTO measure.radionuclide VALUES ('Sn-125m', 571.200000000000045, 1.71110342058924e-19, 0.00121349296316517006, 5.84418211060345995e+21, 0, 50, 125);
INSERT INTO measure.radionuclide VALUES ('Sn-126', 7253280000000, 2.19019627385144007e-09, 9.55632735203860017e-14, 456580084597.400024, 0, 50, 126);
INSERT INTO measure.radionuclide VALUES ('Sn-127', 7560, 2.30093083498058011e-18, 9.16861349947016991e-05, 4.34606718636302991e+20, 0, 50, 127);
INSERT INTO measure.radionuclide VALUES ('Sn-128', 3544.19999999999982, 1.08719197638138002e-18, 0.000195572253416834992, 9.19800754351050064e+20, 0, 50, 128);
INSERT INTO measure.radionuclide VALUES ('Sn-129m', 432, 1.33552340928006994e-19, 0.00160450736240727999, 7.48770102456730989e+21, 0, 50, 129);
INSERT INTO measure.radionuclide VALUES ('Sr-80', 6378.01199999999972, 1.22279419044921004e-18, 0.000108677622519359998, 8.17799109458180047e+20, 0, 38, 80);
INSERT INTO measure.radionuclide VALUES ('Sr-81', 1338, 2.59728244421036993e-19, 0.000518047220149436003, 3.85017810530815024e+21, 0, 38, 81);
INSERT INTO measure.radionuclide VALUES ('Sr-82', 2207520, 4.33806991439174014e-16, 3.13993612995553975e-07, 2.30517262223565005e+18, 0, 38, 82);
INSERT INTO measure.radionuclide VALUES ('Sr-83', 116676.288, 2.3208054938896e-17, 5.94077162070792971e-06, 4.30884881405562962e+19, 0, 38, 83);
INSERT INTO measure.radionuclide VALUES ('Sr-85', 5602950.14400000032, 1.1413365662844499e-15, 1.23711109816354989e-07, 876165742464066048, 0, 38, 85);
INSERT INTO measure.radionuclide VALUES ('Sr-85m', 4056.58800000000019, 8.26338286038243974e-19, 0.000170869504263175006, 1.21015813607566003e+21, 0, 38, 85);
INSERT INTO measure.radionuclide VALUES ('Sr-87m', 10137.6000000000004, 2.11364697084200982e-18, 6.83738932844012056e-05, 4.73115905255281983e+20, 0, 38, 87);
INSERT INTO measure.radionuclide VALUES ('Sr-89', 4369249.72800000012, 9.31912038927248978e-16, 1.58642152248237002e-07, 1.07306264779144998e+18, 0, 38, 89);
INSERT INTO measure.radionuclide VALUES ('Sr-90', 907921440, 1.95825312808021991e-13, 7.63444005199331975e-10, 5106592123666640, 0, 38, 90);
INSERT INTO measure.radionuclide VALUES ('Sr-91', 34668, 7.5604601373023501e-18, 1.99938612137979007e-05, 1.32267081875893993e+20, 0, 38, 91);
INSERT INTO measure.radionuclide VALUES ('Sr-92', 9756, 2.15098641086374015e-18, 7.10482964903592972e-05, 4.64902983556481024e+20, 0, 38, 92);
INSERT INTO measure.radionuclide VALUES ('Sr-93', 445.379999999999995, 9.92639852324498013e-20, 0.00155630513395290998, 1.00741472111789993e+22, 0, 38, 93);
INSERT INTO measure.radionuclide VALUES ('Ta-179', 50769491.0399999991, 2.17787970737272007e-14, 1.36528290191807004e-08, 45916218265624400, 0, 73, 179);
INSERT INTO measure.radionuclide VALUES ('Ta-180', 29088, 1.25477083104452998e-17, 2.38293172634744997e-05, 7.96958277367313039e+19, 0, 73, 180);
INSERT INTO measure.radionuclide VALUES ('Ta-182', 9910080, 4.32241633768762032e-15, 6.99436513691054978e-08, 231352077605503008, 0, 73, 182);
INSERT INTO measure.radionuclide VALUES ('Ta-182m', 950.399999999999977, 4.14529901609100988e-19, 0.000729321528366946013, 2.41237120921373979e+21, 0, 73, 182);
INSERT INTO measure.radionuclide VALUES ('Ta-183', 439776, 1.92868215510403993e-16, 1.57613689823898002e-06, 5.18488750131074048e+18, 0, 73, 183);
INSERT INTO measure.radionuclide VALUES ('Ta-184', 31320, 1.38107614572063004e-17, 2.2131136033203899e-05, 7.24073037608082964e+19, 0, 73, 184);
INSERT INTO measure.radionuclide VALUES ('Ta-186', 630, 2.80822267261410016e-19, 0.00110023361993642006, 3.56097117850390023e+21, 0, 73, 186);
INSERT INTO measure.radionuclide VALUES ('Tb-157', 3122128333.44000006, 1.17470400830004994e-12, 2.22011111182040008e-10, 851278273449606, 0, 65, 157);
INSERT INTO measure.radionuclide VALUES ('Tb-158', 5676483468.96000004, 2.14938647667171018e-12, 1.22108552654155001e-10, 465249042391149, 0, 65, 158);
INSERT INTO measure.radionuclide VALUES ('Tb-160', 6246720, 2.39524570520183993e-15, 1.10961781632591996e-07, 417493703392627968, 0, 65, 160);
INSERT INTO measure.radionuclide VALUES ('Tb-161', 595296, 2.29687250027951997e-16, 1.16437399303867004e-06, 4.35374623484022989e+18, 0, 65, 161);
INSERT INTO measure.radionuclide VALUES ('Tc-101', 852, 2.06223909731855995e-19, 0.00081355302882622695, 4.84909825102365013e+21, 0, 43, 101);
INSERT INTO measure.radionuclide VALUES ('Tc-102', 5.28000000000000025, 1.29066086581588007e-21, 0.13127787510604999, 7.7479687072394403e+23, 0, 43, 102);
INSERT INTO measure.radionuclide VALUES ('Tc-104', 1098, 2.73661515131548987e-19, 0.000631281585209421967, 3.65414917592376987e+21, 0, 43, 104);
INSERT INTO measure.radionuclide VALUES ('Tc-105', 456, 1.14744582321866e-19, 0.00152005960649110997, 8.71500841054902e+21, 0, 43, 105);
INSERT INTO measure.radionuclide VALUES ('Tc-96', 369792, 8.50759470395340961e-17, 1.87442448879354991e-06, 1.17542035651429007e+19, 0, 43, 96);
INSERT INTO measure.radionuclide VALUES ('Tc-97', 81995492160000, 1.90607400692769993e-08, 8.45347911574686078e-15, 52463860079.1712036, 0, 43, 97);
INSERT INTO measure.radionuclide VALUES ('Tc-98', 132451200000000, 3.11071354836871021e-08, 5.23322688325922992e-15, 32146965140.0209999, 0, 43, 98);
INSERT INTO measure.radionuclide VALUES ('Tc-99', 6748704000000, 1.60115590951747997e-09, 1.02708191166769994e-13, 624548798812.07605, 0, 43, 99);
INSERT INTO measure.radionuclide VALUES ('Tc-99m', 21636, 5.13322398764565976e-18, 3.20367526603783004e-05, 1.9480934446007799e+20, 0, 43, 99);
INSERT INTO measure.radionuclide VALUES ('Te-121', 1655419.67999999993, 4.80033483910374038e-16, 4.18713869923271975e-07, 2.08318801399842995e+18, 0, 52, 121);
INSERT INTO measure.radionuclide VALUES ('Te-121m', 13305600, 3.85831677651547017e-15, 5.20943948833532995e-08, 259180377849409984, 0, 52, 121);
INSERT INTO measure.radionuclide VALUES ('Te-123', 2.90131515359999999e+24, 855.220426995066987, 2.3890792411843902e-25, 1.16928918958780992, 0, 52, 123);
INSERT INTO measure.radionuclide VALUES ('Te-123m', 10324800, 3.04344043896172014e-15, 6.71341992639030059e-08, 328575511844467968, 0, 52, 123);
INSERT INTO measure.radionuclide VALUES ('Te-125m', 4959360, 1.4856403816410101e-15, 1.39765449687044989e-07, 673110405692809984, 0, 52, 125);
INSERT INTO measure.radionuclide VALUES ('Te-127', 33660, 1.02446206224136004e-17, 2.05926078597725997e-05, 9.76122041856937001e+19, 0, 52, 127);
INSERT INTO measure.radionuclide VALUES ('Te-127m', 9417600, 2.86630241157581002e-15, 7.36012551562972958e-08, 348881540189692992, 0, 52, 127);
INSERT INTO measure.radionuclide VALUES ('Te-128', 6.93807768000000004e+31, 21282722152.2677002, 9.99047881170371991e-33, 4.69864706612940991e-08, 0, 52, 128);
INSERT INTO measure.radionuclide VALUES ('Te-129', 4176, 1.29100596230407005e-18, 0.000165983520249028996, 7.74589761162135994e+20, 0, 52, 129);
INSERT INTO measure.radionuclide VALUES ('Te-129m', 2903040, 8.97471731036206912e-16, 2.38765976548701989e-07, 1.11424122389393997e+18, 0, 52, 129);
INSERT INTO measure.radionuclide VALUES ('Te-131', 1500, 4.70912916170566968e-19, 0.000462098120373296976, 2.12353487377651991e+21, 0, 52, 131);
INSERT INTO measure.radionuclide VALUES ('Te-131m', 108000, 3.39057299642808009e-17, 6.41802944962911996e-06, 2.94935399135628001e+19, 0, 52, 131);
INSERT INTO measure.radionuclide VALUES ('Te-132', 276825.599999999977, 8.7570580533333505e-17, 2.50391286268301998e-06, 1.14193601767816991e+19, 0, 52, 132);
INSERT INTO measure.radionuclide VALUES ('Te-133', 747, 2.38095008317873023e-19, 0.000927907872235536027, 4.20000405327664015e+21, 0, 52, 133);
INSERT INTO measure.radionuclide VALUES ('Te-133m', 3324, 1.05947497677190003e-18, 0.00020852803265942999, 9.43863726774262039e+20, 0, 52, 133);
INSERT INTO measure.radionuclide VALUES ('Te-134', 2508, 8.05397687344910002e-19, 0.000276374473907473994, 1.24162263650970003e+21, 0, 52, 134);
INSERT INTO measure.radionuclide VALUES ('Th-226', 1834.20000000000005, 9.93420633129019026e-19, 0.000377901635895727987, 1.00662294163374998e+21, 0, 90, 226);
INSERT INTO measure.radionuclide VALUES ('Th-227', 1617240.38400000008, 8.79788908299552971e-16, 4.28598733631391987e-07, 1.13663628918985997e+18, 0, 90, 227);
INSERT INTO measure.radionuclide VALUES ('Th-228', 60318907.200000003, 3.29584181560733975e-14, 1.14913749723891997e-08, 30341261988501200, 0, 90, 228);
INSERT INTO measure.radionuclide VALUES ('Th-229', 231479285760, 1.27035664515437991e-10, 2.99442422368023989e-12, 7871805164434.53027, 0, 90, 229);
INSERT INTO measure.radionuclide VALUES ('Th-230', 2377861704000, 1.31066733605404007e-09, 2.91500207684047988e-13, 762970108807.813965, 0, 90, 230);
INSERT INTO measure.radionuclide VALUES ('Th-231', 91871.7119999999995, 5.08594708013081986e-17, 7.54472911705341009e-06, 1.96620213353513001e+19, 0, 90, 231);
INSERT INTO measure.radionuclide VALUES ('Th-232', 443090260800000000, 0.000246353216421905019, 1.56434758757384008e-18, 4059212.27465282008, 0, 90, 232);
INSERT INTO measure.radionuclide VALUES ('Th-234', 2081380.32000000007, 1.16720018839382997e-15, 3.33022837729121006e-07, 856751061166370048, 0, 90, 234);
INSERT INTO measure.radionuclide VALUES ('Ti-44', 1892164415.03999996, 1.9952145115862101e-13, 3.6632502706975001e-10, 5011992415817940, 0, 22, 44);
INSERT INTO measure.radionuclide VALUES ('Ti-45', 11088, 1.19575933156470998e-18, 6.25132738600238944e-05, 8.36288685860763992e+20, 0, 22, 45);
INSERT INTO measure.radionuclide VALUES ('Ti-51', 348, 4.25331421689324002e-20, 0.00199180224298834991, 2.35110774564506997e+22, 0, 22, 51);
INSERT INTO measure.radionuclide VALUES ('Ti-52', 102, 1.27110539815199995e-20, 0.00679556059372495025, 7.86716822581234966e+22, 0, 22, 52);
INSERT INTO measure.radionuclide VALUES ('Tl-201', 262733.760000000009, 1.26558111657555002e-16, 2.63821132297556997e-06, 7.90150853945916006e+18, 0, 81, 201);
INSERT INTO measure.radionuclide VALUES ('Tl-202', 1057540.32000000007, 5.1194859035088703e-16, 6.55433336631500985e-07, 1.95332113194140006e+18, 0, 81, 202);
INSERT INTO measure.radionuclide VALUES ('Tl-204', 119458683.359999999, 5.84017604903949978e-14, 5.80240097298813012e-09, 17122771498719900, 0, 81, 204);
INSERT INTO measure.radionuclide VALUES ('Tl-206', 252.120000000000005, 1.24466525554881008e-19, 0.00274927487133090013, 8.03428870165630026e+21, 0, 81, 206);
INSERT INTO measure.radionuclide VALUES ('Tl-207', 286.199999999999989, 1.41977008945848999e-19, 0.00242189790552042004, 7.04339390880819026e+21, 0, 81, 207);
INSERT INTO measure.radionuclide VALUES ('Tl-208', 183.180000000000007, 9.1310230130778104e-20, 0.00378396757593594006, 1.09516753880454005e+22, 0, 81, 208);
INSERT INTO measure.radionuclide VALUES ('Tm-170', 11106716.0255999994, 4.52493804355176978e-15, 6.24079321882635978e-08, 220997501043144992, 0, 69, 170);
INSERT INTO measure.radionuclide VALUES ('Tm-171', 60440005.4399999976, 2.47684399276576004e-14, 1.14683507308424001e-08, 40373959882848800, 0, 69, 171);
INSERT INTO measure.radionuclide VALUES ('U-230', 1797120, 9.9056495968927909e-16, 3.85698885194057999e-07, 1.00952490820358003e+18, 0, 92, 230);
INSERT INTO measure.radionuclide VALUES ('U-231', 362880, 2.00887567702871991e-16, 1.91012781238962014e-06, 4.97790884440931021e+18, 0, 92, 231);
INSERT INTO measure.radionuclide VALUES ('U-232', 2201259473.28000021, 1.22387558336899005e-12, 3.14886631482438007e-10, 817076517898396, 0, 92, 232);
INSERT INTO measure.radionuclide VALUES ('U-233', 5022202608000, 2.8043240592657498e-09, 1.38016570549306997e-13, 356592169402.072021, 0, 92, 233);
INSERT INTO measure.radionuclide VALUES ('U-234', 7748552880000, 4.34524737954451959e-09, 8.94550493872277042e-14, 230136494577.39801, 0, 92, 234);
INSERT INTO measure.radionuclide VALUES ('U-235', 22195478304000000, 1.25000116655227998e-05, 3.12292067359966986e-17, 79999925.3407234997, 0, 92, 235);
INSERT INTO measure.radionuclide VALUES ('U-235m', 1560, 8.78558142840355071e-19, 0.000444325115743555011, 1.13822859437284996e+21, 0, 92, 235);
INSERT INTO measure.radionuclide VALUES ('U-236', 747418968000000, 4.22721333404630002e-07, 9.27387730625463044e-16, 2365624634.90053988, 0, 92, 236);
INSERT INTO measure.radionuclide VALUES ('U-237', 583200, 3.31240864185394004e-16, 1.18852397215354003e-06, 3.01895118665161011e+18, 0, 92, 237);
INSERT INTO measure.radionuclide VALUES ('U-238', 140902532640000000, 8.03662685233301949e-05, 4.91933798188643977e-18, 12443031.3659480009, 0, 92, 238);
INSERT INTO measure.radionuclide VALUES ('U-239', 1408.20000000000005, 8.06566701698640021e-19, 0.000492222113733805961, 1.23982306471861997e+21, 0, 92, 239);
INSERT INTO measure.radionuclide VALUES ('U-240', 50760, 2.91951629005410007e-17, 1.36553818077215005e-05, 3.42522493677014999e+19, 0, 92, 240);
INSERT INTO measure.radionuclide VALUES ('V-47', 1956, 2.20315349666120008e-19, 0.000354369724212650998, 4.53894838246841988e+21, 0, 23, 47);
INSERT INTO measure.radionuclide VALUES ('V-48', 1380150.14400000009, 1.58761655954630004e-16, 5.02225923442677999e-07, 6.29875012317692006e+18, 0, 23, 48);
INSERT INTO measure.radionuclide VALUES ('V-49', 28512000, 3.34812612838119998e-15, 2.43107176122315009e-08, 298674530664558976, 0, 23, 49);
INSERT INTO measure.radionuclide VALUES ('V-52', 224.699999999999989, 2.80017042122308971e-20, 0.00308476715870024997, 3.57121121064913008e+22, 0, 23, 52);
INSERT INTO measure.radionuclide VALUES ('W-179', 2223, 9.53609439510653904e-19, 0.000311807098767407005, 1.04864733775406996e+21, 0, 74, 179);
INSERT INTO measure.radionuclide VALUES ('W-179m', 384, 1.64726057027481007e-19, 0.00180507078270818991, 6.07068497871693047e+21, 0, 74, 179);
INSERT INTO measure.radionuclide VALUES ('W-181', 10452699.648, 4.5340373558786099e-15, 6.63127425356156959e-08, 220553983460998016, 0, 74, 181);
INSERT INTO measure.radionuclide VALUES ('W-183m', 5.25, 2.30244063211639987e-21, 0.132028034392371013, 4.34321730624082007e+23, 0, 74, 183);
INSERT INTO measure.radionuclide VALUES ('W-185', 6488640, 2.87675883516784992e-15, 1.06824724527782004e-07, 347613427922835968, 0, 74, 185);
INSERT INTO measure.radionuclide VALUES ('W-185m', 100.000200000000007, 4.43354013889740019e-20, 0.00693145794268357034, 2.2555338818894598e+22, 0, 74, 185);
INSERT INTO measure.radionuclide VALUES ('W-187', 85860, 3.84778270621359028e-17, 8.07299301840140925e-06, 2.5988993567260201e+19, 0, 74, 187);
INSERT INTO measure.radionuclide VALUES ('W-188', 6028990.27199999988, 2.71631717772866006e-15, 1.14969032837733994e-07, 368145520044233024, 0, 74, 188);
INSERT INTO measure.radionuclide VALUES ('Xe-125', 60840, 1.82254082823264995e-17, 1.13929516857322007e-05, 5.48684553184860979e+19, 0, 36, 125);
INSERT INTO measure.radionuclide VALUES ('Xe-127', 3144960, 9.57187227351922905e-16, 2.2039936296803301e-07, 1.04472768902957005e+18, 0, 54, 127);
INSERT INTO measure.radionuclide VALUES ('Xe-129m', 767232, 2.37188957488140024e-16, 9.03438830184279998e-07, 4.21604787419331021e+18, 0, 54, 129);
INSERT INTO measure.radionuclide VALUES ('Xe-131m', 1030741.63199999998, 3.23593031829020004e-16, 6.72474225393416006e-07, 3.09030140218959002e+18, 0, 54, 131);
INSERT INTO measure.radionuclide VALUES ('Xe-133', 453081.599999999977, 1.44412941527007991e-16, 1.52985065065529993e-06, 6.92458715559767962e+18, 0, 54, 133);
INSERT INTO measure.radionuclide VALUES ('Xe-133m', 189043.200000000012, 6.02546750688584992e-17, 3.66660731811535979e-06, 1.6596222597785301e+19, 0, 54, 133);
INSERT INTO measure.radionuclide VALUES ('Xe-134', 3.46902307199999973e+23, 111.401242405698994, 1.99810484442908002e-24, 8.97656056974856043, 0, 54, 134);
INSERT INTO measure.radionuclide VALUES ('Xe-135', 32904, 1.06453639193196001e-17, 2.10657421760255985e-05, 9.39376058516103004e+19, 0, 54, 135);
INSERT INTO measure.radionuclide VALUES ('Xe-135m', 917.399999999999977, 2.96804548370527022e-19, 0.000755556115718275024, 3.36922060490667983e+21, 0, 54, 135);
INSERT INTO measure.radionuclide VALUES ('Xe-136', 6.62271767999999979e+27, 2158505.6906371098, 1.04662045711715005e-28, 0.000463283467047446009, 0, 54, 136);
INSERT INTO measure.radionuclide VALUES ('Xe-137', 229.080000000000013, 7.52117665373050006e-20, 0.00302578653989848999, 1.32957919490430007e+22, 0, 54, 137);
INSERT INTO measure.radionuclide VALUES ('Xe-138', 844.799999999999955, 2.79390116835438013e-19, 0.00082048671941281398, 3.57922467453996001e+21, 0, 54, 138);
INSERT INTO measure.radionuclide VALUES ('Xe-139', 39.6799999999999997, 1.32179623786111001e-20, 0.0174684269294341013, 7.56546259821534925e+22, 0, 54, 139);
INSERT INTO measure.radionuclide VALUES ('Xe-140', 13.5999999999999996, 4.56294245490462984e-21, 0.0509667044529372032, 2.19156829147629995e+23, 0, 54, 140);
INSERT INTO measure.radionuclide VALUES ('Xe-141', 1.72999999999999998, 5.84579071966851975e-22, 0.400663110150257018, 1.71063256957769007e+24, 0, 54, 141);
INSERT INTO measure.radionuclide VALUES ('Y-86', 53064, 1.09364528071045993e-17, 1.30624751349303993e-05, 9.14373259445125939e+19, 0, 39, 86);
INSERT INTO measure.radionuclide VALUES ('Y-86m', 2880, 5.93565959680030977e-19, 0.000240676104361092004, 1.68473273052763993e+21, 0, 39, 86);
INSERT INTO measure.radionuclide VALUES ('Y-87', 287280, 5.98966719720143037e-17, 2.41279302617635979e-06, 1.66954184110134006e+19, 0, 39, 87);
INSERT INTO measure.radionuclide VALUES ('Y-88', 9212749.91999999993, 1.94289800462293991e-15, 7.52378156987838039e-08, 514695057393953024, 0, 39, 88);
INSERT INTO measure.radionuclide VALUES ('Y-89m', 15.6630000000000003, 3.34074250143604987e-21, 0.0442537943280306989, 2.99334653769375986e+23, 0, 39, 89);
INSERT INTO measure.radionuclide VALUES ('Y-90', 230759.712, 4.97714788912672986e-17, 3.00376168158827005e-06, 2.00918281368460001e+19, 0, 39, 90);
INSERT INTO measure.radionuclide VALUES ('Y-91', 5055259.6799999997, 1.10246017348425006e-15, 1.37114060292930991e-07, 907062245014776960, 0, 39, 91);
INSERT INTO measure.radionuclide VALUES ('Y-91m', 2982.59999999999991, 6.50450802051401014e-19, 0.000232396962569552008, 1.53739529084472997e+21, 0, 39, 91);
INSERT INTO measure.radionuclide VALUES ('Y-92', 12744, 2.80977560681093985e-18, 5.43900800816026983e-05, 3.55900306620922003e+20, 0, 39, 92);
INSERT INTO measure.radionuclide VALUES ('Y-93', 36648, 8.16791623063186976e-18, 1.89136427788678009e-05, 1.22430246805143994e+20, 0, 39, 93);
INSERT INTO measure.radionuclide VALUES ('Y-94', 1122, 2.5275441955560998e-19, 0.000617778235793177985, 3.95640955263290022e+21, 0, 39, 94);
INSERT INTO measure.radionuclide VALUES ('Y-95', 618, 1.40698714037527001e-19, 0.00112159737954683992, 7.10738549986521986e+21, 0, 39, 95);
INSERT INTO measure.radionuclide VALUES ('Yb-169', 2766360.38400000008, 1.1204010545434099e-15, 2.50562863959790024e-07, 892537539075703040, 0, 70, 169);
INSERT INTO measure.radionuclide VALUES ('Zn-60', 142.800000000000011, 2.05332410470708008e-20, 0.00485397185266068024, 4.87015175883621977e+22, 0, 30, 60);
INSERT INTO measure.radionuclide VALUES ('Zn-61', 89.0999999999999943, 1.30252355759728005e-20, 0.00777942963591408965, 7.67740432921358038e+22, 0, 30, 61);
INSERT INTO measure.radionuclide VALUES ('Zn-62', 33336, 4.95316989493457962e-18, 2.07927519966386012e-05, 2.0189091454800701e+20, 0, 30, 62);
INSERT INTO measure.radionuclide VALUES ('Zn-63', 2304, 3.47857260091552979e-19, 0.000300845130451364985, 2.87474235764638011e+21, 0, 30, 63);
INSERT INTO measure.radionuclide VALUES ('Zn-65', 21094599.743999999, 3.2859631870654801e-15, 3.28589870854079028e-08, 304324772698700992, 0, 30, 65);
INSERT INTO measure.radionuclide VALUES ('Zn-69', 3384, 5.59573955593702957e-19, 0.000204830727115823012, 1.78707388005399003e+21, 0, 30, 69);
INSERT INTO measure.radionuclide VALUES ('Zn-69m', 49608, 8.20311607242683944e-18, 1.39724879164640007e-05, 1.21904894575526003e+20, 0, 30, 69);
INSERT INTO measure.radionuclide VALUES ('Zn-71m', 14256, 2.42568321545984989e-18, 4.86214352244630982e-05, 4.12254985987701015e+20, 0, 30, 71);
INSERT INTO measure.radionuclide VALUES ('Zr-86', 59400, 1.22422979184006002e-17, 1.16691444538711005e-05, 8.16840111770979041e+19, 0, 40, 86);
INSERT INTO measure.radionuclide VALUES ('Zr-88', 7171200, 1.51235084982661001e-15, 9.66570700245350032e-08, 661222229031478016, 0, 40, 88);
INSERT INTO measure.radionuclide VALUES ('Zr-89', 282240.288, 6.01986928263520013e-17, 2.45587610993347998e-06, 1.66116563840444006e+19, 0, 40, 89);
INSERT INTO measure.radionuclide VALUES ('Zr-89m', 250.800000000000011, 5.3492831472908203e-20, 0.00276374473907474005, 1.86940936283482992e+22, 0, 40, 89);
INSERT INTO measure.radionuclide VALUES ('Zr-93', 48250080000000, 1.07537276675748996e-08, 1.43657208560057007e-14, 92991010272.209198, 0, 40, 93);
INSERT INTO measure.radionuclide VALUES ('Zr-95', 5532359.61600000039, 1.25954026466721992e-15, 1.25289610341907993e-07, 793940478166614016, 0, 40, 95);
INSERT INTO measure.radionuclide VALUES ('Zr-95+', 5533004.16000000015, 1.25968700659593001e-15, 1.25275015256801004e-07, 793847991416782976, 0, 40, 95);
INSERT INTO measure.radionuclide VALUES ('Zr-97', 60278.4000000000015, 1.40123668256046001e-17, 1.14990971983322003e-05, 7.13655310659376988e+19, 0, 40, 97);

--
-- Data for Name: continuous_rain; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.continuous_rain VALUES (1, 3, '2007-01-01 00:00:00', '2007-01-01 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (2, 3, '2007-01-01 01:00:00', '2007-01-01 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (3, 3, '2007-01-01 02:00:00', '2007-01-01 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (4, 3, '2007-01-01 03:00:00', '2007-01-01 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (5, 3, '2007-01-01 04:00:00', '2007-01-01 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (6, 3, '2007-01-01 05:00:00', '2007-01-01 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (7, 3, '2007-01-01 06:00:00', '2007-01-01 07:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (8, 3, '2007-01-01 07:00:00', '2007-01-01 08:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (9, 3, '2007-01-01 08:00:00', '2007-01-01 09:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (10, 3, '2007-01-01 09:00:00', '2007-01-01 10:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (11, 3, '2007-01-01 10:00:00', '2007-01-01 11:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (12, 3, '2007-01-01 11:00:00', '2007-01-01 12:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (13, 3, '2007-01-01 12:00:00', '2007-01-01 13:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (14, 3, '2007-01-01 13:00:00', '2007-01-01 14:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (15, 3, '2007-01-01 14:00:00', '2007-01-01 15:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (16, 3, '2007-01-01 15:00:00', '2007-01-01 16:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (17, 3, '2007-01-01 16:00:00', '2007-01-01 17:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (18, 3, '2007-01-01 17:00:00', '2007-01-01 18:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (19, 3, '2007-01-01 18:00:00', '2007-01-01 19:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (20, 3, '2007-01-01 19:00:00', '2007-01-01 20:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (21, 3, '2007-01-01 20:00:00', '2007-01-01 21:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (22, 3, '2007-01-01 21:00:00', '2007-01-01 22:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (23, 3, '2007-01-01 22:00:00', '2007-01-01 23:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (24, 3, '2007-01-01 23:00:00', '2007-01-02 00:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (25, 3, '2007-01-02 00:00:00', '2007-01-02 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (26, 3, '2007-01-02 01:00:00', '2007-01-02 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (27, 3, '2007-01-02 02:00:00', '2007-01-02 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (28, 3, '2007-01-02 03:00:00', '2007-01-02 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (29, 3, '2007-01-02 04:00:00', '2007-01-02 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (30, 3, '2007-01-02 05:00:00', '2007-01-02 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (31, 3, '2007-01-02 06:00:00', '2007-01-02 07:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (32, 3, '2007-01-02 07:00:00', '2007-01-02 08:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (33, 3, '2007-01-02 08:00:00', '2007-01-02 09:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (34, 3, '2007-01-02 09:00:00', '2007-01-02 10:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (35, 3, '2007-01-02 10:00:00', '2007-01-02 11:00:00', 0.00277500000000000012, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (36, 3, '2007-01-02 11:00:00', '2007-01-02 12:00:00', 0.00597499999999999767, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (37, 3, '2007-01-02 12:00:00', '2007-01-02 13:00:00', 0.00897500000000000034, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (38, 3, '2007-01-02 13:00:00', '2007-01-02 14:00:00', 0.0117749999999999955, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (39, 3, '2007-01-02 14:00:00', '2007-01-02 15:00:00', 0.0143750000000000006, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (40, 3, '2007-01-02 15:00:00', '2007-01-02 16:00:00', 0.0167749999999999982, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (41, 3, '2007-01-02 16:00:00', '2007-01-02 17:00:00', 0.0189749999999999988, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (42, 3, '2007-01-02 17:00:00', '2007-01-02 18:00:00', 0.0209750000000000006, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (43, 3, '2007-01-02 18:00:00', '2007-01-02 19:00:00', 0.0227750000000000001, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (44, 3, '2007-01-02 19:00:00', '2007-01-02 20:00:00', 0.0243750000000000008, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (45, 3, '2007-01-02 20:00:00', '2007-01-02 21:00:00', 0.0257749999999999993, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (46, 3, '2007-01-02 21:00:00', '2007-01-02 22:00:00', 0.026974999999999999, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (47, 3, '2007-01-02 22:00:00', '2007-01-02 23:00:00', 0.0279749999999999999, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (48, 3, '2007-01-02 23:00:00', '2007-01-03 00:00:00', 0.0287749999999999985, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (49, 3, '2007-01-03 00:00:00', '2007-01-03 01:00:00', 0.0293749999999999983, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (50, 3, '2007-01-03 01:00:00', '2007-01-03 02:00:00', 0.0297749999999999994, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (51, 3, '2007-01-03 02:00:00', '2007-01-03 03:00:00', 0.0299750000000000016, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (52, 3, '2007-01-03 03:00:00', '2007-01-03 04:00:00', 0.0299750000000000016, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (53, 3, '2007-01-03 04:00:00', '2007-01-03 05:00:00', 0.0297749999999999994, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (54, 3, '2007-01-03 05:00:00', '2007-01-03 06:00:00', 0.0293749999999999983, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (55, 3, '2007-01-03 06:00:00', '2007-01-03 07:00:00', 0.0287749999999999985, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (56, 3, '2007-01-03 07:00:00', '2007-01-03 08:00:00', 0.0279749999999999999, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (57, 3, '2007-01-03 08:00:00', '2007-01-03 09:00:00', 0.026974999999999999, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (58, 3, '2007-01-03 09:00:00', '2007-01-03 10:00:00', 0.0257749999999999993, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (59, 3, '2007-01-03 10:00:00', '2007-01-03 11:00:00', 0.0243750000000000008, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (60, 3, '2007-01-03 11:00:00', '2007-01-03 12:00:00', 0.0227750000000000001, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (61, 3, '2007-01-03 12:00:00', '2007-01-03 13:00:00', 0.0209750000000000006, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (62, 3, '2007-01-03 13:00:00', '2007-01-03 14:00:00', 0.0189749999999999988, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (63, 3, '2007-01-03 14:00:00', '2007-01-03 15:00:00', 0.0167749999999999982, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (64, 3, '2007-01-03 15:00:00', '2007-01-03 16:00:00', 0.0143750000000000006, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (65, 3, '2007-01-03 16:00:00', '2007-01-03 17:00:00', 0.0117749999999999955, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (66, 3, '2007-01-03 17:00:00', '2007-01-03 18:00:00', 0.00897500000000000034, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (67, 3, '2007-01-03 18:00:00', '2007-01-03 19:00:00', 0.00597499999999999767, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (68, 3, '2007-01-03 19:00:00', '2007-01-03 20:00:00', 0.00277500000000000012, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (69, 3, '2007-01-03 20:00:00', '2007-01-03 21:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (70, 3, '2007-01-03 21:00:00', '2007-01-03 22:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (71, 3, '2007-01-03 22:00:00', '2007-01-03 23:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (72, 3, '2007-01-03 23:00:00', '2007-01-04 00:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (73, 3, '2007-01-04 00:00:00', '2007-01-04 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (74, 3, '2007-01-04 01:00:00', '2007-01-04 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (75, 3, '2007-01-04 02:00:00', '2007-01-04 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (76, 3, '2007-01-04 03:00:00', '2007-01-04 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (77, 3, '2007-01-04 04:00:00', '2007-01-04 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (78, 3, '2007-01-04 05:00:00', '2007-01-04 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (79, 3, '2007-01-04 06:00:00', '2007-01-04 07:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (80, 3, '2007-01-04 07:00:00', '2007-01-04 08:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (81, 3, '2007-01-04 08:00:00', '2007-01-04 09:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (82, 3, '2007-01-04 09:00:00', '2007-01-04 10:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (83, 3, '2007-01-04 10:00:00', '2007-01-04 11:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (84, 3, '2007-01-04 11:00:00', '2007-01-04 12:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (85, 3, '2007-01-04 12:00:00', '2007-01-04 13:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (86, 3, '2007-01-04 13:00:00', '2007-01-04 14:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (87, 3, '2007-01-04 14:00:00', '2007-01-04 15:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (88, 3, '2007-01-04 15:00:00', '2007-01-04 16:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (89, 3, '2007-01-04 16:00:00', '2007-01-04 17:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (90, 3, '2007-01-04 17:00:00', '2007-01-04 18:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (91, 3, '2007-01-04 18:00:00', '2007-01-04 19:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (92, 3, '2007-01-04 19:00:00', '2007-01-04 20:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (93, 3, '2007-01-04 20:00:00', '2007-01-04 21:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (94, 3, '2007-01-04 21:00:00', '2007-01-04 22:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (95, 3, '2007-01-04 22:00:00', '2007-01-04 23:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (96, 3, '2007-01-04 23:00:00', '2007-01-05 00:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (97, 3, '2007-01-05 00:00:00', '2007-01-05 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (98, 3, '2007-01-05 01:00:00', '2007-01-05 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (99, 3, '2007-01-05 02:00:00', '2007-01-05 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (100, 3, '2007-01-05 03:00:00', '2007-01-05 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (101, 3, '2007-01-05 04:00:00', '2007-01-05 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (102, 3, '2007-01-05 05:00:00', '2007-01-05 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (103, 3, '2007-01-05 06:00:00', '2007-01-05 07:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (104, 3, '2007-01-05 07:00:00', '2007-01-05 08:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (105, 3, '2007-01-05 08:00:00', '2007-01-05 09:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (106, 3, '2007-01-05 09:00:00', '2007-01-05 10:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (107, 3, '2007-01-05 10:00:00', '2007-01-05 11:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (108, 3, '2007-01-05 11:00:00', '2007-01-05 12:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (109, 3, '2007-01-05 12:00:00', '2007-01-05 13:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (110, 3, '2007-01-05 13:00:00', '2007-01-05 14:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (111, 3, '2007-01-05 14:00:00', '2007-01-05 15:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (112, 3, '2007-01-05 15:00:00', '2007-01-05 16:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (113, 3, '2007-01-05 16:00:00', '2007-01-05 17:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (114, 3, '2007-01-05 17:00:00', '2007-01-05 18:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (115, 3, '2007-01-05 18:00:00', '2007-01-05 19:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (116, 3, '2007-01-05 19:00:00', '2007-01-05 20:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (117, 3, '2007-01-05 20:00:00', '2007-01-05 21:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (118, 3, '2007-01-05 21:00:00', '2007-01-05 22:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (119, 3, '2007-01-05 22:00:00', '2007-01-05 23:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (120, 3, '2007-01-05 23:00:00', '2007-01-06 00:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (121, 3, '2007-01-06 00:00:00', '2007-01-06 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (122, 3, '2007-01-06 01:00:00', '2007-01-06 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (123, 3, '2007-01-06 02:00:00', '2007-01-06 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (124, 3, '2007-01-06 03:00:00', '2007-01-06 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (125, 3, '2007-01-06 04:00:00', '2007-01-06 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (126, 3, '2007-01-06 05:00:00', '2007-01-06 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (127, 3, '2007-01-06 06:00:00', '2007-01-06 07:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (128, 3, '2007-01-06 07:00:00', '2007-01-06 08:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (129, 3, '2007-01-06 08:00:00', '2007-01-06 09:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (130, 3, '2007-01-06 09:00:00', '2007-01-06 10:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (131, 3, '2007-01-06 10:00:00', '2007-01-06 11:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (132, 3, '2007-01-06 11:00:00', '2007-01-06 12:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (133, 3, '2007-01-06 12:00:00', '2007-01-06 13:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (134, 3, '2007-01-06 13:00:00', '2007-01-06 14:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (135, 3, '2007-01-06 14:00:00', '2007-01-06 15:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (136, 3, '2007-01-06 15:00:00', '2007-01-06 16:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (137, 3, '2007-01-06 16:00:00', '2007-01-06 17:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (138, 3, '2007-01-06 17:00:00', '2007-01-06 18:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (139, 3, '2007-01-06 18:00:00', '2007-01-06 19:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (140, 3, '2007-01-06 19:00:00', '2007-01-06 20:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (141, 3, '2007-01-06 20:00:00', '2007-01-06 21:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (142, 3, '2007-01-06 21:00:00', '2007-01-06 22:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (143, 3, '2007-01-06 22:00:00', '2007-01-06 23:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (144, 3, '2007-01-06 23:00:00', '2007-01-07 00:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (145, 3, '2007-01-07 00:00:00', '2007-01-07 01:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (146, 3, '2007-01-07 01:00:00', '2007-01-07 02:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (147, 3, '2007-01-07 02:00:00', '2007-01-07 03:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (148, 3, '2007-01-07 03:00:00', '2007-01-07 04:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (149, 3, '2007-01-07 04:00:00', '2007-01-07 05:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);
INSERT INTO measure.continuous_rain VALUES (150, 3, '2007-01-07 05:00:00', '2007-01-07 06:00:00', 0, 0, NULL, '0 days 01:00:00.000000000', 'meteo.xlsx', 1, 17);

--
-- Data for Name: continuous_released_activity; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.continuous_released_activity VALUES (1, 3, 'HT', 'HT', '2001-01-01 00:00:00', '2001-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (2, 3, 'HTO', 'HTO', '2001-01-01 00:00:00', '2001-02-01 00:00:00', 210000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (3, 3, 'HT', 'HT', '2001-02-01 00:00:00', '2001-03-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (4, 3, 'HTO', 'HTO', '2001-02-01 00:00:00', '2001-03-01 00:00:00', 180000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (5, 3, 'HT', 'HT', '2001-03-01 00:00:00', '2001-04-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (6, 3, 'HTO', 'HTO', '2001-03-01 00:00:00', '2001-04-01 00:00:00', 190000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (7, 3, 'HT', 'HT', '2001-04-01 00:00:00', '2001-05-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (8, 3, 'HTO', 'HTO', '2001-04-01 00:00:00', '2001-05-01 00:00:00', 200000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (9, 3, 'HT', 'HT', '2001-05-01 00:00:00', '2001-06-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (10, 3, 'HTO', 'HTO', '2001-05-01 00:00:00', '2001-06-01 00:00:00', 210000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (11, 3, 'HT', 'HT', '2001-06-01 00:00:00', '2001-07-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (12, 3, 'HTO', 'HTO', '2001-06-01 00:00:00', '2001-07-01 00:00:00', 198000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (13, 3, 'HT', 'HT', '2001-07-01 00:00:00', '2001-08-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (14, 3, 'HTO', 'HTO', '2001-07-01 00:00:00', '2001-08-01 00:00:00', 204000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (15, 3, 'HT', 'HT', '2001-08-01 00:00:00', '2001-09-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (16, 3, 'HTO', 'HTO', '2001-08-01 00:00:00', '2001-09-01 00:00:00', 204000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (17, 3, 'HT', 'HT', '2001-09-01 00:00:00', '2001-10-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (18, 3, 'HTO', 'HTO', '2001-09-01 00:00:00', '2001-10-01 00:00:00', 202000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (19, 3, 'HT', 'HT', '2001-10-01 00:00:00', '2001-11-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (20, 3, 'HTO', 'HTO', '2001-10-01 00:00:00', '2001-11-01 00:00:00', 203000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (21, 3, 'HT', 'HT', '2001-11-01 00:00:00', '2001-12-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (22, 3, 'HTO', 'HTO', '2001-11-01 00:00:00', '2001-12-01 00:00:00', 203000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (23, 3, 'HT', 'HT', '2001-12-01 00:00:00', '2002-01-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (24, 3, 'HTO', 'HTO', '2001-12-01 00:00:00', '2002-01-01 00:00:00', 205000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (25, 3, 'HT', 'HT', '2002-01-01 00:00:00', '2002-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (26, 3, 'HTO', 'HTO', '2002-01-01 00:00:00', '2002-02-01 00:00:00', 204000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (27, 3, 'HT', 'HT', '2002-02-01 00:00:00', '2002-03-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (28, 3, 'HTO', 'HTO', '2002-02-01 00:00:00', '2002-03-01 00:00:00', 204000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (29, 3, 'HT', 'HT', '2002-03-01 00:00:00', '2002-04-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (30, 3, 'HTO', 'HTO', '2002-03-01 00:00:00', '2002-04-01 00:00:00', 187000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (31, 3, 'HT', 'HT', '2002-04-01 00:00:00', '2002-05-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (32, 3, 'HTO', 'HTO', '2002-04-01 00:00:00', '2002-05-01 00:00:00', 139100000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (33, 3, 'HT', 'HT', '2002-05-01 00:00:00', '2002-06-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (34, 3, 'HTO', 'HTO', '2002-05-01 00:00:00', '2002-06-01 00:00:00', 158400000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (35, 3, 'HT', 'HT', '2002-06-01 00:00:00', '2002-07-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (36, 3, 'HTO', 'HTO', '2002-06-01 00:00:00', '2002-07-01 00:00:00', 135000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (37, 3, 'HT', 'HT', '2002-07-01 00:00:00', '2002-08-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (38, 3, 'HTO', 'HTO', '2002-07-01 00:00:00', '2002-08-01 00:00:00', 149000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (39, 3, 'HT', 'HT', '2002-08-01 00:00:00', '2002-09-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (40, 3, 'HTO', 'HTO', '2002-08-01 00:00:00', '2002-09-01 00:00:00', 154000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (41, 3, 'HT', 'HT', '2002-09-01 00:00:00', '2002-10-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (42, 3, 'HTO', 'HTO', '2002-09-01 00:00:00', '2002-10-01 00:00:00', 148000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (43, 3, 'HT', 'HT', '2002-10-01 00:00:00', '2002-11-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (44, 3, 'HTO', 'HTO', '2002-10-01 00:00:00', '2002-11-01 00:00:00', 140000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (45, 3, 'HT', 'HT', '2002-11-01 00:00:00', '2002-12-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (46, 3, 'HTO', 'HTO', '2002-11-01 00:00:00', '2002-12-01 00:00:00', 155000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (47, 3, 'HT', 'HT', '2002-12-01 00:00:00', '2003-01-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (48, 3, 'HTO', 'HTO', '2002-12-01 00:00:00', '2003-01-01 00:00:00', 140000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (49, 3, 'HT', 'HT', '2003-01-01 00:00:00', '2003-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (50, 3, 'HTO', 'HTO', '2003-01-01 00:00:00', '2003-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (51, 3, 'HT', 'HT', '2003-02-01 00:00:00', '2003-03-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (52, 3, 'HTO', 'HTO', '2003-02-01 00:00:00', '2003-03-01 00:00:00', 136000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (53, 3, 'HT', 'HT', '2003-03-01 00:00:00', '2003-04-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (54, 3, 'HTO', 'HTO', '2003-03-01 00:00:00', '2003-04-01 00:00:00', 105400000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (55, 3, 'HT', 'HT', '2003-04-01 00:00:00', '2003-05-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (56, 3, 'HTO', 'HTO', '2003-04-01 00:00:00', '2003-05-01 00:00:00', 134000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (57, 3, 'HT', 'HT', '2003-05-01 00:00:00', '2003-06-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (58, 3, 'HTO', 'HTO', '2003-05-01 00:00:00', '2003-06-01 00:00:00', 158000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (59, 3, 'HT', 'HT', '2003-06-01 00:00:00', '2003-07-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (60, 3, 'HTO', 'HTO', '2003-06-01 00:00:00', '2003-07-01 00:00:00', 131000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (61, 3, 'HT', 'HT', '2003-07-01 00:00:00', '2003-08-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (62, 3, 'HTO', 'HTO', '2003-07-01 00:00:00', '2003-08-01 00:00:00', 150000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (63, 3, 'HT', 'HT', '2003-08-01 00:00:00', '2003-09-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (64, 3, 'HTO', 'HTO', '2003-08-01 00:00:00', '2003-09-01 00:00:00', 159000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (65, 3, 'HT', 'HT', '2003-09-01 00:00:00', '2003-10-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (66, 3, 'HTO', 'HTO', '2003-09-01 00:00:00', '2003-10-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (67, 3, 'HT', 'HT', '2003-10-01 00:00:00', '2003-11-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (68, 3, 'HTO', 'HTO', '2003-10-01 00:00:00', '2003-11-01 00:00:00', 135000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (69, 3, 'HT', 'HT', '2003-11-01 00:00:00', '2003-12-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (70, 3, 'HTO', 'HTO', '2003-11-01 00:00:00', '2003-12-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (71, 3, 'HT', 'HT', '2003-12-01 00:00:00', '2004-01-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (72, 3, 'HTO', 'HTO', '2003-12-01 00:00:00', '2004-01-01 00:00:00', 140000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (73, 3, 'HT', 'HT', '2004-01-01 00:00:00', '2004-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (74, 3, 'HTO', 'HTO', '2004-01-01 00:00:00', '2004-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (75, 3, 'HT', 'HT', '2004-02-01 00:00:00', '2004-03-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (76, 3, 'HTO', 'HTO', '2004-02-01 00:00:00', '2004-03-01 00:00:00', 52000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (77, 3, 'HT', 'HT', '2004-03-01 00:00:00', '2004-04-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (78, 3, 'HTO', 'HTO', '2004-03-01 00:00:00', '2004-04-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (79, 3, 'HT', 'HT', '2004-04-01 00:00:00', '2004-05-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (80, 3, 'HTO', 'HTO', '2004-04-01 00:00:00', '2004-05-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (81, 3, 'HT', 'HT', '2004-05-01 00:00:00', '2004-06-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (82, 3, 'HTO', 'HTO', '2004-05-01 00:00:00', '2004-06-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (83, 3, 'HT', 'HT', '2004-06-01 00:00:00', '2004-07-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (84, 3, 'HTO', 'HTO', '2004-06-01 00:00:00', '2004-07-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (85, 3, 'HT', 'HT', '2004-07-01 00:00:00', '2004-08-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (86, 3, 'HTO', 'HTO', '2004-07-01 00:00:00', '2004-08-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (87, 3, 'HT', 'HT', '2004-08-01 00:00:00', '2004-09-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (88, 3, 'HTO', 'HTO', '2004-08-01 00:00:00', '2004-09-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (89, 3, 'HT', 'HT', '2004-09-01 00:00:00', '2004-10-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (90, 3, 'HTO', 'HTO', '2004-09-01 00:00:00', '2004-10-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (91, 3, 'HT', 'HT', '2004-10-01 00:00:00', '2004-11-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (92, 3, 'HTO', 'HTO', '2004-10-01 00:00:00', '2004-11-01 00:00:00', 218500000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (93, 3, 'HT', 'HT', '2004-11-01 00:00:00', '2004-12-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (94, 3, 'HTO', 'HTO', '2004-11-01 00:00:00', '2004-12-01 00:00:00', 197000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (95, 3, 'HT', 'HT', '2004-12-01 00:00:00', '2005-01-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (96, 3, 'HTO', 'HTO', '2004-12-01 00:00:00', '2005-01-01 00:00:00', 177000000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (97, 3, 'HT', 'HT', '2005-01-01 00:00:00', '2005-02-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (98, 3, 'HTO', 'HTO', '2005-01-01 00:00:00', '2005-02-01 00:00:00', 202500000, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (99, 3, 'HT', 'HT', '2005-02-01 00:00:00', '2005-03-01 00:00:00', 0, NULL, NULL, 'classeur.XLS', 0, 207);
INSERT INTO measure.continuous_released_activity VALUES (100, 3, 'HTO', 'HTO', '2005-02-01 00:00:00', '2005-03-01 00:00:00', 182000000, NULL, NULL, 'classeur.XLS', 0, 207);

--
-- Data for Name: continuous_released_flow; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.continuous_released_flow VALUES (1, 3, '2001-01-01 00:00:00', '2001-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (2, 3, '2001-02-01 00:00:00', '2001-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (3, 3, '2001-03-01 00:00:00', '2001-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (4, 3, '2001-04-01 00:00:00', '2001-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (5, 3, '2001-05-01 00:00:00', '2001-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (6, 3, '2001-06-01 00:00:00', '2001-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (7, 3, '2001-07-01 00:00:00', '2001-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (8, 3, '2001-08-01 00:00:00', '2001-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (9, 3, '2001-09-01 00:00:00', '2001-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (10, 3, '2001-10-01 00:00:00', '2001-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (11, 3, '2001-11-01 00:00:00', '2001-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (12, 3, '2001-12-01 00:00:00', '2002-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (13, 3, '2002-01-01 00:00:00', '2002-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (14, 3, '2002-02-01 00:00:00', '2002-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (15, 3, '2002-03-01 00:00:00', '2002-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (16, 3, '2002-04-01 00:00:00', '2002-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (17, 3, '2002-05-01 00:00:00', '2002-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (18, 3, '2002-06-01 00:00:00', '2002-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (19, 3, '2002-07-01 00:00:00', '2002-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (20, 3, '2002-08-01 00:00:00', '2002-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (21, 3, '2002-09-01 00:00:00', '2002-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (22, 3, '2002-10-01 00:00:00', '2002-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (23, 3, '2002-11-01 00:00:00', '2002-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (24, 3, '2002-12-01 00:00:00', '2003-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (25, 3, '2003-01-01 00:00:00', '2003-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (26, 3, '2003-02-01 00:00:00', '2003-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (27, 3, '2003-03-01 00:00:00', '2003-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (28, 3, '2003-04-01 00:00:00', '2003-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (29, 3, '2003-05-01 00:00:00', '2003-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (30, 3, '2003-06-01 00:00:00', '2003-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (31, 3, '2003-07-01 00:00:00', '2003-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (32, 3, '2003-08-01 00:00:00', '2003-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (33, 3, '2003-09-01 00:00:00', '2003-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (34, 3, '2003-10-01 00:00:00', '2003-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (35, 3, '2003-11-01 00:00:00', '2003-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (36, 3, '2003-12-01 00:00:00', '2004-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (37, 3, '2004-01-01 00:00:00', '2004-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (38, 3, '2004-02-01 00:00:00', '2004-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (39, 3, '2004-03-01 00:00:00', '2004-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (40, 3, '2004-04-01 00:00:00', '2004-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (41, 3, '2004-05-01 00:00:00', '2004-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (42, 3, '2004-06-01 00:00:00', '2004-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (43, 3, '2004-07-01 00:00:00', '2004-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (44, 3, '2004-08-01 00:00:00', '2004-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (45, 3, '2004-09-01 00:00:00', '2004-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (46, 3, '2004-10-01 00:00:00', '2004-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (47, 3, '2004-11-01 00:00:00', '2004-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (48, 3, '2004-12-01 00:00:00', '2005-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (49, 3, '2005-01-01 00:00:00', '2005-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (50, 3, '2005-02-01 00:00:00', '2005-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (51, 3, '2005-03-01 00:00:00', '2005-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (52, 3, '2005-04-01 00:00:00', '2005-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (53, 3, '2005-05-01 00:00:00', '2005-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (54, 3, '2005-06-01 00:00:00', '2005-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (55, 3, '2005-07-01 00:00:00', '2005-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (56, 3, '2005-08-01 00:00:00', '2005-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (57, 3, '2005-09-01 00:00:00', '2005-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (58, 3, '2005-10-01 00:00:00', '2005-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (59, 3, '2005-11-01 00:00:00', '2005-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (60, 3, '2005-12-01 00:00:00', '2006-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (61, 3, '2006-01-01 00:00:00', '2006-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (62, 3, '2006-02-01 00:00:00', '2006-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (63, 3, '2006-03-01 00:00:00', '2006-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (64, 3, '2006-04-01 00:00:00', '2006-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (65, 3, '2006-05-01 00:00:00', '2006-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (66, 3, '2006-06-01 00:00:00', '2006-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (67, 3, '2006-07-01 00:00:00', '2006-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (68, 3, '2006-08-01 00:00:00', '2006-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (69, 3, '2006-09-01 00:00:00', '2006-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (70, 3, '2006-10-01 00:00:00', '2006-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (71, 3, '2006-11-01 00:00:00', '2006-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (72, 3, '2006-12-01 00:00:00', '2007-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (73, 3, '2007-01-01 00:00:00', '2007-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (74, 3, '2007-02-01 00:00:00', '2007-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (75, 3, '2007-03-01 00:00:00', '2007-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (76, 3, '2007-04-01 00:00:00', '2007-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (77, 3, '2007-05-01 00:00:00', '2007-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (78, 3, '2007-06-01 00:00:00', '2007-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (79, 3, '2007-07-01 00:00:00', '2007-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (80, 3, '2007-08-01 00:00:00', '2007-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (81, 3, '2007-09-01 00:00:00', '2007-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (82, 3, '2007-10-01 00:00:00', '2007-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (83, 3, '2007-11-01 00:00:00', '2007-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (84, 3, '2007-12-01 00:00:00', '2008-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (85, 3, '2008-01-01 00:00:00', '2008-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (86, 3, '2008-02-01 00:00:00', '2008-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (87, 3, '2008-03-01 00:00:00', '2008-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (88, 3, '2008-04-01 00:00:00', '2008-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (89, 3, '2008-05-01 00:00:00', '2008-06-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (90, 3, '2008-06-01 00:00:00', '2008-07-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (91, 3, '2008-07-01 00:00:00', '2008-08-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (92, 3, '2008-08-01 00:00:00', '2008-09-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (93, 3, '2008-09-01 00:00:00', '2008-10-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (94, 3, '2008-10-01 00:00:00', '2008-11-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (95, 3, '2008-11-01 00:00:00', '2008-12-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (96, 3, '2008-12-01 00:00:00', '2009-01-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (97, 3, '2009-01-01 00:00:00', '2009-02-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (98, 3, '2009-02-01 00:00:00', '2009-03-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (99, 3, '2009-03-01 00:00:00', '2009-04-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);
INSERT INTO measure.continuous_released_flow VALUES (100, 3, '2009-04-01 00:00:00', '2009-05-01 00:00:00', 25, NULL, NULL, NULL, 'cernes d''arbres', 0, 214);

--
-- Data for Name: continuous_temperature; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_wind_direction; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: continuous_wind_force; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: fracturing_rate; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.fracturing_rate VALUES (2, '[0.0,1.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[1.0,2.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[2.0,3.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[3.0,4.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[4.0,5.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[5.0,6.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[6.0,7.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[7.0,8.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[8.0,9.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[9.0,10.0)', 0, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[10.0,11.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[11.0,12.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[12.0,13.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[13.0,14.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[14.0,15.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[15.0,16.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[16.0,17.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[17.0,18.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[18.0,19.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[19.0,20.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[20.0,21.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[21.0,22.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[22.0,23.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[23.0,24.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[24.0,25.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[25.0,26.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[26.0,27.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[27.0,28.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[28.0,29.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[29.0,30.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[30.0,31.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[31.0,32.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[32.0,33.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[33.0,34.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[34.0,35.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[35.0,36.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[36.0,37.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[37.0,38.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[38.0,39.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[39.0,40.0)', 10, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[40.0,41.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[41.0,42.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[42.0,43.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[43.0,44.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[44.0,45.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[45.0,46.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[46.0,47.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[47.0,48.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[48.0,49.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[49.0,50.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[50.0,51.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[51.0,52.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[52.0,53.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[53.0,54.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[54.0,55.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[55.0,56.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[56.0,57.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[57.0,58.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[58.0,59.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[59.0,60.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[60.0,61.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[61.0,62.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[62.0,63.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[63.0,64.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[64.0,65.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[65.0,66.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[66.0,67.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[67.0,68.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[68.0,69.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[69.0,70.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[70.0,71.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[71.0,72.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[72.0,73.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[73.0,74.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[74.0,75.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[75.0,76.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[76.0,77.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[77.0,78.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[78.0,79.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (2, '[79.0,80.0)', 5, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[0.0,1.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[1.0,2.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[2.0,3.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[3.0,4.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[4.0,5.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[5.0,6.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[6.0,7.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[7.0,8.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[8.0,9.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[9.0,10.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[10.0,11.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[11.0,12.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[12.0,13.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[13.0,14.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[14.0,15.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[15.0,16.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[16.0,17.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[17.0,18.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[18.0,19.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[19.0,20.0)', 20, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[20.0,21.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[21.0,22.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[22.0,23.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[23.0,24.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[24.0,25.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[25.0,26.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[26.0,27.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[27.0,28.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[28.0,29.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[29.0,30.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[30.0,31.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[31.0,32.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[32.0,33.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[33.0,34.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[34.0,35.0)', 35, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[35.0,36.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[36.0,37.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[37.0,38.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[38.0,39.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[39.0,40.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[40.0,41.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[41.0,42.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[42.0,43.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[43.0,44.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[44.0,45.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[45.0,46.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[46.0,47.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[47.0,48.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[48.0,49.0)', 25, 13);
INSERT INTO measure.fracturing_rate VALUES (4, '[49.0,50.0)', 25, 13);


--
-- Data for Name: groundwater_conductivity; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.groundwater_conductivity VALUES (1, 2, '2019-01-01 00:00:00', 0.120022247008546204, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (2, 2, '2019-01-01 01:00:00', 0.152056369136636477, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (3, 2, '2019-01-01 02:00:00', 0.182836346761738044, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (4, 2, '2019-01-01 03:00:00', 0.203569160839032703, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (5, 2, '2019-01-01 04:00:00', 0.218181606303515685, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (6, 2, '2019-01-01 05:00:00', 0.221207381881598275, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (7, 2, '2019-01-01 06:00:00', 0.211613467102929054, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (8, 2, '2019-01-01 07:00:00', 0.192528073063924443, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (9, 2, '2019-01-01 08:00:00', 0.166459801065513779, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (10, 2, '2019-01-01 09:00:00', 0.133868752818167847, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (11, 2, '2019-01-01 10:00:00', 0.101566812070135321, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (12, 2, '2019-01-01 11:00:00', 0.0704345704072132928, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (13, 2, '2019-01-01 12:00:00', 0.0435795159157359446, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (14, 2, '2019-01-01 13:00:00', 0.0269644516703018006, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (15, 2, '2019-01-01 14:00:00', 0.0195534504345572097, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (16, 2, '2019-01-01 15:00:00', 0.0233934139336359204, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (17, 2, '2019-01-01 16:00:00', 0.039762268453330453, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (18, 2, '2019-01-01 17:00:00', 0.0644284121037834306, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (19, 2, '2019-01-01 18:00:00', 0.0927708779423527252, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (20, 2, '2019-01-01 19:00:00', 0.125638244377597963, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (21, 2, '2019-01-01 20:00:00', 0.158619572167326917, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (22, 2, '2019-01-01 21:00:00', 0.184457561775232787, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (23, 2, '2019-01-01 22:00:00', 0.206724874220947319, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (24, 2, '2019-01-01 23:00:00', 0.2183925712676833, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (25, 2, '2019-01-02 00:00:00', 0.218943998081098462, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (26, 2, '2019-01-02 01:00:00', 0.209970559388199279, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (27, 2, '2019-01-02 02:00:00', 0.18889186278571124, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (28, 2, '2019-01-02 03:00:00', 0.15976132109008348, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (29, 2, '2019-01-02 04:00:00', 0.129525958470302544, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (30, 2, '2019-01-02 05:00:00', 0.0971226891479369664, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (31, 2, '2019-01-02 06:00:00', 0.0649713507834230597, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (32, 2, '2019-01-02 07:00:00', 0.0419750251775006591, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (33, 2, '2019-01-02 08:00:00', 0.0262427901419262505, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (34, 2, '2019-01-02 09:00:00', 0.0190212655314550561, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (35, 2, '2019-01-02 10:00:00', 0.0270243183072075704, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (36, 2, '2019-01-02 11:00:00', 0.0418544776231723134, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (37, 2, '2019-01-02 12:00:00', 0.0657892335366381531, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (38, 2, '2019-01-02 13:00:00', 0.0958046937189791226, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (39, 2, '2019-01-02 14:00:00', 0.130497922888036411, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (40, 2, '2019-01-02 15:00:00', 0.162843848529495516, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (41, 2, '2019-01-02 16:00:00', 0.189076906101946912, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (42, 2, '2019-01-02 17:00:00', 0.20848290251791507, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (43, 2, '2019-01-02 18:00:00', 0.218959824105681988, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (44, 2, '2019-01-02 19:00:00', 0.220052432897143047, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (45, 2, '2019-01-02 20:00:00', 0.206567489825087269, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (46, 2, '2019-01-02 21:00:00', 0.182788054855998389, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (47, 2, '2019-01-02 22:00:00', 0.157218722924632015, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (48, 2, '2019-01-02 23:00:00', 0.123974783535341526, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (49, 2, '2019-01-03 00:00:00', 0.0919101987292500339, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (50, 2, '2019-01-03 01:00:00', 0.0624724873638610109, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (51, 2, '2019-01-03 02:00:00', 0.036579813887354734, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (52, 2, '2019-01-03 03:00:00', 0.0237830430757863392, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (53, 2, '2019-01-03 04:00:00', 0.0216500564755619795, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (54, 2, '2019-01-03 05:00:00', 0.0285422716961445805, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (55, 2, '2019-01-03 06:00:00', 0.0440726360330666034, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (56, 2, '2019-01-03 07:00:00', 0.0710247419426763005, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (57, 2, '2019-01-03 08:00:00', 0.101418726985826324, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (58, 2, '2019-01-03 09:00:00', 0.134084061609907879, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (59, 2, '2019-01-03 10:00:00', 0.167909789373616641, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (60, 2, '2019-01-03 11:00:00', 0.191808262775852806, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (61, 2, '2019-01-03 12:00:00', 0.211361522273423641, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (62, 2, '2019-01-03 13:00:00', 0.217887650478224754, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (63, 2, '2019-01-03 14:00:00', 0.217110567588212289, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (64, 2, '2019-01-03 15:00:00', 0.202716048123006587, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (65, 2, '2019-01-03 16:00:00', 0.181543089487789328, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (66, 2, '2019-01-03 17:00:00', 0.151290352387722482, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (67, 2, '2019-01-03 18:00:00', 0.117584390395791646, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (68, 2, '2019-01-03 19:00:00', 0.085195405715117925, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (69, 2, '2019-01-03 20:00:00', 0.0584039689873145848, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (70, 2, '2019-01-03 21:00:00', 0.0330308746892713778, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (71, 2, '2019-01-03 22:00:00', 0.0223569821510238992, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (72, 2, '2019-01-03 23:00:00', 0.0210466568677053906, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (73, 2, '2019-01-04 00:00:00', 0.0275784453508907609, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (74, 2, '2019-01-04 01:00:00', 0.0474723044834805818, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (75, 2, '2019-01-04 02:00:00', 0.0744588636465373793, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (76, 2, '2019-01-04 03:00:00', 0.107222691067678871, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (77, 2, '2019-01-04 04:00:00', 0.140346158524185527, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (78, 2, '2019-01-04 05:00:00', 0.17141388779825642, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (79, 2, '2019-01-04 06:00:00', 0.197676865427771797, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (80, 2, '2019-01-04 07:00:00', 0.214097790517912251, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (81, 2, '2019-01-04 08:00:00', 0.219664567637611552, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (82, 2, '2019-01-04 09:00:00', 0.216380548446360704, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (83, 2, '2019-01-04 10:00:00', 0.201416829703026323, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (84, 2, '2019-01-04 11:00:00', 0.17769093328313032, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (85, 2, '2019-01-04 12:00:00', 0.148372216519906674, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (86, 2, '2019-01-04 13:00:00', 0.112781729587958526, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (87, 2, '2019-01-04 14:00:00', 0.0817749519884966025, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (88, 2, '2019-01-04 15:00:00', 0.0525132362367687761, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (89, 2, '2019-01-04 16:00:00', 0.0335178239540414452, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (90, 2, '2019-01-04 17:00:00', 0.0222890297985086396, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (91, 2, '2019-01-04 18:00:00', 0.0220686852125941205, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (92, 2, '2019-01-04 19:00:00', 0.0318401107861381663, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (93, 2, '2019-01-04 20:00:00', 0.0494773474174429878, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (94, 2, '2019-01-04 21:00:00', 0.080490128608349143, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (95, 2, '2019-01-04 22:00:00', 0.112804608206188525, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (96, 2, '2019-01-04 23:00:00', 0.145129249811574157, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (97, 2, '2019-01-05 00:00:00', 0.175945601655351447, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (98, 2, '2019-01-05 01:00:00', 0.199059150982277389, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (99, 2, '2019-01-05 02:00:00', 0.215920233215044804, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (100, 2, '2019-01-05 03:00:00', 0.221068401964682637, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (101, 2, '2019-01-05 04:00:00', 0.215579552026569449, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (102, 2, '2019-01-05 05:00:00', 0.198331123217794558, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (103, 2, '2019-01-05 06:00:00', 0.17344913120782493, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (104, 2, '2019-01-05 07:00:00', 0.142354862751003702, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (105, 2, '2019-01-05 08:00:00', 0.108946789297233296, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (106, 2, '2019-01-05 09:00:00', 0.0778613501274209308, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (107, 2, '2019-01-05 10:00:00', 0.0496743491407026158, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (108, 2, '2019-01-05 11:00:00', 0.0314255166968553795, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (109, 2, '2019-01-05 12:00:00', 0.0214078912034445581, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (110, 2, '2019-01-05 13:00:00', 0.021703120021944286, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (111, 2, '2019-01-05 14:00:00', 0.0330945508449354484, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (112, 2, '2019-01-05 15:00:00', 0.0563974384773064108, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (113, 2, '2019-01-05 16:00:00', 0.0860890751971723489, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (114, 2, '2019-01-05 17:00:00', 0.117233486149303845, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (115, 2, '2019-01-05 18:00:00', 0.150963769765698086, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (116, 2, '2019-01-05 19:00:00', 0.180292126183581203, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (117, 2, '2019-01-05 20:00:00', 0.201008368639907953, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (118, 2, '2019-01-05 21:00:00', 0.217222546697548646, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (119, 2, '2019-01-05 22:00:00', 0.21954313632437733, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (120, 2, '2019-01-05 23:00:00', 0.212826555152963254, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (121, 2, '2019-01-06 00:00:00', 0.194556275360475261, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (122, 2, '2019-01-06 01:00:00', 0.170076352800144576, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (123, 2, '2019-01-06 02:00:00', 0.136437408641316482, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (124, 2, '2019-01-06 03:00:00', 0.104120928899129356, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (125, 2, '2019-01-06 04:00:00', 0.0728001039923899806, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (126, 2, '2019-01-06 05:00:00', 0.0472443896470173125, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (127, 2, '2019-01-06 06:00:00', 0.0277757450534411449, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (128, 2, '2019-01-06 07:00:00', 0.0211469235343005879, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (129, 2, '2019-01-06 08:00:00', 0.0246049222538050893, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (130, 2, '2019-01-06 09:00:00', 0.0375743602012751157, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (131, 2, '2019-01-06 10:00:00', 0.0579421084074194376, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (132, 2, '2019-01-06 11:00:00', 0.0876603004525698531, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (133, 2, '2019-01-06 12:00:00', 0.123519398572442221, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (134, 2, '2019-01-06 13:00:00', 0.153873468719258666, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (135, 2, '2019-01-06 14:00:00', 0.183555048499350087, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (136, 2, '2019-01-06 15:00:00', 0.206654626974426048, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (137, 2, '2019-01-06 16:00:00', 0.218445451540234925, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (138, 2, '2019-01-06 17:00:00', 0.219631586198795387, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (139, 2, '2019-01-06 18:00:00', 0.209777801980053663, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (140, 2, '2019-01-06 19:00:00', 0.190164635047577191, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (141, 2, '2019-01-06 20:00:00', 0.165061991935599256, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (142, 2, '2019-01-06 21:00:00', 0.130895225018197392, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (143, 2, '2019-01-06 22:00:00', 0.0987017170081790352, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (144, 2, '2019-01-06 23:00:00', 0.0681116109796950364, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (145, 2, '2019-01-07 00:00:00', 0.0424304649457121208, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (146, 2, '2019-01-07 01:00:00', 0.0264619500368014904, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (147, 2, '2019-01-07 02:00:00', 0.0209568930847003204, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (148, 2, '2019-01-07 03:00:00', 0.0231891057683599917, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (149, 2, '2019-01-07 04:00:00', 0.0410421540139177116, 1, 10);
INSERT INTO measure.groundwater_conductivity VALUES (150, 2, '2019-01-07 05:00:00', 0.0618844072777906748, 1, 10);


--
-- Data for Name: groundwater_level; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.groundwater_level VALUES (1, 2, '2019-01-01 00:00:00', 110.027244332641004, 1, 11);
INSERT INTO measure.groundwater_level VALUES (2, 2, '2019-01-01 01:00:00', 110.050521087572733, 1, 11);
INSERT INTO measure.groundwater_level VALUES (3, 2, '2019-01-01 02:00:00', 109.839483769647259, 1, 11);
INSERT INTO measure.groundwater_level VALUES (4, 2, '2019-01-01 03:00:00', 110.202617840459069, 1, 11);
INSERT INTO measure.groundwater_level VALUES (5, 2, '2019-01-01 04:00:00', 109.91310296430008, 1, 11);
INSERT INTO measure.groundwater_level VALUES (6, 2, '2019-01-01 05:00:00', 110.019486153738029, 1, 11);
INSERT INTO measure.groundwater_level VALUES (7, 2, '2019-01-01 06:00:00', 109.867349770049145, 1, 11);
INSERT INTO measure.groundwater_level VALUES (8, 2, '2019-01-01 07:00:00', 109.952751136125926, 1, 11);
INSERT INTO measure.groundwater_level VALUES (9, 2, '2019-01-01 08:00:00', 109.851380546219275, 1, 11);
INSERT INTO measure.groundwater_level VALUES (10, 2, '2019-01-01 09:00:00', 110.110163607382248, 1, 11);
INSERT INTO measure.groundwater_level VALUES (11, 2, '2019-01-01 10:00:00', 110.041390794016422, 1, 11);
INSERT INTO measure.groundwater_level VALUES (12, 2, '2019-01-01 11:00:00', 110.05108649860864, 1, 11);
INSERT INTO measure.groundwater_level VALUES (13, 2, '2019-01-01 12:00:00', 110.098326153149145, 1, 11);
INSERT INTO measure.groundwater_level VALUES (14, 2, '2019-01-01 13:00:00', 110.112957580582105, 1, 11);
INSERT INTO measure.groundwater_level VALUES (15, 2, '2019-01-01 14:00:00', 110.087787240631172, 1, 11);
INSERT INTO measure.groundwater_level VALUES (16, 2, '2019-01-01 15:00:00', 109.931028567023475, 1, 11);
INSERT INTO measure.groundwater_level VALUES (17, 2, '2019-01-01 16:00:00', 109.953170735306983, 1, 11);
INSERT INTO measure.groundwater_level VALUES (18, 2, '2019-01-01 17:00:00', 110.066541714204504, 1, 11);
INSERT INTO measure.groundwater_level VALUES (19, 2, '2019-01-01 18:00:00', 109.935533463324688, 1, 11);
INSERT INTO measure.groundwater_level VALUES (20, 2, '2019-01-01 19:00:00', 109.71673573970898, 1, 11);
INSERT INTO measure.groundwater_level VALUES (21, 2, '2019-01-01 20:00:00', 110.056766129588937, 1, 11);
INSERT INTO measure.groundwater_level VALUES (22, 2, '2019-01-01 21:00:00', 110.094559918940945, 1, 11);
INSERT INTO measure.groundwater_level VALUES (23, 2, '2019-01-01 22:00:00', 110.151286422223791, 1, 11);
INSERT INTO measure.groundwater_level VALUES (24, 2, '2019-01-01 23:00:00', 110.004760081935899, 1, 11);
INSERT INTO measure.groundwater_level VALUES (25, 2, '2019-01-02 00:00:00', 110.034123178483114, 1, 11);
INSERT INTO measure.groundwater_level VALUES (26, 2, '2019-01-02 01:00:00', 109.798652617909468, 1, 11);
INSERT INTO measure.groundwater_level VALUES (27, 2, '2019-01-02 02:00:00', 109.955373170285156, 1, 11);
INSERT INTO measure.groundwater_level VALUES (28, 2, '2019-01-02 03:00:00', 110.05384158972285, 1, 11);
INSERT INTO measure.groundwater_level VALUES (29, 2, '2019-01-02 04:00:00', 109.828739335697577, 1, 11);
INSERT INTO measure.groundwater_level VALUES (30, 2, '2019-01-02 05:00:00', 109.94272316085177, 1, 11);
INSERT INTO measure.groundwater_level VALUES (31, 2, '2019-01-02 06:00:00', 110.099044860772096, 1, 11);
INSERT INTO measure.groundwater_level VALUES (32, 2, '2019-01-02 07:00:00', 110.139433586731002, 1, 11);
INSERT INTO measure.groundwater_level VALUES (33, 2, '2019-01-02 08:00:00', 110.104403662863604, 1, 11);
INSERT INTO measure.groundwater_level VALUES (34, 2, '2019-01-02 09:00:00', 110.005765993596214, 1, 11);
INSERT INTO measure.groundwater_level VALUES (35, 2, '2019-01-02 10:00:00', 110.122971081750691, 1, 11);
INSERT INTO measure.groundwater_level VALUES (36, 2, '2019-01-02 11:00:00', 110.080487829796823, 1, 11);
INSERT INTO measure.groundwater_level VALUES (37, 2, '2019-01-02 12:00:00', 109.96608368699809, 1, 11);
INSERT INTO measure.groundwater_level VALUES (38, 2, '2019-01-02 13:00:00', 109.908093342504031, 1, 11);
INSERT INTO measure.groundwater_level VALUES (39, 2, '2019-01-02 14:00:00', 110.123228455224748, 1, 11);
INSERT INTO measure.groundwater_level VALUES (40, 2, '2019-01-02 15:00:00', 109.992748553535748, 1, 11);
INSERT INTO measure.groundwater_level VALUES (41, 2, '2019-01-02 16:00:00', 109.845568560195147, 1, 11);
INSERT INTO measure.groundwater_level VALUES (42, 2, '2019-01-02 17:00:00', 109.843618396111395, 1, 11);
INSERT INTO measure.groundwater_level VALUES (43, 2, '2019-01-02 18:00:00', 110.018387410219503, 1, 11);
INSERT INTO measure.groundwater_level VALUES (44, 2, '2019-01-02 19:00:00', 110.073433173551763, 1, 11);
INSERT INTO measure.groundwater_level VALUES (45, 2, '2019-01-02 20:00:00', 110.018153318098229, 1, 11);
INSERT INTO measure.groundwater_level VALUES (46, 2, '2019-01-02 21:00:00', 110.004965784902623, 1, 11);
INSERT INTO measure.groundwater_level VALUES (47, 2, '2019-01-02 22:00:00', 110.102412399220384, 1, 11);
INSERT INTO measure.groundwater_level VALUES (48, 2, '2019-01-02 23:00:00', 110.053510831245063, 1, 11);
INSERT INTO measure.groundwater_level VALUES (49, 2, '2019-01-03 00:00:00', 110.009913854364299, 1, 11);
INSERT INTO measure.groundwater_level VALUES (50, 2, '2019-01-03 01:00:00', 109.926693646346308, 1, 11);
INSERT INTO measure.groundwater_level VALUES (51, 2, '2019-01-03 02:00:00', 110.004128806584959, 1, 11);
INSERT INTO measure.groundwater_level VALUES (52, 2, '2019-01-03 03:00:00', 110.153188207882181, 1, 11);
INSERT INTO measure.groundwater_level VALUES (53, 2, '2019-01-03 04:00:00', 109.999874978214805, 1, 11);
INSERT INTO measure.groundwater_level VALUES (54, 2, '2019-01-03 05:00:00', 110.111753503458175, 1, 11);
INSERT INTO measure.groundwater_level VALUES (55, 2, '2019-01-03 06:00:00', 109.975045190038429, 1, 11);
INSERT INTO measure.groundwater_level VALUES (56, 2, '2019-01-03 07:00:00', 109.975968455289518, 1, 11);
INSERT INTO measure.groundwater_level VALUES (57, 2, '2019-01-03 08:00:00', 109.96214028528081, 1, 11);
INSERT INTO measure.groundwater_level VALUES (58, 2, '2019-01-03 09:00:00', 110.080477861777723, 1, 11);
INSERT INTO measure.groundwater_level VALUES (59, 2, '2019-01-03 10:00:00', 110.11705318659051, 1, 11);
INSERT INTO measure.groundwater_level VALUES (60, 2, '2019-01-03 11:00:00', 110.020918020325638, 1, 11);
INSERT INTO measure.groundwater_level VALUES (61, 2, '2019-01-03 12:00:00', 110.125016638718762, 1, 11);
INSERT INTO measure.groundwater_level VALUES (62, 2, '2019-01-03 13:00:00', 110.064727228140214, 1, 11);
INSERT INTO measure.groundwater_level VALUES (63, 2, '2019-01-03 14:00:00', 110.134666332889665, 1, 11);
INSERT INTO measure.groundwater_level VALUES (64, 2, '2019-01-03 15:00:00', 110.051753677138038, 1, 11);
INSERT INTO measure.groundwater_level VALUES (65, 2, '2019-01-03 16:00:00', 110.004696986988435, 1, 11);
INSERT INTO measure.groundwater_level VALUES (66, 2, '2019-01-03 17:00:00', 109.990703889714638, 1, 11);
INSERT INTO measure.groundwater_level VALUES (67, 2, '2019-01-03 18:00:00', 109.80335941989344, 1, 11);
INSERT INTO measure.groundwater_level VALUES (68, 2, '2019-01-03 19:00:00', 109.986589502540625, 1, 11);
INSERT INTO measure.groundwater_level VALUES (69, 2, '2019-01-03 20:00:00', 109.943209839461261, 1, 11);
INSERT INTO measure.groundwater_level VALUES (70, 2, '2019-01-03 21:00:00', 110.232658121726189, 1, 11);
INSERT INTO measure.groundwater_level VALUES (71, 2, '2019-01-03 22:00:00', 110.05256009877256, 1, 11);
INSERT INTO measure.groundwater_level VALUES (72, 2, '2019-01-03 23:00:00', 110.032516315254696, 1, 11);
INSERT INTO measure.groundwater_level VALUES (73, 2, '2019-01-04 00:00:00', 109.896735693823516, 1, 11);
INSERT INTO measure.groundwater_level VALUES (74, 2, '2019-01-04 01:00:00', 110.053233774263248, 1, 11);
INSERT INTO measure.groundwater_level VALUES (75, 2, '2019-01-04 02:00:00', 109.913180107996936, 1, 11);
INSERT INTO measure.groundwater_level VALUES (76, 2, '2019-01-04 03:00:00', 110.094352193542122, 1, 11);
INSERT INTO measure.groundwater_level VALUES (77, 2, '2019-01-04 04:00:00', 109.868465220630696, 1, 11);
INSERT INTO measure.groundwater_level VALUES (78, 2, '2019-01-04 05:00:00', 110.117619361740566, 1, 11);
INSERT INTO measure.groundwater_level VALUES (79, 2, '2019-01-04 06:00:00', 109.947758873409413, 1, 11);
INSERT INTO measure.groundwater_level VALUES (80, 2, '2019-01-04 07:00:00', 109.996807268863279, 1, 11);
INSERT INTO measure.groundwater_level VALUES (81, 2, '2019-01-04 08:00:00', 109.969375621213928, 1, 11);
INSERT INTO measure.groundwater_level VALUES (82, 2, '2019-01-04 09:00:00', 110.074124277847162, 1, 11);
INSERT INTO measure.groundwater_level VALUES (83, 2, '2019-01-04 10:00:00', 110.108925491109687, 1, 11);
INSERT INTO measure.groundwater_level VALUES (84, 2, '2019-01-04 11:00:00', 109.922139661047837, 1, 11);
INSERT INTO measure.groundwater_level VALUES (85, 2, '2019-01-04 12:00:00', 109.844077376803, 1, 11);
INSERT INTO measure.groundwater_level VALUES (86, 2, '2019-01-04 13:00:00', 109.907455444549853, 1, 11);
INSERT INTO measure.groundwater_level VALUES (87, 2, '2019-01-04 14:00:00', 109.966216369565075, 1, 11);
INSERT INTO measure.groundwater_level VALUES (88, 2, '2019-01-04 15:00:00', 109.940282301243755, 1, 11);
INSERT INTO measure.groundwater_level VALUES (89, 2, '2019-01-04 16:00:00', 110.173105186186433, 1, 11);
INSERT INTO measure.groundwater_level VALUES (90, 2, '2019-01-04 17:00:00', 110.172049551827769, 1, 11);
INSERT INTO measure.groundwater_level VALUES (91, 2, '2019-01-04 18:00:00', 110.16035676529998, 1, 11);
INSERT INTO measure.groundwater_level VALUES (92, 2, '2019-01-04 19:00:00', 109.989431528505946, 1, 11);
INSERT INTO measure.groundwater_level VALUES (93, 2, '2019-01-04 20:00:00', 110.157707768588608, 1, 11);
INSERT INTO measure.groundwater_level VALUES (94, 2, '2019-01-04 21:00:00', 110.029240993426754, 1, 11);
INSERT INTO measure.groundwater_level VALUES (95, 2, '2019-01-04 22:00:00', 109.912250078340676, 1, 11);
INSERT INTO measure.groundwater_level VALUES (96, 2, '2019-01-04 23:00:00', 110.103261742776994, 1, 11);
INSERT INTO measure.groundwater_level VALUES (97, 2, '2019-01-05 00:00:00', 110.024543049023322, 1, 11);
INSERT INTO measure.groundwater_level VALUES (98, 2, '2019-01-05 01:00:00', 110.023984651466108, 1, 11);
INSERT INTO measure.groundwater_level VALUES (99, 2, '2019-01-05 02:00:00', 110.085536244291305, 1, 11);
INSERT INTO measure.groundwater_level VALUES (100, 2, '2019-01-05 03:00:00', 110.160481488723875, 1, 11);
INSERT INTO measure.groundwater_level VALUES (101, 2, '2019-01-05 04:00:00', 110.11425681402703, 1, 11);
INSERT INTO measure.groundwater_level VALUES (102, 2, '2019-01-05 05:00:00', 110.018454862555416, 1, 11);
INSERT INTO measure.groundwater_level VALUES (103, 2, '2019-01-05 06:00:00', 109.911958670009909, 1, 11);
INSERT INTO measure.groundwater_level VALUES (104, 2, '2019-01-05 07:00:00', 110.033812566358179, 1, 11);
INSERT INTO measure.groundwater_level VALUES (105, 2, '2019-01-05 08:00:00', 109.970500594538905, 1, 11);
INSERT INTO measure.groundwater_level VALUES (106, 2, '2019-01-05 09:00:00', 109.950466813479366, 1, 11);
INSERT INTO measure.groundwater_level VALUES (107, 2, '2019-01-05 10:00:00', 109.92330172195075, 1, 11);
INSERT INTO measure.groundwater_level VALUES (108, 2, '2019-01-05 11:00:00', 109.836500762190084, 1, 11);
INSERT INTO measure.groundwater_level VALUES (109, 2, '2019-01-05 12:00:00', 109.940925254635729, 1, 11);
INSERT INTO measure.groundwater_level VALUES (110, 2, '2019-01-05 13:00:00', 109.759497202554201, 1, 11);
INSERT INTO measure.groundwater_level VALUES (111, 2, '2019-01-05 14:00:00', 110.041387661130941, 1, 11);
INSERT INTO measure.groundwater_level VALUES (112, 2, '2019-01-05 15:00:00', 109.931471194411344, 1, 11);
INSERT INTO measure.groundwater_level VALUES (113, 2, '2019-01-05 16:00:00', 110.059054162607225, 1, 11);
INSERT INTO measure.groundwater_level VALUES (114, 2, '2019-01-05 17:00:00', 110.138471310558486, 1, 11);
INSERT INTO measure.groundwater_level VALUES (115, 2, '2019-01-05 18:00:00', 109.93679577391967, 1, 11);
INSERT INTO measure.groundwater_level VALUES (116, 2, '2019-01-05 19:00:00', 109.965436547862097, 1, 11);
INSERT INTO measure.groundwater_level VALUES (117, 2, '2019-01-05 20:00:00', 109.909319657853359, 1, 11);
INSERT INTO measure.groundwater_level VALUES (118, 2, '2019-01-05 21:00:00', 109.909567107639774, 1, 11);
INSERT INTO measure.groundwater_level VALUES (119, 2, '2019-01-05 22:00:00', 109.990574015853895, 1, 11);
INSERT INTO measure.groundwater_level VALUES (120, 2, '2019-01-05 23:00:00', 109.887676435122188, 1, 11);
INSERT INTO measure.groundwater_level VALUES (121, 2, '2019-01-06 00:00:00', 109.772789737599936, 1, 11);
INSERT INTO measure.groundwater_level VALUES (122, 2, '2019-01-06 01:00:00', 110.11830339736494, 1, 11);
INSERT INTO measure.groundwater_level VALUES (123, 2, '2019-01-06 02:00:00', 110.178273661234158, 1, 11);
INSERT INTO measure.groundwater_level VALUES (124, 2, '2019-01-06 03:00:00', 109.966662496178216, 1, 11);
INSERT INTO measure.groundwater_level VALUES (125, 2, '2019-01-06 04:00:00', 109.834875464780978, 1, 11);
INSERT INTO measure.groundwater_level VALUES (126, 2, '2019-01-06 05:00:00', 109.942254902815904, 1, 11);
INSERT INTO measure.groundwater_level VALUES (127, 2, '2019-01-06 06:00:00', 110.114314329188431, 1, 11);
INSERT INTO measure.groundwater_level VALUES (128, 2, '2019-01-06 07:00:00', 109.806071224689518, 1, 11);
INSERT INTO measure.groundwater_level VALUES (129, 2, '2019-01-06 08:00:00', 109.904498754012167, 1, 11);
INSERT INTO measure.groundwater_level VALUES (130, 2, '2019-01-06 09:00:00', 109.792975380147027, 1, 11);
INSERT INTO measure.groundwater_level VALUES (131, 2, '2019-01-06 10:00:00', 109.885826277976335, 1, 11);
INSERT INTO measure.groundwater_level VALUES (132, 2, '2019-01-06 11:00:00', 109.95449653097819, 1, 11);
INSERT INTO measure.groundwater_level VALUES (133, 2, '2019-01-06 12:00:00', 109.812093248420553, 1, 11);
INSERT INTO measure.groundwater_level VALUES (134, 2, '2019-01-06 13:00:00', 109.820325403041693, 1, 11);
INSERT INTO measure.groundwater_level VALUES (135, 2, '2019-01-06 14:00:00', 110.106980532771189, 1, 11);
INSERT INTO measure.groundwater_level VALUES (136, 2, '2019-01-06 15:00:00', 110.220795061298759, 1, 11);
INSERT INTO measure.groundwater_level VALUES (137, 2, '2019-01-06 16:00:00', 109.850210032133106, 1, 11);
INSERT INTO measure.groundwater_level VALUES (138, 2, '2019-01-06 17:00:00', 110.044328506092015, 1, 11);
INSERT INTO measure.groundwater_level VALUES (139, 2, '2019-01-06 18:00:00', 110.063401516726358, 1, 11);
INSERT INTO measure.groundwater_level VALUES (140, 2, '2019-01-06 19:00:00', 110.122306998482443, 1, 11);
INSERT INTO measure.groundwater_level VALUES (141, 2, '2019-01-06 20:00:00', 109.955002363945226, 1, 11);
INSERT INTO measure.groundwater_level VALUES (142, 2, '2019-01-06 21:00:00', 109.926237416645193, 1, 11);
INSERT INTO measure.groundwater_level VALUES (143, 2, '2019-01-06 22:00:00', 109.98752749034179, 1, 11);
INSERT INTO measure.groundwater_level VALUES (144, 2, '2019-01-06 23:00:00', 110.056507409302924, 1, 11);
INSERT INTO measure.groundwater_level VALUES (145, 2, '2019-01-07 00:00:00', 109.968697596808965, 1, 11);
INSERT INTO measure.groundwater_level VALUES (146, 2, '2019-01-07 01:00:00', 110.024668476538096, 1, 11);
INSERT INTO measure.groundwater_level VALUES (147, 2, '2019-01-07 02:00:00', 109.94702805024923, 1, 11);
INSERT INTO measure.groundwater_level VALUES (148, 2, '2019-01-07 03:00:00', 110.102654090344316, 1, 11);
INSERT INTO measure.groundwater_level VALUES (149, 2, '2019-01-07 04:00:00', 109.937807015728069, 1, 11);
INSERT INTO measure.groundwater_level VALUES (150, 2, '2019-01-07 05:00:00', 110.004472056448691, 1, 11);


--
-- Data for Name: groundwater_temperature; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.groundwater_temperature VALUES (1, 2, '2019-01-01 00:00:00', 9.74261856408976001, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (2, 2, '2019-01-01 01:00:00', 10.0683926703253039, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (3, 2, '2019-01-01 02:00:00', 10.4098893758046636, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (4, 2, '2019-01-01 03:00:00', 10.7756302931530072, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (5, 2, '2019-01-01 04:00:00', 11.0525853206117937, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (6, 2, '2019-01-01 05:00:00', 11.106478921135416, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (7, 2, '2019-01-01 06:00:00', 11.3271861607956339, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (8, 2, '2019-01-01 07:00:00', 11.7194255731739734, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (9, 2, '2019-01-01 08:00:00', 11.5768162474199041, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (10, 2, '2019-01-01 09:00:00', 11.9201306306828805, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (11, 2, '2019-01-01 10:00:00', 12.0370218898917241, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (12, 2, '2019-01-01 11:00:00', 12.0769002293665366, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (13, 2, '2019-01-01 12:00:00', 12.0932795588122843, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (14, 2, '2019-01-01 13:00:00', 12.0677808408935192, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (15, 2, '2019-01-01 14:00:00', 11.9758163651047518, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (16, 2, '2019-01-01 15:00:00', 11.7920255181756648, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (17, 2, '2019-01-01 16:00:00', 11.7486395946876794, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (18, 2, '2019-01-01 17:00:00', 11.5351007222624116, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (19, 2, '2019-01-01 18:00:00', 11.4299688738332517, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (20, 2, '2019-01-01 19:00:00', 11.1496532062706493, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (21, 2, '2019-01-01 20:00:00', 10.9193641868336631, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (22, 2, '2019-01-01 21:00:00', 10.8652033825644843, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (23, 2, '2019-01-01 22:00:00', 10.566764705368497, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (24, 2, '2019-01-01 23:00:00', 10.2675602781377062, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (25, 2, '2019-01-02 00:00:00', 9.94988588605203716, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (26, 2, '2019-01-02 01:00:00', 9.74366744089167369, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (27, 2, '2019-01-02 02:00:00', 9.40036646589408065, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (28, 2, '2019-01-02 03:00:00', 9.21906628641078285, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (29, 2, '2019-01-02 04:00:00', 9.18245055126731557, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (30, 2, '2019-01-02 05:00:00', 8.97297090620016569, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (31, 2, '2019-01-02 06:00:00', 8.64594904538261488, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (32, 2, '2019-01-02 07:00:00', 8.34431742114456299, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (33, 2, '2019-01-02 08:00:00', 8.35542395609460442, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (34, 2, '2019-01-02 09:00:00', 8.07377580544353535, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (35, 2, '2019-01-02 10:00:00', 8.12421954094355492, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (36, 2, '2019-01-02 11:00:00', 8.07654751463762643, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (37, 2, '2019-01-02 12:00:00', 8.02324897620485267, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (38, 2, '2019-01-02 13:00:00', 7.86155013700500227, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (39, 2, '2019-01-02 14:00:00', 8.09148742495306372, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (40, 2, '2019-01-02 15:00:00', 8.23197710959682638, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (41, 2, '2019-01-02 16:00:00', 8.35383172516594286, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (42, 2, '2019-01-02 17:00:00', 8.31369481352642303, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (43, 2, '2019-01-02 18:00:00', 8.36367893602273504, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (44, 2, '2019-01-02 19:00:00', 8.81537749846028973, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (45, 2, '2019-01-02 20:00:00', 9.00580066383098909, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (46, 2, '2019-01-02 21:00:00', 9.2408893453003671, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (47, 2, '2019-01-02 22:00:00', 9.61031042321389073, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (48, 2, '2019-01-02 23:00:00', 9.70753857835693168, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (49, 2, '2019-01-03 00:00:00', 10.1155079708124944, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (50, 2, '2019-01-03 01:00:00', 10.311046970869695, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (51, 2, '2019-01-03 02:00:00', 10.4620618928281335, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (52, 2, '2019-01-03 03:00:00', 10.6357111130617792, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (53, 2, '2019-01-03 04:00:00', 10.9778008095350046, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (54, 2, '2019-01-03 05:00:00', 11.2830316908155091, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (55, 2, '2019-01-03 06:00:00', 11.3157344473363111, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (56, 2, '2019-01-03 07:00:00', 11.4303501366890963, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (57, 2, '2019-01-03 08:00:00', 11.8354788016187733, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (58, 2, '2019-01-03 09:00:00', 11.9203301089187406, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (59, 2, '2019-01-03 10:00:00', 11.9088474781160354, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (60, 2, '2019-01-03 11:00:00', 12.0897737042811855, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (61, 2, '2019-01-03 12:00:00', 11.9742467176188327, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (62, 2, '2019-01-03 13:00:00', 11.9240351983733248, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (63, 2, '2019-01-03 14:00:00', 11.8338069741963938, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (64, 2, '2019-01-03 15:00:00', 11.923058139009175, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (65, 2, '2019-01-03 16:00:00', 11.6463732535766624, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (66, 2, '2019-01-03 17:00:00', 11.4590019198867559, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (67, 2, '2019-01-03 18:00:00', 11.3940014812568045, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (68, 2, '2019-01-03 19:00:00', 11.1613309124515556, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (69, 2, '2019-01-03 20:00:00', 10.9059058337964156, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (70, 2, '2019-01-03 21:00:00', 10.8980091023281531, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (71, 2, '2019-01-03 22:00:00', 10.4211035948672244, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (72, 2, '2019-01-03 23:00:00', 10.2942782518049984, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (73, 2, '2019-01-04 00:00:00', 9.8276939098893159, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (74, 2, '2019-01-04 01:00:00', 9.77209226873407921, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (75, 2, '2019-01-04 02:00:00', 9.55919669156674878, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (76, 2, '2019-01-04 03:00:00', 9.17359798642615765, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (77, 2, '2019-01-04 04:00:00', 8.96123370211030768, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (78, 2, '2019-01-04 05:00:00', 8.72472448116121591, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (79, 2, '2019-01-04 06:00:00', 8.40302375524653655, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (80, 2, '2019-01-04 07:00:00', 8.35672467503258432, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (81, 2, '2019-01-04 08:00:00', 8.13361368749360025, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (82, 2, '2019-01-04 09:00:00', 8.09327196925826264, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (83, 2, '2019-01-04 10:00:00', 8.23575457622992957, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (84, 2, '2019-01-04 11:00:00', 8.00109310921219219, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (85, 2, '2019-01-04 12:00:00', 7.87328084316436172, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (86, 2, '2019-01-04 13:00:00', 8.18751670695944256, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (87, 2, '2019-01-04 14:00:00', 7.90688497708296545, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (88, 2, '2019-01-04 15:00:00', 8.25020178174606755, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (89, 2, '2019-01-04 16:00:00', 8.08223505102500361, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (90, 2, '2019-01-04 17:00:00', 8.41422647912439636, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (91, 2, '2019-01-04 18:00:00', 8.56795357259955104, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (92, 2, '2019-01-04 19:00:00', 9.04845573140542214, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (93, 2, '2019-01-04 20:00:00', 9.01185678293733083, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (94, 2, '2019-01-04 21:00:00', 9.35775540049259824, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (95, 2, '2019-01-04 22:00:00', 9.50037970828372202, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (96, 2, '2019-01-04 23:00:00', 9.79023839050156752, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (97, 2, '2019-01-05 00:00:00', 9.83422800970850197, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (98, 2, '2019-01-05 01:00:00', 10.2824230234748804, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (99, 2, '2019-01-05 02:00:00', 10.4322065981304739, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (100, 2, '2019-01-05 03:00:00', 10.5441267244567634, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (101, 2, '2019-01-05 04:00:00', 10.9869985244165225, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (102, 2, '2019-01-05 05:00:00', 11.1494770653011273, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (103, 2, '2019-01-05 06:00:00', 11.1967961780234297, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (104, 2, '2019-01-05 07:00:00', 11.6179062423719675, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (105, 2, '2019-01-05 08:00:00', 11.779618341828284, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (106, 2, '2019-01-05 09:00:00', 11.7616778868556349, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (107, 2, '2019-01-05 10:00:00', 11.8736895154890085, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (108, 2, '2019-01-05 11:00:00', 12.0270297952391427, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (109, 2, '2019-01-05 12:00:00', 12.0239303364707819, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (110, 2, '2019-01-05 13:00:00', 11.9789613625676434, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (111, 2, '2019-01-05 14:00:00', 12.0277641170974263, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (112, 2, '2019-01-05 15:00:00', 11.8036691454415799, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (113, 2, '2019-01-05 16:00:00', 11.6045468755635852, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (114, 2, '2019-01-05 17:00:00', 11.5596363183793471, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (115, 2, '2019-01-05 18:00:00', 11.353408435206866, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (116, 2, '2019-01-05 19:00:00', 11.1267138596149611, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (117, 2, '2019-01-05 20:00:00', 11.0486633967047236, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (118, 2, '2019-01-05 21:00:00', 10.8261116150564618, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (119, 2, '2019-01-05 22:00:00', 10.6344325146229046, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (120, 2, '2019-01-05 23:00:00', 10.2265822599321936, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (121, 2, '2019-01-06 00:00:00', 9.75425672934305688, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (122, 2, '2019-01-06 01:00:00', 9.64061216758163653, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (123, 2, '2019-01-06 02:00:00', 9.54090614937305759, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (124, 2, '2019-01-06 03:00:00', 9.17997753610560707, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (125, 2, '2019-01-06 04:00:00', 9.2515040906620829, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (126, 2, '2019-01-06 05:00:00', 8.85735070038129635, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (127, 2, '2019-01-06 06:00:00', 8.66965198601387499, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (128, 2, '2019-01-06 07:00:00', 8.45624234794345142, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (129, 2, '2019-01-06 08:00:00', 8.34160226482305411, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (130, 2, '2019-01-06 09:00:00', 8.18384173510546553, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (131, 2, '2019-01-06 10:00:00', 8.1635684008149596, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (132, 2, '2019-01-06 11:00:00', 8.08704910193200988, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (133, 2, '2019-01-06 12:00:00', 8.09175333746347114, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (134, 2, '2019-01-06 13:00:00', 8.03033404725271005, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (135, 2, '2019-01-06 14:00:00', 8.32432456061592418, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (136, 2, '2019-01-06 15:00:00', 8.12539243001092792, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (137, 2, '2019-01-06 16:00:00', 8.08709522172063977, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (138, 2, '2019-01-06 17:00:00', 8.4192925776482781, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (139, 2, '2019-01-06 18:00:00', 8.59985407916156497, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (140, 2, '2019-01-06 19:00:00', 8.81388757966441361, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (141, 2, '2019-01-06 20:00:00', 8.97336665532851541, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (142, 2, '2019-01-06 21:00:00', 9.34344138450225969, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (143, 2, '2019-01-06 22:00:00', 9.39423094551642457, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (144, 2, '2019-01-06 23:00:00', 9.59446183379756867, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (145, 2, '2019-01-07 00:00:00', 10.1955338459238671, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (146, 2, '2019-01-07 01:00:00', 10.5029264507405422, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (147, 2, '2019-01-07 02:00:00', 10.3876418610312982, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (148, 2, '2019-01-07 03:00:00', 10.8076926102652404, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (149, 2, '2019-01-07 04:00:00', 10.9369735201564762, 1, 12);
INSERT INTO measure.groundwater_temperature VALUES (150, 2, '2019-01-07 05:00:00', 11.1381105967337817, 1, 12);


--
-- Data for Name: instrument; Type: TABLE DATA; Schema: measure; Owner: postgres
--



--
-- Data for Name: measure_metadata; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.measure_metadata VALUES ('measure.atmospheric_pressure', 'Pression atmosphérique', 'Pa', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.manual_groundwater_level', 'Cote de nappe (mesure manuelle)', 'm', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.groundwater_level', 'Cote de nappe', 'm', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.groundwater_ph', 'pH', '', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.groundwater_temperature', 'Température nappe', '°C', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.groundwater_conductivity', 'Conductivité nappe', 'S/m', 'Hydrogéologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.manual_water_level', 'Hauteur d''eau (mesure manuelle)', 'm', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.water_level', 'Hauteur d''eau', 'm', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.water_discharge', 'Débit', 'm³/s', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.water_ph', 'pH', '', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.water_temperature', 'Température eau', '°C', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.water_conductivity', 'Conductivité eau', 'S/m', 'Hydrologie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_atmospheric_pressure', 'Pression atmosphérique', 'Pa', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_rain', 'Pluie', 'm', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_potential_evapotranspiration', 'ETP', 'm', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_temperature', 'Température', '°C', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_wind_direction', 'Direction du vent', '', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_wind_force', 'Force du vent', 'm/s', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_pasquill_index', 'Indice de stabilité de Pasquill', '', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_nebulosity', 'Nébulosité', '', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_humidity', 'Humidité', '', 'Météorologie', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.fracturing_rate', 'Fracturation', '', 'Forages', 'DepthAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.tool_instant_speed', 'Vitesse instantanée d''avancement', 'm/s', 'Diagraphie', 'DepthAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.weight_on_tool', 'Poids sur l''outil', 'kg', 'Diagraphie', 'DepthAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.tool_injection_pressure', 'Pression d''injection', 'Pa', 'Diagraphie', 'DepthAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.tool_rotation_couple', 'Couple de rotation', 'N.m', 'Diagraphie', 'DepthAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.massic_activity', 'Activité massique', 'Bq/kg', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.volumic_activity', 'Activité volumique', 'Bq/m³', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.massic_concentration', 'Concentration massique', 'kg/kg', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.volumic_concentration', 'Concentration volumique', 'kg/m³', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.dosimetry', 'Dosimétrie', 'Gy', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.mass_isotopic_ratio', 'Rapport isotopique en masse', '', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.activity_isotopic_ratio', 'Rapport isotopique en activité', '', 'Chimie', 'TimeAxis', 'Instantaneous');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_released_activity', 'Activité rejetée', 'Bq', 'Rejets gazeux', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_released_mass', 'Masse rejetée', 'kg', 'Rejets gazeux', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.continuous_released_flow', 'Débit du rejet', 'm³/s', 'Rejets gazeux', 'TimeAxis', 'Cumulative');
INSERT INTO measure.measure_metadata VALUES ('measure.optical_imagery', 'Imagerie optique', NULL, 'Imagerie', 'DepthAxis', 'Image');
INSERT INTO measure.measure_metadata VALUES ('measure.acoustic_imagery', 'Imagerie acoustique', NULL, 'Imagerie', 'DepthAxis', 'Image');


--
-- Data for Name: optical_imagery; Type: TABLE DATA; Schema: measure; Owner: postgres
--

INSERT INTO measure.optical_imagery VALUES (1, 2, '2019-01-01', '[10.0,20.75)', '\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