# coding=UTF-8

import os

from PyQt5.QtWidgets import QDialog
from PyQt5 import uic


class ConfigurePlotDialog(QDialog):
    def __init__(self, layer, parent):
        super().__init__(parent)

        uic.loadUi(os.path.join(os.path.dirname(__file__), "configure_plot_dialog.ui"), self)

        text = self.tr("There is not plot configured for layer") + " {}".format(
            layer.name() + "." + self.tr("\nDo you want to configure one ?")
        )
        self._message.setText(text)
        self.setWindowTitle(self.tr("Configure a plot layer") + " {}".format(layer.name()))

        self._name.setText(layer.name())

        for column_field in [self._id_column, self._name_column, self._elevation_column]:
            column_field.addItems(layer.fields().names())

    def config(self):
        return {
            "layer_name": self._name.text(),
            "id_column": self._id_column.currentText(),
            "name_column": self._name_column.currentText(),
            "ground_elevation": self._elevation_column.currentText()
            if self._elevation_column.currentIndex() != 0
            else None,
            "stratigraphy_config": [],
            "log_measures": [],
            "imagery_data": [],
        }
