# -*- coding: utf-8 -*-
"""
---------------------------------------------------------------------------
set_gyf.py GYF AP
Created on: 2021-04-20 22:05:53
---------------------------------------------------------------------------
"""
import os
import webbrowser
from PyQt5.QtWidgets import QMessageBox
from qgis.core import QgsProject

from ..ui.layer_selector import LayerSelectorDialog
from .gyf_tables import QualityTable


class SwitchGYFs:
    def __init__(self, dockwidget, plugin_dir):
        self.dockwidget = dockwidget
        self.plugin_dir = plugin_dir
        self.proj = QgsProject.instance()
        

    def defineGYF(self):
        gyf_var = [
            'Name',
            'Version',
            'Doc', 
            'Input_groups', 
            'Input_categories',
            'Input_ground_areas',
            'Ground_areas_enabled',
            'Tabs_labels',
            'Klass_items']

        gyf_ap = [
            r'GYF för allmän platsmark, C/O City',
            'GYF AP 2.0',
            'gyf_ap.pdf',
            'gyf_AP_groups.txt', 
            'gyf_AP_qualities.txt',
            'gyf_AP_groundareas.txt',
            0,
            ['Grundytor','Klassificera', 'Visualisera', 'Beräkna'],
            ['ytklass', 'kvalitet']]

        gyf_model = dict(zip(gyf_var, gyf_ap))

        db = self.proj.readEntry("QGYF", "activeDataBase")[0]
        if db and os.path.exists(os.path.join(self.proj.readEntry("QGYF", "dataPath")[0], db)):
            QualityTable().init(gyf_model)
        
        return gyf_model

    def adjustDockwidget(self, model):
        ### GYF Name
        self.showGYFname(model)
        pdfGYF = lambda: self.pdfGYF(model)
        ### GYF Documentation
        #self.dockwidget.info.disconnect()
        self.dockwidget.info.clicked.connect(pdfGYF)

        ### Import GYF model
        group_list = self.dockwidget.chooseQ('gyf_qgroup', self.dockwidget.selectQGroup, self.dockwidget.selectQ, self.dockwidget.textQ)
        
        ### Labels
        self.dockwidget.setTableLabels(model)
        
        # Tab1
        self.dockwidget.label_G.setText('Välj grupp för ' + model['Klass_items'][1])
        self.dockwidget.label_Q.setText('Välj ' + model['Klass_items'][1])
        self.dockwidget.approveButton.setText('Lägg till ' + model['Klass_items'][1])
        self.dockwidget.removeButton.setText('Ta bort ' + model['Klass_items'][1])
        # Tab2
        # Qualities
        self.dockwidget.createCheckBoxes(group_list)
        self.dockwidget.enableGroupList()
        self.dockwidget.tabWidget.currentChanged.connect(self.dockwidget.disableGroup)

        # Tab3
        self.dockwidget.plot.canvas.ax.cla()
        self.dockwidget.plot.canvas.ax.axis('off')
        self.dockwidget.obsText.clear()
        
    def showGYFname(self, model):
        gyf_name = '<h3 style="color:#238973">{}</h3>'.format(model['Name'])
        self.dockwidget.gyfVersion.setText(gyf_name)

    def pdfGYF(self, model):
        docPath = os.path.join(self.plugin_dir, 'gyf_models', model['Doc'])
        try:
            webbrowser.open(docPath)
        except:
            QMessageBox.warning(LayerSelectorDialog(), 'Ingen PDF läsare', 'Det ser ut att ingen PDF läsare finns installerat på datorn.')