"""
---------------------------------------------------------------------------
map_export.py GYF AP
Created on: 2019-04-09 10:20:53
---------------------------------------------------------------------------
"""

from PyQt5.QtXml import QDomDocument
from PyQt5.QtWidgets import QMessageBox
from qgis.core import Qgis, QgsProject, QgsLayout, QgsReadWriteContext, QgsLayoutItemPicture, QgsLayoutFrame, QgsLayoutTableColumn, QgsLayoutSize, QgsTextFormat
from qgis.core import QgsLayoutItemLabel, QgsLayoutItemMap, QgsLayoutItemLegend, QgsLayoutExporter, QgsLayoutItemTextTable, QgsLayoutPoint, QgsUnitTypes
from PyQt5.QtGui import QColor
from ..ui.export import ExportDialog
from qgis.utils import spatialite_connect
import os
import sip
import datetime

class ExportCreator:

    def exportPDF(self, model, chart_path, gyf, exportDialog, area_id, groups, feature_gids, total):

        # Text from export dialog
        map_title = exportDialog.projectName.text()
        area_name = exportDialog.areaName.text()
        output_path = exportDialog.pdfPath.text()
        output_name = exportDialog.pdfName.text()
        author = exportDialog.author.text()
        gyf_version = model['Version']
        date = datetime.datetime.today().strftime('%Y-%m-%d')

        # Get template
        path = os.path.dirname(os.path.realpath(__file__))
        template_file = open(os.path.join(os.path.dirname(path), 'template', 'qgyf_template1.qpt'), encoding="utf-8")
        template_content = template_file.read()
        template_file.close()

        document = QDomDocument()
        proj = QgsProject.instance()
        document.setContent(template_content)
        composition = QgsLayout(proj)
        composition.loadFromTemplate(document, QgsReadWriteContext())

        # Title
        title = sip.cast(composition.itemById("title"), QgsLayoutItemLabel)
        title.setText(map_title)
        title = sip.cast(composition.itemById("title1"), QgsLayoutItemLabel)
        title.setText(map_title)
        title = sip.cast(composition.itemById("title2"), QgsLayoutItemLabel)
        title.setText(map_title)

        # GYF value
        value = sip.cast(composition.itemById("gyf_value"), QgsLayoutItemLabel)
        value.setText('GYF  ' + gyf)
        value = sip.cast(composition.itemById("gyf_value1"), QgsLayoutItemLabel)
        value.setText('GYF  ' + gyf)
        value = sip.cast(composition.itemById("gyf_value2"), QgsLayoutItemLabel)
        value.setText('GYF  ' + gyf)

        # GYF groups
        groups = sorted(list(set(groups)))
        groupList = sip.cast(composition.itemById("groups"), QgsLayoutItemLabel)
        text = '''<font face="tahoma" color="#238973"><h3>GYF Kategorier:</h3></font>
        <p style="font-family:tahoma; font-size:13.5; font-color:#4d4949; line-height:21px">'''
        for g in groups:
            text += g + '<br>'
        text = text + '</p>'
        groupList.setText(text)

        # Research Area
        area_id = area_id.id()
        research_area_lyr = proj.mapLayersByName('Beräkningsområde')[0]
        query = "id = " + str(area_id)
        research_area_lyr.setSubsetString(query)
        for feature in research_area_lyr.getFeatures():
            s = feature['yta']
        area_info = sip.cast(composition.itemById("area_info"), QgsLayoutItemLabel)
        items = [['Beräkningsyta: ', str(int(float(s)))], ['Ekoeffektiv yta: ', str(int(float(total)))]]
        text2 = ""
        for i in items:
            text2 += '<font face="tahoma" color="#238973"><b>{}</b></font>\
            <p style="display:inline;font-family:tahoma; font-size:13.5; font-color:#4d4949; line-height:19px">{} m<sup>2</sup></p>\
            <br>'.format(i[0], i[1])
        area_info.setText(text2)
        extent = research_area_lyr.extent()

        # Map
        main_map = sip.cast(composition.itemById("map"), QgsLayoutItemMap)
        main_map.zoomToExtent(extent)
        composition.itemById("map").refresh()
        main_map.setKeepLayerSet(True)
        main_map.setKeepLayerStyles(True)

        # Legend
        legend = sip.cast(composition.itemById("legend"), QgsLayoutItemLegend)
        legend.setLegendFilterByMapEnabled(True)
        # Remove background map from legend - have to be checked out
        #root = QgsLayerTree()
        #for lyr in iface.mapCanvas().layers():
        #    if lyr.type() == QgsMapLayer.VectorLayer:
        #        root.addLayer(lyr)
        #    legend.model().setRootGroup(root)
        legend.setAutoUpdateModel(False)

        # Table
        # Filter
        feature_ids = "', '".join(i for i in feature_gids.keys())
        query = "gid in ('"+ feature_ids +"')"
        

        con = spatialite_connect(os.path.join(proj.readEntry("QGYF", "dataPath")[0], proj.readEntry("QGYF", 'activeDataBase')[0]))
        cur = con.cursor()

        cur.execute('SELECT * FROM classification WHERE ' + query)
        data = cur.fetchall()
        print(data)
        data = [list(d[1:-3]) + [str(d[-3]), "{:.1f}".format(feature_gids[d[0]]), "{:.1f}".format(feature_gids[d[0]]*d[-3])] for d in data]

        cur.close()
        con.close()

        if len(data) < 48:
            self.setTable([data], composition)
        else:
            pages = composition.pageCollection()
            data = [data[i:i + 48] for i in range(0, len(data), 48)]
            n = len(data)-1
            for nn in range(0, n):
                pages.extendByNewPage()
            self.setTable(data, composition)

        

         # label
        table_class = sip.cast(composition.itemById("table_class"), QgsLayoutItemLabel)
        table_name = '<font face="tahoma" color="#238973"><b>'+ model['Klass_items'][1].title() + 'er</b></font>'
        table_class.setText(table_name)

        # Diagram
        chart = sip.cast(composition.itemById("chart"), QgsLayoutItemPicture)
        chart.setPicturePath(chart_path)
        chart.refreshPicture()

        # Diagram
        chart2 = sip.cast(composition.itemById("chart2"), QgsLayoutItemPicture)
        if float(gyf) > 0.0:
            chart2.setPicturePath(os.path.join(proj.readEntry("QGYF", "dataPath")[0],'PieChart2.png'))
            chart2.refreshPicture()

        # Metadata
        text = '<p style="font-family:tahoma; font-size:13.5; font-color:#4d4949; line-height:21px">Område: {}\
        <br>Utförd av: {}<br>GYF version: {}<br>Datum: {}</p>'.format(area_name, author, gyf_version, date)
        info = sip.cast(composition.itemById("info"), QgsLayoutItemLabel)
        info.setText(text)
        info = sip.cast(composition.itemById("info1"), QgsLayoutItemLabel)
        info.setText(text)

        # EXPORT!
        QgsLayoutExporter(composition).exportToPdf(os.path.join(output_path, output_name), QgsLayoutExporter.PdfExportSettings())
        QMessageBox.information(ExportDialog(), 'Rapport', 'Din rapport har skapats! :)')

        # Reset map view
        research_area_lyr.setSubsetString('')

    def setTable(self, data, composition):
        c = 470
        for d in data:
            table = QgsLayoutItemTextTable(composition)
            # Add columns
            fields = ['Geometri', 'Filnamn', 'Grupp', 'Kvalitet', 'Faktor', 'Yta', 'Poäng'] # no gid
            cols = [QgsLayoutTableColumn(), QgsLayoutTableColumn(), QgsLayoutTableColumn(), QgsLayoutTableColumn(),
            QgsLayoutTableColumn(),QgsLayoutTableColumn(),QgsLayoutTableColumn()]
            width = [15, 25, 45, 15, 15, 15, 15]
            for n in range(0, len(fields)):
                cols[n].setHeading(fields[n])
                cols[n].setWidth(width[n])
            table.setColumns(cols)

            composition.addMultiFrame(table)
            table.setContents(d)

            frame = QgsLayoutFrame(composition, table)
            frame.attemptResize(QgsLayoutSize(20, 500), True)
            frame.attemptMove(QgsLayoutPoint(10, c, QgsUnitTypes.LayoutMillimeters))
            table.addFrame(frame)
            c += 300

            # table grid stroke
            table.setGridStrokeWidth(0.1) # 0.1 mm

            # content text
            content_text_format = QgsTextFormat()
            content_text_format.setColor(QColor('#4d4949'))
            content_text_format.setSize(7)

            # header text
            header_text_format = QgsTextFormat()
            header_text_format.setSize(8)
            header_text_format.setColor(QColor("#238973"))
            header_text_format.setNamedStyle("bold")

            version = float(Qgis.QGIS_VERSION[:4])
            print(version)
            if version >=3.16:
                print('here')
                table.setContentTextFormat(content_text_format)
                table.setHeaderTextFormat(header_text_format)