# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Rockyfor3DInputRasters
                                 A QGIS plugin
 This plugin prepares the input rasters for Rockyfor3D.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-04-24
        copyright            : (C) 2025 by ecorisQ
        email                : a.erbach@posteo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Alexandra Erbach'
__date__ = '2025-04-24'
__copyright__ = '(C) 2025 by ecorisQ'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import processing

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .rockyfor3d_inputs_provider import Rockyfor3DInputRastersProvider
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class Rockyfor3DInputRastersPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        
    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = Rockyfor3DInputRastersProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        
        icon = os.path.join(os.path.join(cmd_folder, 'Logo_IEA_Q.png'))
        self.action = QAction(
            QIcon(icon),
            u"Create Rockyfor3D Input Rasters", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addPluginToMenu(u"&ecorisQ", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginMenu(u"&ecorisQ", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        processing.execAlgorithmDialog("ecorisQ:rockyfor3Drasters")
