

from qgis.core import *
from qgis.PyQt import uic
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWidgets import *

from .storagesettings import StorageSettings

################################################################################

import os

def _form():
    path, ext = os.path.splitext(__file__)
    form, _ = uic.loadUiType(path+'.ui')
    return form

################################################################################
### Labels
################################################################################

import sys
_MODULE = sys.modules.get(__name__.split('.')[0])

_LABELS = _MODULE.LANGUAGE.LABELS({
    "STORAGEDIALOG_TITLE":
        "Central Storage Location"
    })

################################################################################
### Storage Dialog
################################################################################
'''
'''

class Dialog(QDialog, _form()):

    def __init__(self, parent):
        super().__init__(parent)
        self.setupUi(self)
        self.setWindowTitle(_LABELS.STORAGEDIALOG_TITLE)
        self._storageSettings = StorageSettings()
        self.layout().insertWidget(0, self._storageSettings)

    def askStorageLocation(self, path=None):
        self._storageSettings.setPath(path)
        if self.exec():
            return self._storageSettings.getPath()
