

from qgis.core import *
from qgis.PyQt import uic
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWidgets import *

from .storagesettings import StorageSettings
from ..database import Database

################################################################################

import os

def _form():
    path, ext = os.path.splitext(__file__)
    form, _ = uic.loadUiType(path+'.ui')
    return form

################################################################################
### Labels
################################################################################

import sys
_MODULE = sys.modules.get(__name__.split('.')[0])
_LABELS = _MODULE.LANGUAGE.LABELS({
    "SETTINGSDIALOG": {
        "TITLE":
            "Settings",
        "ADMINTOOLS": {
            "LABEL":
                "Hide Admin Tools"
            }
        }
    })

_LABELS = _LABELS.SETTINGSDIALOG

################################################################################
### Settings Dialog
################################################################################
'''
'''

class Dialog(QDialog, _form()):
    settingsChanged = pyqtSignal(object)

    class OPTIONS:
        class ADMINTOOLS:
            HIDE = "options/admintools/hide"

    def __init__(self, parent):
        super().__init__(parent)
        self.setupUi(self)
        self.setWindowTitle(_LABELS.TITLE)
        self._storageSettings = StorageSettings()
        self.layout().insertWidget(0, self._storageSettings)
        self.adminTools.setText(_LABELS.ADMINTOOLS.LABEL)
        self.adminTools.toggled.connect(self.adminToolsToggled)

    def adminToolsToggled(self, isChecked):
        path = self._storageSettings.getPath()
        hide = self.adminTools.isChecked()
        result = dict(path=path, hide=hide)
        self.settingsChanged.emit(result)

    def askSettings(self, responder=None):
        self.loadDialogSettings()
        if hasattr(responder, 'settingsChanged'):
            self.settingsChanged.connect(responder.settingsChanged)
        if self.exec():
            return self.saveDialogSettings()
        self.loadDialogSettings()

    def loadDialogSettings(self):
        Settings = _MODULE.plugin.Settings
        path = Database.getGlobalPath()
        hide = Settings.getGlobalValue(self.OPTIONS.ADMINTOOLS.HIDE)
        hide = hide in (True, 'true', 'True', 'TRUE')
        self._storageSettings.setPath(path)
        self.adminTools.setChecked(hide)

    def saveDialogSettings(self):
        path = self._storageSettings.getPath()
        hide = self.adminTools.isChecked()
        Settings = _MODULE.plugin.Settings
        if path != Database.getGlobalPath():
            Database.setGlobalPath(path)
            Database(path).start()
        Settings.setGlobalValue(self.OPTIONS.ADMINTOOLS.HIDE, hide)
        return dict(path=path, hide=hide)
