# -*- coding: utf-8 -*-
"""
/***************************************************************************
 getwkt3Dialog
                                 A QGIS plugin
 This plugin displays the selected features' WKT representation.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-03-13
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Paul Skeen
        email                : paulskeen@spatialecology.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import QApplication
from qgis.core import Qgis
from qgis.utils import iface

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'getwkt3_dialog_base.ui'))

class getwkt3Dialog(QtWidgets.QDialog, FORM_CLASS):
    """Get dialog class"""
    def __init__(self, parent=None):
        """Constructor."""
        super(getwkt3Dialog, self).__init__(parent)
        self.setupUi(self)
        self.pushButton.clicked.connect(self.handleHide)
        self.copyButton.clicked.connect(self.copyAndHide)

    def handleHide(self):
        """Hide handle"""
        self.hide()

    def copyAndHide(self):
        """Copy the WKT content and close"""
        clipboard = QApplication.clipboard()
        wkt_text = self.wktTextEdit.toPlainText()
        if "ERROR" in wkt_text:
            iface.messageBar().pushMessage("Get WKT", "There is no WKT to copy!", level=Qgis.Warning, duration=5)
            return
        clipboard.setText(wkt_text)
        iface.messageBar().pushMessage("Get WKT", "WKT copied to clipboard", level=Qgis.Info, duration=5)
        self.handleHide()
