# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SocialBurdenCalculatorDialog
                                 A QGIS plugin
 This plugin calculates social burden
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-08-30
        git sha              : $Format:%H$
        email                : oehart@sandia.gov
 ***************************************************************************/

"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'social_burden_calculator_dialog_base.ui'))


class SocialBurdenCalculatorDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(SocialBurdenCalculatorDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)


    # ---------facilities data getters ----------
    def getFacilitiesLayerName(self): 
        return str(self.layerComboBox_facilities.currentText())
        
    def getFacilitiesIndexFieldName(self): 
        return str(self.FieldComboBox_facilityIndex.currentText())
    
    def getFacilitiesHaveLatLongs(self): 
        return self.checkBox_facilityLatLongs.isChecked()
    
    
    def getFacilitiesLatFieldName(self): 
        return str(self.ComboBox_facilityLat.currentText())
    
    def getFacilitiesLongFieldName(self): 
        return str(self.ComboBox_facilityLong.currentText())
        
    def getFacilitiesSectorFieldName(self): 
        return str(self.FieldComboBox_facilitySector.currentText())
        
        
        
        
    # ----------population data getters -------
    
    def getPopulationLayerName(self): 
        return str(self.layerComboBox_popBlock.currentText())
    
    def getPopulationHasCentroids(self): 
        return self.checkBox_hasCentroids.isChecked()
    
    def getPopulationLatField(self): 
        return str(self.ComboBox_centroidLat.currentText()) #field with override latitude
    
    def getPopulationLongField(self): 
        return str(self.ComboBox_centroidLong.currentText()) #field with override latitude
    
    def getPopulationIndexField(self): 
        return str(self.FieldComboBox_popIndex.currentText()) #field that  holds indices of population groups
        
    def getPopulationPopulationField(self): 
        return str(self.FieldComboBox_popCount.currentText()) #field that holds populations of each population group
        
    def getPopulationAttainFactorField(self): 
        return str(self.FieldComboBox_attainmentFactor.currentText()) 
        
        
        
        
    #------ sector to service mapping table getters ----------
    
    def getSectorToServiceLayerName(self): 
        return str(self.layerComboBox_sectorServiceMapping.currentText())
        
    def getSectorToServiceSectorField(self): 
        return str(self.FieldComboBox_sectortoServiceSector.currentText())
    
    def getSectorToServiceEffortPerFootField(self): 
        return str(self.FieldComboBox_effortPerFoot.currentText())
    
    def getSectorToServiceZeroDistanceEffortField(self): 
        return str(self.FieldComboBox_effortZeroDistance.currentText())
        
    
    
    # --------- exclusion profile getters ------
    
    def getHasExclusionProfile(self): 
        return self.checkBox_hasExclusionLayer.isChecked()
        
    def getExclusionLayerName(self): 
        return str(self.layerComboBox_exclusion.currentText())

    
    def getExclusionServiceLevelReduction(self): 
        #this needs to stay as a string for downstream reasons
        return str(self.spinBox_exclusionPctReduction.value())
        
        
        
        
        
    # ----------- export getters ------------
    def exportToCSV(self): 
        return self.checkBox_exportToCsv.isChecked()
        
    def getPerCapitaCsvOutputPath(self): 
        return self.lineEdit_outFilePerPopulationGroup.text()
        
    def getAggregatedCsvOutputPath(self): 
        return self.lineEdit_outFileAggregatedPopulation.text()
        
    def exportToRencat(self): 
        return self.checkBox_exportToRencat.isChecked()
        
    def getExportToRencatPath(self): 
        return self.lineEdit_outFileRencatInput.text()
        
    def exportAsRencatOutput(self): 
        return self.checkBox_exportAsRencatOutput.isChecked()
        
    def getExportAsRencatOutputPath(self): 
        return self.lineEdit_outFileRencatOutput.text()