# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LegendView
                                 A QGIS plugin
 凡例を表示する
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2020 by soja city.
        email                : none
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import re

# Import Qt compatibility module first
from .qt_compat import QSettings, QTranslator, QCoreApplication, Qt, QIcon, QAction, QDockWidget, WA_DeleteOnClose, RightDockWidgetArea, translate, is_qt5, is_qt6, QT_VERSION, QtWidgets, QSize

from qgis.core import QgsSettings, QgsMessageLog, QgsProject, QgsExpressionContextUtils

# Initialize Qt resources from file resources.py
if is_qt5():
    # Qt5 specific resource file with forced registration
    try:
        from . import resources_rc_qt5
        # Force resource registration for Qt5 multiple times if needed
        resources_rc_qt5.qInitResources()
        # Double-check registration
        if hasattr(resources_rc_qt5, 'qInitResources'):
            resources_rc_qt5.qInitResources()
    except ImportError:
        try:
            from .resources_rc import *
        except:
            pass
else:
    # Qt6 and fallback
    from .resources_rc import *

# Import version information
from .version import __version__, get_version_info, get_compatibility_info

# Import the code for the DockWidget
from .legend_view_dockwidget import LegendViewDockWidget
import os.path

class LegendView:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale (default: English)
        locale = QSettings().value('locale/userLocale', 'en')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LegendView_{}.qm'.format(locale))

        # Try to load Qt translator (QGIS標準)
        self.translator = None
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            if self.translator.load(locale_path):
                QCoreApplication.installTranslator(self.translator)
            else:
                self.translator = None

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Legend View')  # Default to English, will be translated
        # No custom toolbar - using standard QGIS plugin toolbar
        
        #print "** INITIALIZING LegendView"

        self.pluginIsActive = False
        self.dockwidget = None

        # Show window if project variable contains its own name
        iface.projectRead.connect(self.checkLoadedProject)

    def __del__(self):
        if self.pluginIsActive:
            self.storeState()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """QGIS/Qt標準の翻訳APIのみ"""
        return QCoreApplication.translate('LegendView', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        # Create icon - simple and reliable approach
        icon = QIcon()
        
        # Try multiple approaches in order of reliability
        import os
        
        # Method 1: File system path (most reliable)
        if icon_path.startswith(':/'):
            file_name = os.path.basename(icon_path)
            file_path = os.path.join(os.path.dirname(__file__), file_name)
        else:
            file_path = icon_path
            
        if os.path.exists(file_path):
            icon = QIcon(file_path)
        
        # Method 2: Resource path (if file system failed)
        if icon.isNull() and icon_path.startswith(':/'):
            icon = QIcon(icon_path)
        
        # Method 3: Create simple fallback icon if both failed
        if icon.isNull():
            icon = self.create_fallback_icon()
        
        # Qt6ではparent=NoneでQAction生成（ツールバー表示対策）
        if is_qt6():
            action = QAction(icon, text)
        else:
            action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Add to the standard QGIS plugin toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        icon_path = ':/plugins/legend_view/icon.png'
        
        self.add_action(
            icon_path,
            text=self.tr(u'Legend'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING LegendView"

        self.storeState()

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        self.dockwidget = None
        
        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD LegendView"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Legend View'),  # Default to English, will be translated
                action)
            self.iface.removeToolBarIcon(action)
        # No custom toolbar to remove - using standard plugin toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING LegendView"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = LegendViewDockWidget(self.iface)
                self.dockwidget.setAttribute(WA_DeleteOnClose)

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            self.restoreState()

        if self.dockwidget:
            if self.dockwidget.isFloating():
                self.dockwidget.activateWindow()
            else:
                self.dockwidget.raise_()
                
    def onProjectClose(self):
        if self.dockwidget:
            self.dockwidget.close()

    def storeState(self):
        if not self.dockwidget:
            return

        s = QgsSettings()
        is_floating = "1" if self.dockwidget.isFloating() else "0"
        s.setValue("LegendView/isfloating", is_floating)
        s.setValue("LegendView/geometry", self.dockwidget.saveGeometry())

    def restoreState(self):
        s = QgsSettings()
        is_floating = s.value("LegendView/isfloating", "0") == "1"

        if is_floating:
            self.iface.addDockWidget(RightDockWidgetArea, self.dockwidget)
            geometry = s.value("LegendView/geometry", "")
            if not geometry.isEmpty():
                self.dockwidget.restoreGeometry(bytearray(geometry))
            self.dockwidget.setFloating(True)

        else:
            self.dockwidget.setFloating(False)
            if not self.iface.mainWindow().restoreDockWidget(self.dockwidget):
                self.iface.addDockWidget(RightDockWidgetArea, self.dockwidget)

        self.dockwidget.show()

    def checkLoadedProject(self):
        # Do nothing if already active
        if self.pluginIsActive:
            return

        # Tests whether a variable with "plugin_" + menu name exists in the scope.
        ecs = QgsExpressionContextUtils.projectScope(QgsProject.instance())
        menu_text = re.sub(r"^&", "", self.menu)
        name = f"plugin_{menu_text}"
        if ecs.hasVariable(name):
            value = ecs.variable(name)
            if value == "1":
                self.run()

    def create_fallback_icon(self):
        """Create a simple fallback icon when other methods fail"""
        try:
            # Import Qt modules based on version
            if is_qt5():
                from PyQt5.QtGui import QPixmap, QPainter, QColor, QPen
                from PyQt5.QtCore import Qt
            else:
                from PyQt6.QtGui import QPixmap, QPainter, QColor, QPen
                from PyQt6.QtCore import Qt
            
            # Create a simple 24x24 icon
            pixmap = QPixmap(24, 24)
            pixmap.fill(Qt.transparent)
            
            painter = QPainter(pixmap)
            painter.setRenderHint(QPainter.Antialiasing)
            
            # Draw a simple legend-like icon
            painter.setPen(QPen(QColor(50, 50, 150), 2))
            painter.setBrush(QColor(200, 220, 255))
            painter.drawRect(2, 2, 20, 20)
            
            # Add some lines to represent legend entries
            painter.setPen(QPen(QColor(100, 100, 100), 1))
            painter.drawLine(5, 8, 19, 8)
            painter.drawLine(5, 12, 19, 12)
            painter.drawLine(5, 16, 19, 16)
            
            painter.end()
            
            return QIcon(pixmap)
        except:
            # Return empty icon if even fallback fails
            return QIcon()



