from qgis.core import QgsProject, QgsVectorLayer, QgsRasterLayer, QgsMapLayer, QgsExpressionContextUtils, QgsLayerTreeGroup, QgsLayerTreeLayer, QgsRenderContext
from qgis.core import QgsWkbTypes
# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LegendViewDockWidget
                                 A QGIS plugin
 Display legend
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2020 by soja city.
        email                : none
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

#QMessageBox.information(self,'Message',type(layer).__name__,QMessageBox.Ok)

import os
import re
from io import BytesIO

# Import Qt compatibility module
from .qt_compat import *

# Use QGIS-provided PyQt bindings to remain version independent
from qgis.PyQt.QtWidgets import QDialog, QVBoxLayout, QPushButton, QInputDialog, QMessageBox, QHBoxLayout

from qgis.core import *
from qgis.gui import *

# Import resources explicitly
from . import resources_rc

from operator import itemgetter

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'legend_view_dockwidget_base.ui'))


class LegendViewDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Constructor."""
        super(LegendViewDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # Set window icon for dock widget - try multiple approaches
        try:
            # Method 1: Direct resource path
            icon_path = ':/plugins/legend_view/icon.png'
            icon = QIcon(icon_path)
            self.setWindowIcon(icon)
            
            # Method 2: Alternative approach with file path
            if icon.isNull():
                import os
                file_path = os.path.join(os.path.dirname(__file__), 'icon.png')
                if os.path.exists(file_path):
                    icon = QIcon(file_path)
                    self.setWindowIcon(icon)
        except Exception as e:
            # Fallback - continue without icon
            pass
        
        self.iface = iface
        self.currentLayer = None
        self.root = QgsProject.instance().layerTreeRoot()

        # Qt5/Qt6 compatible orientation usage
        if is_qt5():
            vheader = QHeaderView(Qt.Vertical)
            hheader = QHeaderView(Qt.Horizontal)
        else:
            vheader = QHeaderView(QtOrientation.Vertical)
            hheader = QHeaderView(QtOrientation.Horizontal)
            
        self.tableWidget.setVerticalHeader(vheader)
        self.tableWidget.setHorizontalHeader(hheader)
        self.tableWidget.setHorizontalHeaderLabels([self.tr("Symbol"), self.tr("Legend")])
        self.tableWidget.setSelectionMode(NoSelection)
        self.styleComboBox.setVisible(False)
        self.styleLabel.setVisible(False)

        self.comboDataSet()
        self.comboBox.currentIndexChanged.connect(self.currentIndexChanged)
        self.mOpacityWidget.opacityChanged.connect(self.opacityChanged)
        
        # Connect current layer button
        self.currentLayerButton.clicked.connect(self.selectCurrentLayer)
        # Connect register button to save current layer as project variable
        try:
            self.registerButton.clicked.connect(self.registerCurrentLayer)
        except Exception:
            # If UI doesn't have the button for any reason, ignore
            pass
        try:
            self.varsButton.clicked.connect(self.showLegendVariables)
        except Exception:
            pass
        
        # Qt5/Qt6 compatible signal connection
        try:
            # Try Qt6 approach first
            self.styleComboBox.currentTextChanged.connect(self.changeNamedStyle)
        except AttributeError:
            try:
                # Qt5 approach with QString
                self.styleComboBox.currentIndexChanged['QString'].connect(self.changeNamedStyle)
            except (KeyError, TypeError):
                # Fallback: use index changed and get text manually
                self.styleComboBox.currentIndexChanged.connect(self._styleComboBoxIndexChanged)
                
        self.comboBox.setCurrentIndex(-1)
        self.comboBox.setCurrentIndex(0)
        self.showLegend()

    def tr(self, message):
        """QGIS/Qt標準の翻訳APIに統一"""
        return QCoreApplication.translate('LegendView', message)

    def closeEvent(self, event):        
        self.closingPlugin.emit()
        event.accept()

    def showLegend(self):
        layer = self.currentLayer
        if layer is None:
            return

        # Create named style list
        self.initNamedStyleList(layer)

        if isinstance(layer,QgsVectorLayer):
            symbols = layer.renderer().symbols(QgsRenderContext())
            legendItems = layer.renderer().legendSymbolItems()
            self.mOpacityWidget.setOpacity( layer.opacity())
            self.tableWidget.setVisible(True)
            self.tableWidget.horizontalHeader().setDefaultSectionSize(65)
            
            # Qt6 requires larger row height for better symbol display
            if is_qt6():
                self.tableWidget.verticalHeader().setDefaultSectionSize(30)  # Same as Qt5
            else:
                self.tableWidget.verticalHeader().setDefaultSectionSize(30)  # Standard for Qt5
                
            self.tableWidget.setRowCount(len(symbols))
            self.tableWidget.setColumnCount(2)
            self.tableWidget.horizontalHeader().setStretchLastSection(True)

            pm_icon_size = self.tableWidget.style().pixelMetric(PM_ListViewIconSize)
            
            # Use same size for both Qt5 and Qt6
            icon_size = QSize(self.tableWidget.columnWidth(0) - 10, pm_icon_size)

            i = 0
            for symbol in symbols:
                item1 = QTableWidgetItem()
                label = QLabel()
                # Use Qt version-specific alignment function
                setLabelAlignment(label)
                # Use Qt version-specific symbol preview function for better SVG support
                pixmap = createSymbolPreview(symbol, icon_size)
                label.setPixmap(pixmap)
                self.tableWidget.setCellWidget(i,0,label)
                i+=1

            j = 0
            for legendItem in legendItems :
                label = legendItem.label()
                other_item = not bool(label)
                item2 = QTableWidgetItem(self.tr("Other values") if other_item else legendItem.label())
                if other_item:
                    font = QFont()
                    font.setItalic(True)
                    item2.setFont(font)

                self.tableWidget.setItem(j,1,item2)
                j+=1
            
            self.listWidget.setVisible(False)

        if isinstance(layer,QgsRasterLayer):
            self.tableWidget.setVisible(False)
            self.listWidget.setVisible(True)
            self.mOpacityWidget.setOpacity( layer.renderer().opacity())
        
    def opacityChanged(self,opacity):
        layer = self.currentLayer
        if layer is None:
            return

        if isinstance(layer,QgsVectorLayer):
            layer.setOpacity(opacity)
        if isinstance(layer,QgsRasterLayer):
            layer.renderer().setOpacity(opacity)
        layer.triggerRepaint()

    def legendChanged(self):
        self.showLegend()
    
    def getLayer(self,groups):
        node = self.root

        for group in groups[:len(groups)-1]:
            next_node = node.findGroup(group)
            if isinstance(next_node, QgsLayerTreeGroup):
                node = next_node
            else:
                return None

        for child in node.children():
            if isinstance(child, QgsLayerTreeLayer):
                if child.name() == groups[len(groups)-1]:
                    return child.layer()

        return None

    def findLayerByVariableName(self, layer_name_str):
        """Resolve a legend_ variable value to a QgsMapLayer.

        The project variable stores the layer path as groups + layer name joined by '_' which
        is ambiguous if any group or layer name contains underscores. Try all possible
        split positions where the last element is treated as the layer name (may contain
        underscores) and return the first matching layer.
        """
        if not layer_name_str:
            return None

        tokens = layer_name_str.split('_')

        # Try every possible split: tokens[:i] are groups, '_'.join(tokens[i:]) is layer name
        for i in range(0, len(tokens)):
            candidate = tokens[:i] + ['_'.join(tokens[i:])]
            layer = self.getLayer(candidate)
            if isinstance(layer, QgsMapLayer):
                return layer

        return None

    def comboDataSet(self) :
        ecs = QgsExpressionContextUtils.projectScope(QgsProject.instance())
        slist = ecs.variableNames()
        layerIdList = []
        layerIdList2 = []
        
        # Process layers with legend_ variables
        for sstr in slist:
            if "legend_" not in sstr:
                continue
            layer_name = sstr.replace("legend_","")
            # Try to resolve the layer even if group or layer names contain underscores
            layer = self.findLayerByVariableName(layer_name)
            if isinstance(layer, QgsMapLayer) :
                # Get variable value and handle None safely
                variable_value = ecs.variable(sstr)
                self.distributeOrderList(layer.id(), layer_name, variable_value, layerIdList, layerIdList2)

        # Add current active layer if not already in the list
        current_layer = self.iface.activeLayer()
        if current_layer and isinstance(current_layer, (QgsVectorLayer, QgsRasterLayer)):
            # Check if current layer is not already in the lists
            existing_ids = [item[0] for item in layerIdList + layerIdList2]
            if current_layer.id() not in existing_ids:
                # Add current layer to the beginning of layerIdList2 with high priority
                layerIdList2.insert(0, [current_layer.id(), f"current_{current_layer.name()}"])

        if len(layerIdList) > 0:
            layerIdList.sort(key=itemgetter(1))
        if len(layerIdList2) > 0:
            layerIdList2.sort(key=itemgetter(1))
        layerIdList.extend(layerIdList2)

        for layerid in layerIdList:
            layer = QgsProject.instance().mapLayer(layerid[0])
            icon = QIcon()
            if isinstance(layer,QgsRasterLayer):
                icon = QIcon()  # 代替: 空アイコンまたは適切なアイコンに置き換え

            elif  isinstance(layer,QgsVectorLayer):
                if ( layer.geometryType() == QgsWkbTypes.PointGeometry ) :
                    icon = QIcon()  # 代替: 空アイコンまたは適切なアイコンに置き換え
                elif ( layer.geometryType() == QgsWkbTypes.LineGeometry ) :
                    icon = QIcon()
                elif ( layer.geometryType() == QgsWkbTypes.PolygonGeometry ) :
                    icon = QIcon()
            else :
                continue

            # Display name with current layer indicator
            display_name = layer.name()
            if isinstance(layerid[1], str) and layerid[1].startswith("current_"):
                display_name = f"★ {layer.name()} (Current)"
                
            self.comboBox.addItem(icon, display_name, layerid[0])
            # Detect and handle legend change signal for target layer
            layer.legendChanged.connect(self.legendChanged)

    
    def currentIndexChanged(self,index):
        self.currentLayer = QgsProject.instance().mapLayer(self.comboBox.itemData(index))
        self.showLegend()

    def initNamedStyleList(self, layer: QgsMapLayer):
        # Create named style list

        self.styleComboBox.blockSignals(True)
        self.styleComboBox.setVisible(False)
        self.styleLabel.setVisible(False)
        self.styleComboBox.clear()

        if isinstance(layer, QgsMapLayer):
            manager = layer.styleManager()
            style_count = len(manager.styles())

            if style_count > 0:
                self.styleComboBox.setVisible(style_count > 1)
                self.styleLabel.setVisible(style_count > 1)

                for idx, name in enumerate(manager.styles()):
                    self.styleComboBox.addItem(name)
                    if name == manager.currentStyle():
                        self.styleComboBox.setCurrentIndex(idx)

        self.styleComboBox.blockSignals(False)

    def changeNamedStyle(self, styleName):
        # Set the layer style with the specified name
        self.currentLayer.styleManager().setCurrentStyle(styleName)

    def distributeOrderList(self, layer_id, layer_name, orderValue, numericList: list, nonNumericList: list):

        while True:
            # Check for None or QVariant null values first
            if orderValue is None or isinstance(orderValue, QVariant):
                break
            
            # Convert to string if not already
            if not isinstance(orderValue, str):
                try:
                    orderValue = str(orderValue)
                except:
                    break

            m = re.fullmatch(r"\d+", orderValue)
            if not m is None:
                numericList.append([layer_id, int(orderValue)])
                return

            n = re.fullmatch(r"\d*\.\d+", orderValue)
            if not n is None:
                numericList.append([layer_id, float(orderValue)])
                return
            
            break
        
        nonNumericList.append([layer_id, layer_name])

    def _styleComboBoxIndexChanged(self, index):
        """Fallback method for Qt5/Qt6 compatibility when currentTextChanged is not available"""
        if index >= 0:
            styleName = self.styleComboBox.itemText(index)
            self.changeNamedStyle(styleName)

    def selectCurrentLayer(self):
        """Select the currently active layer"""
        current_layer = self.iface.activeLayer()
        if current_layer:
            # Search for the corresponding layer from the combo box
            for i in range(self.comboBox.count()):
                if self.comboBox.itemData(i) == current_layer.id():
                    self.comboBox.setCurrentIndex(i)
                    return
            
            # コンボボックスにない場合は、リストを更新して再度検索
            self.comboBox.clear()
            self.comboDataSet()
            for i in range(self.comboBox.count()):
                if self.comboBox.itemData(i) == current_layer.id():
                    self.comboBox.setCurrentIndex(i)
                    return

    def registerCurrentLayer(self):
        """Register the currently active layer as a project variable named legend_<group>_<layer>

        The variable name is derived from the layer tree path (groups + layer name) joined by '_'.
        The value is left empty (or could be a numeric priority if desired).
        """
        current_layer = self.iface.activeLayer()
        if not current_layer:
            return

        # Build layer path: traverse layer tree to get group path
        def find_path(node, target_layer_id, path_parts):
            for child in node.children():
                if isinstance(child, QgsLayerTreeLayer):
                    if child.layer().id() == target_layer_id:
                        return path_parts + [child.name()]
                elif isinstance(child, QgsLayerTreeGroup):
                    res = find_path(child, target_layer_id, path_parts + [child.name()])
                    if res:
                        return res
            return None

        root = QgsProject.instance().layerTreeRoot()
        path = find_path(root, current_layer.id(), [])
        if not path:
            # fallback to layer name only
            path = [current_layer.name()]

        var_name = 'legend_' + '_'.join(path)

        # Get priority value from spin box if available
        try:
            priority = str(self.prioritySpinBox.value())
        except Exception:
            priority = ''

        # Try to set project variable via QgsExpressionContextUtils if available
        try:
            QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), var_name, priority)
        except Exception:
            # Fallback: use project writeEntry to store under 'LegendView' group
            try:
                QgsProject.instance().writeEntry('LegendView', var_name, priority)
            except Exception:
                # give up silently
                return

        # Refresh combo box dataset and select the new variable's layer
        self.comboBox.clear()
        self.comboDataSet()
        for i in range(self.comboBox.count()):
            if self.comboBox.itemData(i) == current_layer.id():
                self.comboBox.setCurrentIndex(i)
                break

    def showLegendVariables(self):
        """Show a dialog listing project variables that start with 'legend_'."""
        ecs = QgsExpressionContextUtils.projectScope(QgsProject.instance())
        vars_list = [v for v in ecs.variableNames() if v.startswith('legend_')]

        dlg = QDialog(self)
        dlg.setWindowTitle(self.tr('Legend variables'))
        layout = QVBoxLayout(dlg)

        table = QTableWidget(dlg)
        table.setColumnCount(2)
        table.setHorizontalHeaderLabels([self.tr('Variable'), self.tr('Value')])
        table.setRowCount(len(vars_list))
        # allow row selection for edit/delete
        try:
            table.setSelectionBehavior(QtWidgets.QAbstractItemView.SelectRows)
            table.setSelectionMode(QtWidgets.QAbstractItemView.SingleSelection)
        except Exception:
            pass

        for i, name in enumerate(sorted(vars_list)):
            value = ecs.variable(name)
            item_name = QTableWidgetItem(name)
            item_value = QTableWidgetItem('' if value is None else str(value))
            item_name.setFlags(item_name.flags() & ~Qt.ItemIsEditable)
            item_value.setFlags(item_value.flags() & ~Qt.ItemIsEditable)
            table.setItem(i, 0, item_name)
            table.setItem(i, 1, item_value)

        table.horizontalHeader().setStretchLastSection(True)
        layout.addWidget(table)
        # Buttons: Edit, Delete, Close
        btn_layout = QHBoxLayout()
        edit_btn = QPushButton(self.tr('Edit'), dlg)
        del_btn = QPushButton(self.tr('Delete'), dlg)
        close_btn = QPushButton(self.tr('Close'), dlg)
        edit_btn.clicked.connect(lambda: self.editLegendVariable(table))
        del_btn.clicked.connect(lambda: self.deleteLegendVariable(table))
        close_btn.clicked.connect(dlg.accept)
        btn_layout.addWidget(edit_btn)
        btn_layout.addWidget(del_btn)
        btn_layout.addWidget(close_btn)
        layout.addLayout(btn_layout)

        dlg.exec_()

    def editLegendVariable(self, table: QTableWidget):
        sel = table.selectionModel().selectedRows()
        if not sel:
            return
        row = sel[0].row()
        name_item = table.item(row, 0)
        val_item = table.item(row, 1)
        if name_item is None:
            return
        name = name_item.text()
        old = '' if val_item is None else val_item.text()

        text, ok = QInputDialog.getText(self, self.tr('Edit variable'), self.tr('Value for %s') % name, text=old)
        if not ok:
            return

        new_value = text
        try:
            QgsExpressionContextUtils.setProjectVariable(QgsProject.instance(), name, new_value)
        except Exception:
            try:
                QgsProject.instance().writeEntry('LegendView', name, new_value)
            except Exception:
                QMessageBox.warning(self, self.tr('Error'), self.tr('Could not update variable'))
                return

        # update table
        table.setItem(row, 1, QTableWidgetItem(new_value))

    def deleteLegendVariable(self, table: QTableWidget):
        sel = table.selectionModel().selectedRows()
        if not sel:
            return
        row = sel[0].row()
        name_item = table.item(row, 0)
        if name_item is None:
            return
        name = name_item.text()

        resp = QMessageBox.question(self, self.tr('Confirm delete'), self.tr('Delete variable %s?') % name, QMessageBox.Yes | QMessageBox.No)
        if resp != QMessageBox.Yes:
            return

        # attempt removal
        try:
            # try API if available
            QgsExpressionContextUtils.removeProjectVariable(QgsProject.instance(), name)
        except Exception:
            try:
                # fallback: write empty string or None
                QgsProject.instance().writeEntry('LegendView', name, None)
            except Exception:
                QMessageBox.warning(self, self.tr('Error'), self.tr('Could not remove variable'))
                return

        # remove row from table
        table.removeRow(row)
