# QFAT01 Flow Estimator (QGIS Plugin)

QFAT01 Flow Estimator is a QGIS plugin for quick open-channel checks. It samples a cross-section (XS) profile from a DEM along a user-drawn line, plots chainage vs elevation, and uses Manning's equation to estimate discharge Q (m3/s) or water surface level (WSL), reporting wetted area (A), wetted perimeter (P), hydraulic radius (R), velocity and freeboard. Optional exclusion zones by chainage let you ignore parts of the profile in both calculations and plotting.

This tool is part of QFAT (QGIS Flood Analysis Toolkit) - a set of focused QGIS utilities designed to support flood modelling workflows (e.g., TUFLOW, HEC-RAS), hydraulic QA, and rapid engineering checks.

## Units
Q (m3/s), WSL (m), A (m2), P (m), R (m).

## Install (ZIP)
QGIS -> Plugins -> Manage and Install Plugins -> Install from ZIP

## Links
- GitHub: https://github.com/FGE-2025/QFAT01-Flow-Estimator
- Issues: https://github.com/FGE-2025/QFAT01-Flow-Estimator/issues

## Tags
flood,hydraulic,manning,open channel,cross section,xs,profile,water surface level,wsl,flow,discharge,wetted area,wetted perimeter,hydraulic radius,freeboard,qfat,normal depth

## License
GPL-2.0-or-later (see LICENSE)
