# Purpose: Standard definitions
# Created: 08.07.2015
# Copyright (C) 2015, Manfred Moitzi
# License: MIT License

# pattern type: predefined (1)
PATTERN = {
    'ANSI31': [[45.0, (0.0, 0.0), (-0.0883883476483184, 0.0883883476483185), []]],
    'ANSI32': [[45.0, (0.0, 0.0), (-0.2651650429449553, 0.2651650429449553), []],
               [45.0, (0.176776695, 0.0), (-0.2651650429449553, 0.2651650429449553), []]],
    'ANSI33': [[45.0, (20.0, 0.0), (-0.1767766952966369, 0.1767766952966369), []],
               [45.0, (20.176776695, 0.0), (-0.1767766952966369, 0.1767766952966369), [0.125, -0.0625]]],
    'ANSI34': [[45.0, (0.0, 0.0), (-0.5303300858899106, 0.5303300858899107), []],
               [45.0, (0.176776695, 0.0), (-0.5303300858899106, 0.5303300858899107), []],
               [45.0, (0.353553391, 0.0), (-0.5303300858899106, 0.5303300858899107), []],
               [45.0, (0.5303300860000002, 0.0), (-0.5303300858899106, 0.5303300858899107), []]],
    'ANSI35': [[45.0, (-40.0, -10.0), (-0.1767766952966369, 0.1767766952966369), []],
               [45.0, (-39.823223305, -10.0), (-0.1767766952966369, 0.1767766952966369),
                [0.3125, -0.0625, 0.0, -0.0625]]],
    'ANSI36': [[45.0, (-40.0, -10.0), (0.0662912607362388, 0.2430679560328757), [0.3125, -0.0625, 0.0, -0.0625]]],
    'ANSI37': [[45.0, (0.0, 0.0), (-0.0883883476483184, 0.0883883476483185), []],
               [135.0, (0.0, 0.0), (-0.0883883476483185, -0.0883883476483184), []]],
    'ANSI38': [[45.0, (0.0, 0.0), (-0.0883883476483184, 0.0883883476483185), []],
               [135.0, (0.0, 0.0), (-0.2651650429449553, 0.0883883476483185), [0.3125, -0.1875]]],
    'ACAD_ISO02W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3]]],
    'ACAD_ISO03W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -1.8]]],
    'ACAD_ISO04W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3]]],
    'ACAD_ISO05W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3, 0.05, -0.3]]],
    'ACAD_ISO06W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3, 0.05, -0.65]],
                       [0.0, (0.0, 0.0), (0.0, 0.5), [-3.4, 0.05, -0.3]]],
    'ACAD_ISO07W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [0.05, -0.3]]],
    'ACAD_ISO08W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.6000000000000001, -0.3]]],
    'ACAD_ISO09W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.6000000000000001, -0.3, 0.6000000000000001, -0.3]]],
    'ACAD_ISO10W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3]]],
    'ACAD_ISO11W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -0.3]]],
    'ACAD_ISO12W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3, 0.05, -0.3]]],
    'ACAD_ISO13W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -0.65]],
                       [0.0, (0.0, 0.0), (0.0, 0.5), [-3.35, 0.05, -0.3]]],
    'ACAD_ISO14W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3, 0.05, -0.65]],
                       [0.0, (0.0, 0.0), (0.0, 0.5), [-2.2, 0.05, -0.3]]],
    'ACAD_ISO15W100': [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -1.0]],
                       [0.0, (0.0, 0.0), (0.0, 0.5), [-3.35, 0.05, -0.3, 0.05, -0.3]]],
    'ANGLE': [[0.0, (0.0, 0.0), (0.0, 0.275), [0.2, -0.075]], [90.0, (0.0, 0.0), (-0.275, 0.0), [0.2, -0.075]]],
    'AR-B816': [[0.0, (0.0, 0.0), (0.0, 0.8), []], [90.0, (0.0, 0.0), (-0.8, 0.8), [0.8, -0.8]]],
    'AR-B816C': [[0.0, (0.0, 0.0), (0.8, 0.8), [1.5625, -0.0375]], [0.0, (-0.8, 0.0375), (0.8, 0.8), [1.5625, -0.0375]],
                 [90.0, (0.0, 0.0), (-0.8, 0.8), [-0.8375, 0.7625000000000001]],
                 [90.0, (-0.0375, 0.0), (-0.8, 0.8), [-0.8375, 0.7625000000000001]]],
    'AR-B88': [[0.0, (0.0, 0.0), (0.0, 0.8), []], [90.0, (0.0, 0.0), (-0.4, 0.8), [0.8, -0.8]]],
    'AR-BRELM': [[0.0, (0.0, 0.0), (0.0, 2.666999999999999), [3.8125, -0.1875]],
                 [0.0, (0.0, 1.125), (0.0, 2.666999999999999), [3.8125, -0.1875]],
                 [0.0, (1.0, 1.333499999999999), (0.0, 2.666999999999999), [1.8125, -0.1875]],
                 [0.0, (1.0, 2.458499999999999), (0.0, 2.666999999999999), [1.8125, -0.1875]],
                 [90.0, (0.0, 0.0), (-4.0, 2e-16), [1.125, -1.541999999999999]],
                 [90.0, (-0.1875, 0.0), (-4.0, 2e-16), [1.125, -1.541999999999999]],
                 [90.0, (1.0, 1.333499999999999), (-2.0, 1e-16), [1.125, -1.541999999999999]],
                 [90.0, (0.8125, 1.333499999999999), (-2.0, 1e-16), [1.125, -1.541999999999999]]],
    'AR-BRSTD': [[0.0, (0.0, 0.0), (0.0, 2.666999999999999), []],
                 [90.0, (0.0, 0.0), (-4.0, 2.667), [2.666999999999999, -2.666999999999999]]],
    'AR-CONC': [[50.0, (0.0, 0.0), (1.434520365201507, -0.1255042699651902), [0.15, -1.65]],
                [355.0, (0.0, 0.0), (-0.277502667226, 1.504384267400023), [0.12, -1.32]],
                [100.45144446, (0.119543362, -0.010458688), (1.157017693454224, 1.378879981937259),
                 [0.127480384, -1.402284223999999]],
                [46.18420000000001, (0.0, 0.4), (2.134482661343144, -0.3310385615861531), [0.225, -2.474999999999999]],
                [96.63563549000003, (0.17787349, 0.372413386), (1.869323891348456, 1.9482372015491),
                 [0.191220684, -2.103427519999999]],
                [351.18416399, (0.0, 0.4), (1.869323890109546, 1.94823720053998), [0.18, -1.980000001999999]],
                [21.0, (0.2, 0.3), (1.193814104236923, -0.8052377813306776), [0.15, -1.65]],
                [326.0, (0.2, 0.3), (0.4866306638431635, 1.450300090093706), [0.12, -1.32]],
                [71.45144474, (0.299484508, 0.232896852), (1.680444753459942, 0.6450623056127078),
                 [0.12748038, -1.402284223999999]],
                [37.5, (0.0, 0.0), (0.0243197106345814, 0.6657877076626231), [0.0, -1.304, 0.0, -1.34, 0.0, -1.325]],
                [7.499999999999999, (0.0, 0.0), (0.5261390748842972, 0.7888234237647205),
                 [0.0, -0.7640000000000001, 0.0, -1.274, 0.0, -0.505]],
                [327.5, (-0.446, 0.0), (1.067644872344817, -0.0451097434687595),
                 [0.0, -0.5, 0.0, -1.56, 0.0, -2.069999999999999]],
                [317.5, (-0.646, 0.0), (1.166372338684772, 0.2002099646646354),
                 [0.0, -0.65, 0.0, -1.036, 0.0, -1.469999999999999]]],
    'AR-HBONE': [[45.0, (0.0, 0.0), (1e-16, 1.131370849898476), [2.4, -0.8]],
                 [135.0, (0.5656854250000001, 0.5656854250000001), (1e-16, 1.131370849898476), [2.4, -0.8]]],
    'AR-PARQ1': [[90.0, (0.0, 0.0), (-2.4, 2.4), [2.4, -2.4]], [90.0, (0.4, 0.0), (-2.4, 2.4), [2.4, -2.4]],
                 [90.0, (0.8, 0.0), (-2.4, 2.4), [2.4, -2.4]], [90.0, (1.2, 0.0), (-2.4, 2.4), [2.4, -2.4]],
                 [90.0, (1.6, 0.0), (-2.4, 2.4), [2.4, -2.4]], [90.0, (2.0, 0.0), (-2.4, 2.4), [2.4, -2.4]],
                 [90.0, (2.4, 0.0), (-2.4, 2.4), [2.4, -2.4]], [0.0, (0.0, 2.4), (2.4, -2.4), [2.4, -2.4]],
                 [0.0, (0.0, 2.8), (2.4, -2.4), [2.4, -2.4]], [0.0, (0.0, 3.2), (2.4, -2.4), [2.4, -2.4]],
                 [0.0, (0.0, 3.6), (2.4, -2.4), [2.4, -2.4]], [0.0, (0.0, 4.0), (2.4, -2.4), [2.4, -2.4]],
                 [0.0, (0.0, 4.4), (2.4, -2.4), [2.4, -2.4]], [0.0, (0.0, 4.8), (2.4, -2.4), [2.4, -2.4]]],
    'AR-RROOF': [[0.0, (0.0, 0.0), (2.2, 1.0), [15.0, -2.0, 5.0, -1.0]],
                 [0.0, (1.33, 0.5), (-1.0, 1.33), [3.0, -0.33, 6.0, -0.75]],
                 [0.0, (0.5, 0.85), (5.2, 0.6700000000000002), [8.0, -1.399999999999999, 4.0, -1.0]]],
    'AR-RSHKE': [[0.0, (0.0, 0.0), (2.55, 1.2), [0.6000000000000001, -0.5, 0.7000000000000001, -0.3, 0.9, -0.4]],
                 [0.0, (0.6000000000000001, 0.05), (2.55, 1.2), [0.5, -1.9, 0.4, -0.6000000000000001]],
                 [0.0, (1.8, -0.075), (2.55, 1.2), [0.3, -3.1]], [90.0, (0.0, 0.0), (-0.85, 1.2), [1.15, -3.65]],
                 [90.0, (0.6000000000000001, 0.0), (-0.85, 1.2), [1.125, -3.675]],
                 [90.0, (1.1, 0.0), (-0.85, 1.2), [1.05, -3.75]], [90.0, (1.8, -0.075), (-0.85, 1.2), [1.15, -3.65]],
                 [90.0, (2.1, -0.075), (-0.85, 1.2), [1.15, -3.65]], [90.0, (3.0, 0.0), (-0.85, 1.2), [1.1, -3.7]]],
    'AR-SAND': [[37.5, (0.0, 0.0), (-0.0629933581096082, 1.926823769013158), [0.0, -1.52, 0.0, -1.7, 0.0, -1.625]],
                [7.499999999999999, (0.0, 0.0), (1.769776705267727, 2.82214606522974),
                 [0.0, -0.82, 0.0, -1.37, 0.0, -0.525]],
                [327.5, (-1.229999999999999, 0.0), (3.114141861751495, 0.0056590535369649),
                 [0.0, -0.5, 0.0, -1.8, 0.0, -2.35]],
                [317.5, (-1.229999999999999, 0.0), (3.006126604572293, 0.8776755649342494),
                 [0.0, -0.25, 0.0, -1.179999999999999, 0.0, -1.35]]],
    'BOX': [[90.0, (0.0, 0.0), (-1.0, 1e-16), []], [90.0, (0.25, 0.0), (-1.0, 1e-16), []],
            [0.0, (0.0, 0.0), (0.0, 1.0), [-0.25, 0.25]], [0.0, (0.0, 0.25), (0.0, 1.0), [-0.25, 0.25]],
            [0.0, (0.0, 0.5), (0.0, 1.0), [0.25, -0.25]], [0.0, (0.0, 0.75), (0.0, 1.0), [0.25, -0.25]],
            [90.0, (0.5, 0.0), (-1.0, 1e-16), [0.25, -0.25]], [90.0, (0.75, 0.0), (-1.0, 1e-16), [0.25, -0.25]]],
    'BRASS': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [0.0, (0.0, 0.125), (0.0, 0.25), [0.125, -0.0625]]],
    'BRICK': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [90.0, (0.0, 0.0), (-0.5, 0.0), [0.25, -0.25]],
              [90.0, (0.25, 0.0), (-0.5, 0.0), [-0.25, 0.25]]],
    'BRSTONE': [[0.0, (0.0, 0.0), (0.0, 0.33), []], [90.0, (0.9, 0.0), (-0.5, 0.3300000000000001), [0.33, -0.33]],
                [90.0, (0.8, 0.0), (-0.5, 0.3300000000000001), [0.33, -0.33]],
                [0.0, (0.9, 0.055), (0.5, 0.33), [-0.9, 0.1]], [0.0, (0.9, 0.11), (0.5, 0.33), [-0.9, 0.1]],
                [0.0, (0.9, 0.165), (0.5, 0.33), [-0.9, 0.1]], [0.0, (0.9, 0.22), (0.5, 0.33), [-0.9, 0.1]],
                [0.0, (0.9, 0.275), (0.5, 0.33), [-0.9, 0.1]]],
    'CLAY': [[0.0, (0.0, 0.0), (0.0, 0.1875), []], [0.0, (0.0, 0.03125), (0.0, 0.1875), []],
             [0.0, (0.0, 0.0625), (0.0, 0.1875), []], [0.0, (0.0, 0.125), (0.0, 0.1875), [0.1875, -0.125]]],
    'CORK': [[0.0, (0.0, 0.0), (0.0, 0.125), []],
             [135.0, (0.0625, -0.0625), (-0.2499999995804921, -0.2499999995804921), [0.176776696, -0.176776696]],
             [135.0, (0.09375, -0.0625), (-0.2499999995804921, -0.2499999995804921), [0.176776696, -0.176776696]],
             [135.0, (0.125, -0.0625), (-0.2499999995804921, -0.2499999995804921), [0.176776696, -0.176776696]]],
    'CROSS': [[0.0, (0.0, 0.0), (0.25, 0.25), [0.125, -0.375]],
              [90.0, (0.0625, -0.0625), (-0.25, 0.25), [0.125, -0.375]]],
    'DASH': [[0.0, (0.0, 0.0), (0.125, 0.125), [0.125, -0.125]]],
    'DOLMIT': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [45.0, (0.0, 0.0), (-0.4999999991609842, 0.4999999991609842),
                                                    [0.3535533905932737, -0.7071067811865475]]],
    'DOTS': [[0.0, (0.0, 0.0), (0.03125, 0.0625), [0.0, -0.0625]]],
    'EARTH': [[0.0, (0.0, 0.0), (0.25, 0.25), [0.25, -0.25]], [0.0, (0.0, 0.09375), (0.25, 0.25), [0.25, -0.25]],
              [0.0, (0.0, 0.1875), (0.25, 0.25), [0.25, -0.25]],
              [90.0, (0.03125, 0.21875), (-0.25, 0.25), [0.25, -0.25]],
              [90.0, (0.125, 0.21875), (-0.25, 0.25), [0.25, -0.25]],
              [90.0, (0.21875, 0.21875), (-0.25, 0.25), [0.25, -0.25]]],
    'ESCHER': [[60.0, (0.0, 0.0), (-1.199999999531197, -2.70663e-10), [1.1, -0.1]],
               [180.0, (0.0, 0.0), (0.5999999999999999, -1.039230483999999), [1.1, -0.1]],
               [300.0, (0.0, 0.0), (1.199999999531197, -2.70663e-10), [1.1, -0.1]],
               [60.0, (0.1, 0.0), (-1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [300.0, (0.1, 0.0), (1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [60.0, (-0.05, 0.08660254), (-1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [180.0, (-0.05, 0.08660254), (0.5999999999999999, -1.039230483999999), [0.2, -1.0]],
               [300.0, (-0.05, -0.08660254), (1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [180.0, (-0.05, -0.08660254), (0.5999999999999999, -1.039230483999999), [0.2, -1.0]],
               [60.0, (-0.4, 0.0), (-1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [300.0, (-0.4, 0.0), (1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [60.0, (0.2, -0.346410161), (-1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [180.0, (0.2, -0.346410161), (0.5999999999999999, -1.039230483999999), [0.2, -1.0]],
               [300.0, (0.2, 0.346410161), (1.199999999531197, -2.70663e-10), [0.2, -1.0]],
               [180.0, (0.2, 0.346410161), (0.5999999999999999, -1.039230483999999), [0.2, -1.0]],
               [0.0, (0.2, 0.173205081), (-0.6, 1.039230483999999), [0.7, -0.5]],
               [0.0, (0.2, -0.173205081), (-0.6, 1.039230483999999), [0.7, -0.5]],
               [120.0, (0.05, 0.259807621), (-1.199999999531197, 2.706635e-10), [0.6999999999999998, -0.5]],
               [120.0, (-0.25, 0.08660254), (-1.199999999531197, 2.706635e-10), [0.6999999999999998, -0.5]],
               [240.0, (-0.25, -0.08660254), (0.599999999531197, -1.039230484270663), [0.7, -0.5]],
               [240.0, (0.05, -0.259807621), (0.599999999531197, -1.039230484270663), [0.7, -0.5]]],
    'FLEX': [[0.0, (0.0, 0.0), (0.0, 0.25), [0.25, -0.25]],
             [45.0, (0.25, 0.0), (0.0, 0.2499999999990993), [0.0625, -0.2285533906, 0.0625, -0.353553390593]]],
    'GOST_GLASS': [[45.0, (0.0, 0.0), (0.8485281374238571, -1e-16), [0.5, -0.7000000000000001]],
                   [45.0, (0.212132, 0.0), (0.8485281374238571, -1e-16), [0.2, -1.0]],
                   [45.0, (0.0, 0.212132), (0.8485281374238571, -1e-16), [0.2, -1.0]]],
    'GOST_WOOD': [[90.0, (0.0, 0.0), (1.2, -1e-16), [2.0, -0.4]],
                  [90.0, (0.4, -0.4), (1.2, -1e-16), [1.2, -0.3, 0.6000000000000001, -0.3]],
                  [90.0, (0.8, -1.0), (1.2, -1e-16), [2.0, -0.4]]],
    'GOST_GROUND': [[45.0, (0.0, 0.0), (2.82842712474619, -2e-16), [4.0]],
                    [45.0, (0.6000000000000001, 0.0), (2.82842712474619, -2e-16), [4.0]],
                    [45.0, (1.2, 0.0), (2.82842712474619, -2e-16), [4.0]]],
    'GRASS': [[90.0, (0.0, 0.0), (-0.7071067809999999, 0.7071067809999999), [0.1875, -1.226713562999999]],
              [45.0, (0.0, 0.0), (-0.7071067811865475, 0.7071067811865476), [0.1875, -0.8125]],
              [135.0, (0.0, 0.0), (-0.7071067811865476, -0.7071067811865475), [0.1875, -0.8125]]],
    'GRATE': [[0.0, (0.0, 0.0), (0.0, 0.03125), []], [90.0, (0.0, 0.0), (-0.125, 0.0), []]],
    'GRAVEL': [[228.012787504, (0.72, 1.0), (-8.000000000000062, -9.000000000000004), [0.134536, -13.3190880470737]],
               [184.969740728, (0.63, 0.9), (11.99999999999997, 1.000000000000035), [0.230868, -22.85592476122999]],
               [132.510447078, (0.4, 0.88), (10.00000000000011, -10.99999999999986), [0.162788, -16.1160325960997]],
               [267.273689006, (0.01, 0.63), (1.000000000000024, 20.00000000000002), [0.210238, -20.813558041629]],
               [292.833654178, (0.0, 0.4200000000000001), (-4.999999999999988, 12.00000000000003),
                [0.2061549999999999, -20.4093731280883]],
               [357.273689006, (0.08, 0.23), (-20.00000000000002, 1.000000000000025), [0.210238, -20.813558041629]],
               [37.6942404667, (0.29, 0.22), (-13.0, -9.999999999999973), [0.278029, -27.524848548916]],
               [72.2553283749, (0.51, 0.39), (7.000000000000027, 22.00000000000001),
                [0.2624879999999999, -25.9863214968134]],
               [121.429565615, (0.59, 0.6400000000000001), (-8.00000000000002, 12.99999999999999),
                [0.21095, -20.884073109729]],
               [175.236358309, (0.48, 0.82), (10.99999999999998, -1.000000000000037), [0.240832, -11.8007625787923]],
               [222.397437798, (0.24, 0.84), (-11.99999999999996, -10.99999999999997), [0.311448, -30.8333750047949]],
               [138.814074834, (1.0, 0.6200000000000001), (-7.000000000000032, 6.0), [0.106301, -10.52384481273469]],
               [171.46923439, (0.9200000000000002, 0.69), (13.0, -1.999999999999995), [0.202237, -20.021511416157]],
               [225.0, (0.72, 0.72), (-1e-16, -0.9999999999999328), [0.141421, -1.2727925623731]],
               [203.198590514, (0.65, 0.84), (4.999999999999989, 1.999999999999975), [0.076158, -7.5396151058639]],
               [291.801409486, (0.58, 0.81), (-0.9999999999996839, 3.000000000000102), [0.107703, -5.2774618071345]],
               [30.96375653209999, (0.6200000000000001, 0.71), (3.000000000000052, 1.999999999999979),
                [0.174929, -5.656022894845298]],
               [161.565051177, (0.7700000000000001, 0.8), (2.000000000000011, -0.9999999999999767),
                [0.126491, -3.035786660168399]],
               [16.389540334, (0.0, 0.81), (9.999999999999966, 3.000000000000043), [0.1772, -17.5428451466694]],
               [70.3461759419, (0.17, 0.8599999999999999), (-4.00000000000122, -11.00000000000339),
                [0.148661, -14.717407747319]],
               [293.198590514, (0.7700000000000001, 1.0), (-1.99999999999997, 4.999999999999991),
                [0.152315, -7.4634581058639]],
               [343.610459666, (0.8299999999999998, 0.8599999999999999), (-9.999999999999966, 3.000000000000043),
                [0.1772, -17.54284514666899]],
               [339.44395478, (0.0, 0.19), (-5.000000000000036, 2.000000000000024), [0.17088, -8.373123745317498]],
               [294.775140569, (0.16, 0.13), (-5.000000000000005, 11.0), [0.143178, -14.174643063276]],
               [66.8014094864, (0.7800000000000001, 0.0), (1.999999999999981, 4.999999999999969),
                [0.152315, -7.4634581058639]],
               [17.3540246363, (0.84, 0.14), (-12.99999999999998, -3.999999999999962), [0.167631, -16.59542361424]],
               [69.4439547804, (0.29, 0.0), (-2.000000000000007, -4.999999999999954), [0.08544, -8.458563745317498]],
               [101.309932474, (0.72, 0.0), (-0.9999999999999637, 4.000000000000012), [0.05099, -5.048029513592799]],
               [165.963756532, (0.71, 0.05), (2.999999999999958, -1.000000000000001), [0.206155, -3.9169506256177]],
               [186.009005957, (0.51, 0.1), (10.00000000000004, 0.9999999999999831), [0.19105, -18.9139231745428]],
               [303.690067526, (0.6200000000000001, 0.6200000000000001), (-0.9999999999999872, 1.999999999999985),
                [0.144222, -3.461329275463999]],
               [353.157226587, (0.7, 0.5), (17.00000000000001, -2.000000000000052), [0.251794, -24.9275626240283]],
               [60.9453959009, (0.95, 0.47), (-3.999999999999975, -6.999999999999976), [0.102956, -10.192674140987]],
               [90.0, (1.0, 0.56), (-0.9999999999999998, 1.0), [0.06, -0.9399999999999998]],
               [120.256437164, (0.4900000000000001, 0.13), (4.000000000000008, -7.000000000000007),
                [0.138924, -13.7535199894498]],
               [48.01278750419999, (0.4200000000000001, 0.25), (8.0, 8.999999999999975), [0.269072, -13.1845520470737]],
               [0.0, (0.6, 0.45), (1.0, 1.0), [0.26, -0.7400000000000001]],
               [325.304846469, (0.8599999999999999, 0.45), (10.00000000000014, -6.999999999999825),
                [0.158114, -15.653274300842]],
               [254.0546040990001, (0.99, 0.36), (-1.000000000000037, -4.000000000000004),
                [0.145602, -7.1345078892805]],
               [207.645975364, (0.95, 0.22), (-18.99999999999995, -10.00000000000005), [0.237065, -23.4694741822594]],
               [175.42607874, (0.7400000000000001, 0.11), (-12.99999999999995, 1.000000000000001),
                [0.250799, -24.8290734079689]]],
    'HEX': [[0.0, (0.0, 0.0), (0.0, 0.2165063509461096), [0.125, -0.25]],
            [120.0, (0.0, 0.0), (-0.1875, -0.1082531754730548), [0.125, -0.25]],
            [60.0, (0.125, 0.0), (-0.1875, 0.1082531754730549), [0.125, -0.25]]],
    'HONEY': [[0.0, (0.0, 0.0), (0.1875, 0.1082531754730548), [0.125, -0.25]],
              [120.0, (0.0, 0.0), (-0.1875, 0.1082531754730549), [0.125, -0.25]],
              [60.0, (0.0, 0.0), (0.0, 0.2165063509461097), [-0.25, 0.125]]],
    'HOUND': [[0.0, (0.0, 0.0), (0.25, 0.0625), [1.0, -0.5]], [90.0, (0.0, 0.0), (-0.0625, -0.25), [1.0, -0.5]]],
    'INSUL': [[0.0, (0.0, 0.0), (0.0, 0.375), []], [0.0, (0.0, 0.125), (0.0, 0.375), [0.125, -0.125]],
              [0.0, (0.0, 0.25), (0.0, 0.375), [0.125, -0.125]]],
    'LINE': [[0.0, (0.0, 0.0), (0.0, 0.125), []]],
    'MUDST': [[0.0, (0.0, 0.0), (0.5, 0.25), [0.25, -0.25, 0.0, -0.25, 0.0, -0.25]]],
    'NET': [[0.0, (0.0, 0.0), (0.0, 0.125), []], [90.0, (0.0, 0.0), (-0.125, 0.0), []]],
    'NET3': [[0.0, (0.0, 0.0), (0.0, 0.125), []], [60.0, (0.0, 0.0), (-0.1082531754730548, 0.0625), []],
             [120.0, (0.0, 0.0), (-0.1082531754730548, -0.0625), []]],
    'PLAST': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [0.0, (0.0, 0.03125), (0.0, 0.25), []],
              [0.0, (0.0, 0.0625), (0.0, 0.25), []]],
    'PLASTI': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [0.0, (0.0, 0.03125), (0.0, 0.25), []],
               [0.0, (0.0, 0.0625), (0.0, 0.25), []], [0.0, (0.0, 0.15625), (0.0, 0.25), []]],
    'SACNCR': [[45.0, (0.0, 0.0), (-0.0662912607362388, 0.0662912607362388), []],
               [45.0, (0.066291261, 0.0), (-0.0662912607362388, 0.0662912607362388), [0.0, -0.09375]]],
    'SQUARE': [[0.0, (0.0, 0.0), (0.0, 0.125), [0.125, -0.125]], [90.0, (0.0, 0.0), (-0.125, 0.0), [0.125, -0.125]]],
    'STARS': [[0.0, (0.0, 0.0), (0.0, 0.216506351), [0.125, -0.125]],
              [60.0, (0.0, 0.0), (-0.1875000000466704, 0.1082531755), [0.125, -0.125]],
              [120.0, (0.0625, 0.108253176), (-0.1875000000466704, -0.1082531755), [0.125, -0.125]]],
    'STEEL': [[45.0, (0.0, 0.0), (-0.0883883476483184, 0.0883883476483185), []],
              [45.0, (0.0, 0.0625), (-0.0883883476483184, 0.0883883476483185), []]],
    'SWAMP': [[0.0, (0.0, 0.0), (0.5, 0.8660254029999999), [0.125, -0.875]],
              [90.0, (0.0625, 0.0), (-0.5, 0.8660254029999999), [0.0625, -1.669550805999999]],
              [90.0, (0.078125, 0.0), (-0.5, 0.8660254029999999), [0.05, -1.682050805999999]],
              [90.0, (0.046875, 0.0), (-0.5, 0.8660254029999999), [0.05, -1.682050805999999]],
              [60.0, (0.09375, 0.0), (-0.4999999993206561, 0.8660254033922195), [0.04, -0.9599999999999999]],
              [120.0, (0.03125, 0.0), (-0.9999999993206561, 3.922195e-10), [0.04, -0.9599999999999997]]],
    'TRANS': [[0.0, (0.0, 0.0), (0.0, 0.25), []], [0.0, (0.0, 0.125), (0.0, 0.25), [0.125, -0.125]]],
    'TRIANG': [[60.0, (0.0, 0.0), (-0.1874999996369928, 0.3247595262095823), [0.1875, -0.1875]],
               [120.0, (0.0, 0.0), (-0.3749999996369929, 2.095823e-10), [0.1875, -0.1875]],
               [0.0, (-0.09375, 0.162379763), (0.1875, 0.324759526), [0.1875, -0.1875]]],
    'ZIGZAG': [[0.0, (0.0, 0.0), (0.125, 0.125), [0.125, -0.125]],
               [90.0, (0.125, 0.0), (-0.125, 0.125), [0.125, -0.125]]],
}
