# Autodesk DXF 2018 Reference
link_tpl = 'http://help.autodesk.com/view/OARX/2018/ENU/?guid={guid}'
# Autodesk DXF 2014 Reference
# link_tpl = 'http://docs.autodesk.com/ACD/2014/ENU/files/{guid}.htm'
main_index_guid = 'GUID-235B22E0-A567-4CF6-92D3-38A2306D73F3'  # main index

reference_guids = {
        "HEADER": "GUID-EA9CDD11-19D1-4EBC-9F56-979ACF679E3C",
        "CLASSES": "GUID-6160F1F1-2805-4C69-8077-CA1AEB6B1005",
        "TABLES": "GUID-A9FD9590-C97B-4E41-9F26-BD82C34A4F9F",
        "BLOCKS": "GUID-1D14A213-5E4D-4EA6-A6B5-8709EB925D01",
        "ENTITIES": "GUID-7D07C886-FD1D-4A0C-A7AB-B4D21F18E484",
        "OBJECTS": "GUID-2D71EE99-A6BE-4060-9B43-808CF1E201C6",
        "THUMBNAILIMAGE": "GUID-792F79DC-0D5D-43B5-AB0E-212E0EDF6BAE",
        "APPIDS": "GUID-6E3140E9-E560-4C77-904E-480382F0553E",
        "BLOCK_RECORDS": "GUID-A1FD1934-7EF5-4D35-A4B0-F8AE54A9A20A",
        "DIMSTYLES": "GUID-F2FAD36F-0CE3-4943-9DAD-A9BCD2AE81DA",
        "LAYERS": "GUID-D94802B0-8BE8-4AC9-8054-17197688AFDB",
        "LINETYPES": "GUID-F57A316C-94A2-416C-8280-191E34B182AC",
        "STYLES": "GUID-EF68AF7C-13EF-45A1-8175-ED6CE66C8FC9",
        "UCS": "GUID-1906E8A7-3393-4BF9-BD27-F9AE4352FB8B",
        "VIEWS": "GUID-CF3094AB-ECA9-43C1-8075-7791AC84F97C",
        "VIEWPORTS": "GUID-8CE7CC87-27BD-4490-89DA-C21F516415A9",
        "BLOCK": "GUID-66D32572-005A-4E23-8B8B-8726E8C14302",
        "ENDBLK": "GUID-27F7CC8A-E340-4C7F-A77F-5AF139AD502D",
        "3DFACE": "GUID-747865D5-51F0-45F2-BEFE-9572DBC5B151",
        "3DSOLID": "GUID-19AB1C40-0BE0-4F32-BCAB-04B37044A0D3",
        "ACAD_PROXY_ENTITY": "GUID-89A690F9-E859-4D57-89EA-750F3FB76C6B",
        "ARC": "GUID-0B14D8F1-0EBA-44BF-9108-57D8CE614BC8",
        "ATTDEF": "GUID-F0EA099B-6F88-4BCC-BEC7-247BA64838A4",
        "ATTRIB": "GUID-7DD8B495-C3F8-48CD-A766-14F9D7D0DD9B",
        "BODY": "GUID-7FB91514-56FF-4487-850E-CF1047999E77",
        "CIRCLE": "GUID-8663262B-222C-414D-B133-4A8506A27C18",
        "DIMENSION": "GUID-239A1BDD-7459-4BB9-8DD7-08EC79BF1EB0",
        "ELLIPSE": "GUID-107CB04F-AD4D-4D2F-8EC9-AC90888063AB",
        "HATCH": "GUID-C6C71CED-CE0F-4184-82A5-07AD6241F15B",
        "HELIX": "GUID-76DB3ABF-3C8C-47D1-8AFB-72942D9AE1FF",
        "IMAGE": "GUID-3A2FF847-BE14-4AC5-9BD4-BD3DCAEF2281",
        "INSERT": "GUID-28FA4CFB-9D5E-4880-9F11-36C97578252F",
        "LEADER": "GUID-396B2369-F89F-47D7-8223-8B7FB794F9F3",
        "LIGHT": "GUID-1A23DB42-6A92-48E9-9EB2-A7856A479930",
        "LINE": "GUID-FCEF5726-53AE-4C43-B4EA-C84EB8686A66",
        "LWPOLYLINE": "GUID-748FC305-F3F2-4F74-825A-61F04D757A50",
        "MESH": "GUID-4B9ADA67-87C8-4673-A579-6E4C76FF7025",
        "MLINE": "GUID-590E8AE3-C6D9-4641-8485-D7B3693E432C",
        "MLEADERSTYLE": "GUID-0E489B69-17A4-4439-8505-9DCE032100B4",
        "MLEADER": "GUID-72D20B8C-0F5E-4993-BEB7-0FCF94F32BE0",
        "MTEXT": "GUID-5E5DB93B-F8D3-4433-ADF7-E92E250D2BAB",
        "OLEFRAME": "GUID-4A10EF68-35A3-4961-8B15-1222ECE5E8C6",
        "OLE2FRAME": "GUID-77747CE6-82C6-4452-97ED-4CEEB38BE960",
        "POINT": "GUID-9C6AD32D-769D-4213-85A4-CA9CCB5C5317",
        "POLYLINE": "GUID-ABF6B778-BE20-4B49-9B58-A94E64CEFFF3",
        "RAY": "GUID-638B9F01-5D86-408E-A2DE-FA5D6ADBD415",
        "REGION": "GUID-644BF0F0-FD79-4C5E-AD5A-0053FCC5A5A4",
        "SECTION": "GUID-8B60CBAB-B226-4A5F-ABB1-46FD8AABB928",
        "SEQEND": "GUID-FD4FAA74-1F6D-45F6-B132-BF0C4BE6CC3B",
        "SHAPE": "GUID-0988D755-9AAB-4D6C-8E26-EC636F507F2C",
        "SOLID": "GUID-E0C5F04E-D0C5-48F5-AC09-32733E8848F2",
        "SPLINE": "GUID-E1F884F8-AA90-4864-A215-3182D47A9C74",
        "SUN": "GUID-BB191D89-9302-45E4-9904-108AB418FAE1",
        "SURFACE": "GUID-BB62483A-89C3-47C4-80E5-EA3F08979863",
        "TABLE": "GUID-D8CCD2F0-18A3-42BB-A64D-539114A07DA0",
        "TEXT": "GUID-62E5383D-8A14-47B4-BFC4-35824CAE8363",
        "TOLERANCE": "GUID-ADFCED35-B312-4996-B4C1-61C53757B3FD",
        "TRACE": "GUID-EA6FBCA8-1AD6-4FB2-B149-770313E93511",
        "UNDERLAY": "GUID-3EC8FBCC-A85A-4B0B-93CD-C6C785959077",
        "VERTEX": "GUID-0741E831-599E-4CBF-91E1-8ADBCFD6556D",
        "VIEWPORT": "GUID-2602B0FB-02E4-4B9A-B03C-B1D904753D34",
        "WIPEOUT": "GUID-2229F9C4-3C80-4C67-9EDA-45ED684808DC",
        "XLINE": "GUID-55080553-34B6-40AA-9EE2-3F3A3A2A5C0A",
        "ACAD_PROXY_OBJECT": "GUID-F59F0EC3-D34D-4C1A-91AC-7FDA569EF016",
        "ACDBDICTIONARYWDFLT": "GUID-A6605C05-1CF4-42A4-95EC-42190B2424EE",
        "ACDBPLACEHOLDER": "GUID-3BC75FF1-6139-49F4-AEBB-AE2AB4F437E4",
        "DATATABLE": "GUID-D09D0650-B926-40DD-A2F2-4FD5BDDFC330",
        "DICTIONARY": "GUID-40B92C63-26F0-485B-A9C2-B349099B26D0",
        "DICTIONARYVAR": "GUID-D305303C-F9CE-4714-9C92-607BFDA891B4",
        "DIMASSOC": "GUID-C0B96256-A911-4B4D-85E6-EB4AF2C91E27",
        "FIELD": "GUID-51B921F2-16CA-4948-AC75-196198DD1796",
        "GEODATA": "GUID-104FE0E2-4801-4AC8-B92C-1DDF5AC7AB64",
        "GROUP": "GUID-5F1372C4-37C8-4056-9303-EE1715F58E67",
        "IDBUFFER": "GUID-7A243F2B-72D8-4C48-A29A-3F251B86D03F",
        "IMAGEDEF": "GUID-EFE5319F-A71A-4612-9431-42B6C7C3941F",
        "IMAGEDEF_REACTOR": "GUID-46C12333-1EDA-4619-B2C9-D7D2607110C8",
        "LAYER_INDEX": "GUID-17560B05-31B9-44A5-BA92-E92C799398C0",
        "LAYER_FILTER": "GUID-3B44DCFD-FA96-482B-8468-37B3C5B5F289",
        "LAYOUT": "GUID-433D25BF-655D-4697-834E-C666EDFD956D",
        "LIGHTLIST": "GUID-C4E7FFF8-C3ED-43DD-854D-304F87FFCF06",
        "MATERIAL": "GUID-E540C5BB-E166-44FA-B36C-5C739878B272",
        "MLINESTYLE": "GUID-3EC12E5B-F5F6-484D-880F-D69EBE186D79",
        "OBJECT_PTR": "GUID-6D6885E2-281C-410A-92FB-8F6A7F54C9DF",
        "PLOTSETTINGS": "GUID-1113675E-AB07-4567-801A-310CDE0D56E9",
        "RASTERVARIABLES": "GUID-DDCC21A4-822A-469B-9954-1E1EC4F6DF82",
        "SPATIAL_INDEX": "GUID-CD1E44DA-CDBA-4AA7-B08E-C53F71648984",
        "SPATIAL_FILTER": "GUID-34F179D8-2030-47E4-8D49-F87B6538A05A",
        "SORTENTSTABLE": "GUID-462F4378-F850-4E89-90F2-3C1880F55779",
        "SUNSTUDY": "GUID-1C7C073F-4CFD-4939-97D9-7AB0C1E163A3",
        "TABLESTYLE": "GUID-0DBCA057-9F6C-4DEB-A66F-8A9B3C62FB1A",
        "UNDERLAYDEFINITION": "GUID-A4FF15D3-F745-4E1F-94D4-1DC3DF297B0F",
        "VISUALSTYLE": "GUID-8A8BF2C4-FC56-44EC-A8C4-A60CE33A530C",
        "VBA_PROJECT": "GUID-F247DB75-5C4D-4944-8C20-1567480221F4",
        "WIPEOUTVARIABLES": "GUID-CD28B95F-483C-4080-82A6-420606F88356",
        "XRECORD": "GUID-24668FAF-AE03-41AE-AFA4-276C3692827F",
}


def get_reference_link(name):
    guid = reference_guids.get(name, main_index_guid)
    return link_tpl.format(guid=guid)

















































