# QClassiPy
QClassiPy is a QGIS plugin that allows the manual, interactive drawing and editing of classification maps.

The plugin makes it possible to interactively change the pixel values of a classification raster using intuitive tools:
* **Selection**: just draw a selection shape over the chosen pixels using the QGIS built-in Select Feature tools to change their value.
* **Brush and Erase**: change pixel values by dragging your mouse over them.
* **Polygons**: convert regions of uniform classification into polygons, modify their borders with QGIS built-in tools and see the changes reflected on the raster.

It is furthermore possible to split large rasters into tiles to edit separately.

[Installation](https://github.com/michelelissoni/QClassiPy/blob/main/docs/install.md)

[Get started](https://github.com/michelelissoni/QClassiPy/blob/main/docs/get_started.md)

<!---
## Documentation

### Plugin features
* [Draw mask](https://github.com/michelelissoni/QClassiPy/blob/main/docs/draw_mask.md): select a tile and draw the mask using the plugin's drawing tools
* [Create tiles](https://github.com/michelelissoni/QClassiPy/blob/main/docs/create_tiles.md): create an empty mask and split it into tiles
* [Merge masks](https://github.com/michelelissoni/QClassiPy/blob/main/docs/merge_masks.md): collaborative mapping, split the mapping effort with your colleagues and then merge the results.
  
[Frequently Asked Questions](https://github.com/michelelissoni/QClassiPy/blob/main/docs/faq.md)

[Future improvements](https://github.com/michelelissoni/QClassiPy/blob/main/docs/future.md)
--->

### Citation
If you found this plugin useful, you can cite:

Lissoni, M., Doressoundiram, A., and Besse, S.: Deep learning map of fresh crater ejecta on Mercury: a resource for space weathering studies, EPSC-DPS Joint Meeting 2025, Helsinki, Finland, 7–13 Sep 2025, EPSC-DPS2025-256, https://doi.org/10.5194/epsc-dps2025-256, 2025. 
