# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PreCourlisPlugin
                                 A QGIS plugin
 Creation de profils pour Courlis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-03-13
        copyright            : (C) 2020 by EDF Hydro, DeltaCAD, Camptocamp
        email                : matthieu.secher@edf.fr
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import configparser
import os


def parse_metadata():
    """Parse metadata.txt file

    Return "general" section key/value pairs as a dictionnary
    """
    dict_ = {}
    parser = configparser.RawConfigParser()
    parser.read(os.path.join(os.path.dirname(__file__), "metadata.txt"))
    for key, value in parser.items("general"):
        dict_[key] = value
    return dict_


metadata = parse_metadata()


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load PreCourlisPlugin class from file PreCourlisPlugin.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .PreCourlis import PreCourlisPlugin  # pylint: disable=import-outside-toplevel

    return PreCourlisPlugin(iface)
