# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sewercalc
                                 A QGIS plugin
 Plugin para dimensionamento de redes coletoras de esgoto 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wanderilo  Lima
        email                : Wanderilo Lima
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


from qgis.utils import iface
from qgis.core import Qgis, QgsProcessingException

from .Sewercalc_Classificar_PV import atualizar_coluna_cat
from .Sewercalc_Add_pv_rede import adicionar_pvs_trechos
from .Sewercalc_Informacoes import preencher_contrib_rede, calcular_comprimento_rede, verificar_camadas

def preencher_campos_rede():
    
    #-------------------------------------------------
    camadas_verificar = ["MDE", "PV"]
    nao_encontradas = verificar_camadas(camadas_verificar)
    
    if nao_encontradas:  
        camadas_faltantes = "\n• " + "\n• ".join(nao_encontradas)  
        iface.messageBar().pushMessage(
            "Erro: Camadas faltantes", 
            f"As seguintes camadas não foram encontradas:{camadas_faltantes}",
            level=Qgis.Critical, 
            duration=10 
        )
        return
    #-------------------------------------------------
    
    funcoes = [
        atualizar_coluna_cat,
        calcular_comprimento_rede,
        preencher_contrib_rede,
        adicionar_pvs_trechos,
        
    ]

    # Função para executar todas as funções
    def executar_funcoes():
        for funcao in funcoes:
            funcao() 
            
        # Correct way to show success message with duration
        iface.messageBar().pushMessage(
            "Sucesso",
            "Campos preenchidos: CATEGORIA, CONTRIBUIÇÃO, PV MONTANTE e JUSANTE, COMPRIMENTO DA REDE",
            level=Qgis.Success,
            duration=12
        )

    executar_funcoes()
