# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sewercalc
                                 A QGIS plugin
 Plugin para dimensionamento de redes coletoras de esgoto 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wanderilo  Lima
        email                : Wanderilo Lima
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QStandardPaths
from PyQt5.QtCore import QSettings, Qt
from PyQt5.QtGui import QIntValidator, QDoubleValidator
from qgis.PyQt.QtWidgets import QLineEdit, QMessageBox
from PyQt5.QtWidgets import QComboBox
import json
import os


def get_config_path(arquivo="configuracoes.json"):
    """Retorna o caminho seguro para o arquivo de configuração"""
    config_dir = QStandardPaths.writableLocation(QStandardPaths.AppDataLocation)
    os.makedirs(config_dir, exist_ok=True)  # Garante que o diretório existe
    return os.path.join(config_dir, arquivo)

#-------------------------------------------------------------------------

def salvar_valores_campos(dlg, arquivo="configuracoes.json"):
    """Salva os valores dos campos e os IDs das camadas selecionadas em JSON."""
    try:
        config_path = get_config_path(arquivo)
        
        # Obtém os IDs das camadas selecionadas
        dados = {
            # Campos de texto/numéricos
            "Edit_Pini": dlg.Edit_Pini.text(),
            "Edit_Pfim": dlg.Edit_Pfim.text(),
            "Edit_consumo": dlg.Edit_consumo.text(),
            "Edit_Retorno": dlg.Edit_Retorno.text(),
            "Edit_tx_infiltra": dlg.Edit_tx_infiltra.text(),
            "Edit_k1": dlg.Edit_k1.text(),
            "Edit_k2": dlg.Edit_k2.text(),
            "Edit_manning": dlg.Edit_manning.text(),
            "Edit_Tensao": dlg.Edit_Tensao.text(),
            "Edit_R_min": dlg.Edit_R_min.text(),
            
            # IDs das camadas
            "camada_pv": dlg.C_PV.currentData() or None,
            "camada_rede": dlg.C_REDE.currentData() or None,
            "camada_mde": dlg.C_MDE.currentData() or None,
        }

        # Salvamento seguro com escrita atômica
        temp_path = config_path + '.tmp'
        with open(temp_path, 'w') as f:
            json.dump(dados, f, indent=4)
        
        # Substitui o arquivo original apenas se a escrita for bem-sucedida
        if os.path.exists(temp_path):
            os.replace(temp_path, config_path)
            
    except PermissionError:
        print(f"ERRO: Sem permissão para escrever em {config_path}")
    except Exception as e:
        print(f"ERRO ao salvar configurações: {str(e)}")

#------------------------------------------------------------------------------------
def carregar_valor(nome, valor_padrao, arquivo="configuracoes.json"):
    dados = carregar_configuracoes(arquivo)
    return dados.get(nome, valor_padrao) 

def configurar_botoes(dlg):
    
    campos_inteiros = {
        "Edit_Pini": (0, 100000),
        "Edit_Pfim": (0, 100000),
        "Edit_consumo": (0, 100000)
    }
    
    for nome, (min_val, max_val) in campos_inteiros.items():
        campo = getattr(dlg, nome)
        campo.setValidator(QIntValidator(min_val, max_val))  
        valor = carregar_valor(nome, min_val)  
        campo.setText(str(valor)) 

    campos_decimais = {
        "Edit_Retorno": (0.8, None),
        "Edit_tx_infiltra": (0.0, None),
        "Edit_k1": (1.2, None),
        "Edit_k2": (1.5, None),
        "Edit_manning": (0.010, None),
        "Edit_Tensao": (0.6, None),
        "Edit_R_min": (0.9, None)
    }
    
    for nome, (min_val, max_val) in campos_decimais.items():
        min_val = min_val if min_val is not None else -999999
        max_val = max_val if max_val is not None else 999999
        campo = getattr(dlg, nome)
        campo.setValidator(QDoubleValidator(min_val, max_val, 3))  
        valor = carregar_valor(nome, min_val) 
        campo.setText(str(valor)) 

#----------------------------------------------------------------------------------------------------
def limpar_json(nome_arquivo):
    try:
        config_dir = QStandardPaths.writableLocation(QStandardPaths.AppDataLocation)
        caminho_arquivo = os.path.join(config_dir, nome_arquivo)
        
        # Escrita atômica para evitar corrupção
        temp_path = caminho_arquivo + '.tmp'
        with open(temp_path, 'w', encoding='utf-8') as f:
            json.dump({}, f, indent=4)
        
        if os.path.exists(temp_path):
            os.replace(temp_path, caminho_arquivo)
            
    except FileNotFoundError:
        pass  
    except PermissionError:
        print(f"ERRO: Sem permissão para limpar {caminho_arquivo}")
    except Exception as e:
        print(f"ERRO ao limpar {nome_arquivo}: {str(e)}")

def limpar_combobox(combobox: QComboBox):
    combobox.setCurrentText("")

#------------------------------------------------------------------------------              
def limpar_configuracoes(dlg):
    """Limpa todos os campos do diálogo e os arquivos de configuração"""
    try:
        # 1. Limpar campos do diálogo
        # Campos de configuração com valores padrão
        dlg.Edit_Retorno.setText("0.8")
        dlg.Edit_tx_infiltra.setText("0.0")
        dlg.Edit_k1.setText("1.2")
        dlg.Edit_k2.setText("1.5")
        dlg.Edit_manning.setText("0.010")
        dlg.Edit_Tensao.setText("0.6")
        dlg.Edit_R_min.setText("0.9")

        # Campos numéricos zerados
        dlg.Edit_Pini.setText("0")
        dlg.Edit_Pfim.setText("0")
        dlg.Edit_consumo.setText("0")

        # Limpar comboboxes
        limpar_combobox(dlg.C_PV)
        limpar_combobox(dlg.C_MDE)
        limpar_combobox(dlg.C_REDE)
        
        #Limpar arquivos JSON no diretório de configurações
        config_dir = QStandardPaths.writableLocation(QStandardPaths.AppDataLocation)
        
        #Limpar configurações principais
        #limpar_json(os.path.join(config_dir, "configuracoes.json"))
        
        # Limpar arquivos adicionais do plugin
        limpar_json(os.path.join(config_dir, "tabela_pv.json"))
        limpar_json(os.path.join(config_dir, "tabela_rede.json"))
        limpar_json(os.path.join(config_dir, "pontos_criticos.json"))
        
        
    except Exception as e:
        QMessageBox.critical(dlg, "Erro", f"Não foi possível limpar as configurações:\n{str(e)}")


def carregar_configuracoes(arquivo="configuracoes.json"):
    """Carrega as configurações do arquivo JSON"""
    try:
        config_path = get_config_path(arquivo)
        
        if os.path.exists(config_path):
            with open(config_path, 'r') as f:
                dados = json.load(f)
            return dados or {}  # Retorna vazio se dados forem None
            
        return {}
    except PermissionError:
        print(f"ERRO: Sem permissão para ler {config_path}")
        return {}
    except json.JSONDecodeError:
        print(f"ERRO: Arquivo {config_path} corrompido")
        return {}
    except Exception as e:
        print(f"ERRO ao carregar configurações: {str(e)}")
        return {}


def salvar_configuracoes(configuracoes, arquivo="configuracoes.json"):
    """Salva um dicionário de configurações no arquivo JSON"""
    try:
        config_path = get_config_path(arquivo)
        temp_path = config_path + '.tmp'
        
        with open(temp_path, 'w') as f:
            json.dump(configuracoes, f, indent=4)
        
        if os.path.exists(temp_path):
            os.replace(temp_path, config_path)
            
    except PermissionError:
        print(f"ERRO: Sem permissão para escrever em {config_path}")
    except Exception as e:
        print(f"ERRO ao salvar configurações: {str(e)}")