
# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sewercalc
                                 A QGIS plugin
 Plugin para dimensionamento de redes coletoras de esgoto 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wanderilo  Lima
        email                : Wanderilo Lima
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5.QtWidgets import QDialog, QVBoxLayout, QTextEdit, QPushButton
from PyQt5.QtCore import QTimer
from qgis.utils import iface
from qgis.core import QgsProject, Qgis
from collections import Counter
from .Sewercalc_config_cx_txt import carregar_configuracoes
import json

configuracoes = carregar_configuracoes()

camada_pv = configuracoes.get("camada_pv")

# Mapeamento de siglas para os nomes completos
siglas_para_nomes = {
    'CT': 'Cota de Topo',
    'CAT': 'Categoria',
    'NOME': 'Nome',
    'PV_MONT': 'PV Montante',
    'PV_JUS': 'PV Jusante',
    'L': 'Comprimento',
    'COLETOR': 'Coletor',
    'TRECHO': 'Trecho',
    'CONTRIB': 'Contribuição'
}

def exibir_mensagem(message):
    # Criando a caixa de diálogo com o novo título
    dialog = QDialog()
    dialog.setWindowTitle("AVISO DE ERROS E AUSÊNCIA DE DADOS")

    layout = QVBoxLayout()

    # Caixa de texto
    text_edit = QTextEdit()
    text_edit.setPlainText(message)
    text_edit.setReadOnly(True)  #somente leitura
    text_edit.setStyleSheet("font-size: 11pt; line-height: 1.5;")  #  fonte e espaçamento entre as linhas

    # Botão de Fechar
    close_button = QPushButton("Fechar")
    close_button.clicked.connect(dialog.accept)  

    # Adicionando widgets ao layout
    layout.addWidget(text_edit)
    layout.addWidget(close_button)

    dialog.setLayout(layout)

    # Ajustando o tamanho mínimo da caixa de texto
    dialog.setMinimumWidth(800)  
    dialog.setMinimumHeight(600) 

    dialog.exec_()
#-----------------------------------------------------------------------------------------------------    
def verificar_campos_vazios(tabela_pv):
    dados_faltantes = {}
    
    # Primeiro laço: processa os campos e coleta os valores válidos de 'NOME'
    valid_names = []
    for fid, colunas in tabela_pv.items():
        id_pv = fid
        num_val = colunas.get('NUM')
        num_pv = num_val if num_val not in [None, '', 'NULL'] else 'NULL'
        
        faltantes = {'NUM': num_pv}
        
        for campo in ['CT', 'CAT', 'NOME']:
            if campo not in colunas:
                faltantes[campo] = 'AUSENTE'
            elif colunas[campo] in [None, '', 'NULL']:
                faltantes[campo] = 'NULL'
            # Se o campo for NOME e tiver valor válido, armazena-o para a contagem
            elif campo == 'NOME':
                valid_names.append(colunas[campo])
        
        if len(faltantes) > 1:  
            dados_faltantes[id_pv] = faltantes

    # Utiliza o Counter para contar quantas vezes cada nome válido aparece
    nome_counts = Counter(valid_names)
    
    # Segundo laço: marca os registros com 'NOME' duplicado
    for fid, colunas in tabela_pv.items():
        nome_val = colunas.get('NOME')
        num_val = colunas.get('NUM')
        num_pv = num_val if num_val not in [None, '', 'NULL'] else 'NULL'
        
        if nome_val not in [None, '', 'NULL'] and nome_counts[nome_val] > 1:
            if fid in dados_faltantes:
                dados_faltantes[fid]['NOME'] = 'DUPLICADO'
            else:
                dados_faltantes[fid] = {'NUM': num_pv, 'NOME': 'DUPLICADO'} 

    #print(dados_faltantes) 
    return dados_faltantes
#-----------------------------------------------------------------------------------------------------    
def obter_coordenadas_pv(camada_pv, dados_faltantes):
    layer_pv = QgsProject.instance().mapLayer(camada_pv)

    coordenadas_mensagem = ""

    for id_feicao, dados in dados_faltantes.items():
        # Encontre a feição correspondente ao ID na camada
        feature = layer_pv.getFeature(id_feicao)
        
        if feature:
            # Obtém as coordenadas da feição
            geom = feature.geometry()
            x, y = geom.asPoint()
            x = round(x, 3)
            y = round(y, 3)
            
            # Monta a mensagem com coordenadas sem os prefixos "x" e "y"
            num_pv = dados['NUM'] if dados['NUM'] != 'NULL' else 'NULL'
            coordenadas_mensagem += f"PV {num_pv}, Id: {id_feicao}  ---  {x}, {y}\n"
        else:
    
            num_pv = dados['NUM'] if dados['NUM'] != 'NULL' else 'NULL'
            coordenadas_mensagem += f"PV {num_pv}, Id: {id_feicao}  ---  NULL, NULL\n"
    
    return coordenadas_mensagem
#-----------------------------------------------------------------------------------------------------    
def verificar_erro_pv(tabela_pv):
    dados_faltantes = verificar_campos_vazios(tabela_pv)
    
    if not dados_faltantes:
        return 0

    # Organizar os dados de acordo com o valor de 'NUM'
    dados_faltantes_ordenados = {k: v for k, v in sorted(dados_faltantes.items(), key=lambda item: item[1]['NUM'] if item[1]['NUM'] != 'NULL' else float('inf'))}

    # Criar a mensagem de erros
    erro_mensagem = "\nAnálise de PVs com colunas ou dados faltantes:\n\n"
    for fid, faltantes in dados_faltantes_ordenados.items():
        num_pv = faltantes['NUM']
        faltantes_info = ', '.join(f"{siglas_para_nomes.get(campo, campo)}: {valor}" for campo, valor in faltantes.items() if campo != 'NUM')
        erro_mensagem += f"PV {num_pv}, Id: {fid}  ---  {faltantes_info}\n"

    erro_mensagem += "\n\n" + "=============================Localização dos PVs=============================\n\n"

    # Obter coordenadas 
    coordenadas_mensagem = obter_coordenadas_pv(camada_pv, dados_faltantes_ordenados)
    erro_mensagem += coordenadas_mensagem

    exibir_mensagem(erro_mensagem)

    return 1

#===========================================================VERIFICAR ERRO NA REDE==============================================

def verificar_erro_rede(tabela_rede):
    campos_checagem = ['NOME', 'PV_MONT', 'PV_JUS', 'CONTRIB']
    dados_faltantes = {}

    for fid, colunas in tabela_rede.items():
        faltantes = {}

        for campo in campos_checagem:
            if campo not in colunas:
                faltantes[campo] = 'AUSENTE'
            elif colunas[campo] in [None, '', 'NULL']:
                faltantes[campo] = 'NULL'

        if faltantes:
            dados_faltantes[fid] = {
                'faltantes': faltantes,
                'nome': colunas.get('NOME') if colunas.get('NOME') not in [None, '', 'NULL'] else None
            }

    # Se não houver erros, retorna 0
    if not dados_faltantes:
        return 0

    mensagem = "\nAnálise de trechos da rede com colunas ou dados faltantes:\n\n"

    for fid, info in dados_faltantes.items():
        nome = info['nome']
        faltantes = info['faltantes']
        faltantes_info = ', '.join(f"{siglas_para_nomes.get(campo, campo)}: {valor}" for campo, valor in faltantes.items())

        if nome:
            mensagem += f"Trecho {nome}, Id: {fid}  ---  {faltantes_info}\n"
        else:
            mensagem += f"Trecho Id: {fid}  ---  {faltantes_info}\n"

    exibir_mensagem(mensagem)
    return 1
