 # -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sewercalc
                                 A QGIS plugin
 Plugin para dimensionamento de redes coletoras de esgoto 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wanderilo  Lima
        email                : Wanderilo Lima
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
import json
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction,QMessageBox
from qgis.core import QgsProject, QgsWkbTypes, QgsMapLayer, QgsRasterLayer, Qgis,QgsMessageLog
from PyQt5.QtCore import QThread, pyqtSignal
from qgis.utils import iface

from .Sewercalc_config_cx_txt import configurar_botoes, salvar_valores_campos, limpar_configuracoes
from .Sewercalc_Adicionar_campos import  Adicionar_campos_iniciais
from .Sewercalc_Importar_elevacao import importar_elevacao
from .Sewercalc_Preencher_campos import preencher_campos_rede
from .Sewercalc_Calc_vazao import dimensionar
from .Sewercalc_Nomear_trecho import executar_nomear_trechos
from .Sewercalc_Grafico import lista_coletores, grafico,verificar_tabela
from .Sewercalc_Nomear_trecho_auto import executar_nomeacao_automatica 
from .Sewercalc_config_cx_txt import carregar_configuracoes

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Sewercalc_dialog import SewercalcDialog
from .Sewercalc_dockwidget import SewercalcDockWidget
from .Sewercalc_perfil import SewercalcDlgPerfil
from .Sewercalc_Dialog_Dimensionar import SewercalcDlgDimensionar
import os.path
import webbrowser
          
#MINHAS FUNÇÕES--------------------------------------------------------------------------------
def carregar_camada(combobox, tipo_geometria, camada_id, raster):
    """Função unificada para carregar qualquer tipo de camada"""
    combobox.clear()
    combobox.addItem("", "")
    
    for layer in QgsProject.instance().mapLayers().values():
        if raster:
            if layer.type() == QgsMapLayer.RasterLayer:
                combobox.addItem(layer.name(), layer.id())
        else:
            if (layer.type() == QgsMapLayer.VectorLayer and 
                layer.geometryType() == tipo_geometria):
                combobox.addItem(layer.name(), layer.id())
    
    if camada_id:
        if camada := QgsProject.instance().mapLayer(camada_id):
            if index := combobox.findData(camada_id):
                combobox.setCurrentIndex(index)
#------------------------------------------------------------------------------------------------

class Sewercalc:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Sewercalc_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&Sewercalc')
        
        

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.pluginIsActive = False
        self.dockwidget = None
        self.dlg_perfil = None
        self.dlg_Dimensionar = None
        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Sewercalc', message)
    
    

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar and hasattr(self, 'toolbar'):
            self.toolbar.addAction(action) 

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        if hasattr(self, 'toolbar'):
            self.iface.removeToolBarIcon(self.toolbar)
            del self.toolbar

        self.toolbar = self.iface.addToolBar("Meu Plugin")
        
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        #--------configuração--------------------------------------------------
        icon_path = os.path.join(self.plugin_dir, 'img', 'configuracao.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Configuração'),
            callback=self.run,
            parent=self.iface.mainWindow())
        
        #--------Importar elevação--------------------------------------------------
        icon_path_cotas = os.path.join(self.plugin_dir, 'img', 'impotar_cotas.png')
        self.add_action(
            icon_path_cotas,
            text=self.tr(u'Importar Cotas'),
            callback=self.chamar_importar_elevacao,
            parent=self.iface.mainWindow())
        
        #--------Renomear trechos-------------------------------------------------
        icon_path_renomear = os.path.join(self.plugin_dir, 'img', 'renomear.png')
        self.add_action(
            icon_path_renomear,
            text=self.tr(u'Renomear trechos'),
            callback=self.run_renomear,
            parent=self.iface.mainWindow())

        #--------Preencher campos--------------------------------------------------
        icon_path_preencher = os.path.join(self.plugin_dir, 'img', 'preencher_dados.png')
        self.add_action(
            icon_path_preencher,
            text=self.tr(u'Preencher Campos'),
            callback=self.chamar_preencher_campos,
            parent=self.iface.mainWindow())
        ##--------Dimensionamento-------------------------------------------------
        icon_path_dimensionar = os.path.join(self.plugin_dir, 'img', 'Dimensionar.png')
        self.add_action(
            icon_path_dimensionar,
            text=self.tr(u'Executar Dimensionamento'),
            callback=self.run_dimensionar,
            parent=self.iface.mainWindow())
        ##--------Dimensionamento-------------------------------------------------
        icon_path_dimensionar = os.path.join(self.plugin_dir, 'img', 'Perfil.png')
        self.add_action(
            icon_path_dimensionar,
            text=self.tr(u'Desenhar Perfil'),
            callback=self.run_perfil,
            parent=self.iface.mainWindow())
        
        
        # will be set False in run()
        self.first_start = True

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.pluginIsActive = False
    
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Sewercalc'),
                action)
            self.iface.removeToolBarIcon(action)
    #-------------------------------
    def on_salvamento_concluido(self):
        mensagem = "Configurações salvas!!!"
        iface.messageBar().pushMessage(
            "",  
            mensagem,
            level=Qgis.Info,  
            duration=5  
        )
        print("Configurações Salvas!!")
        

    #-------------------------------
    def chamar_importar_elevacao(self):
        try:
            importar_elevacao() 
        except Exception as e:
            QMessageBox.critical(None, "Erro", f"Erro ao importar ELEVAÇÕES: {str(e)}")
    #-------------------------------
    def chamar_preencher_campos(self):
        try:
            preencher_campos_rede() 
        except Exception as e:
            QMessageBox.critical(None, "Erro", f"Erro ao PREENCHER CAMPOS: {str(e)}")
    #-------------------------------
    def chamar_dimensionamento(self,planilha, xml, pontos):
        dimensionar(planilha, xml, pontos) 
    #-------------------------------
    def chamar_nomear_trechos(self):
        executar_nomeacao_automatica()
        '''
        try:
            executar_nomeacao_automatica()
        except Exception as e:
            QMessageBox.critical(None, "Erro", f"Erro ao NOMEAR TRECHOS: {str(e)}")
            '''
    #-------------------------------
    def chamar_aplicar_estilo_01(self):
        Adicionar_campos_iniciais(self.dlg)

        
    #---------------DIALOGO CONFIGURAÇÃO------------------   
    def run(self):
        """Método principal que executa todo o trabalho"""
        # Criar o diálogo apenas na primeira vez
        if self.first_start:
            self.first_start = False
            self.dlg = SewercalcDialog()
            self.dlg.setFixedSize(self.dlg.size())
            
    
            self.dlg.Limp_config.clicked.connect(lambda: limpar_configuracoes(self.dlg))
            self.dlg.Estilo_botao.clicked.connect(lambda: self.chamar_aplicar_estilo_01())
        
        # Carregar configurações e camadas
        config = carregar_configuracoes()
        configurar_botoes(self.dlg)
        
        # ----------------- CARREGAR CAMADAS -----------------
        carregar_camada(self.dlg.C_PV, QgsWkbTypes.PointGeometry, config.get("camada_pv"), False)
        carregar_camada(self.dlg.C_REDE, QgsWkbTypes.LineGeometry, config.get("camada_rede"), False)
        carregar_camada(self.dlg.C_MDE, None, config.get("camada_mde"), True)
        
        # ----------------- CONECTAR LISTBOXS ÀS PROJEÇÕES -----------------
        self.conectar_listbox_projecao(self.dlg.C_PV, self.dlg.projecao_pv)
        self.conectar_listbox_projecao(self.dlg.C_REDE, self.dlg.projecao_rede)
        self.conectar_listbox_projecao(self.dlg.C_MDE, self.dlg.projecao_mde)
        
        #-------------------BOTÃO MANUAL------------------------------------ 
        self.dlg.manual.clicked.connect(self.abrir_manual)
        
        # Loop para manter o diálogo aberto até que os parâmetros estejam corretos
        while True:
            result = self.dlg.exec_()
            if not result:
                break
                
            try:
                tensao = float(self.dlg.Edit_Tensao.text())
                r_min = float(self.dlg.Edit_R_min.text())
                
                if tensao < 0.6 or r_min < 0.65:
                    mensagem = ""
                    if tensao < 0.6 and r_min < 0.65:
                        mensagem = "Os valores de Tensão e Recobrimento Mínimo estão abaixo dos parâmetros normativos!"
                    elif tensao < 0.6:
                        mensagem = "O valor da Tensão está abaixo do parâmetro normativo!"
                    else:
                        mensagem = "O valor do Recobrimento Mínimo está abaixo do parâmetro normativo!"
                    
                    QMessageBox.warning(self.dlg, "Erro", f"{mensagem} Ajuste-os antes de continuar.")
                    continue  # Volta para o início do loop 
                    
                salvar_valores_campos(self.dlg)
                
                iface.messageBar().pushMessage(
                    "Sucesso",
                    "Configuração salva com sucesso!!!",
                    level=Qgis.Success,
                    duration=12
                )
                break 
                
            except ValueError:
                QMessageBox.warning(self.dlg, "Erro", "Valores inválidos inseridos! Use números decimais.")
                continue 
            
    def run_renomear(self):
        """Run method that loads and starts the plugin"""
        self.chamar_nomear_trechos()
        
    def run_perfil(self):
        
        if not self.pluginIsActive:
            self.pluginIsActive = True 

        if self.dlg_perfil is None:
            self.dlg_perfil = SewercalcDlgPerfil() 
            self.dlg_perfil.setFixedSize(self.dlg_perfil.size()) 
            
            self.dlg_perfil.Button_pc.setEnabled(False)  # Inicia desabilitado
                    
            # Conexão do sinal (feito apenas uma vez na criação)
            self.dlg_perfil.Button_mde.toggled.connect(
                lambda checked: (
                    self.dlg_perfil.Button_pc.setEnabled(checked),
                    self.dlg_perfil.Button_pc.setChecked(False) if not checked else None
                )
            )

        lista_coletores(self.dlg_perfil)
        
        if verificar_tabela() == 1:
            return
        else:
            self.dlg_perfil.show()
        
        result = self.dlg_perfil.exec_()
        if result:
            mde_ativado = self.dlg_perfil.Button_mde.isChecked()
            self.dlg_perfil.Button_pc.setEnabled(mde_ativado)
            
            if self.dlg_perfil.Button_mde.isChecked():
                terreno_mde = "SIM"
            else:
                terreno_mde = "NAO"

            if self.dlg_perfil.Button_pc.isChecked() and self.dlg_perfil.Button_mde.isChecked():
                exibir_pc = "SIM"
            else:
                exibir_pc = "NAO" 

            if self.dlg_perfil.Button_zoom_coletor.isChecked():
                zoom_coletor = "SIM"
            else:
                zoom_coletor = "NAO"

            Coletor_selecionado = self.dlg_perfil.List_Coletores.currentText()
            grafico(Coletor_selecionado, terreno_mde, exibir_pc, zoom_coletor)
    
    def run_dimensionar(self):
        
        if not self.pluginIsActive:
            self.pluginIsActive = True 

        if self.dlg_Dimensionar is None:
            self.dlg_Dimensionar = SewercalcDlgDimensionar() 
            self.dlg_Dimensionar.setFixedSize(self.dlg_Dimensionar.size())  

        self.dlg_Dimensionar.show()
        
        result = self.dlg_Dimensionar.exec_()
        if result:
            
            if self.dlg_Dimensionar.checkBox_planilha.isChecked():
                planilha = "sim"
            else:
                planilha = "nao"
                
            if self.dlg_Dimensionar.checkBox_xml.isChecked():
                xml = "sim"
            else:
                xml = "nao"
            
            if self.dlg_Dimensionar.checkBox_pontos.isChecked():
                p_critico = "sim"
            else:
                p_critico = "nao"
            
            self.chamar_dimensionamento(planilha, xml, p_critico)
            pass
        
    #=====================================================
    # ----------------- FUNÇÃO AUXILIAR -----------------
    #=====================================================
    
    # Caixa de Texto das projeções-----------------------------------------------------
    def conectar_listbox_projecao(self, listbox, line_edit):
        """Conecta uma ListBox ao QLineEdit e atualiza label de aviso se CRS forem diferentes.    """
        
        def atualizar_projecao():
            nome_camada = listbox.currentText()
            camada = QgsProject.instance().mapLayersByName(nome_camada)
            if camada:
                camada = camada[0]
                crs_str = camada.crs().authid()
                line_edit.setText(crs_str)
            else:
                line_edit.setText("")

            # ----------------- VERIFICAR CONSISTÊNCIA -----------------
            proj_pv = self.dlg.projecao_pv.text()
            proj_rede = self.dlg.projecao_rede.text()
            proj_mde = self.dlg.projecao_mde.text()
            crs_list = [proj for proj in [proj_pv, proj_rede, proj_mde] if proj]
            
            if len(set(crs_list)) > 1:
                # Mudança de cor nos QLineEdit
                for le in [self.dlg.projecao_pv, self.dlg.projecao_rede, self.dlg.projecao_mde]:
                    le.setStyleSheet("background-color: rgb(255, 200, 200);")  # vermelho claro
                
                # Atualiza o label de aviso
                self.dlg.label_aviso.setStyleSheet("color: red; font-weight: bold;")
                self.dlg.label_aviso.setText("Existem camadas com projeções diferentes!")
            else:
                # Resetar cor e aviso
                for le in [self.dlg.projecao_pv, self.dlg.projecao_rede, self.dlg.projecao_mde]:
                    le.setStyleSheet("")
                self.dlg.label_aviso.setText("")

        # Conecta o sinal
        listbox.currentIndexChanged.connect(atualizar_projecao)
        
        # Atualiza imediatamente
        atualizar_projecao()

    #link do manual-------------------------------------------------------------------------------
    def abrir_manual(self):
        
        plugin_dir = os.path.dirname(os.path.abspath(__file__))
        manual_path = os.path.join(plugin_dir, "manual", "index.html")
        
        if os.path.exists(manual_path):
            webbrowser.open(f"file:///{manual_path}")
        else:
            QMessageBox.warning(self.dlg, "Erro", "O manual não foi encontrado!")
