# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Sewercalc
                                 A QGIS plugin
 Plugin para dimensionamento de redes coletoras de esgoto 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Wanderilo  Lima
        email                : Wanderilo Lima
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""



#ADICIONAR O PRIMEIRO ESTILO
from PyQt5.QtWidgets import QMessageBox
from qgis.core import QgsProcessingException
from .Sewercalc_Estilo import aplicar_estilo

def aplicar_estilo_01(dlg):
    camada_pv = dlg.C_PV.itemData(dlg.C_PV.currentIndex())
    camada_rede = dlg.C_REDE.itemData(dlg.C_REDE.currentIndex())
    
    #------------------VERIFICAR EXISTENCIA DE CAMADAS-------------------------------
    nao_encontradas = []
    if camada_pv == "":
        nao_encontradas.append("PV")
    if camada_rede == "":
        nao_encontradas.append("REDE")

    if nao_encontradas:  
        mensagem = "Camadas não encontradas: " + ", ".join(nao_encontradas)
        msg_box = QMessageBox()
        msg_box.setIcon(QMessageBox.Critical)
        msg_box.setWindowTitle("Erro")
        msg_box.setText(mensagem)
        msg_box.exec_()  
        raise QgsProcessingException("Execução interrompida: Existem ausências de camadas")  
    #-------------------------------------------------
    #Adicionar_campos_iniciais(dlg)
    aplicar_estilo(camada_pv, "Estilo01_PV.qml")
    aplicar_estilo(camada_rede, "Estilo01_REDE.qml")





