4# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PlanCreator
                                 A QGIS plugin
 Инструмент создания пространственно-информационной модели здания
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-08-27
        git sha              : $Format:%H$
        copyright            : (C) 2021 by bvchirkov
        email                : b.v.chirkov@udsu.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QDoubleSpinBox
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QLineEdit, QPlainTextEdit, QGroupBox, QFileDialog

from qgis.core import (
    Qgis,
    QgsProject,
    QgsApplication,
    QgsVectorLayer,
    QgsFeature,
    QgsField,
    QgsMapLayerStore,
    QgsCoordinateReferenceSystem,
    QgsEditFormConfig,
    QgsObjectCustomProperties,
    QgsMapLayerType
)

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .plan_creator_dialog import PlanCreatorDialogCreateProj, PlanCreatorDialogCreateLevel
from .create_topo import CreateTopo
from .create_cfast import CreateCfast

from sys import platform
import os.path
import os
import uuid
import shutil

PLUGIN_VERSION_MAJOR = 3
PLUGIN_VERSION_MINOR = 2
PLUGIN_VERSION_PATCH = 1
PLUGIN_VERSION = "v{}.{}.{}".format(PLUGIN_VERSION_MAJOR, PLUGIN_VERSION_MINOR, PLUGIN_VERSION_PATCH)

PLUGIN_NAME = u'PlanCreator-3'

class PlanCreator:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            '{}_{}.qm'.format(PLUGIN_NAME, locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(PLUGIN_NAME)

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start_create_proj = None
        self.first_start_create_level = None
        
        # Поля диалогового окна создания проекта
        self.QTextNameObj = None
        self.QTextCity = None
        self.QTextStreet = None
        self.QTextHomeNumber = None
        self.QTextAdditionalInfo  = None

        #
        self.QLevelHeight:str = None
        self.QFloorHeight:str = None
        self.QTransitHeight:str = None
        self.QNameLevel:str = None

        #
        self.BimLevelCount = 0

        #
        self.map_layer_store = QgsMapLayerStore()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate(PLUGIN_NAME, message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self) -> None:
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/{}/icon_b.png'.format(PLUGIN_NAME)
        self.add_action(
            icon_path,
            text=self.tr(u'Начать новый проект BuildingJSON'),
            callback=self.run_create_project,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/{}/icon_l.png'.format(PLUGIN_NAME)
        self.add_action(
            icon_path,
            text=self.tr(u'Добавить новый уровень'),
            callback=self.run_create_level,
            parent=self.iface.mainWindow())
        
        icon_path = ':/plugins/{}/icon_j.png'.format(PLUGIN_NAME)
        self.add_action(
            icon_path,
            text=self.tr(u'Создать JSON'),
            callback=self.run_create_json,
            parent=self.iface.mainWindow())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(PLUGIN_NAME),
                action)
            self.iface.removeToolBarIcon(action)

    def run_create_project(self) -> None:
        self.dlg = PlanCreatorDialogCreateProj()
        self.dlg.show() # show the dialog
        result = self.dlg.exec_() # Run the dialog event loop
        
        # See if CANCEL was pressed
        if not result:
            self.print_crit(u'Новый проект не создан')
            return

        # See if Ok was pressed
        # Получение значений полей диалогового окна
        for root_item in self.dlg.children():
            if isinstance(root_item, QLineEdit):
                if root_item.objectName() == "QTextNameObj":
                    self.QTextNameObj = root_item.text()
            if isinstance(root_item, QGroupBox):                    
                for group_box_item in root_item.children():
                    if isinstance(group_box_item, QLineEdit):
                        if group_box_item.objectName() == "QTextCity":
                            self.QTextCity = group_box_item.text()
                        if group_box_item.objectName() == "QTextStreet":
                            self.QTextStreet = group_box_item.text()
                        if group_box_item.objectName() == "QTextHomeNumber":
                            self.QTextHomeNumber = group_box_item.text()
                    if isinstance(group_box_item, QPlainTextEdit):
                        if group_box_item.objectName() == "QTextAdditionalInfo":
                            self.QTextAdditionalInfo = group_box_item.toPlainText()
        
        # print("QTextNameObj: {}\nQTextCity: {}\nQTextStreet: {}\nQTextHomeNumber: {}\nQTextAdditionalInfo: {}"
        #        .format(self.QTextNameObj, self.QTextCity, self.QTextStreet, self.QTextHomeNumber, self.QTextAdditionalInfo))

        # New filename for project
        prefix:str = None
        suffix:str = ""
        if platform.startswith('linux'):
            prefix = "~/"
            suffix = ".qgs"
        elif platform.startswith('win32'):
            prefix = "c:\\"

        projFileName = list(QFileDialog.getSaveFileName(None, u'Сохранить проект как...', prefix, "Project file (*.qgs *.QGS)"))[0]

        if projFileName == "":
            self.print_crit(u'Новый проект не создан. Необходимо указать название проекта')
            return
        else:
            projFileName = "{}{}".format(projFileName, suffix if not projFileName.endswith(".qgs") else "")
        
        #Create new project
        self.iface.newProject(True)
        myProject = QgsProject.instance()
        myProject.setTitle("MyProject for BuildingJSON")   #Title for new project

        # set CRS
        myProject.writeEntry("SpatialRefSys", "ProjectCrs", "EPSG:3395")
        myProject.writeEntry("SpatialRefSys", "ProjectCRSProj4String", "+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs")
        myProject.writeEntry("SpatialRefSys", "ProjectCRSID", 1353)
        # store some custom key values
        myProject.writeEntry(PLUGIN_NAME, "projectkey", "{}:{}".format(PLUGIN_NAME, PLUGIN_VERSION))
        myProject.writeEntry(PLUGIN_NAME, "nameBuilding", self.QTextNameObj)
        myProject.writeEntry(PLUGIN_NAME, "streetAddress", "{}, {}".format(self.QTextStreet, self.QTextHomeNumber))
        myProject.writeEntry(PLUGIN_NAME, "city", self.QTextCity)
        myProject.writeEntry(PLUGIN_NAME, "additionalInfo", self.QTextAdditionalInfo)
        
        #Save new project with custom key values
        myProject.setFileName(projFileName)
        # Save project to disk 
        if myProject.write():
            # print("Project saved as: " + projFileName)
            self.print_info(u'Новый проект создан успешно. ({})'.format(projFileName))
        else:
            # print("Project not saved for same reason")
            self.print_crit(u'Не удалось сохранить проект. Попробуйте выбрать другое место сохранения. ({})'.format(projFileName))
            
    def run_create_level(self) -> None:
        """Run method that performs all the real work"""
        self.dlg = PlanCreatorDialogCreateLevel()
        self.dlg.show()             # show the dialog
        result = self.dlg.exec_()   # Run the dialog event loop
        
        # See if CANCEL was pressed
        if not result:
            self.print_info(u'Новый уровень не добавлен')
            return

        # Get instance of the current project
        myProject = QgsProject.instance()
        # Get the level number by the two last symbols if layer tree of project is not empty
        # Now layers can moved to top or bottom and numbering will right even past restart QGIS
        if len(myProject.layerTreeRoot().layerOrder()) != 0:
            self.BimLevelCount = int(list(filter(lambda x: x.type() is QgsMapLayerType.VectorLayer, myProject.layerTreeRoot().layerOrder()))[-1].name()[-2:]) + 1

        self.QNameLevel = "Level_{}".format("%2.2d" % self.BimLevelCount)
        # Получение значений полей диалогового окна
        for root_item in self.dlg.children():
            if isinstance(root_item, QGroupBox):
                for group_box_item in root_item.children():
                    if isinstance(group_box_item, QDoubleSpinBox):
                        if group_box_item.objectName() == "QDoubleLevelHeight":
                            self.QLevelHeight = group_box_item.text()
                        if group_box_item.objectName() == "QDoubleFloorHeight":
                            self.QFloorHeight = group_box_item.text()
                        if group_box_item.objectName() == "QDoubleTransitHeight":
                            self.QTransitHeight = group_box_item.text()

        # See if OK was pressed
        # Проверим, что проект создан правильно (что это наш проект)
        # if myProject.readEntry(PLUGIN_NAME, "projectkey", "noname")[0] != "{}:{}".format(PLUGIN_NAME, PLUGIN_VERSION) or \
        if not myProject.readEntry(PLUGIN_NAME, "projectkey", "noname")[0][1] or not myProject.readEntry(PLUGIN_NAME[:-2], "projectkey", "noname")[0][1]:
            self.print_crit(u'Сначала необходимо создать проект для {}!'.format(PLUGIN_NAME))
            return

        #Скопируем шаблон уровня shp в папку проекта с переименовкой
        newSUUID = str(uuid.uuid4()).split('-')[0]
        doors_layer = self.copy_level_pattern(myProject, "doors", newSUUID)
        rooms_layer = self.copy_level_pattern(myProject, "rooms", newSUUID)
        stairs_layer = self.copy_level_pattern(myProject, "stairs", newSUUID)
        
        #Make group
        tree_root = QgsProject.instance().layerTreeRoot()
        group = tree_root.addGroup(self.QNameLevel + ", (" + str(self.QLevelHeight) + u'м.)')
        group.addLayer(doors_layer)
        group.addLayer(rooms_layer)
        group.addLayer(stairs_layer)
   
    def copy_level_pattern(self, project:QgsProject, name:str, suffix:str) -> QgsVectorLayer:
        #copy & rename
        home_dir = project.homePath()
        src = os.path.join(os.path.dirname(QgsApplication.qgisUserDatabaseFilePath()), "python", "plugins", PLUGIN_NAME, "layers", name)
        dst = shutil.copy(src + ".shp", os.path.join(home_dir, "{}-{}.shp".format(name, suffix)))
        shutil.copy(src + ".shx", os.path.join(home_dir, "{}-{}.shx".format(name, suffix)))
        shutil.copy(src + ".prj", os.path.join(home_dir, "{}-{}.prj".format(name, suffix)))
        shutil.copy(src + ".dbf", os.path.join(home_dir, "{}-{}.dbf".format(name, suffix)))
        shutil.copy(src + ".qml", os.path.join(home_dir, "{}-{}.qml".format(name, suffix)))
        dst_ui = shutil.copy(src + ".ui", os.path.join(home_dir, "{}.ui".format(name)))

        #Добавляем слои в проект
        name_leyer = "{}{}".format(name, "%2.2d" % self.BimLevelCount)
        new_layer = QgsVectorLayer(dst, name_leyer, "ogr")
                
        if not new_layer or not new_layer.isValid():
            self.print_crit("Не удалось загрузить слой {}".format(name_leyer))
            return

        QgsProject.instance().addMapLayer(new_layer, False)
        # print("Successfull loaded ROOMS and added")

        #Save layer's parameters
        prop = QgsObjectCustomProperties()
        prop.setValue("nameLevel", self.QNameLevel)
        prop.setValue("zLevel", self.QLevelHeight)
        prop.setValue("sizeZ", self.QFloorHeight if not name == "doors" else self.QTransitHeight)
        new_layer.setCustomProperties(prop)
        new_layer.setCrs(QgsCoordinateReferenceSystem('EPSG:3395'))
        new_layer.loadDefaultStyle() # Must before `layer.setEditFormConfig`

        edit_form_config = QgsEditFormConfig()
        edit_form_config.setLayout(QgsEditFormConfig.EditorLayout.UiFileLayout)
        edit_form_config.setUiForm(dst_ui)
        new_layer.setEditFormConfig(edit_form_config)
        
        return new_layer

    def run_create_json(self) -> None:
        topo = CreateTopo(PLUGIN_NAME, self.iface)
        topo.fill_ids()
        topo.make_topo()

    def print_info(self, text) -> None:
        self.iface.messageBar().pushMessage("Info", text, level=Qgis.Info, duration=10)

    def print_warn(self, text) -> None:
        self.iface.messageBar().pushMessage("Warning", text, level=Qgis.Warning, duration=10)
        
    def print_crit(self, text) -> None:
        self.iface.messageBar().pushMessage("Critical", text, level=Qgis.Critical, duration=10)