# -*- coding: utf-8 -*-
from qgis.core import QgsProcessingProvider
from .algorithms.percent_rates_algorithm import PercentRatesAlgorithm

class PercentRatesProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def id(self):
        return "gisphn_wariai"

    def name(self):
        return "GISPHNプラグイン"

    def longName(self):
        return self.name()

    def loadAlgorithms(self):
        self.addAlgorithm(PercentRatesAlgorithm())
