# -*- coding: utf-8 -*-
from qgis.core import QgsApplication
from .percent_rates_provider import PercentRatesProvider

class PercentRatesPlugin:
    def __init__(self, iface):
        self.iface = iface
        self.provider = None

    def initGui(self):
        self.provider = PercentRatesProvider(self.iface)
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)
            self.provider = None
