import os
import json
from pickle import FALSE
import requests
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject
from qgis.PyQt.QtWidgets import QFileDialog
from PyQt5.QtCore import QThread, pyqtSignal

from .login import LoginDialog
from ..SLDHandler import SLDDialog
from ..worker import Worker
from ..report import ReportDialog
from .publikasi import Publikasi
from .metadata import Metadata
from ..metadata_form import MetadataForm
from .register_service import RegisterService
from qgis.utils import iface
from ..utils import storeSetting

#from .login import LoginDialog

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), '../../ui/UploadPalapa_main.ui'))

class UploadDialog(QtWidgets.QDialog, FORM_CLASS):

    UserLogout = pyqtSignal()
  
    def __init__(self,parent=iface.mainWindow()):
        """Constructor."""
        super(UploadDialog, self).__init__(parent)
        self.setupUi(self)
        self.login = LoginDialog()
        # self.login.UserSignal.connect(self.UserParam)
        self.enable_button(True)
        self.upload.clicked.connect(self.checking)
        self.browse_metadata.clicked.connect(self.start_browse_metadata)
        self.browse_style.clicked.connect(self.start_browse_style)
        self.url = None
        self.simpulJaringan=None
        self.grup = None
        self.user=None
        self.pathMeta = None
        self.pathSLD = None
        self.MetaRun = False
        self.pathSLD = None
        self.UserParams = None
        self.LayerParams = None
        self.filesSld = None
        self.SLDqgis = False
        self.lineEdit_metadata.setReadOnly(True)
        self.lineEdit_style.setReadOnly(True)
        self.radioButton_StyleBrowse.toggled.connect(self.browse_style.setEnabled)
        self.radioButton_StyleBrowse.toggled.connect(self.lineEdit_style.setEnabled)
        self.pushButton_clearStyle.clicked.connect(self.clearStyle)
        self.pushButton_clearMetadata.clicked.connect(self.clearMetadata)
        self.select_layer.currentTextChanged.connect(self.changeTitle)
        self.pushButton_logout.clicked.connect(self.logout) 
        self.meta_lengkap.clicked.connect(self.isi_metadata_lengkap) 

        self.radioButton_meta_lengkap.toggled.connect(self.changeMeta)
        self.radioButton_meta_xml.toggled.connect(self.changeMeta)
        self.radioButton_meta_min.toggled.connect(self.changeMeta)
        
        self.ReportDlg = ReportDialog()
        self.changeMeta()
        self.setup_workpanel()

    def setup_workpanel(self):
        
        # Inialisasi kelas
        self.publikasiPanel = Publikasi()
        self.metadataPanel = Metadata()

        # Menambahkan tab publikasi,metadata,register service ke tab upload
        self._main_tab.addTab(self.publikasiPanel, "Publkasi")
        self._main_tab.addTab(self.metadataPanel, "Metadata")

        # Handle daftar table ketika menambahkan data melalui register service
    
    
    # Handle ketika ada perubahan user yang melakukan login
    def checkUser(self):
        self.publikasiPanel.checkUser()
        self.metadataPanel.checkUser()
    
    # Handle ketika ada perubahan input metadata 
    def changeMeta(self):
        if(self.radioButton_meta_lengkap.isChecked()):
            self.meta_lengkap.setVisible(True) 
            self.browse_metadata.setVisible(False) 
            self.lineEdit_metadata.setVisible(False) 
            self.pushButton_clearMetadata.setVisible(False) 
        elif(self.radioButton_meta_xml.isChecked()):
            self.browse_metadata.setVisible(True) 
            self.lineEdit_metadata.setVisible(True) 
            self.pushButton_clearMetadata.setVisible(True) 
            self.meta_lengkap.setVisible(False) 
        else:
            self.browse_metadata.setVisible(False) 
            self.lineEdit_metadata.setVisible(False) 
            self.pushButton_clearMetadata.setVisible(False) 
            self.meta_lengkap.setVisible(False) 

    # Merubah judul teks ketika ada perubahan layer yang dipilih
    def changeTitle(self):
        layerName = self.select_layer.currentText()
        self.lineEdit_layertitle.setText(layerName)
        self.metadataForm = MetadataForm(layerName)

    # Memasukkan parameter ke dalam class upload
    def UserParam(self, signalpayload):
        self.grup = signalpayload['grup']
        self.user = signalpayload['user']
        self.url = signalpayload['url']
        self.simpulJaringan = signalpayload['kodesimpul']
        layerName = self.select_layer.currentText()
        self.lineEdit_layertitle.setText(layerName)
        self.label_userdesc.setText(f"Anda masuk sebagai '{self.user}' pada '{self.url}'")
        urlKeyword = self.url+"/api/keyword/list"
        responseKeyword = requests.get(urlKeyword)
        self.comboBox_constraint.setCurrentIndex(0)
        self.comboBox_keyword.clear()
        # Memasukkan kayword ke dalam combo box keyword
        storeSetting("keyword",responseKeyword.json())
        for x in responseKeyword.json():
            self.comboBox_keyword.addItem(x['keyword'])
        self.comboBox_keyword.setCurrentIndex(0)
        self.metadataForm = MetadataForm(layerName)
        print(signalpayload)
    
    # Handle logout
    def logout(self):
        self.UserLogout.emit()

    # Cek kelengkapan
    def checking(self):
        self.checkEPSG()
        self.ReportDlg.reportReset()
        self.reportReset()
        self.report(self.label_statusbase, 'process', 'Mengecek data . . .')
        if((self.radioButton_StyleBrowse.isChecked() and self.pathSLD == '') or (self.radioButton_StyleBrowse.isChecked() and self.pathSLD == None)):
            self.report(self.label_statusbase, 'caution', 'Masukkan SLD atau gunakan SLD bawaan')
            print('masukkan SLD atau gunakan sld bawaan')
        else:
            layerPath = self.exportLayer()
            if(layerPath == False):
                self.report(self.label_statusbase, 'reset', '')
                QtWidgets.QMessageBox.warning(
                None, "Palapa", "Layer tidak berformat SHP"
                )
                return
            # define layer parameter
            self.LayerParams = layerPath
            # Handle check apakah file shp tersebut ada atau tidak
            if self.checkFileExist(layerPath['shp']) and self.checkFileExist(layerPath['dbf']) and self.checkFileExist(layerPath['shx']) and self.checkFileExist(layerPath['prj']) :
                print("file Lengkap")
                if(self.radioButton_StyleQgis.isChecked()):      
                    self.SLDqgis = True              
                    sldPath = self.exportSld()
                elif(self.radioButton_StyleBrowse.isChecked() and (self.pathSLD != '' or self.pathSLD != None)):  
                    self.SLDqgis = False  
                    sldPath = self.pathSLD
                # define SLD parameter
                self.filesSld = {'file': open(sldPath,'rb')}
                if (self.pathMeta is not None and self.pathMeta != ''):
                    print('metajalan',self.pathMeta)         
                    self.MetaRun = True
                self.filesSld['file'].close()
                self.report(self.label_statusbase, True, 'Data lengkap, mulai mengunggah . . .')
                #Melakukan uploading
                self.runUpload()
            else :
                print("file Tidak Lengkap")
                self.report(self.label_statusbase, False, 'File tidak lengkap')

    # Handle upload file shp ke dalam geoportal 
    def runUpload(self,sldName=False):
        self.thread = QThread()
        title = self.lineEdit_layertitle.text()
        abstrack = self.textEdit_layerabstract.toPlainText() 
        tanggal = self.mDateTimeEdit.dateTime()
        tanggal = tanggal.toString("ddd MMM dd yyyy HH:mm:ss")
        keyword = self.comboBox_keyword.currentText()
        akses = self.comboBox_constraint.currentText()

        data = {"grup":self.grup,
                "user":self.user,
                "kodesimpul":self.simpulJaringan,
                "url":self.url,
                "title":title,
                "abstrack":abstrack,
                "layerPath":self.LayerParams,
                "sldPath":self.filesSld['file'].name,
                "sLDqgis":self.SLDqgis,
                "pathMeta":self.pathMeta,
                "MetaRun":self.MetaRun,
                "date":tanggal,
                "keyword":keyword,
                "akses":akses
                }

        # Check metadata yang digunakan
        if(self.radioButton_meta_lengkap.isChecked()):
            data["metadataLengkap"] = self.metadataForm.getMetadata()
        else:
            data["metadataLengkap"] = None

        # Memindahkan proses upload ke dalam Thread untuk menghindari freeze
        self.worker = Worker(data,sldName)
        self.worker.sldRename.connect(self.sldRename)
        self.worker.moveToThread(self.thread) 
        # Connect signals and slots:
        self.thread.started.connect(self.worker.run)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.worker.status.connect(self.reportStatus)
        self.worker.progress.connect(self.reportProgress)

        self.thread.start() # finally start the thread
        self.ReportDlg.show()
        self.ReportDlg.accept.setEnabled(False)
        self.thread.finished.connect(self.reportFinish)

        self.enable_button(False) # disable the start-upload button while thread is running
        self.thread.finished.connect(lambda: self.enable_button(True))
        self.thread.finished.connect(lambda: self.ReportDlg.accept.setEnabled(True))
        # enable the start-thread button when thread has been finished    

    #Handle enable button untuk login
    def enable_button(self,enable):
        if (enable):
            self.pushButton_logout.setEnabled(True)
            self.upload.setEnabled(True)
        else :
            self.pushButton_logout.setEnabled(False)
            self.upload.setEnabled(False)               

    #Handle untuk sld dengan nama yang sama
    def sldRename(self,pathSld):
        print("SLD Rename")
        self.ReportDlg.hide()
        self.report(self.label_statusbase,'caution','Nama file SLD sudah ada, silakan rename atau gunakan SLD yang sudah ada')
        self.sldHandler = SLDDialog(self.user,self.grup,self.simpulJaringan,self.url,pathSld,self.SLDqgis)
        self.sldHandler.uploadStyle.connect(self.runUpload)
        self.sldHandler.show()

    def clearStyle(self):
        self.lineEdit_style.setText('')
        self.filename1 = ''
        self.pathSLD = None

    def clearMetadata(self):
        self.lineEdit_metadata.setText('')
        self.filename1 = ''
        self.pathMeta = None

    def checkEPSG(self):
        layerName = self.select_layer.currentText()
        layer = QgsProject().instance().mapLayersByName(layerName)[0]
        lyrCRS = layer.crs().authid()
        print(lyrCRS)
    
    #Mencari path dari file yang dipilih
    def exportLayer(self):
        layerName = self.select_layer.currentText()
        layer = QgsProject().instance().mapLayersByName(layerName)[0]
        source = layer.source()
        source = source.split("|")
        sourceFile = False
        tipe = source[0].split(".")[-1]
        if (tipe=="shp"):
            sourceFile = self.replacePath(source[0],".shp")
        elif (tipe=="dbf"):
            sourceFile = self.replacePath(source[0],".dbf")
        elif (tipe=="shx"):
            sourceFile = self.replacePath(source[0],".shx")
    
        return sourceFile

    #mencari 4 tipe file yang dibutuhkan dalam shp
    def replacePath(self,source,tipeFile):
        shp = source.replace(tipeFile, ".shp")
        shp = shp.replace("\\", "/")
        prj = source.replace(tipeFile, ".prj")
        prj = prj.replace("\\", "/")
        dbf = source.replace(tipeFile, ".dbf")
        dbf = dbf.replace("\\", "/")
        shx = source.replace(tipeFile, ".shx")
        shx = shx.replace("\\", "/")
        sourceFile = json.loads('{"shp":"%s","prj":"%s","dbf":"%s","shx":"%s"}'%(shp,prj,dbf,shx))
        print(sourceFile)
        return sourceFile
    
    #Check file apakah ada atau tidak
    def checkFileExist(self,filePath):
        fileExist = True
        if os.path.isfile(filePath):
            print ("File exist")
            fileExist = True
        else:
            print ("File not exist")
            fileExist = False
        return fileExist

    #Export sld dari layer yang dipih
    def exportSld(self):
        layerName = self.select_layer.currentText()
        layer = QgsProject().instance().mapLayersByName(layerName)[0]
        source = layer.source()
        source = source.split("|")[0]
        tipe = source.split(".")[-1]
        if(tipe=="shp"):
            sldPath = source.replace(".shp", ".sld")
        elif(tipe=="shx"):
            sldPath = source.replace(".shx", ".sld")
        elif(tipe=="dbf"):
            sldPath = source.replace(".dbf", ".sld")
        sldPath = sldPath.replace("\\", "/")
        layer.saveSldStyle(sldPath)
        return sldPath
    
    #Mencari metadata dari local computer
    def start_browse_metadata(self):
        filter = "XML files (*.xml)"
        filename1, _ = QFileDialog.getOpenFileName(None, "Import XML", "",filter)
        self.lineEdit_metadata.setText(filename1)
        self.pathMeta = filename1
    
    #Mencari sld dari local computer
    def start_browse_style(self):
        filter = "SLD files (*.sld)"
        filePath, _ = QFileDialog.getOpenFileName(None, "Import SLD", "",filter)
        self.lineEdit_style.setText(filePath)
        self.pathSLD = filePath

    #Pengisian metadata lengkap
    def isi_metadata_lengkap(self):
        self.metadataForm.show()
        constraint =  self.comboBox_constraint.currentText()
        self.metadataForm.setKeyword(constraint)

    # report upload
    def report(self, label, result, message):
        if result is True:
            label.setStyleSheet("color: white; background-color: #4AA252; border-radius: 4px;") 
        elif result == 'reset':
            label.setStyleSheet("background-color: none; border-radius: 4px;")
        elif result == 'caution':
            label.setStyleSheet("color: white; background-color: #F28F1E; border-radius: 4px;")
        elif result == 'process':
            label.setStyleSheet("color: black; background-color: #92c9e8; border-radius: 4px;")
        else :
            label.setStyleSheet("color: white; background-color: #C4392A; border-radius: 4px;")
        label.setText(message)
    
    def reportReset(self):
         self.report(self.label_statusbase, 'reset', '')
    
    def reportProgress(self, val):
        self.ReportDlg.progressBar.setValue(val/4*100)
    
    def reportStatus(self, status):
        type = status["type"]
        result = status["result"]
        message = status["msg"]
        if type == 'SLD':
            self.ReportDlg.report(self.ReportDlg.label_statusSLD, result, message)
        elif type == 'layer':
            self.ReportDlg.report(self.ReportDlg.label_statusLayer, result, message)
        elif type == 'publish':
            self.ReportDlg.report(self.ReportDlg.label_statusPublish, result, message)
        elif type == 'metadata':
            self.ReportDlg.report(self.ReportDlg.label_statusMetadata, result, message)
        elif type == 'general':
            self.ReportDlg.report(self.ReportDlg.label_statusgeneral, result, message)
            self.report(self.label_statusbase, result, message)

    def reportFinish(self):
        self.report(self.label_statusbase, 'reset', '')
        self.metadataPanel.refresh_grid()
        self.publikasiPanel.refresh_grid()
        #self.reportStatus('general',True,'Proses Selesai')

    def refreshMetadata(self):
        self.metadataPanel.refresh_grid()
    

