# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Palapa
                                 A QGIS plugin
 Plugin yang berguna untuk mengupload data spasial, style, dan metadata ke Geoportal Palapa
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2021 by BIG
        email                : sandysetyanagara@mail.ugm.ac.id
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QThreadPool
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
#from .ui.upload import UploadDialog
from .module.workspace.login import LoginDialog
from .module.workspace.upload import UploadDialog
from .module.workspace.layer_umum import LayerUmum
import os.path


class Palapa:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Palapa_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Palapa')

        self.threadpool = QThreadPool()
        self.check_worker = None

        self.login = LoginDialog()
        self.upload = UploadDialog()
        self.umum = LayerUmum()
        
        self.login.UserSignal.connect(self.openUpload)
        self.login.UmumMasuk.connect(self.openLayer)
        self.upload.UserLogout.connect(self.logout)
        self.umum.UserLogout.connect(self.logout)
        self.LoggedIn = False        

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Palapa', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action) 

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Plugin-upload-Palapa/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Palapa'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Palapa'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
        if self.LoggedIn == False:
            self.login.show()
        elif self.LoggedIn == "upload":
            self.upload.show()
        elif self.LoggedIn == "umum":
            self.umum.show()
        # # show the dialog
        # # Run the dialog event loop
        # result = self.login.exec_()
        # # See if OK was pressed
        # if result:
        #     # Do something useful here - delete the line containing pass and
        #     # substitute with your code.
        #     pass
    def openLayer(self):
        self.LoggedIn = "umum"
        self.login.close()
        self.umum.show()
        self.umum.refresh_grid()
    
    def openUpload(self,payload):
        self.LoggedIn = "upload"
        self.login.close()
        self.upload.checkUser()       
        self.upload.show()
        self.upload.UserParam(payload)

    def logout(self):
        self.LoggedIn = False
        self.upload.close()   
        self.umum.close()       
        self.login.show()