from __future__ import annotations

from .settings import PluginSettings

__name__ = PluginSettings().get("name")
__version__ = PluginSettings().get("version")

try:
    import pip
except ImportError:
    from .cmd import INTERPRETER, dlg_run

    dlg_run(f"{INTERPRETER} -m ensurepip")

# declare plugin factory
from .plugin import PackageInstallerQgis

classFactory = PackageInstallerQgis

# make sure its loaded ASAP
from qgis.utils import loadPlugin

loadPlugin("PackageInstallerQgis")
