from pathlib import Path

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QApplication, QStyle

ASSETS = Path(__file__).parent.parent / "assets"
ICON = next(ASSETS.glob(f"**/icon.*"), "")


def qicon(name: str = None) -> QIcon:
    if name is None:
        return QIcon(str(ICON))
    elif name.startswith("SP_"):
        if enum := getattr(QStyle, name, None):
            return QApplication.style().standardIcon(enum)
    elif file := next(ICON.parent.glob(f"**/{name}.*"), "") or next(
        ASSETS.glob(f"**/{name}.*"), ""
    ):
        return QIcon(str(file))
    return QIcon(str(ICON))
