from functools import cache
from pathlib import Path

from qgis.PyQt.QtGui import QIcon

from ..settings import PluginSettings

ROOT = Path(PluginSettings().get("path", "."))
ICON = ROOT / PluginSettings().get("icon", "icon.ico")


@cache
def qicon(name: str = None) -> QIcon:

    if name is None:
        return QIcon(str(ICON))
    file = next(ICON.parent.glob(f"**/{name}.*"), "") or next(
        ROOT.parent.glob(f"**/{name}.*"), ""
    )
    return QIcon(str(file))
