from pathlib import Path


def folder_size(folder: str, as_string: bool = True) -> int | str:
    size = sum(p.stat().st_size for p in Path(folder).rglob("*"))
    if as_string:
        for unit in ("B", "KB", "MB", "GB", "TB", "PB"):
            if size < 1024:
                break
            size /= 1024
        return f"{size:.1f}{unit}"
    else:
        return size
