# PRESTO

**PRESTO** Is a tool that supports the definition of the potential user base of a REC through energy, environmental, economic and socio-demographic criteria. It allows scenarios to be generated that assess the compatibility between renewable energy production and the consumption of residential units belonging to the same basin, connected to the same primary distribution substation.


---

## Features
- Calculates the energy production potential of public buildings to act as Renewable Energy Community (REC) HUBs
- Generates social, technical, equity-based and demographic energy-sharing scenarios
- Computes hourly energy flows (production, self-consumption, shared energy) for each scenario
- Calculates environmental indicators (CO₂ index, CO₂ storage, avoided km, planted trees, avoided oil barrels)
- Calculates economic performance metrics (VAN, B/C ratio, payback time) across custom simulation periods
- Exports detailed CSV outputs (scenario summaries, household allocation, building-level aggregations)
- Automatically generates charts for hourly profiles and annual VAN evolution

---

## Installation
1. Download the latest version of **PRESTO.zip** from the [QGIS Plugin Repository](https://github.com/SavinoGiacobbe/PRESTO).
2. In QGIS, open **Plugins → Manage and Install Plugins → Install from ZIP**.
3. Select the ZIP file and click **Install Plugin**.

---

## Usage
After installation, you will find **PRESTO** under the **Plugins** menu or in the toolbar.  
Click the PRESTO icon to open the main dialog and start your analysis.

---

## Requirements
- QGIS ≥ 3.0
- No additional Python libraries required (uses built-in PyQGIS and PyQt)

---

## Source Code & Support
- **Repository:** [https://github.com/SavinoGiacobbe/PRESTO]
- **Issue Tracker:** [https://github.com/SavinoGiacobbe/PRESTO/issues]

---

## Authors
Supervisor **Renata Valente and Louise Anna Mozingo**
Concept **Valente, Mozingo, Giacobbe, Bosco, Maienza**
Algorithm and data analysis **Savino Giacobbe and Mihaela Bianca Maienza**
Developer **Mihaela Bianca Maienza**  
Contact: savino.giacobbe@unicampania.it

---

## License
This plugin is released under the [GNU General Public License v2 or later (GPLv2+)]